/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filmlisten.reader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Stopwatch;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.event.EventListenerList;
import mediathek.config.Config;
import mediathek.config.Konstanten;
import mediathek.controller.SenderFilmlistLoadApprover;
import mediathek.daten.DatenFilm;
import mediathek.daten.FilmListMetaData;
import mediathek.daten.ListeFilme;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.InputStreamProgressMonitor;
import mediathek.tool.ProgressMonitorInputStream;
import mediathek.tool.TrailerTeaserChecker;
import mediathek.tool.http.MVHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.tukaani.xz.XZInputStream;

public class FilmListReader
implements AutoCloseable {
    private static final int PROGRESS_MAX = 100;
    private static final Logger logger = LogManager.getLogger(FilmListReader.class);
    private static final String THEMA_LIVE = "Livestream";
    private final EventListenerList listeners = new EventListenerList();
    private final ListenerFilmeLadenEvent progressEvent = new ListenerFilmeLadenEvent("", "Download", 0, 0, false);
    private final int max;
    private final TrailerTeaserChecker ttc = new TrailerTeaserChecker();
    protected int DECOMPRESSOR_MEMORY_LIMIT = -1;
    private int progress;
    private long milliseconds;
    private String sender = "";
    private String thema = "";

    public FilmListReader() {
        this.max = 100;
    }

    public void addAdListener(ListenerFilmeLaden listener) {
        this.listeners.add(ListenerFilmeLaden.class, listener);
    }

    private void removeRegisteredListeners() {
        ListenerFilmeLaden[] list;
        for (ListenerFilmeLaden lst : list = (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            this.listeners.remove(ListenerFilmeLaden.class, lst);
        }
    }

    private InputStream selectDecompressor(String source2, InputStream in) throws Exception {
        return switch (source2.substring(source2.lastIndexOf(46))) {
            case ".xz" -> new XZInputStream(in, this.DECOMPRESSOR_MEMORY_LIMIT, false);
            case ".json" -> in;
            default -> throw new UnsupportedOperationException("Unbekanntes Dateiformat entdeckt.");
        };
    }

    private void parseNeu(JsonParser jp, DatenFilm datenFilm) throws IOException {
        String value = jp.nextTextValue();
        datenFilm.setNew(Boolean.parseBoolean(value));
    }

    protected void parseWebsiteLink(JsonParser jp, DatenFilm datenFilm) throws IOException {
        String value = jp.nextTextValue();
        if (value != null && !value.isEmpty()) {
            datenFilm.setWebsiteLink(value);
        }
    }

    private void parseDescription(JsonParser jp, DatenFilm datenFilm) throws IOException {
        String value = jp.nextTextValue();
        if (value != null && !value.isEmpty()) {
            datenFilm.setDescription(value);
        }
    }

    protected void parseGeo(JsonParser jp, DatenFilm datenFilm) throws IOException {
        String geoStr = this.checkedString(jp);
        Optional<Object> geo = geoStr.isEmpty() ? Optional.empty() : Optional.of(geoStr);
        datenFilm.setGeo(geo);
    }

    private void parseSender(JsonParser jp, DatenFilm datenFilm) throws IOException {
        String parsedSender = this.checkedString(jp);
        if (parsedSender.isEmpty()) {
            datenFilm.setSender(this.sender);
        } else {
            datenFilm.setSender(parsedSender);
            this.sender = parsedSender;
        }
        if (datenFilm.getSender().equalsIgnoreCase("rbtv")) {
            datenFilm.setSender("Radio Bremen TV");
        }
    }

    private void parseThema(JsonParser jp, DatenFilm datenFilm) throws IOException {
        String value = this.checkedString(jp);
        if (value.isEmpty()) {
            datenFilm.setThema(this.thema);
        } else {
            datenFilm.setThema(value);
            this.thema = value;
        }
        if (this.ttc.check(datenFilm.getThema())) {
            datenFilm.setTrailerTeaser(true);
        }
    }

    private String checkedString(JsonParser jp) throws IOException {
        String value = jp.nextTextValue();
        if (value == null) {
            value = "";
        }
        return value;
    }

    private void parseMetaData(JsonParser jp, ListeFilme listeFilme) throws IOException {
        JsonToken jsonToken;
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            FilmListMetaData meta = listeFilme.metaData();
            jp.nextTextValue();
            meta.setDatum(jp.nextTextValue());
            jp.nextTextValue();
            jp.nextTextValue();
            meta.setId(jp.nextTextValue());
            break;
        }
    }

    private void skipFieldDescriptions(JsonParser jp) throws IOException {
        JsonToken jsonToken;
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            jp.nextToken();
            break;
        }
    }

    private void parseUrlSubtitle(JsonParser jp, DatenFilm datenFilm) throws IOException {
        datenFilm.setUrlSubtitle(this.checkedString(jp));
    }

    private void parseUrlKlein(JsonParser jp, DatenFilm datenFilm) throws IOException {
        datenFilm.setUrlKlein(this.checkedString(jp));
    }

    private void parseUrlHd(JsonParser jp, DatenFilm datenFilm) throws IOException {
        datenFilm.setUrlHighQuality(this.checkedString(jp));
    }

    private void parseDatumLong(JsonParser jp, DatenFilm datenFilm) throws IOException {
        datenFilm.setDatumLong(this.checkedString(jp));
    }

    private void parseSendedatum(JsonParser jp, DatenFilm datenFilm) throws IOException {
        datenFilm.setSendeDatum(this.checkedString(jp));
    }

    private void parseDauer(JsonParser jp, DatenFilm datenFilm) throws IOException {
        datenFilm.setDauer(this.checkedString(jp));
    }

    private void parseGroesse(JsonParser jp, DatenFilm datenFilm) throws IOException {
        String value = this.checkedString(jp);
        datenFilm.setSize(value);
    }

    private void skipToken(JsonParser jp) throws IOException {
        jp.nextToken();
    }

    private void parseTime(JsonParser jp, DatenFilm datenFilm) throws IOException {
        Object zeit = this.checkedString(jp);
        if (!((String)zeit).isEmpty() && ((String)zeit).length() < 8) {
            zeit = (String)zeit + ":00";
        }
        datenFilm.setSendeZeit((String)zeit);
    }

    private void parseAudioVersion(String title, DatenFilm film) {
        if (title.contains("H\u00f6rfassung") || title.contains("Audiodeskription") || title.contains("AD |") || title.endsWith("(AD)") || title.contains("H\u00f6rspiel") || title.contains("H\u00f6rfilm") || title.contains("mit gesprochenen Untertiteln")) {
            film.setAudioVersion(true);
        }
    }

    private void parseSignLanguage(String title, DatenFilm film) {
        if (title.contains("Geb\u00e4rden")) {
            film.setSignLanguage(true);
        }
    }

    private void parseTrailerTeaser(String title, DatenFilm film) {
        if (this.ttc.check(title)) {
            film.setTrailerTeaser(true);
        }
    }

    private void parseTitel(JsonParser jp, DatenFilm datenFilm) throws IOException {
        String title = this.checkedString(jp);
        datenFilm.setTitle(title);
        this.parseAudioVersion(title, datenFilm);
        this.parseSignLanguage(title, datenFilm);
        this.parseTrailerTeaser(title, datenFilm);
        if (title.contains("(mit Untertitel)")) {
            datenFilm.setBurnedInSubtitles(true);
        }
    }

    private void parseUrl(JsonParser jp, DatenFilm datenFilm) throws IOException {
        datenFilm.setUrl(this.checkedString(jp));
    }

    private void parseLivestream(DatenFilm datenFilm) {
        if (datenFilm.getThema().equals(THEMA_LIVE)) {
            datenFilm.setLivestream(true);
        }
    }

    private void readData(JsonParser jp, ListeFilme listeFilme) throws IOException {
        JsonToken jsonToken;
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Expected data to start with an Object");
        }
        this.parseMetaData(jp, listeFilme);
        this.skipFieldDescriptions(jp);
        Configuration config = ApplicationConfiguration.getConfiguration();
        boolean loadTrailer = config.getBoolean("filmlist.load.trailer", true);
        boolean loadAudiodescription = config.getBoolean("filmlist.load.audio_description", true);
        boolean loadSignLanguage = config.getBoolean("filmlist.load.sign_language", true);
        boolean loadLivestreams = config.getBoolean("filmlist.load.livestreams", true);
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            DatenFilm datenFilm = new DatenFilm();
            this.parseSender(jp, datenFilm);
            this.parseThema(jp, datenFilm);
            this.parseTitel(jp, datenFilm);
            this.parseSendedatum(jp, datenFilm);
            this.parseTime(jp, datenFilm);
            this.parseDauer(jp, datenFilm);
            this.parseGroesse(jp, datenFilm);
            this.parseDescription(jp, datenFilm);
            this.parseUrl(jp, datenFilm);
            this.parseWebsiteLink(jp, datenFilm);
            this.parseUrlSubtitle(jp, datenFilm);
            this.skipToken(jp);
            this.parseUrlKlein(jp, datenFilm);
            this.skipToken(jp);
            this.parseUrlHd(jp, datenFilm);
            this.skipToken(jp);
            this.parseDatumLong(jp, datenFilm);
            this.skipToken(jp);
            this.parseGeo(jp, datenFilm);
            this.parseNeu(jp, datenFilm);
            this.parseLivestream(datenFilm);
            this.checkPlayList(datenFilm);
            if (!SenderFilmlistLoadApprover.isApproved(datenFilm.getSender()) || !loadTrailer && datenFilm.isTrailerTeaser() || !loadAudiodescription && datenFilm.isAudioVersion() || !loadSignLanguage && datenFilm.isSignLanguage() || !loadLivestreams && datenFilm.isLivestream()) continue;
            listeFilme.addAndInitialize(datenFilm);
            if (this.milliseconds <= 0L || datenFilm.isLivestream() || this.checkDate(datenFilm)) continue;
            listeFilme.remove(datenFilm);
        }
        stopwatch.stop();
        logger.debug("Reading filmlist took {}", (Object)stopwatch);
    }

    private void checkPlayList(@NotNull DatenFilm datenFilm) {
        if (datenFilm.getUrl().endsWith(".m3u8")) {
            datenFilm.setPlayList(true);
        }
    }

    private void checkDays(long days) {
        this.milliseconds = days > 0L ? System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(days, TimeUnit.DAYS) : 0L;
    }

    public void readFilmListe(String source2, ListeFilme listeFilme, int days) {
        try {
            logger.trace("Liste Filme lesen von: {}", (Object)source2);
            listeFilme.clear();
            this.notifyStart(source2);
            this.checkDays(days);
            if (source2.startsWith("http")) {
                URL sourceUrl = new URL(source2);
                this.processFromWeb(sourceUrl, listeFilme);
            } else {
                this.processFromFile(source2, listeFilme);
            }
        }
        catch (MalformedURLException ex) {
            logger.warn(ex);
        }
        this.notifyFertig(source2, listeFilme);
    }

    private void processFromFile(String source2, ListeFilme listeFilme) {
        try {
            Path filePath = Paths.get(source2, new String[0]);
            long fileSize = Files.size(filePath);
            if (fileSize == 0L) {
                Files.deleteIfExists(filePath);
            }
            ProgressMonitor monitor = new ProgressMonitor(source2);
            try (Source sourceFile = Okio.source(filePath, new OpenOption[0]);
                 BufferedSource bufferedSource = Okio.buffer(sourceFile);
                 InputStream is = bufferedSource.inputStream();
                 ProgressMonitorInputStream input = new ProgressMonitorInputStream(is, fileSize, monitor);
                 InputStream in = this.selectDecompressor(source2, input);
                 JsonParser jp = new JsonFactory().createParser(in);){
                this.readData(jp, listeFilme);
            }
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            logger.debug("FilmListe existiert nicht: {}", (Object)source2);
            listeFilme.clear();
        }
        catch (Exception ex) {
            logger.error("FilmListe: {}", (Object)source2, (Object)ex);
            listeFilme.clear();
        }
    }

    private void processFromWeb(URL source2, ListeFilme listeFilme) {
        block33: {
            String clientId = Konstanten.MVVERSION + "," + SystemUtils.OS_ARCH + "," + SystemUtils.OS_NAME + "," + SystemUtils.OS_VERSION;
            Request request = new Request.Builder().url(source2).header("MV-Client", clientId).get().build();
            try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();
                 ResponseBody body = response.body();){
                if (response.isSuccessful() && body != null) {
                    Request endRequest = response.request();
                    if (Config.isEnhancedLoggingEnabled()) {
                        logger.trace("Final Endpoint URL for filmlist: {}", (Object)endRequest.url().toString());
                    }
                    ProgressMonitor monitor = new ProgressMonitor(source2.toString());
                    try (ProgressMonitorInputStream input = new ProgressMonitorInputStream(body.byteStream(), body.contentLength(), monitor);
                         InputStream is = this.selectDecompressor(source2.toString(), input);
                         JsonParser jp = new JsonFactory().createParser(is);){
                        this.readData(jp, listeFilme);
                        break block33;
                    }
                }
                logger.warn("processFromWeb HTTP Response Code: {} for {}", (Object)response.code(), (Object)response.request().url().url());
            }
            catch (Exception ex) {
                logger.error("FilmListe: {}", (Object)source2, (Object)ex);
                listeFilme.clear();
            }
        }
    }

    private boolean checkDate(@NotNull DatenFilm film) {
        long time = film.getDatumFilm().getTime();
        return time == 0L || time >= this.milliseconds;
    }

    private void notifyStart(String url) {
        this.progress = 0;
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.start(new ListenerFilmeLadenEvent(url, "", this.max, 0, false));
        }
    }

    private void notifyProgress(String url, int iProgress) {
        this.progress = iProgress;
        if (this.progress > this.max) {
            this.progress = this.max;
        }
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            this.progressEvent.senderUrl = url;
            this.progressEvent.progress = this.progress;
            this.progressEvent.max = this.max;
            l.progress(this.progressEvent);
        }
    }

    private void notifyFertig(String url, ListeFilme liste) {
        logger.info("Liste Filme gelesen am: {}", (Object)DateTimeFormatter.ofPattern("dd.MM.yyyy, HH:mm").format(LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault())));
        logger.info("  erstellt am: {}", (Object)liste.metaData().getGenerationDateTimeAsString());
        logger.info("  Anzahl Filme: {}", (Object)liste.size());
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            this.progressEvent.senderUrl = url;
            this.progressEvent.text = "";
            this.progressEvent.max = this.max;
            this.progressEvent.progress = this.progress;
            l.fertig(this.progressEvent);
        }
    }

    @Override
    public void close() {
        this.removeRegisteredListeners();
    }

    class ProgressMonitor
    implements InputStreamProgressMonitor {
        private final String sourceString;
        private int oldProgress;

        public ProgressMonitor(String source2) {
            this.sourceString = source2;
        }

        @Override
        public void progress(long bytesRead, long size) {
            int iProgress = (int)(bytesRead * 100L / size);
            if (iProgress != this.oldProgress) {
                this.oldProgress = iProgress;
                FilmListReader.this.notifyProgress(this.sourceString, iProgress);
            }
        }
    }
}

