/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss2.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.KRSS2DocumentFormat;
import org.semanticweb.owlapi.formats.KRSS2DocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.krss2.parser.KRSS2OWLParserException;
import org.semanticweb.owlapi.krss2.parser.KRSS2Parser;
import org.semanticweb.owlapi.krss2.parser.ParseException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class KRSS2OWLParser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;

    @Override
    @Nonnull
    public String getName() {
        return "KRSS2OWLParser";
    }

    @Override
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new KRSS2DocumentFormatFactory();
    }

    @Override
    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        Reader reader = null;
        InputStream is = null;
        try {
            KRSS2Parser parser;
            if (documentSource.isReaderAvailable()) {
                reader = documentSource.getReader();
                parser = new KRSS2Parser(reader);
            } else if (documentSource.isInputStreamAvailable()) {
                is = documentSource.getInputStream();
                parser = new KRSS2Parser(is);
            } else {
                if (documentSource.getDocumentIRI().getNamespace().startsWith("jar:")) {
                    if (documentSource.getDocumentIRI().getNamespace().startsWith("jar:!")) {
                        String name = documentSource.getDocumentIRI().toString().substring(5);
                        if (!name.startsWith("/")) {
                            name = "/" + name;
                        }
                        is = this.getClass().getResourceAsStream(name);
                    } else {
                        try {
                            is = ((JarURLConnection)new URL(documentSource.getDocumentIRI().toString()).openConnection()).getInputStream();
                        }
                        catch (IOException e) {
                            throw new OWLParserException(e);
                        }
                    }
                } else {
                    Optional<String> headers = documentSource.getAcceptHeaders();
                    is = headers.isPresent() ? this.getInputStream(documentSource.getDocumentIRI(), configuration, headers.get()) : this.getInputStream(documentSource.getDocumentIRI(), configuration, "application/rdf+xml, application/xml; q=0.7, text/xml; q=0.6, text/plain; q=0.1, */*; q=0.09");
                }
                parser = new KRSS2Parser(is);
            }
            parser.setOntology(ontology, ontology.getOWLOntologyManager().getOWLDataFactory());
            parser.parse();
            KRSS2DocumentFormat kRSS2DocumentFormat = new KRSS2DocumentFormat();
            return kRSS2DocumentFormat;
        }
        catch (ParseException e) {
            throw new KRSS2OWLParserException(e);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }
}

