/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicModule;
import javax.media.Clock;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Time;
import javax.media.TimeBase;

public abstract class BasicSinkModule
extends BasicModule {
    private Clock clock;
    protected boolean prerolling = false;
    protected float rate = 1.0f;
    protected long stopTime = -1L;

    public void doStart() {
        super.doStart();
        if (this.clock != null) {
            this.clock.syncStart(this.clock.getTimeBase().getTime());
        }
    }

    public void doStop() {
        if (this.clock != null) {
            this.clock.stop();
        }
    }

    public void doSetMediaTime(Time t) {
        if (this.clock != null) {
            this.clock.setMediaTime(t);
        }
    }

    public float doSetRate(float r) {
        this.rate = this.clock != null ? this.clock.setRate(r) : r;
        return this.rate;
    }

    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        if (this.clock != null) {
            this.clock.setTimeBase(tb);
        }
    }

    public TimeBase getTimeBase() {
        if (this.clock != null) {
            return this.clock.getTimeBase();
        }
        return this.controller.getTimeBase();
    }

    public Time getMediaTime() {
        if (this.clock != null) {
            return this.clock.getMediaTime();
        }
        return this.controller.getMediaTime();
    }

    public long getMediaNanoseconds() {
        if (this.clock != null) {
            return this.clock.getMediaNanoseconds();
        }
        return this.controller.getMediaNanoseconds();
    }

    public Clock getClock() {
        return this.clock;
    }

    protected void setClock(Clock c) {
        this.clock = c;
    }

    public void setStopTime(Time t) {
        this.stopTime = t == Clock.RESET ? -1L : t.getNanoseconds();
    }

    public void setPreroll(long wanted, long actual) {
        if (actual < wanted) {
            this.prerolling = true;
        }
    }

    public void triggerReset() {
    }

    public void doneReset() {
    }
}

