/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.sql.DataSource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSourceMXBean;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactoryFactory;
import org.apache.tomcat.dbcp.dbcp2.DataSourceMXBean;
import org.apache.tomcat.dbcp.dbcp2.DriverFactory;
import org.apache.tomcat.dbcp.dbcp2.ObjectNameWrapper;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.PoolingDataSource;
import org.apache.tomcat.dbcp.dbcp2.SwallowedExceptionLogger;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.AbandonedConfig;
import org.apache.tomcat.dbcp.pool2.impl.BaseGenericObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.BaseObjectPoolConfig;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPoolConfig;

public class BasicDataSource
implements DataSource,
BasicDataSourceMXBean,
MBeanRegistration,
AutoCloseable {
    private static final Log log = LogFactory.getLog(BasicDataSource.class);
    private volatile Boolean defaultAutoCommit;
    private transient Boolean defaultReadOnly;
    private volatile int defaultTransactionIsolation = -1;
    private Duration defaultQueryTimeoutDuration;
    private volatile String defaultCatalog;
    private volatile String defaultSchema;
    private boolean cacheState = true;
    private Driver driver;
    private String driverClassName;
    private ClassLoader driverClassLoader;
    private boolean lifo = true;
    private int maxTotal = 8;
    private int maxIdle = 8;
    private int minIdle = 0;
    private int initialSize;
    private Duration maxWaitDuration = BaseObjectPoolConfig.DEFAULT_MAX_WAIT;
    private boolean poolPreparedStatements;
    private boolean clearStatementPoolOnReturn;
    private int maxOpenPreparedStatements = -1;
    private boolean testOnCreate;
    private boolean testOnBorrow = true;
    private boolean testOnReturn;
    private Duration durationBetweenEvictionRuns = BaseObjectPoolConfig.DEFAULT_DURATION_BETWEEN_EVICTION_RUNS;
    private int numTestsPerEvictionRun = 3;
    private Duration minEvictableIdleDuration = BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_DURATION;
    private Duration softMinEvictableIdleDuration = BaseObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_DURATION;
    private String evictionPolicyClassName = BaseObjectPoolConfig.DEFAULT_EVICTION_POLICY_CLASS_NAME;
    private boolean testWhileIdle;
    private volatile String password;
    private String connectionString;
    private String userName;
    private volatile String validationQuery;
    private volatile Duration validationQueryTimeoutDuration = Duration.ofSeconds(-1L);
    private String connectionFactoryClassName;
    private volatile List<String> connectionInitSqls;
    private boolean accessToUnderlyingConnectionAllowed;
    private Duration maxConnDuration = Duration.ofMillis(-1L);
    private boolean logExpiredConnections = true;
    private String jmxName;
    private boolean registerConnectionMBean = true;
    private boolean autoCommitOnReturn = true;
    private boolean rollbackOnReturn = true;
    private volatile Set<String> disconnectionSqlCodes;
    private boolean fastFailValidation;
    private volatile GenericObjectPool<PoolableConnection> connectionPool;
    private Properties connectionProperties = new Properties();
    private volatile DataSource dataSource;
    private volatile PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
    private AbandonedConfig abandonedConfig;
    private boolean closed;
    private ObjectNameWrapper registeredJmxObjectName;

    protected static void validateConnectionFactory(PoolableConnectionFactory poolableConnectionFactory) throws SQLException {
        PoolableConnection poolableConnection = null;
        PooledObject<PoolableConnection> pooledObject = null;
        try {
            pooledObject = poolableConnectionFactory.makeObject();
            poolableConnection = pooledObject.getObject();
            poolableConnectionFactory.activateObject(pooledObject);
            poolableConnectionFactory.validateConnection(poolableConnection);
            poolableConnectionFactory.passivateObject(pooledObject);
        }
        finally {
            if (pooledObject != null) {
                poolableConnectionFactory.destroyObject(pooledObject);
            }
        }
    }

    public void addConnectionProperty(String string, String string2) {
        this.connectionProperties.put(string, string2);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.registeredJmxObjectName != null) {
            this.registeredJmxObjectName.unregisterMBean();
            this.registeredJmxObjectName = null;
        }
        this.closed = true;
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        this.connectionPool = null;
        this.dataSource = null;
        try {
            if (genericObjectPool != null) {
                genericObjectPool.close();
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException(Utils.getMessage("pool.close.fail"), exception);
        }
    }

    private void closeConnectionPool() {
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        this.connectionPool = null;
        Utils.closeQuietly(genericObjectPool);
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        return ConnectionFactoryFactory.createConnectionFactory(this, DriverFactory.createDriver(this));
    }

    protected void createConnectionPool(PoolableConnectionFactory poolableConnectionFactory) {
        GenericObjectPoolConfig<PoolableConnection> genericObjectPoolConfig = new GenericObjectPoolConfig<PoolableConnection>();
        this.updateJmxName(genericObjectPoolConfig);
        genericObjectPoolConfig.setJmxEnabled(this.registeredJmxObjectName != null);
        if (this.getAbandonedUsageTracking() && this.abandonedConfig != null) {
            this.abandonedConfig.setUseUsageTracking(true);
        }
        GenericObjectPool<PoolableConnection> genericObjectPool = this.createObjectPool(poolableConnectionFactory, genericObjectPoolConfig, this.abandonedConfig);
        genericObjectPool.setMaxTotal(this.maxTotal);
        genericObjectPool.setMaxIdle(this.maxIdle);
        genericObjectPool.setMinIdle(this.minIdle);
        genericObjectPool.setMaxWait(this.maxWaitDuration);
        genericObjectPool.setTestOnCreate(this.testOnCreate);
        genericObjectPool.setTestOnBorrow(this.testOnBorrow);
        genericObjectPool.setTestOnReturn(this.testOnReturn);
        genericObjectPool.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        genericObjectPool.setMinEvictableIdleDuration(this.minEvictableIdleDuration);
        genericObjectPool.setSoftMinEvictableIdleDuration(this.softMinEvictableIdleDuration);
        genericObjectPool.setTestWhileIdle(this.testWhileIdle);
        genericObjectPool.setLifo(this.lifo);
        genericObjectPool.setSwallowedExceptionListener(new SwallowedExceptionLogger(log, this.logExpiredConnections));
        genericObjectPool.setEvictionPolicyClassName(this.evictionPolicyClassName);
        poolableConnectionFactory.setPool(genericObjectPool);
        this.connectionPool = genericObjectPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized DataSource createDataSource() throws SQLException {
        if (this.closed) {
            throw new SQLException("Data source is closed");
        }
        if (this.dataSource != null) {
            return this.dataSource;
        }
        BasicDataSource basicDataSource = this;
        synchronized (basicDataSource) {
            if (this.dataSource != null) {
                return this.dataSource;
            }
            this.jmxRegister();
            ConnectionFactory connectionFactory = this.createConnectionFactory();
            try {
                PoolableConnectionFactory poolableConnectionFactory = this.createPoolableConnectionFactory(connectionFactory);
                poolableConnectionFactory.setPoolStatements(this.poolPreparedStatements);
                poolableConnectionFactory.setMaxOpenPreparedStatements(this.maxOpenPreparedStatements);
                this.createConnectionPool(poolableConnectionFactory);
                DataSource dataSource = this.createDataSourceInstance();
                dataSource.setLogWriter(this.logWriter);
                this.connectionPool.addObjects(this.initialSize);
                this.startPoolMaintenance();
                this.dataSource = dataSource;
            }
            catch (RuntimeException | SQLException exception) {
                this.closeConnectionPool();
                throw exception;
            }
            catch (Exception exception) {
                this.closeConnectionPool();
                throw new SQLException("Error creating connection factory", exception);
            }
            return this.dataSource;
        }
    }

    protected DataSource createDataSourceInstance() throws SQLException {
        PoolingDataSource<PoolableConnection> poolingDataSource = new PoolingDataSource<PoolableConnection>(this.connectionPool);
        poolingDataSource.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        return poolingDataSource;
    }

    protected GenericObjectPool<PoolableConnection> createObjectPool(PoolableConnectionFactory poolableConnectionFactory, GenericObjectPoolConfig<PoolableConnection> genericObjectPoolConfig, AbandonedConfig abandonedConfig) {
        GenericObjectPool<PoolableConnection> genericObjectPool = abandonedConfig != null && (abandonedConfig.getRemoveAbandonedOnBorrow() || abandonedConfig.getRemoveAbandonedOnMaintenance()) ? new GenericObjectPool<PoolableConnection>(poolableConnectionFactory, genericObjectPoolConfig, abandonedConfig) : new GenericObjectPool<PoolableConnection>(poolableConnectionFactory, genericObjectPoolConfig);
        return genericObjectPool;
    }

    protected PoolableConnectionFactory createPoolableConnectionFactory(ConnectionFactory connectionFactory) throws SQLException {
        PoolableConnectionFactory poolableConnectionFactory = null;
        try {
            poolableConnectionFactory = this.registerConnectionMBean ? new PoolableConnectionFactory(connectionFactory, ObjectNameWrapper.unwrap(this.registeredJmxObjectName)) : new PoolableConnectionFactory(connectionFactory, null);
            poolableConnectionFactory.setValidationQuery(this.validationQuery);
            poolableConnectionFactory.setValidationQueryTimeout(this.validationQueryTimeoutDuration);
            poolableConnectionFactory.setConnectionInitSql(this.connectionInitSqls);
            poolableConnectionFactory.setDefaultReadOnly(this.defaultReadOnly);
            poolableConnectionFactory.setDefaultAutoCommit(this.defaultAutoCommit);
            poolableConnectionFactory.setDefaultTransactionIsolation(this.defaultTransactionIsolation);
            poolableConnectionFactory.setDefaultCatalog(this.defaultCatalog);
            poolableConnectionFactory.setDefaultSchema(this.defaultSchema);
            poolableConnectionFactory.setCacheState(this.cacheState);
            poolableConnectionFactory.setPoolStatements(this.poolPreparedStatements);
            poolableConnectionFactory.setClearStatementPoolOnReturn(this.clearStatementPoolOnReturn);
            poolableConnectionFactory.setMaxOpenPreparedStatements(this.maxOpenPreparedStatements);
            poolableConnectionFactory.setMaxConn(this.maxConnDuration);
            poolableConnectionFactory.setRollbackOnReturn(this.getRollbackOnReturn());
            poolableConnectionFactory.setAutoCommitOnReturn(this.getAutoCommitOnReturn());
            poolableConnectionFactory.setDefaultQueryTimeout(this.getDefaultQueryTimeoutDuration());
            poolableConnectionFactory.setFastFailValidation(this.fastFailValidation);
            poolableConnectionFactory.setDisconnectionSqlCodes(this.disconnectionSqlCodes);
            BasicDataSource.validateConnectionFactory(poolableConnectionFactory);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Cannot create PoolableConnectionFactory (" + exception.getMessage() + ")", exception);
        }
        return poolableConnectionFactory;
    }

    public void evict() throws Exception {
        if (this.connectionPool != null) {
            this.connectionPool.evict();
        }
    }

    public PrintWriter getAbandonedLogWriter() {
        return this.abandonedConfig == null ? null : this.abandonedConfig.getLogWriter();
    }

    @Override
    public boolean getAbandonedUsageTracking() {
        return this.abandonedConfig != null && this.abandonedConfig.getUseUsageTracking();
    }

    public boolean getAutoCommitOnReturn() {
        return this.autoCommitOnReturn;
    }

    @Override
    public boolean getCacheState() {
        return this.cacheState;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (Utils.isSecurityEnabled()) {
            PrivilegedExceptionAction<Connection> privilegedExceptionAction = () -> this.createDataSource().getConnection();
            try {
                return AccessController.doPrivileged(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof SQLException) {
                    throw (SQLException)throwable;
                }
                throw new SQLException(privilegedActionException);
            }
        }
        return this.createDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    public String getConnectionFactoryClassName() {
        return this.connectionFactoryClassName;
    }

    public List<String> getConnectionInitSqls() {
        List<String> list = this.connectionInitSqls;
        return list == null ? Collections.emptyList() : list;
    }

    @Override
    public String[] getConnectionInitSqlsAsArray() {
        return this.getConnectionInitSqls().toArray(Utils.EMPTY_STRING_ARRAY);
    }

    public GenericObjectPool<PoolableConnection> getConnectionPool() {
        return this.connectionPool;
    }

    Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @Deprecated
    public Integer getDefaultQueryTimeout() {
        return this.defaultQueryTimeoutDuration == null ? null : Integer.valueOf((int)this.defaultQueryTimeoutDuration.getSeconds());
    }

    public Duration getDefaultQueryTimeoutDuration() {
        return this.defaultQueryTimeoutDuration;
    }

    @Override
    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public Set<String> getDisconnectionSqlCodes() {
        Set<String> set = this.disconnectionSqlCodes;
        return set == null ? Collections.emptySet() : set;
    }

    @Override
    public String[] getDisconnectionSqlCodesAsArray() {
        return this.getDisconnectionSqlCodes().toArray(Utils.EMPTY_STRING_ARRAY);
    }

    public synchronized Driver getDriver() {
        return this.driver;
    }

    public synchronized ClassLoader getDriverClassLoader() {
        return this.driverClassLoader;
    }

    @Override
    public synchronized String getDriverClassName() {
        return this.driverClassName;
    }

    public synchronized Duration getDurationBetweenEvictionRuns() {
        return this.durationBetweenEvictionRuns;
    }

    @Deprecated
    public boolean getEnableAutoCommitOnReturn() {
        return this.autoCommitOnReturn;
    }

    public synchronized String getEvictionPolicyClassName() {
        return this.evictionPolicyClassName;
    }

    @Override
    public boolean getFastFailValidation() {
        return this.fastFailValidation;
    }

    @Override
    public synchronized int getInitialSize() {
        return this.initialSize;
    }

    public String getJmxName() {
        return this.jmxName;
    }

    @Override
    public synchronized boolean getLifo() {
        return this.lifo;
    }

    @Override
    public boolean getLogAbandoned() {
        return this.abandonedConfig != null && this.abandonedConfig.getLogAbandoned();
    }

    @Override
    public boolean getLogExpiredConnections() {
        return this.logExpiredConnections;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    public Duration getMaxConnDuration() {
        return this.maxConnDuration;
    }

    @Override
    @Deprecated
    public long getMaxConnLifetimeMillis() {
        return this.maxConnDuration.toMillis();
    }

    @Override
    public synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public synchronized int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    @Override
    public synchronized int getMaxTotal() {
        return this.maxTotal;
    }

    public synchronized Duration getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    @Override
    @Deprecated
    public synchronized long getMaxWaitMillis() {
        return this.maxWaitDuration.toMillis();
    }

    public synchronized Duration getMinEvictableIdleDuration() {
        return this.minEvictableIdleDuration;
    }

    @Override
    @Deprecated
    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleDuration.toMillis();
    }

    @Override
    public synchronized int getMinIdle() {
        return this.minIdle;
    }

    @Override
    public int getNumActive() {
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        return genericObjectPool == null ? 0 : genericObjectPool.getNumActive();
    }

    @Override
    public int getNumIdle() {
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        return genericObjectPool == null ? 0 : genericObjectPool.getNumIdle();
    }

    @Override
    public synchronized int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public String getPassword() {
        return this.password;
    }

    protected ObjectName getRegisteredJmxName() {
        return ObjectNameWrapper.unwrap(this.registeredJmxObjectName);
    }

    @Override
    public boolean getRemoveAbandonedOnBorrow() {
        return this.abandonedConfig != null && this.abandonedConfig.getRemoveAbandonedOnBorrow();
    }

    @Override
    public boolean getRemoveAbandonedOnMaintenance() {
        return this.abandonedConfig != null && this.abandonedConfig.getRemoveAbandonedOnMaintenance();
    }

    @Override
    @Deprecated
    public int getRemoveAbandonedTimeout() {
        return (int)this.getRemoveAbandonedTimeoutDuration().getSeconds();
    }

    public Duration getRemoveAbandonedTimeoutDuration() {
        return this.abandonedConfig == null ? Duration.ofSeconds(300L) : this.abandonedConfig.getRemoveAbandonedTimeoutDuration();
    }

    public boolean getRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    public synchronized Duration getSoftMinEvictableIdleDuration() {
        return this.softMinEvictableIdleDuration;
    }

    @Override
    @Deprecated
    public synchronized long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleDuration.toMillis();
    }

    @Override
    public synchronized boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    @Override
    public synchronized boolean getTestOnCreate() {
        return this.testOnCreate;
    }

    public synchronized boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    @Override
    public synchronized boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    @Override
    @Deprecated
    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.durationBetweenEvictionRuns.toMillis();
    }

    @Override
    public synchronized String getUrl() {
        return this.connectionString;
    }

    @Override
    @Deprecated
    public String getUsername() {
        return this.userName;
    }

    @Override
    public String getValidationQuery() {
        return this.validationQuery;
    }

    @Override
    @Deprecated
    public int getValidationQueryTimeout() {
        return (int)this.validationQueryTimeoutDuration.getSeconds();
    }

    public Duration getValidationQueryTimeoutDuration() {
        return this.validationQueryTimeoutDuration;
    }

    public void invalidateConnection(Connection connection) throws IllegalStateException {
        PoolableConnection poolableConnection;
        if (connection == null) {
            return;
        }
        if (this.connectionPool == null) {
            throw new IllegalStateException("Cannot invalidate connection: ConnectionPool is null.");
        }
        try {
            poolableConnection = connection.unwrap(PoolableConnection.class);
            if (poolableConnection == null) {
                throw new IllegalStateException("Cannot invalidate connection: Connection is not a poolable connection.");
            }
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("Cannot invalidate connection: Unwrapping poolable connection failed.", sQLException);
        }
        try {
            this.connectionPool.invalidateObject(poolableConnection);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Invalidating connection threw unexpected exception", exception);
        }
    }

    @Override
    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    @Override
    public boolean isClearStatementPoolOnReturn() {
        return this.clearStatementPoolOnReturn;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    @Override
    public synchronized boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isInstance(this);
    }

    private void jmxRegister() {
        if (this.registeredJmxObjectName != null) {
            return;
        }
        String string = this.getJmxName();
        if (string == null) {
            return;
        }
        this.registeredJmxObjectName = this.registerJmxObjectName(string, null);
        try {
            StandardMBean standardMBean = new StandardMBean(this, DataSourceMXBean.class);
            this.registeredJmxObjectName.registerMBean(standardMBean);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            log.warn((Object)("The requested JMX name [" + string + "] was not valid and will be ignored."));
        }
    }

    protected void log(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }

    protected void log(String string, Throwable throwable) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
            throwable.printStackTrace(this.logWriter);
        }
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        this.registeredJmxObjectName = this.registerJmxObjectName(this.getJmxName(), objectName);
        return ObjectNameWrapper.unwrap(this.registeredJmxObjectName);
    }

    private ObjectNameWrapper registerJmxObjectName(String string, ObjectName objectName) {
        ObjectNameWrapper objectNameWrapper = null;
        if (string != null) {
            try {
                objectNameWrapper = ObjectNameWrapper.wrap(string);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                log.warn((Object)("The requested JMX name '" + string + "' was not valid and will be ignored."));
            }
        }
        if (objectNameWrapper == null) {
            objectNameWrapper = ObjectNameWrapper.wrap(objectName);
        }
        return objectNameWrapper;
    }

    public void removeConnectionProperty(String string) {
        this.connectionProperties.remove(string);
    }

    @Override
    public synchronized void restart() throws SQLException {
        this.close();
        this.start();
    }

    private <T> void setAbandoned(BiConsumer<AbandonedConfig, T> biConsumer, T t) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        biConsumer.accept(this.abandonedConfig, (AbandonedConfig)t);
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        if (genericObjectPool != null) {
            genericObjectPool.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public void setAbandonedLogWriter(PrintWriter printWriter) {
        this.setAbandoned(AbandonedConfig::setLogWriter, printWriter);
    }

    public void setAbandonedUsageTracking(boolean bl) {
        this.setAbandoned(AbandonedConfig::setUseUsageTracking, bl);
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    public void setAutoCommitOnReturn(boolean bl) {
        this.autoCommitOnReturn = bl;
    }

    public void setCacheState(boolean bl) {
        this.cacheState = bl;
    }

    public void setClearStatementPoolOnReturn(boolean bl) {
        this.clearStatementPoolOnReturn = bl;
    }

    public void setConnectionFactoryClassName(String string) {
        this.connectionFactoryClassName = this.isEmpty(string) ? null : string;
    }

    public void setConnectionInitSqls(Collection<String> collection) {
        List list = Utils.isEmpty(collection) ? null : collection.stream().filter(string -> !this.isEmpty((String)string)).collect(Collectors.toList());
        this.connectionInitSqls = Utils.isEmpty(list) ? null : list;
    }

    public void setConnectionInitSqls(List<String> list) {
        this.setConnectionInitSqls((Collection<String>)list);
    }

    private <T> void setConnectionPool(BiConsumer<GenericObjectPool<PoolableConnection>, T> biConsumer, T t) {
        if (this.connectionPool != null) {
            biConsumer.accept(this.connectionPool, (GenericObjectPool<PoolableConnection>)t);
        }
    }

    public void setConnectionProperties(String string2) {
        Objects.requireNonNull(string2, "connectionProperties");
        String[] stringArray = string2.split(";");
        Properties properties = new Properties();
        Stream.of(stringArray).filter(string -> !string.isEmpty()).forEach(string -> {
            int n = string.indexOf(61);
            if (n > 0) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                properties.setProperty(string2, string3);
            } else {
                properties.setProperty((String)string, "");
            }
        });
        this.connectionProperties = properties;
    }

    public void setDefaultAutoCommit(Boolean bl) {
        this.defaultAutoCommit = bl;
    }

    public void setDefaultCatalog(String string) {
        this.defaultCatalog = this.isEmpty(string) ? null : string;
    }

    public void setDefaultQueryTimeout(Duration duration) {
        this.defaultQueryTimeoutDuration = duration;
    }

    @Deprecated
    public void setDefaultQueryTimeout(Integer n) {
        this.defaultQueryTimeoutDuration = n == null ? null : Duration.ofSeconds(n.longValue());
    }

    public void setDefaultReadOnly(Boolean bl) {
        this.defaultReadOnly = bl;
    }

    public void setDefaultSchema(String string) {
        this.defaultSchema = this.isEmpty(string) ? null : string;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.defaultTransactionIsolation = n;
    }

    public void setDisconnectionSqlCodes(Collection<String> collection) {
        Set set = Utils.isEmpty(collection) ? null : collection.stream().filter(string -> !this.isEmpty((String)string)).collect(Collectors.toSet());
        this.disconnectionSqlCodes = Utils.isEmpty(set) ? null : set;
    }

    public synchronized void setDriver(Driver driver) {
        this.driver = driver;
    }

    public synchronized void setDriverClassLoader(ClassLoader classLoader) {
        this.driverClassLoader = classLoader;
    }

    public synchronized void setDriverClassName(String string) {
        this.driverClassName = this.isEmpty(string) ? null : string;
    }

    public synchronized void setDurationBetweenEvictionRuns(Duration duration) {
        this.durationBetweenEvictionRuns = duration;
        this.setConnectionPool(BaseGenericObjectPool::setDurationBetweenEvictionRuns, duration);
    }

    @Deprecated
    public void setEnableAutoCommitOnReturn(boolean bl) {
        this.autoCommitOnReturn = bl;
    }

    public synchronized void setEvictionPolicyClassName(String string) {
        this.setConnectionPool(BaseGenericObjectPool::setEvictionPolicyClassName, string);
        this.evictionPolicyClassName = string;
    }

    public void setFastFailValidation(boolean bl) {
        this.fastFailValidation = bl;
    }

    public synchronized void setInitialSize(int n) {
        this.initialSize = n;
    }

    public void setJmxName(String string) {
        this.jmxName = string;
    }

    public synchronized void setLifo(boolean bl) {
        this.lifo = bl;
        this.setConnectionPool(BaseGenericObjectPool::setLifo, bl);
    }

    public void setLogAbandoned(boolean bl) {
        this.setAbandoned(AbandonedConfig::setLogAbandoned, bl);
    }

    public void setLogExpiredConnections(boolean bl) {
        this.logExpiredConnections = bl;
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.createDataSource().setLogWriter(printWriter);
        this.logWriter = printWriter;
    }

    public void setMaxConn(Duration duration) {
        this.maxConnDuration = duration;
    }

    @Deprecated
    public void setMaxConnLifetimeMillis(long l) {
        this.maxConnDuration = Duration.ofMillis(l);
    }

    public synchronized void setMaxIdle(int n) {
        this.maxIdle = n;
        this.setConnectionPool(GenericObjectPool::setMaxIdle, n);
    }

    public synchronized void setMaxOpenPreparedStatements(int n) {
        this.maxOpenPreparedStatements = n;
    }

    public synchronized void setMaxTotal(int n) {
        this.maxTotal = n;
        this.setConnectionPool(BaseGenericObjectPool::setMaxTotal, n);
    }

    public synchronized void setMaxWait(Duration duration) {
        this.maxWaitDuration = duration;
        this.setConnectionPool(BaseGenericObjectPool::setMaxWait, duration);
    }

    @Deprecated
    public synchronized void setMaxWaitMillis(long l) {
        this.setMaxWait(Duration.ofMillis(l));
    }

    public synchronized void setMinEvictableIdle(Duration duration) {
        this.minEvictableIdleDuration = duration;
        this.setConnectionPool(BaseGenericObjectPool::setMinEvictableIdleDuration, duration);
    }

    @Deprecated
    public synchronized void setMinEvictableIdleTimeMillis(long l) {
        this.setMinEvictableIdle(Duration.ofMillis(l));
    }

    public synchronized void setMinIdle(int n) {
        this.minIdle = n;
        this.setConnectionPool(GenericObjectPool::setMinIdle, n);
    }

    public synchronized void setNumTestsPerEvictionRun(int n) {
        this.numTestsPerEvictionRun = n;
        this.setConnectionPool(BaseGenericObjectPool::setNumTestsPerEvictionRun, n);
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public synchronized void setPoolPreparedStatements(boolean bl) {
        this.poolPreparedStatements = bl;
    }

    public void setRegisterConnectionMBean(boolean bl) {
        this.registerConnectionMBean = bl;
    }

    public void setRemoveAbandonedOnBorrow(boolean bl) {
        this.setAbandoned(AbandonedConfig::setRemoveAbandonedOnBorrow, bl);
    }

    public void setRemoveAbandonedOnMaintenance(boolean bl) {
        this.setAbandoned(AbandonedConfig::setRemoveAbandonedOnMaintenance, bl);
    }

    public void setRemoveAbandonedTimeout(Duration duration) {
        this.setAbandoned(AbandonedConfig::setRemoveAbandonedTimeout, duration);
    }

    @Deprecated
    public void setRemoveAbandonedTimeout(int n) {
        this.setAbandoned(AbandonedConfig::setRemoveAbandonedTimeout, Duration.ofSeconds(n));
    }

    public void setRollbackOnReturn(boolean bl) {
        this.rollbackOnReturn = bl;
    }

    public synchronized void setSoftMinEvictableIdle(Duration duration) {
        this.softMinEvictableIdleDuration = duration;
        this.setConnectionPool(BaseGenericObjectPool::setSoftMinEvictableIdleDuration, duration);
    }

    @Deprecated
    public synchronized void setSoftMinEvictableIdleTimeMillis(long l) {
        this.setSoftMinEvictableIdle(Duration.ofMillis(l));
    }

    public synchronized void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
        this.setConnectionPool(BaseGenericObjectPool::setTestOnBorrow, bl);
    }

    public synchronized void setTestOnCreate(boolean bl) {
        this.testOnCreate = bl;
        this.setConnectionPool(BaseGenericObjectPool::setTestOnCreate, bl);
    }

    public synchronized void setTestOnReturn(boolean bl) {
        this.testOnReturn = bl;
        this.setConnectionPool(BaseGenericObjectPool::setTestOnReturn, bl);
    }

    public synchronized void setTestWhileIdle(boolean bl) {
        this.testWhileIdle = bl;
        this.setConnectionPool(BaseGenericObjectPool::setTestWhileIdle, bl);
    }

    @Deprecated
    public synchronized void setTimeBetweenEvictionRunsMillis(long l) {
        this.setDurationBetweenEvictionRuns(Duration.ofMillis(l));
    }

    public synchronized void setUrl(String string) {
        this.connectionString = string;
    }

    public void setUsername(String string) {
        this.userName = string;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = this.isEmpty(string) ? null : string;
    }

    public void setValidationQueryTimeout(Duration duration) {
        this.validationQueryTimeoutDuration = duration;
    }

    @Deprecated
    public void setValidationQueryTimeout(int n) {
        this.validationQueryTimeoutDuration = Duration.ofSeconds(n);
    }

    @Override
    public synchronized void start() throws SQLException {
        this.closed = false;
        this.createDataSource();
    }

    protected void startPoolMaintenance() {
        if (this.connectionPool != null && this.durationBetweenEvictionRuns.compareTo(Duration.ZERO) > 0) {
            this.connectionPool.setDurationBetweenEvictionRuns(this.durationBetweenEvictionRuns);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return clazz.cast(this);
        }
        throw new SQLException(this + " is not a wrapper for " + clazz);
    }

    private void updateJmxName(GenericObjectPoolConfig<?> genericObjectPoolConfig) {
        if (this.registeredJmxObjectName == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(this.registeredJmxObjectName.toString());
        stringBuilder.append(",connectionpool=");
        genericObjectPoolConfig.setJmxNameBase(stringBuilder.toString());
        genericObjectPoolConfig.setJmxNamePrefix("connections");
    }

    static {
        DriverManager.getDrivers();
        try {
            if (Utils.isSecurityEnabled()) {
                ClassLoader classLoader = BasicDataSource.class.getClassLoader();
                String string = BasicDataSource.class.getPackage().getName();
                classLoader.loadClass(string + ".DelegatingCallableStatement");
                classLoader.loadClass(string + ".DelegatingDatabaseMetaData");
                classLoader.loadClass(string + ".DelegatingPreparedStatement");
                classLoader.loadClass(string + ".DelegatingResultSet");
                classLoader.loadClass(string + ".PoolableCallableStatement");
                classLoader.loadClass(string + ".PoolablePreparedStatement");
                classLoader.loadClass(string + ".PoolingConnection$StatementType");
                classLoader.loadClass(string + ".PStmtKey");
                String string2 = PooledObject.class.getPackage().getName();
                classLoader.loadClass(string2 + ".impl.LinkedBlockingDeque$Node");
                classLoader.loadClass(string2 + ".impl.GenericKeyedObjectPool$ObjectDeque");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to pre-load classes", classNotFoundException);
        }
    }
}

