/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.cpdsadapter;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.tomcat.dbcp.dbcp2.DelegatingCallableStatement;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.cpdsadapter.PooledConnectionImpl;

final class ConnectionImpl
extends DelegatingConnection<Connection> {
    private final boolean accessToUnderlyingConnectionAllowed;
    private final PooledConnectionImpl pooledConnection;

    ConnectionImpl(PooledConnectionImpl pooledConnectionImpl, Connection connection, boolean bl) {
        super(connection);
        this.pooledConnection = pooledConnectionImpl;
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosedInternal()) {
            try {
                this.passivate();
            }
            finally {
                this.setClosedInternal(true);
                this.pooledConnection.notifyListeners();
            }
        }
    }

    @Override
    public Connection getDelegate() {
        if (this.isAccessToUnderlyingConnectionAllowed()) {
            return this.getDelegateInternal();
        }
        return null;
    }

    @Override
    public Connection getInnermostDelegate() {
        if (this.isAccessToUnderlyingConnectionAllowed()) {
            return super.getInnermostDelegateInternal();
        }
        return null;
    }

    PooledConnectionImpl getPooledConnectionImpl() {
        return this.pooledConnection;
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingCallableStatement(this, this.pooledConnection.prepareCall(string));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingCallableStatement(this, this.pooledConnection.prepareCall(string, n, n2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingCallableStatement(this, this.pooledConnection.prepareCall(string, n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this.pooledConnection.prepareStatement(string));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this.pooledConnection.prepareStatement(string, n));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this.pooledConnection.prepareStatement(string, n, n2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this.pooledConnection.prepareStatement(string, n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this.pooledConnection.prepareStatement(string, nArray));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this.pooledConnection.prepareStatement(string, stringArray));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }
}

