# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Meta message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # *
    #  This message contains meta information about the environment. Consumers can use
    #  this for various purposes.
    ##
    class Meta < Message
      ##
      # *
      #  The [SEMVER](https://semver.org/) version number of the protocol
      ##
      attr_reader :protocol_version

      ##
      # SpecFlow, Cucumber-JVM, Cucumber.js, Cucumber-Ruby, Behat etc.
      ##
      attr_reader :implementation

      ##
      # Java, Ruby, Node.js etc
      ##
      attr_reader :runtime

      ##
      # Windows, Linux, MacOS etc
      ##
      attr_reader :os

      ##
      # 386, arm, amd64 etc
      ##
      attr_reader :cpu

      attr_reader :ci

      def initialize(
        protocol_version: '',
        implementation: Product.new,
        runtime: Product.new,
        os: Product.new,
        cpu: Product.new,
        ci: nil
      )
        @protocol_version = protocol_version
        @implementation = implementation
        @runtime = runtime
        @os = os
        @cpu = cpu
        @ci = ci
        super()
      end

      ##
      # Returns a new Meta from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Meta.from_h(some_hash) # => #<Cucumber::Messages::Meta:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          protocol_version: hash[:protocolVersion],
          implementation: Product.from_h(hash[:implementation]),
          runtime: Product.from_h(hash[:runtime]),
          os: Product.from_h(hash[:os]),
          cpu: Product.from_h(hash[:cpu]),
          ci: Ci.from_h(hash[:ci])
        )
      end
    end
  end
end
