/** @type {import('stylelint').PublicApi['rules']} */
const rules = {
	get 'alpha-value-notation'() {
		return import('./alpha-value-notation/index.mjs').then((m) => m.default);
	},
	get 'annotation-no-unknown'() {
		return import('./annotation-no-unknown/index.mjs').then((m) => m.default);
	},
	get 'at-rule-allowed-list'() {
		return import('./at-rule-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'at-rule-disallowed-list'() {
		return import('./at-rule-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'at-rule-empty-line-before'() {
		return import('./at-rule-empty-line-before/index.mjs').then((m) => m.default);
	},
	get 'at-rule-no-unknown'() {
		return import('./at-rule-no-unknown/index.mjs').then((m) => m.default);
	},
	get 'at-rule-no-vendor-prefix'() {
		return import('./at-rule-no-vendor-prefix/index.mjs').then((m) => m.default);
	},
	get 'at-rule-property-required-list'() {
		return import('./at-rule-property-required-list/index.mjs').then((m) => m.default);
	},
	get 'block-no-empty'() {
		return import('./block-no-empty/index.mjs').then((m) => m.default);
	},
	get 'color-function-notation'() {
		return import('./color-function-notation/index.mjs').then((m) => m.default);
	},
	get 'color-hex-alpha'() {
		return import('./color-hex-alpha/index.mjs').then((m) => m.default);
	},
	get 'color-hex-length'() {
		return import('./color-hex-length/index.mjs').then((m) => m.default);
	},
	get 'color-named'() {
		return import('./color-named/index.mjs').then((m) => m.default);
	},
	get 'color-no-hex'() {
		return import('./color-no-hex/index.mjs').then((m) => m.default);
	},
	get 'color-no-invalid-hex'() {
		return import('./color-no-invalid-hex/index.mjs').then((m) => m.default);
	},
	get 'comment-empty-line-before'() {
		return import('./comment-empty-line-before/index.mjs').then((m) => m.default);
	},
	get 'comment-no-empty'() {
		return import('./comment-no-empty/index.mjs').then((m) => m.default);
	},
	get 'comment-pattern'() {
		return import('./comment-pattern/index.mjs').then((m) => m.default);
	},
	get 'comment-whitespace-inside'() {
		return import('./comment-whitespace-inside/index.mjs').then((m) => m.default);
	},
	get 'comment-word-disallowed-list'() {
		return import('./comment-word-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'custom-media-pattern'() {
		return import('./custom-media-pattern/index.mjs').then((m) => m.default);
	},
	get 'custom-property-empty-line-before'() {
		return import('./custom-property-empty-line-before/index.mjs').then((m) => m.default);
	},
	get 'custom-property-no-missing-var-function'() {
		return import('./custom-property-no-missing-var-function/index.mjs').then((m) => m.default);
	},
	get 'custom-property-pattern'() {
		return import('./custom-property-pattern/index.mjs').then((m) => m.default);
	},
	get 'declaration-block-no-duplicate-custom-properties'() {
		return import('./declaration-block-no-duplicate-custom-properties/index.mjs').then(
			(m) => m.default,
		);
	},
	get 'declaration-block-no-duplicate-properties'() {
		return import('./declaration-block-no-duplicate-properties/index.mjs').then((m) => m.default);
	},
	get 'declaration-block-no-redundant-longhand-properties'() {
		return import('./declaration-block-no-redundant-longhand-properties/index.mjs').then(
			(m) => m.default,
		);
	},
	get 'declaration-block-no-shorthand-property-overrides'() {
		return import('./declaration-block-no-shorthand-property-overrides/index.mjs').then(
			(m) => m.default,
		);
	},
	get 'declaration-block-single-line-max-declarations'() {
		return import('./declaration-block-single-line-max-declarations/index.mjs').then(
			(m) => m.default,
		);
	},
	get 'declaration-empty-line-before'() {
		return import('./declaration-empty-line-before/index.mjs').then((m) => m.default);
	},
	get 'declaration-no-important'() {
		return import('./declaration-no-important/index.mjs').then((m) => m.default);
	},
	get 'declaration-property-max-values'() {
		return import('./declaration-property-max-values/index.mjs').then((m) => m.default);
	},
	get 'declaration-property-unit-allowed-list'() {
		return import('./declaration-property-unit-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'declaration-property-unit-disallowed-list'() {
		return import('./declaration-property-unit-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'declaration-property-value-allowed-list'() {
		return import('./declaration-property-value-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'declaration-property-value-disallowed-list'() {
		return import('./declaration-property-value-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'declaration-property-value-no-unknown'() {
		return import('./declaration-property-value-no-unknown/index.mjs').then((m) => m.default);
	},
	get 'font-family-name-quotes'() {
		return import('./font-family-name-quotes/index.mjs').then((m) => m.default);
	},
	get 'font-family-no-duplicate-names'() {
		return import('./font-family-no-duplicate-names/index.mjs').then((m) => m.default);
	},
	get 'font-family-no-missing-generic-family-keyword'() {
		return import('./font-family-no-missing-generic-family-keyword/index.mjs').then(
			(m) => m.default,
		);
	},
	get 'font-weight-notation'() {
		return import('./font-weight-notation/index.mjs').then((m) => m.default);
	},
	get 'function-allowed-list'() {
		return import('./function-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'function-calc-no-unspaced-operator'() {
		return import('./function-calc-no-unspaced-operator/index.mjs').then((m) => m.default);
	},
	get 'function-disallowed-list'() {
		return import('./function-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'function-linear-gradient-no-nonstandard-direction'() {
		return import('./function-linear-gradient-no-nonstandard-direction/index.mjs').then(
			(m) => m.default,
		);
	},
	get 'function-name-case'() {
		return import('./function-name-case/index.mjs').then((m) => m.default);
	},
	get 'function-no-unknown'() {
		return import('./function-no-unknown/index.mjs').then((m) => m.default);
	},
	get 'function-url-no-scheme-relative'() {
		return import('./function-url-no-scheme-relative/index.mjs').then((m) => m.default);
	},
	get 'function-url-quotes'() {
		return import('./function-url-quotes/index.mjs').then((m) => m.default);
	},
	get 'function-url-scheme-allowed-list'() {
		return import('./function-url-scheme-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'function-url-scheme-disallowed-list'() {
		return import('./function-url-scheme-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'hue-degree-notation'() {
		return import('./hue-degree-notation/index.mjs').then((m) => m.default);
	},
	get 'import-notation'() {
		return import('./import-notation/index.mjs').then((m) => m.default);
	},
	get 'keyframe-block-no-duplicate-selectors'() {
		return import('./keyframe-block-no-duplicate-selectors/index.mjs').then((m) => m.default);
	},
	get 'keyframe-declaration-no-important'() {
		return import('./keyframe-declaration-no-important/index.mjs').then((m) => m.default);
	},
	get 'keyframe-selector-notation'() {
		return import('./keyframe-selector-notation/index.mjs').then((m) => m.default);
	},
	get 'keyframes-name-pattern'() {
		return import('./keyframes-name-pattern/index.mjs').then((m) => m.default);
	},
	get 'length-zero-no-unit'() {
		return import('./length-zero-no-unit/index.mjs').then((m) => m.default);
	},
	get 'lightness-notation'() {
		return import('./lightness-notation/index.mjs').then((m) => m.default);
	},
	get 'max-nesting-depth'() {
		return import('./max-nesting-depth/index.mjs').then((m) => m.default);
	},
	get 'media-feature-name-allowed-list'() {
		return import('./media-feature-name-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'media-feature-name-disallowed-list'() {
		return import('./media-feature-name-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'media-feature-name-no-unknown'() {
		return import('./media-feature-name-no-unknown/index.mjs').then((m) => m.default);
	},
	get 'media-feature-name-no-vendor-prefix'() {
		return import('./media-feature-name-no-vendor-prefix/index.mjs').then((m) => m.default);
	},
	get 'media-feature-name-unit-allowed-list'() {
		return import('./media-feature-name-unit-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'media-feature-name-value-allowed-list'() {
		return import('./media-feature-name-value-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'media-feature-name-value-no-unknown'() {
		return import('./media-feature-name-value-no-unknown/index.mjs').then((m) => m.default);
	},
	get 'media-feature-range-notation'() {
		return import('./media-feature-range-notation/index.mjs').then((m) => m.default);
	},
	get 'media-query-no-invalid'() {
		return import('./media-query-no-invalid/index.mjs').then((m) => m.default);
	},
	get 'named-grid-areas-no-invalid'() {
		return import('./named-grid-areas-no-invalid/index.mjs').then((m) => m.default);
	},
	get 'no-descending-specificity'() {
		return import('./no-descending-specificity/index.mjs').then((m) => m.default);
	},
	get 'no-duplicate-at-import-rules'() {
		return import('./no-duplicate-at-import-rules/index.mjs').then((m) => m.default);
	},
	get 'no-duplicate-selectors'() {
		return import('./no-duplicate-selectors/index.mjs').then((m) => m.default);
	},
	get 'no-empty-source'() {
		return import('./no-empty-source/index.mjs').then((m) => m.default);
	},
	get 'no-invalid-double-slash-comments'() {
		return import('./no-invalid-double-slash-comments/index.mjs').then((m) => m.default);
	},
	get 'no-invalid-position-at-import-rule'() {
		return import('./no-invalid-position-at-import-rule/index.mjs').then((m) => m.default);
	},
	get 'no-irregular-whitespace'() {
		return import('./no-irregular-whitespace/index.mjs').then((m) => m.default);
	},
	get 'no-unknown-animations'() {
		return import('./no-unknown-animations/index.mjs').then((m) => m.default);
	},
	get 'no-unknown-custom-media'() {
		return import('./no-unknown-custom-media/index.mjs').then((m) => m.default);
	},
	get 'no-unknown-custom-properties'() {
		return import('./no-unknown-custom-properties/index.mjs').then((m) => m.default);
	},
	get 'number-max-precision'() {
		return import('./number-max-precision/index.mjs').then((m) => m.default);
	},
	get 'property-allowed-list'() {
		return import('./property-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'property-disallowed-list'() {
		return import('./property-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'property-no-unknown'() {
		return import('./property-no-unknown/index.mjs').then((m) => m.default);
	},
	get 'property-no-vendor-prefix'() {
		return import('./property-no-vendor-prefix/index.mjs').then((m) => m.default);
	},
	get 'rule-empty-line-before'() {
		return import('./rule-empty-line-before/index.mjs').then((m) => m.default);
	},
	get 'rule-selector-property-disallowed-list'() {
		return import('./rule-selector-property-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'selector-anb-no-unmatchable'() {
		return import('./selector-anb-no-unmatchable/index.mjs').then((m) => m.default);
	},
	get 'selector-attribute-name-disallowed-list'() {
		return import('./selector-attribute-name-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'selector-attribute-operator-allowed-list'() {
		return import('./selector-attribute-operator-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'selector-attribute-operator-disallowed-list'() {
		return import('./selector-attribute-operator-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'selector-attribute-quotes'() {
		return import('./selector-attribute-quotes/index.mjs').then((m) => m.default);
	},
	get 'selector-class-pattern'() {
		return import('./selector-class-pattern/index.mjs').then((m) => m.default);
	},
	get 'selector-combinator-allowed-list'() {
		return import('./selector-combinator-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'selector-combinator-disallowed-list'() {
		return import('./selector-combinator-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'selector-disallowed-list'() {
		return import('./selector-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'selector-id-pattern'() {
		return import('./selector-id-pattern/index.mjs').then((m) => m.default);
	},
	get 'selector-max-attribute'() {
		return import('./selector-max-attribute/index.mjs').then((m) => m.default);
	},
	get 'selector-max-class'() {
		return import('./selector-max-class/index.mjs').then((m) => m.default);
	},
	get 'selector-max-combinators'() {
		return import('./selector-max-combinators/index.mjs').then((m) => m.default);
	},
	get 'selector-max-compound-selectors'() {
		return import('./selector-max-compound-selectors/index.mjs').then((m) => m.default);
	},
	get 'selector-max-id'() {
		return import('./selector-max-id/index.mjs').then((m) => m.default);
	},
	get 'selector-max-pseudo-class'() {
		return import('./selector-max-pseudo-class/index.mjs').then((m) => m.default);
	},
	get 'selector-max-specificity'() {
		return import('./selector-max-specificity/index.mjs').then((m) => m.default);
	},
	get 'selector-max-type'() {
		return import('./selector-max-type/index.mjs').then((m) => m.default);
	},
	get 'selector-max-universal'() {
		return import('./selector-max-universal/index.mjs').then((m) => m.default);
	},
	get 'selector-nested-pattern'() {
		return import('./selector-nested-pattern/index.mjs').then((m) => m.default);
	},
	get 'selector-no-qualifying-type'() {
		return import('./selector-no-qualifying-type/index.mjs').then((m) => m.default);
	},
	get 'selector-no-vendor-prefix'() {
		return import('./selector-no-vendor-prefix/index.mjs').then((m) => m.default);
	},
	get 'selector-not-notation'() {
		return import('./selector-not-notation/index.mjs').then((m) => m.default);
	},
	get 'selector-pseudo-class-allowed-list'() {
		return import('./selector-pseudo-class-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'selector-pseudo-class-disallowed-list'() {
		return import('./selector-pseudo-class-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'selector-pseudo-class-no-unknown'() {
		return import('./selector-pseudo-class-no-unknown/index.mjs').then((m) => m.default);
	},
	get 'selector-pseudo-element-allowed-list'() {
		return import('./selector-pseudo-element-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'selector-pseudo-element-colon-notation'() {
		return import('./selector-pseudo-element-colon-notation/index.mjs').then((m) => m.default);
	},
	get 'selector-pseudo-element-disallowed-list'() {
		return import('./selector-pseudo-element-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'selector-pseudo-element-no-unknown'() {
		return import('./selector-pseudo-element-no-unknown/index.mjs').then((m) => m.default);
	},
	get 'selector-type-case'() {
		return import('./selector-type-case/index.mjs').then((m) => m.default);
	},
	get 'selector-type-no-unknown'() {
		return import('./selector-type-no-unknown/index.mjs').then((m) => m.default);
	},
	get 'shorthand-property-no-redundant-values'() {
		return import('./shorthand-property-no-redundant-values/index.mjs').then((m) => m.default);
	},
	get 'string-no-newline'() {
		return import('./string-no-newline/index.mjs').then((m) => m.default);
	},
	get 'time-min-milliseconds'() {
		return import('./time-min-milliseconds/index.mjs').then((m) => m.default);
	},
	get 'unit-allowed-list'() {
		return import('./unit-allowed-list/index.mjs').then((m) => m.default);
	},
	get 'unit-disallowed-list'() {
		return import('./unit-disallowed-list/index.mjs').then((m) => m.default);
	},
	get 'unit-no-unknown'() {
		return import('./unit-no-unknown/index.mjs').then((m) => m.default);
	},
	get 'value-keyword-case'() {
		return import('./value-keyword-case/index.mjs').then((m) => m.default);
	},
	get 'value-no-vendor-prefix'() {
		return import('./value-no-vendor-prefix/index.mjs').then((m) => m.default);
	},
};

export default rules;
