/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.Field;
import com.dickimawbooks.bib2gls.FieldCaseChange;
import com.dickimawbooks.bib2gls.FieldValueCase;
import com.dickimawbooks.bib2gls.FieldValueCs;
import com.dickimawbooks.bib2gls.FieldValueElement;
import com.dickimawbooks.bib2gls.FieldValueGroupMatch;
import com.dickimawbooks.bib2gls.FieldValueInterpret;
import com.dickimawbooks.bib2gls.FieldValueLabelify;
import com.dickimawbooks.bib2gls.FieldValueLength;
import com.dickimawbooks.bib2gls.FieldValueString;
import com.dickimawbooks.bib2gls.FieldValueTrim;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.bib.BibValue;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.util.Vector;

public class FieldValueList
extends Vector<FieldValueElement>
implements FieldValueElement {
    public FieldValueList() {
    }

    public FieldValueList(int n) {
        super(n);
    }

    @Override
    public BibValue getValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        BibValueList bibValueList = new BibValueList();
        for (FieldValueElement fieldValueElement : this) {
            BibValue bibValue = fieldValueElement.getValue(bib2GlsEntry);
            if (bibValue == null) {
                return null;
            }
            bibValueList.add(bibValue);
        }
        return bibValueList;
    }

    @Override
    public String getStringValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        StringBuilder stringBuilder = new StringBuilder();
        for (FieldValueElement fieldValueElement : this) {
            String string = fieldValueElement.getStringValue(bib2GlsEntry);
            if (string == null) {
                return null;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static FieldValueList pop(GlsResource glsResource, String string, TeXObjectList teXObjectList) throws Bib2GlsException, IOException {
        TeXParser teXParser = glsResource.getParser();
        Bib2Gls bib2Gls = glsResource.getBib2Gls();
        FieldValueList fieldValueList = new FieldValueList();
        boolean bl = true;
        TeXObjectList teXObjectList2 = null;
        TeXObjectList teXObjectList3 = new TeXObjectList();
        while (teXObjectList.size() > 0) {
            FieldValueElement fieldValueElement;
            TeXObject teXObject = teXObjectList.peek();
            if (teXObjectList2 != null) {
                if (teXObject instanceof Group) {
                    teXObjectList3.add(teXObjectList.pop());
                    teXObjectList.push(((Group)teXObject).splitTokens(teXParser), true);
                    continue;
                }
                if (teXObject instanceof SingleToken && ((SingleToken)teXObject).getCharCode() == 34) {
                    teXObjectList3.add(teXObjectList.pop());
                    fieldValueList.add(new FieldValueString(teXObjectList2, true));
                    teXObjectList2 = null;
                    bl = false;
                    continue;
                }
                if (teXObject instanceof ControlSequence) {
                    teXObjectList3.add(teXObjectList.pop());
                    String string2 = ((ControlSequence)teXObject).getName();
                    if (string2.equals("\"")) {
                        teXObject = teXParser.getListener().getOther(34);
                    }
                    teXObjectList2.add(teXObject);
                    continue;
                }
                teXObjectList2.add(teXObject);
                teXObjectList3.add(teXObjectList.pop());
                continue;
            }
            if (teXObject instanceof ControlSequence) {
                String string3 = ((ControlSequence)teXObject).getName();
                if (bl) {
                    Object object;
                    teXObjectList3.add(teXObjectList.pop());
                    if (string3.equals("MGP")) {
                        object = TeXParserUtils.popLabelString(teXParser, teXObjectList);
                        try {
                            fieldValueElement = new FieldValueGroupMatch(Integer.parseInt((String)object));
                        }
                        catch (NumberFormatException numberFormatException) {
                            fieldValueElement = new FieldValueGroupMatch((String)object);
                        }
                        fieldValueList.add(fieldValueElement);
                        teXObjectList3.addAll(TeXParserUtils.createGroup(teXParser, teXParser.getListener().createString((String)object)));
                    } else {
                        object = TeXParserUtils.popArg(teXParser, teXObjectList);
                        teXObjectList3.addAll(TeXParserUtils.createGroup(teXParser, (TeXObject)object.clone()));
                        fieldValueList.add(FieldValueList.getQuark(string3, (TeXObject)object, glsResource, string));
                    }
                    bl = false;
                    continue;
                }
                throw new Bib2GlsException(bib2Gls.getMessage("error.expected_before_after", "+", teXObject.toString(teXParser), teXObjectList3.toString(teXParser)));
            }
            if (teXObject instanceof WhiteSpace) {
                teXObjectList3.add(teXObjectList.pop());
                continue;
            }
            if (teXObject instanceof Group) {
                if (bl) {
                    teXObject = teXObjectList.popArg(teXParser);
                    FieldValueString fieldValueString = new FieldValueString(teXObject, false);
                    fieldValueList.add(fieldValueString);
                    teXObjectList3.add(teXParser.getListener().createString(fieldValueString.toString()));
                    bl = false;
                    continue;
                }
                throw new Bib2GlsException(bib2Gls.getMessage("error.expected_before_after", "+", teXObject.toString(teXParser), teXObjectList3.toString(teXParser)));
            }
            if (teXObject instanceof SingleToken) {
                int n = ((SingleToken)teXObject).getCharCode();
                int n2 = ((SingleToken)teXObject).getCatCode();
                if (n2 == 1) {
                    if (bl) {
                        teXObject = teXObjectList.popArg(teXParser);
                        fieldValueElement = new FieldValueString(teXObject, false);
                        fieldValueList.add(fieldValueElement);
                        teXObjectList3.add(teXParser.getListener().createString(((FieldValueString)fieldValueElement).toString()));
                        bl = false;
                        continue;
                    }
                    throw new Bib2GlsException(bib2Gls.getMessage("error.expected_before_after", "+", teXObject.toString(teXParser), teXObjectList3.toString(teXParser)));
                }
                if (n == 43) {
                    teXObjectList3.add(teXObjectList.pop());
                    bl = true;
                    continue;
                }
                if (n == 34) {
                    if (!bl) {
                        throw new Bib2GlsException(bib2Gls.getMessage("error.expected_before_after", "+", teXObject.toString(teXParser), teXObjectList3.toString(teXParser)));
                    }
                    teXObjectList3.add(teXObjectList.pop());
                    teXObjectList2 = teXParser.getListener().createStack();
                    bl = false;
                    continue;
                }
                if (n == 91 || n == 44) break;
                if (bl) {
                    fieldValueElement = Field.popField(glsResource, string, teXObjectList);
                    fieldValueList.add(fieldValueElement);
                    bl = false;
                    teXObjectList3.addAll(teXParser.getListener().createString(((Field)fieldValueElement).toString()));
                    continue;
                }
                if (!teXObjectList3.isEmpty()) {
                    throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.expected_after", "> + [", teXObjectList3.toString(teXParser), teXObject.toString(teXParser)));
                }
                throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.expected", "> + [", teXObject.toString(teXParser)));
            }
            if (bl) {
                if (!teXObjectList3.isEmpty()) {
                    throw new Bib2GlsException(bib2Gls.getMessage("error.expected_field_or_string_condition_after", teXObjectList3.toString(teXParser), teXObject.toString(teXParser)));
                }
                throw new Bib2GlsException(bib2Gls.getMessage("error.expected_field_or_string_condition", teXObject.toString(teXParser)));
            }
            if (!teXObjectList3.isEmpty()) {
                throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.expected_after", "> + [", teXObjectList3.toString(teXParser), teXObject.toString(teXParser)));
            }
            throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.expected", "> + [", teXObject.toString(teXParser)));
        }
        if (bl && !fieldValueList.isEmpty()) {
            throw new Bib2GlsException(bib2Gls.getMessage("error.expected_field_or_string_after", fieldValueList.toString() + " + "));
        }
        return fieldValueList;
    }

    public static FieldValueElement getQuark(String string, TeXObject teXObject, GlsResource glsResource, String string2) throws Bib2GlsException, IOException {
        TeXParser teXParser = glsResource.getParser();
        Bib2Gls bib2Gls = glsResource.getBib2Gls();
        if (!teXParser.isStack(teXObject)) {
            throw new Bib2GlsException(bib2Gls.getMessage("error.unexpected_content_in_arg", teXObject.toString(teXParser), "\\" + string));
        }
        TeXObjectList teXObjectList = (TeXObjectList)teXObject;
        FieldValueList fieldValueList = FieldValueList.pop(glsResource, string2, teXObjectList);
        teXObjectList.popLeadingWhiteSpace();
        if (!teXObjectList.isEmpty()) {
            throw new Bib2GlsException(bib2Gls.getMessage("error.unexpected_content_in_arg", teXObjectList.toString(teXParser), "\\" + string));
        }
        if (FieldCaseChange.isFieldCaseChange(string)) {
            return new FieldValueCase(fieldValueList, FieldCaseChange.getFieldCaseChange(string));
        }
        if (string.equals("INTERPRET")) {
            return new FieldValueInterpret(fieldValueList);
        }
        if (string.equals("LABELIFY")) {
            return new FieldValueLabelify(fieldValueList, false);
        }
        if (string.equals("LABELIFYLIST")) {
            return new FieldValueLabelify(fieldValueList, true);
        }
        if (string.equals("TRIM")) {
            return new FieldValueTrim(fieldValueList);
        }
        if (string.equals("CS")) {
            return new FieldValueCs(fieldValueList);
        }
        if (string.equals("LEN")) {
            return new FieldValueLength(fieldValueList);
        }
        throw new Bib2GlsException(bib2Gls.getMessage("error.expected_field_or_string_condition", "\\" + string));
    }
}

