/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.PathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class PositionPathInterpolator
extends PathInterpolator {
    private Transform3D position = new Transform3D();
    private Vector3f pos = new Vector3f();
    private Point3f[] positions;
    private float prevInterpolationValue = Float.NaN;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    PositionPathInterpolator() {
    }

    public PositionPathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float[] fArray, Point3f[] point3fArray) {
        super(alpha, transformGroup, transform3D, fArray);
        if (fArray.length != point3fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("PositionPathInterpolator0"));
        }
        this.setPathArrays(point3fArray);
    }

    public void setPosition(int n, Point3f point3f) {
        this.positions[n].set((Tuple3f)point3f);
    }

    public void getPosition(int n, Point3f point3f) {
        point3f.set((Tuple3f)this.positions[n]);
    }

    public void setPathArrays(float[] fArray, Point3f[] point3fArray) {
        if (fArray.length != point3fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("PositionPathInterpolator0"));
        }
        this.setKnots(fArray);
        this.setPathArrays(point3fArray);
    }

    private void setPathArrays(Point3f[] point3fArray) {
        this.positions = new Point3f[point3fArray.length];
        for (int i = 0; i < point3fArray.length; ++i) {
            this.positions[i] = new Point3f();
            this.positions[i].set((Tuple3f)point3fArray[i]);
        }
    }

    public void getPositions(Point3f[] point3fArray) {
        for (int i = 0; i < this.positions.length; ++i) {
            point3fArray[i].set((Tuple3f)this.positions[i]);
        }
    }

    public void setAxisOfTranslation(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfTranslation() {
        return this.getTransformAxis();
    }

    @Override
    public void computeTransform(float f, Transform3D transform3D) {
        this.computePathInterpolation(f);
        if (this.currentKnotIndex == 0 && this.currentInterpolationValue == 0.0f) {
            this.pos.x = this.positions[0].x;
            this.pos.y = this.positions[0].y;
            this.pos.z = this.positions[0].z;
        } else {
            this.pos.x = this.positions[this.currentKnotIndex].x + (this.positions[this.currentKnotIndex + 1].x - this.positions[this.currentKnotIndex].x) * this.currentInterpolationValue;
            this.pos.y = this.positions[this.currentKnotIndex].y + (this.positions[this.currentKnotIndex + 1].y - this.positions[this.currentKnotIndex].y) * this.currentInterpolationValue;
            this.pos.z = this.positions[this.currentKnotIndex].z + (this.positions[this.currentKnotIndex + 1].z - this.positions[this.currentKnotIndex].z) * this.currentInterpolationValue;
        }
        this.position.setIdentity();
        this.position.setTranslation(this.pos);
        transform3D.mul(this.axis, this.position);
        transform3D.mul(transform3D, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean bl) {
        PositionPathInterpolator positionPathInterpolator = new PositionPathInterpolator();
        positionPathInterpolator.duplicateNode(this, bl);
        return positionPathInterpolator;
    }

    @Override
    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        PositionPathInterpolator positionPathInterpolator = (PositionPathInterpolator)node;
        int n = positionPathInterpolator.getArrayLengths();
        this.positions = new Point3f[n];
        Point3f point3f = new Point3f();
        for (int i = 0; i < n; ++i) {
            this.positions[i] = new Point3f();
            positionPathInterpolator.getPosition(i, point3f);
            this.setPosition(i, point3f);
        }
    }
}

