import ts = require("./typesystem");
import su = require("./schemaUtil");
import { Constraint } from "./typesystem";
import { AbstractType } from "./typesystem";
import { Status } from "./typesystem";
export declare type IValidationPath = ts.IValidationPath;
/**
 * this class is an abstract super type for every constraint that can select properties from objects
 */
export declare abstract class MatchesProperty extends ts.Constraint {
    private _type;
    protected optional: boolean;
    matches(s: string): boolean;
    constructor(_type: ts.AbstractType, optional?: boolean);
    private static CLASS_IDENTIFIER_MatchesProperty;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is MatchesProperty;
    abstract path(): string;
    check(i: any, p: ts.IValidationPath): ts.Status;
    patchPath(p: ts.IValidationPath, name: string): IValidationPath;
    validateProp(i: any, n: string, t: ts.AbstractType, q: ts.IValidationPath): ts.Status;
    abstract propId(): string;
    validateSelfIndividual(st: ts.Status, registry: ts.TypeRegistry): ts.Status;
    range(): ts.AbstractType;
    isOptional(): boolean;
}
export declare class MatchToSchema extends ts.Constraint {
    private _value;
    private provider;
    constructor(_value: string, provider: su.IContentProvider);
    value(): string;
    check(i: any): ts.Status;
    facetName(): string;
    requiredType(): ts.InheritedType;
}
/**
 * this is a constraint which checks that object has no unknown properties if at has not additional properties
 */
export declare class KnownPropertyRestriction extends ts.Constraint {
    private _value;
    private static CLASS_IDENTIFIER_KnownPropertyRestriction;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is KnownPropertyRestriction;
    facetName(): string;
    requiredType(): ts.InheritedType;
    value(): boolean;
    constructor(_value: boolean);
    patchOwner(t: AbstractType): void;
    check(i: any): ts.Status;
    composeWith(restriction: Constraint): Constraint;
}
/**
 * this constaint checks that object has a particular property
 */
export declare class HasProperty extends ts.Constraint {
    private name;
    constructor(name: string);
    private static CLASS_IDENTIFIER_HasProperty;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is HasProperty;
    check(i: any): ts.Status;
    requiredType(): ts.InheritedType;
    facetName(): string;
    value(): string;
    composeWith(r: Constraint): Constraint;
}
/**
 * this constraint checks that property has a particular tyoe if exists
 */
export declare class PropertyIs extends MatchesProperty {
    private name;
    private type;
    constructor(name: string, type: ts.AbstractType, optional?: boolean);
    private static CLASS_IDENTIFIER_PropertyIs;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is PropertyIs;
    matches(s: string): boolean;
    path(): string;
    check(i: any, p: ts.IValidationPath): ts.Status;
    requiredType(): ts.InheritedType;
    propId(): string;
    propertyName(): string;
    facetName(): string;
    value(): ts.AbstractType;
    composeWith(t: ts.Constraint): ts.Constraint;
}
export declare function anotherRestrictionComponent(): any;
export declare function releaseAnotherRestrictionComponent(l?: number): void;
export declare function anotherRestrictionComponentsCount(): number;
/**
 * this cosnstraint checks that map property values passes to particular type if exists
 */
export declare class MapPropertyIs extends MatchesProperty {
    private regexp;
    private type;
    constructor(regexp: string, type: ts.AbstractType, optional?: boolean);
    private static CLASS_IDENTIFIER_MapPropertyIs;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is MapPropertyIs;
    path(): string;
    matches(s: string): boolean;
    requiredType(): ts.InheritedType;
    propId(): string;
    facetName(): string;
    value(): ts.AbstractType;
    regexpValue(): string;
    validateSelfIndividual(st: Status, t: ts.TypeRegistry): ts.Status;
    checkValue(): any;
    composeWith(t: ts.Constraint): ts.Constraint;
    check(i: any, p: ts.IValidationPath): ts.Status;
}
/**
 * this constraint tests that additional property
 */
export declare class AdditionalPropertyIs extends MatchesProperty {
    private type;
    constructor(type: ts.AbstractType, optional?: boolean);
    private static CLASS_IDENTIFIER_AdditionalPropertyIs;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is AdditionalPropertyIs;
    path(): string;
    matches(s: string): boolean;
    requiredType(): ts.InheritedType;
    propId(): string;
    facetName(): string;
    value(): ts.AbstractType;
    match(n: string): boolean;
    composeWith(t: ts.Constraint): ts.Constraint;
    check(i: any, p: ts.IValidationPath): ts.Status;
}
/**
 * common super type for a simple restrictions
 */
export declare abstract class FacetRestriction<T> extends ts.Constraint {
    abstract facetName(): string;
    abstract requiredType(): ts.AbstractType;
    abstract checkValue(): ts.Status;
    abstract value(): T;
    /**
     * Extension of requiredType() method for the case when there are more than a single type
     * hierarchy roots to cover.
     * requiredType() should return the common superclass for the list.
     *
     * @returns {Array} of types or empty list of there is only a single type set by requiredType() method
     */
    requiredTypes(): ts.AbstractType[];
    private checkOwner;
    validateSelfIndividual(superStatus: ts.Status, registry: ts.TypeRegistry): ts.Status;
}
/**
 * abstract super type for every min max restriction
 */
export declare abstract class MinMaxRestriction extends FacetRestriction<Number> {
    private _facetName;
    private _value;
    private _max;
    private _opposite;
    private _requiredType;
    private _isInt;
    constructor(_facetName: string, _value: number, _max: boolean, _opposite: string, _requiredType: ts.AbstractType, _isInt: boolean);
    facetName(): string;
    isIntConstraint(): boolean;
    isMax(): boolean;
    abstract extractValue(i: any): number;
    value(): number;
    check(i: any): ts.Status;
    createError(): ts.Status;
    minValue(): number;
    requiredType(): ts.AbstractType;
    checkValue(): ts.Status;
    composeWith(t: ts.Constraint): ts.Constraint;
    abstract textMessagePart(): string;
    facetPath(): string;
    toString(): string;
    conflictMessage(otherPath: string, otherValue: any): string;
}
export declare class MultipleOf extends FacetRestriction<Number> {
    private _value;
    constructor(_value: number);
    value(): number;
    check(o: any): ts.Status;
    composeWith(t: ts.Constraint): ts.Constraint;
    facetName(): string;
    checkValue(): ts.Status;
    requiredType(): ts.AbstractType;
}
/**
 * maximum  constraint
 */
export declare class Maximum extends MinMaxRestriction {
    constructor(val: number);
    extractValue(i: any): number;
    textMessagePart(): string;
}
/**
 * minimum constraint
 */
export declare class Minimum extends MinMaxRestriction {
    constructor(val: number);
    extractValue(i: any): number;
    textMessagePart(): string;
}
/**
 * max items cosntraint
 */
export declare class MaxItems extends MinMaxRestriction {
    constructor(val: number);
    extractValue(i: any): number;
    textMessagePart(): string;
}
/**
 * min items cosntraint
 */
export declare class MinItems extends MinMaxRestriction {
    constructor(val: number);
    extractValue(i: any): number;
    textMessagePart(): string;
}
/**
 * max length
 */
export declare class MaxLength extends MinMaxRestriction {
    constructor(val: number);
    extractValue(i: any): number;
    textMessagePart(): string;
}
/**
 * min length
 */
export declare class MinLength extends MinMaxRestriction {
    constructor(val: number);
    extractValue(i: any): number;
    textMessagePart(): string;
}
/**
 * max properties constraint
 */
export declare class MaxProperties extends MinMaxRestriction {
    constructor(val: number);
    extractValue(i: any): number;
    textMessagePart(): string;
}
/**
 * min properties constraint
 */
export declare class MinProperties extends MinMaxRestriction {
    constructor(val: number);
    extractValue(i: any): number;
    textMessagePart(): string;
}
/**
 * unique items constraint
 */
export declare class UniqueItems extends FacetRestriction<boolean> {
    private _value;
    constructor(_value: boolean);
    facetName(): string;
    requiredType(): ts.InheritedType;
    check(i: any): ts.Status;
    composeWith(r: ts.Constraint): ts.Constraint;
    value(): boolean;
    checkValue(): ts.Status;
    toString(): any;
}
/**
 * components of array should be of type
 */
export declare class ComponentShouldBeOfType extends FacetRestriction<ts.AbstractType> {
    private type;
    facetName(): string;
    requiredType(): ts.InheritedType;
    constructor(type: ts.AbstractType);
    toString(): string;
    check(i: any): ts.Status;
    validateSelfIndividual(st: ts.Status, registry: ts.TypeRegistry): ts.Status;
    composeWith(t: ts.Constraint): ts.Constraint;
    checkValue(): ts.Status;
    value(): ts.AbstractType;
}
/**
 * regular expression (pattern) constraint
 */
export declare class Pattern extends FacetRestriction<string> {
    private _value;
    constructor(_value: string);
    facetName(): string;
    requiredType(): ts.InheritedType;
    check(i: any): ts.Status;
    composeWith(r: ts.Constraint): ts.Constraint;
    value(): string;
    checkValue(): ts.Status;
    toString(): string;
}
export declare class FileTypes extends FacetRestriction<string[]> {
    private _value;
    constructor(_value: string[]);
    facetName(): string;
    requiredType(): ts.InheritedType;
    check(i: any): ts.Status;
    composeWith(r: ts.Constraint): ts.Constraint;
    value(): string[];
    checkValue(): ts.Status;
    toString(): any;
}
/**
 * regular expression (pattern) constraint
 */
export declare class Format extends FacetRestriction<string> {
    private _value;
    constructor(_value: string);
    facetName(): string;
    requiredType(): ts.InheritedType;
    requiredTypes(): ts.InheritedType[];
    check(i: any): ts.Status;
    composeWith(r: ts.Constraint): ts.Constraint;
    value(): string;
    checkValue(): ts.Status;
    toString(): string;
}
/**
 * enum constraint
 */
export declare class Enum extends FacetRestriction<string[]> {
    private _value;
    constructor(_value: string[]);
    facetName(): string;
    requiredType(): ts.RootType;
    checkStatus: boolean;
    check(i: any): ts.Status;
    composeWith(r: ts.Constraint): ts.Constraint;
    value(): string[];
    checkValue(): ts.Status;
    toString(): string;
}
/**
 * this function attempts to optimize to set of restrictions
 * @param r
 * @returns {ts.Constraint[]}
 */
export declare function optimize(r: ts.Constraint[]): ts.Constraint[];
export declare function validatePropertyType(_type: ts.AbstractType, propName: string, registry: ts.TypeRegistry, source: any, isFacet?: boolean): ts.Status;
