/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasource.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.sql.datasource.model.DataSourceStatus;
import org.opensearch.sql.datasource.model.DataSourceType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DataSourceMetadata {
    public static final String DEFAULT_RESULT_INDEX = "query_execution_result";
    public static final int MAX_RESULT_INDEX_NAME_SIZE = 255;
    private static String DATASOURCE_NAME_REGEX = "[@*A-Za-z]+?[*a-zA-Z_\\-0-9]*";
    public static final String RESULT_INDEX_NAME_PATTERN = "[a-z0-9_-]+";
    public static String INVALID_RESULT_INDEX_NAME_SIZE = "Result index name size must contains less than 255 characters.";
    public static String INVALID_CHAR_IN_RESULT_INDEX_NAME = "Result index name has invalid character. Valid characters are a-z, 0-9, -(hyphen) and _(underscore).";
    public static String INVALID_RESULT_INDEX_PREFIX = "Result index must start with query_execution_result";
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})
    private DataSourceType connector;
    @JsonProperty
    private List<String> allowedRoles;
    @JsonProperty
    private Map<String, String> properties;
    @JsonProperty
    private String resultIndex;
    @JsonProperty
    private DataSourceStatus status;
    public static Function<String, String> DATASOURCE_TO_RESULT_INDEX = datasourceName -> String.format("%s_%s", DEFAULT_RESULT_INDEX, datasourceName);

    private DataSourceMetadata(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.connector = builder.connector;
        this.allowedRoles = builder.allowedRoles;
        this.properties = builder.properties;
        this.resultIndex = builder.resultIndex;
        this.status = builder.status;
    }

    public static DataSourceMetadata defaultOpenSearchDataSourceMetadata() {
        return new Builder().setName("@opensearch").setDescription("").setConnector(DataSourceType.OPENSEARCH).setAllowedRoles(Collections.emptyList()).setProperties((Map<String, String>)ImmutableMap.of()).validateAndBuild();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public DataSourceType getConnector() {
        return this.connector;
    }

    @Generated
    public List<String> getAllowedRoles() {
        return this.allowedRoles;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public String getResultIndex() {
        return this.resultIndex;
    }

    @Generated
    public DataSourceStatus getStatus() {
        return this.status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceMetadata)) {
            return false;
        }
        DataSourceMetadata other = (DataSourceMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        DataSourceType this$connector = this.getConnector();
        DataSourceType other$connector = other.getConnector();
        if (this$connector == null ? other$connector != null : !this$connector.equals(other$connector)) {
            return false;
        }
        List<String> this$allowedRoles = this.getAllowedRoles();
        List<String> other$allowedRoles = other.getAllowedRoles();
        if (this$allowedRoles == null ? other$allowedRoles != null : !((Object)this$allowedRoles).equals(other$allowedRoles)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$resultIndex = this.getResultIndex();
        String other$resultIndex = other.getResultIndex();
        if (this$resultIndex == null ? other$resultIndex != null : !this$resultIndex.equals(other$resultIndex)) {
            return false;
        }
        DataSourceStatus this$status = this.getStatus();
        DataSourceStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataSourceMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        DataSourceType $connector = this.getConnector();
        result = result * 59 + ($connector == null ? 43 : $connector.hashCode());
        List<String> $allowedRoles = this.getAllowedRoles();
        result = result * 59 + ($allowedRoles == null ? 43 : ((Object)$allowedRoles).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $resultIndex = this.getResultIndex();
        result = result * 59 + ($resultIndex == null ? 43 : $resultIndex.hashCode());
        DataSourceStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public static class Builder {
        private String name;
        private String description;
        private DataSourceType connector;
        private List<String> allowedRoles;
        private Map<String, String> properties;
        private String resultIndex;
        private DataSourceStatus status;

        public Builder() {
        }

        public Builder(DataSourceMetadata dataSourceMetadata) {
            this.name = dataSourceMetadata.getName();
            this.description = dataSourceMetadata.getDescription();
            this.connector = dataSourceMetadata.getConnector();
            this.resultIndex = dataSourceMetadata.getResultIndex();
            this.status = dataSourceMetadata.getStatus();
            this.allowedRoles = new ArrayList<String>(dataSourceMetadata.getAllowedRoles());
            this.properties = new HashMap<String, String>(dataSourceMetadata.getProperties());
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setConnector(DataSourceType connector) {
            this.connector = connector;
            return this;
        }

        public Builder setAllowedRoles(List<String> allowedRoles) {
            this.allowedRoles = allowedRoles;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder setResultIndex(String resultIndex) {
            this.resultIndex = resultIndex;
            return this;
        }

        public Builder setDataSourceStatus(DataSourceStatus status) {
            this.status = status;
            return this;
        }

        public DataSourceMetadata validateAndBuild() {
            this.validateMissingAttributes();
            this.validateName();
            this.validateCustomResultIndex();
            return this.build();
        }

        public DataSourceMetadata build() {
            this.fillNullAttributes();
            return new DataSourceMetadata(this);
        }

        private void fillNullAttributes() {
            if (this.resultIndex == null) {
                this.resultIndex = this.fromNameToCustomResultIndex();
            }
            if (this.status == null) {
                this.status = DataSourceStatus.ACTIVE;
            }
            if (this.description == null) {
                this.description = "";
            }
            if (this.properties == null) {
                this.properties = ImmutableMap.of();
            }
            if (this.allowedRoles == null) {
                this.allowedRoles = ImmutableList.of();
            }
        }

        private void validateMissingAttributes() {
            ArrayList<String> missingAttributes = new ArrayList<String>();
            if (this.name == null) {
                missingAttributes.add("name");
            }
            if (this.connector == null) {
                missingAttributes.add("connector");
            }
            if (!missingAttributes.isEmpty()) {
                String errorMessage = "Datasource configuration error: " + String.join((CharSequence)", ", missingAttributes) + " cannot be null or empty.";
                throw new IllegalArgumentException(errorMessage);
            }
        }

        private void validateName() {
            if (!this.name.matches(DATASOURCE_NAME_REGEX)) {
                throw new IllegalArgumentException(String.format("DataSource Name: %s contains illegal characters. Allowed characters: a-zA-Z0-9_-*@.", this.name));
            }
        }

        private void validateCustomResultIndex() {
            if (this.resultIndex == null) {
                return;
            }
            StringBuilder errorMessage = new StringBuilder();
            if (this.resultIndex.length() > 255) {
                errorMessage.append(INVALID_RESULT_INDEX_NAME_SIZE);
            }
            if (!this.resultIndex.matches(DataSourceMetadata.RESULT_INDEX_NAME_PATTERN)) {
                errorMessage.append(INVALID_CHAR_IN_RESULT_INDEX_NAME);
            }
            if (!this.resultIndex.startsWith(DataSourceMetadata.DEFAULT_RESULT_INDEX)) {
                errorMessage.append(INVALID_RESULT_INDEX_PREFIX);
            }
            if (errorMessage.length() > 0) {
                throw new IllegalArgumentException(errorMessage.toString());
            }
        }

        private String convertToValidResultIndex(String resultIndex) {
            if (resultIndex.length() > 255) {
                resultIndex = resultIndex.substring(0, 255);
            }
            StringBuilder validChars = new StringBuilder();
            for (char c : resultIndex.toCharArray()) {
                if (!String.valueOf(c).matches(DataSourceMetadata.RESULT_INDEX_NAME_PATTERN)) continue;
                validChars.append(c);
            }
            return validChars.toString();
        }

        private String fromNameToCustomResultIndex() {
            return this.convertToValidResultIndex(DATASOURCE_TO_RESULT_INDEX.apply(this.name.toLowerCase()));
        }
    }
}

