# Contributing to PacketFu 

Thanks for your interest in contributing to PacketFu.

If you could follow the following guidelines, you will make it much easier for 
us to give feedback, help you find whatever problem you have and fix it.

## Issues

If you have questions of any kind, or are unsure of how something works, please
[create an issue](https://github.com/packetfu/packetfu/issues/new).

Please try to answer the following questions in your issue:

- What did you do?
- What did you expect to happen?
- What happened instead?

If you have identified a bug, it would be very helpful if you could include a 
way to replicate the bug.  Ideally a failing test would be perfect, but even a 
simple script demonstrating the error would suffice.

Feature requests are great and if submitted they will be considered for 
inclusion, but sending a pull request is much more awesome.

## Pull Requests

If you want your pull requests to be accepted, please follow the following guidelines:

- [**Add tests!**](http://rspec.info/) Your patch won't be accepted (or will be delayed) if it doesn't have tests.

- [**Document any change in behaviour**](http://yardoc.org/) Make sure the README and any other
  relevant documentation are kept up-to-date.

- [**Create topic branches**](https://github.com/dchelimsky/rspec/wiki/Topic-Branches) Don't ask us to pull from your master branch.

- [**One pull request per feature**](https://help.github.com/articles/using-pull-requests) If you want to do more than one thing, send
  multiple pull requests.

- [**Send coherent history**](http://stackoverflow.com/questions/6934752/git-combining-multiple-commits-before-pushing) Make sure each individual commit in your pull
  request is meaningful. If you had to make multiple intermediate commits while
  developing, please squash them before sending them to us.

- [**Follow coding conventions**](https://github.com/styleguide/ruby) The standard Ruby stuff, two spaces indent,
  don't omit parens unless you have a good reason.

Thank you so much for contributing!