/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.attach;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.attach.AttachModelImpl;
import org.graalvm.visualvm.attach.HeapHistogramImpl;
import org.graalvm.visualvm.attach.JRockitHeapHistogramImpl;

class OracleJRockitAttachModelImpl
extends AttachModelImpl {
    OracleJRockitAttachModelImpl(Application app) {
        super(app);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized HeapHistogramImpl takeHeapHistogram() {
        try (InputStream in = this.getVirtualMachine().heapHisto("-all");){
            JRockitHeapHistogramImpl jRockitHeapHistogramImpl = new JRockitHeapHistogramImpl(in);
            return jRockitHeapHistogramImpl;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "takeHeapHistogram", ex);
            return null;
        }
    }
}

