/*
 * Decompiled with CFR 0.152.
 */
package com.lizardworks.tiff;

import com.lizardworks.tiff.DataType;
import com.lizardworks.tiff.Tag;
import com.lizardworks.tiff.tag.CompressionType;
import com.lizardworks.util.MemoryFileInputFilter;
import com.lizardworks.util.MotorolaIntelInputFilter;
import java.io.IOException;

class IFDEntry {
    public static final int SIZE = 12;
    public Tag tag;
    public DataType type;
    public long count;
    public long value;
    public byte[] dataArray;

    public IFDEntry() {
        this.init();
    }

    public IFDEntry(int newTag, int newType, long newCount, long newValue) {
        this.tag = new Tag(newTag);
        this.type = new DataType(newType);
        this.count = newCount;
        this.value = newValue;
        this.dataArray = null;
    }

    void init() {
        this.tag = new Tag();
        this.type = new DataType();
        this.count = 0L;
        this.value = 0L;
        this.dataArray = null;
    }

    public boolean isOffset() {
        return this.sizeOfData() > 4;
    }

    public int sizeOfData() {
        return (int)this.count * this.type.size();
    }

    void setOffset(long n) {
        this.value = n;
    }

    public void writeEntry(MotorolaIntelInputFilter out) throws IOException {
        this.tag.write(out);
        this.type.write(out);
        out.writeInt((int)this.count);
        out.writeInt((int)this.value);
    }

    public void writeData(MotorolaIntelInputFilter out) throws IOException {
        out.seek(this.value);
        if (this.type.isRational()) {
            byte[] b = new byte[this.dataArray.length];
            b[0] = this.dataArray[3];
            b[1] = this.dataArray[2];
            b[2] = this.dataArray[1];
            b[3] = this.dataArray[0];
            b[4] = this.dataArray[7];
            b[5] = this.dataArray[6];
            b[6] = this.dataArray[5];
            b[7] = this.dataArray[4];
            out.write(b);
        } else {
            out.writeProperly(this.dataArray, this.type.size(), this.sizeOfData());
        }
    }

    public void read(MemoryFileInputFilter in) {
        this.read(in, 0L);
    }

    public void read(MemoryFileInputFilter in, long ifdOffset) {
        this.tag.read(in);
        this.type.read(in);
        this.count = in.readInt();
        this.value = in.readInt();
        if (this.isOffset()) {
            int len = this.sizeOfData();
            long currentOffset = in.getFilePointer();
            this.dataArray = new byte[len];
            in.seek(this.value + ifdOffset);
            if (this.type.isAscii()) {
                in.readFully(this.dataArray);
            } else if (this.type.isRational()) {
                DataType t = new DataType(4);
                byte[] b = new byte[4];
                if (in.isIntel()) {
                    in.readProperly(this.dataArray, t.size(), 4);
                    in.readProperly(b, t.size(), 4);
                    System.arraycopy(b, 0, this.dataArray, 4, 4);
                } else {
                    in.readFully(this.dataArray);
                }
            } else {
                in.readProperly(this.dataArray, this.type.size(), len);
            }
            in.seek(currentOffset);
        }
        if (this.type.isShort() && !in.isIntel()) {
            this.value = (int)(this.value >> 16 & 0xFFFFL);
        }
    }

    public String toString() {
        String s = "Tag: " + this.tag.toString() + ", Type: " + this.type.toString() + ", Count: " + this.count;
        if (this.tag.equals(259)) {
            s = String.valueOf(s) + ", " + CompressionType.toString((int)this.value);
        } else if (this.isOffset()) {
            int len = Math.min(this.dataArray.length, 256);
            s = String.valueOf(s) + ", Offset: 0x" + Long.toHexString(this.value) + ", " + this.sizeOfData() + "bytes";
            if (this.type.isAscii()) {
                String sz = new String(this.dataArray, 0, 0, this.dataArray.length);
                s = String.valueOf(s) + "\n\t\t" + sz + "\n";
            } else if (this.type.isRational()) {
                int n = ((this.dataArray[0] & 0xFF) << 24) + ((this.dataArray[1] & 0xFF) << 16) + ((this.dataArray[2] & 0xFF) << 8) + (this.dataArray[3] & 0xFF);
                int d = ((this.dataArray[4] & 0xFF) << 24) + ((this.dataArray[5] & 0xFF) << 16) + ((this.dataArray[6] & 0xFF) << 8) + (this.dataArray[7] & 0xFF);
                s = String.valueOf(s) + "\n\t\t" + n + "/" + d + "\n";
            } else if (this.tag.equals(320)) {
                int skip = this.dataArray.length / 3;
                int i = 0;
                while (i < this.dataArray.length) {
                    if (i % skip == 0) {
                        s = String.valueOf(s) + "\n\n\t\t";
                    }
                    if (i % 16 == 0) {
                        s = String.valueOf(s) + "\n\t\t";
                    }
                    s = i % 2 == 0 ? String.valueOf(s) + "|" : String.valueOf(s) + " ";
                    int d = this.dataArray[i] & 0xFF;
                    s = String.valueOf(s) + (d == 0 ? "00" : Integer.toHexString(d));
                    ++i;
                }
                s = String.valueOf(s) + "\n";
            } else if (this.type.equals(3)) {
                int i = 0;
                while (i < this.dataArray.length) {
                    s = i % 16 == 0 ? String.valueOf(s) + "\n\t\t" : String.valueOf(s) + ", ";
                    int d = ((this.dataArray[i] & 0xFF) << 8) + (this.dataArray[i + 1] & 0xFF);
                    s = String.valueOf(s) + d;
                    i += 2;
                }
                s = String.valueOf(s) + "\n";
            } else if (this.type.equals(4)) {
                int i = 0;
                while (i < len) {
                    int n = ((this.dataArray[i] & 0xFF) << 24) + ((this.dataArray[i + 1] & 0xFF) << 16) + ((this.dataArray[i + 2] & 0xFF) << 8) + (this.dataArray[i + 3] & 0xFF);
                    s = i % 16 == 0 ? String.valueOf(s) + "\n\t\t" : String.valueOf(s) + ", ";
                    s = String.valueOf(s) + n;
                    i += 4;
                }
                s = String.valueOf(s) + "\n";
            }
        } else {
            s = String.valueOf(s) + ", Value: " + this.value;
        }
        return s;
    }
}

