---
relatedlinks: '[How&#32;to&#32;install&#32;a&#32;Windows&#32;11&#32;VM&#32;using&#32;LXD](https://ubuntu.com/tutorials/how-to-install-a-windows-11-vm-using-lxd)'
---

(instances)=
# Instances

```{only} diataxis
The following how-to guides cover common operations related to instances.

How to create and manage instances:
```

```{filtered-toctree}
:titlesonly:

:diataxis:Create instances </howto/instances_create.md>
:diataxis:Configure instances </howto/instances_configure.md>
:diataxis:Manage instances </howto/instances_manage.md>
:diataxis:Use profiles </profiles.md>
:diataxis:Troubleshoot errors </howto/instances_troubleshoot.md>
```

```{only} diataxis
How to work with instances:
```

```{filtered-toctree}
:titlesonly:

:diataxis:Access files </howto/instances_access_files.md>
:diataxis:Access the console </howto/instances_console.md>
:diataxis:Run commands </instance-exec.md>
:diataxis:Use cloud-init </cloud-init>
:diataxis:Add a routed NIC to a VM </howto/instances_routed_nic_vm.md>
```

```{only} diataxis
How to export and move instances:
```

```{filtered-toctree}
:titlesonly:

:diataxis:Back up instances </howto/instances_backup.md>
:diataxis:Move instances </howto/move_instances>
```

```{only} diataxis
How to import instances:
```

```{filtered-toctree}
:titlesonly:

:diataxis:Import existing machines </howto/import_machines_to_instances>
:diataxis:Migrate from LXC </howto/migrate_from_lxc>
```

## Related topics

```{only} diataxis
{{instances_exp}}

{{instances_ref}}
```

```{filtered-toctree}
:titlesonly:

:topical:/explanation/instances.md
:topical:Create instances </howto/instances_create.md>
:topical:Manage instances </howto/instances_manage.md>
:topical:Configure instances </howto/instances_configure.md>
:topical:Back up instances </howto/instances_backup.md>
:topical:Use profiles </profiles.md>
:topical:Use cloud-init </cloud-init>
:topical:Run commands </instance-exec.md>
:topical:Access the console </howto/instances_console.md>
:topical:Access files </howto/instances_access_files.md>
:topical:Add a routed NIC to a VM </howto/instances_routed_nic_vm.md>
:topical:Troubleshoot errors </howto/instances_troubleshoot.md>
:topical:/explanation/instance_config.md
:topical:Container environment </container-environment>
```
