/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sampler;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.sampler.Bundle;
import org.netbeans.modules.sampler.Sampler;
import org.netbeans.modules.sampler.SelfSampleVFS;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;

final class InternalSampler
extends Sampler {
    private static final String SAMPLER_NAME = "selfsampler";
    private static final String FILE_NAME = "selfsampler.npss";
    private static final String X_DEBUG_ARG = "-Xdebug";
    private static final String JDWP_DEBUG_ARG = "-agentlib:jdwp";
    private static final String JDWP_DEBUG_ARG_PREFIX = "-agentlib:jdwp=";
    private static final Logger LOGGER = Logger.getLogger(InternalSampler.class.getName());
    private static Boolean debugMode;
    private static String lastReason;
    private ProgressHandle progress = ProgressHandle.createHandle((String)Bundle.Save_Progress());

    static InternalSampler createInternalSampler(String string) {
        if (InternalSampler.isRunMode()) {
            return new InternalSampler(string);
        }
        return null;
    }

    private static synchronized boolean isDebugged() {
        if (debugMode == null) {
            debugMode = Boolean.FALSE;
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> list = runtimeMXBean.getInputArguments();
            if (list.contains(X_DEBUG_ARG)) {
                debugMode = Boolean.TRUE;
            } else if (list.contains(JDWP_DEBUG_ARG)) {
                debugMode = Boolean.TRUE;
            } else {
                for (String string : list) {
                    if (!string.startsWith(JDWP_DEBUG_ARG_PREFIX)) continue;
                    debugMode = Boolean.TRUE;
                    break;
                }
            }
        }
        return debugMode;
    }

    private static boolean isRunMode() {
        boolean bl = true;
        String string = null;
        if (InternalSampler.isDebugged()) {
            string = "running in debug mode";
            bl = false;
        }
        if (bl) {
            try {
                Class.forName("org.netbeans.lib.profiler.server.ProfilerServer", false, ClassLoader.getSystemClassLoader());
                string = "running under profiler";
                bl = false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!bl && !string.equals(lastReason)) {
            LOGGER.log(Level.INFO, "Slowness detector disabled - {0}", string);
        }
        lastReason = string;
        return bl;
    }

    InternalSampler(String string) throws LinkageError {
        super(string);
    }

    @Override
    protected void printStackTrace(Throwable throwable) {
        Exceptions.printStackTrace((Throwable)throwable);
    }

    @Override
    protected void saveSnapshot(byte[] byArray) throws IOException {
        SelfSampleVFS selfSampleVFS;
        FileObject fileObject;
        Openable openable;
        File file = File.createTempFile(SAMPLER_NAME, ".npss");
        File file2 = Places.getUserDirectory();
        File file3 = null;
        file = FileUtil.normalizeFile((File)file);
        this.writeToFile(file, byArray);
        if (file2 != null) {
            file3 = new File(new File(new File(file2, "var"), "log"), "uigestures");
        }
        if ((openable = (Openable)(fileObject = (selfSampleVFS = file3 != null && file3.exists() ? new SelfSampleVFS(new String[]{FILE_NAME, "selfsampler.log"}, new File[]{file, file3}) : new SelfSampleVFS(new String[]{FILE_NAME}, new File[]{file})).findResource(FILE_NAME)).getLookup().lookup(Openable.class)) != null) {
            openable.open();
        } else {
            IOException iOException = new IOException("Cannot open " + fileObject + " with MIME type: " + fileObject.getMIMEType());
            String string = Bundle.SelfSamplerAction_SavedFile(file.getAbsolutePath());
            Exceptions.attachSeverity((Throwable)iOException, (Level)Level.WARNING);
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string);
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void writeToFile(File file, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    @Override
    ThreadMXBean getThreadMXBean() {
        return ManagementFactory.getThreadMXBean();
    }

    @Override
    void openProgress(int n) {
        if (this.isDispatchThread()) {
            return;
        }
        this.progress.start(n);
    }

    @Override
    void closeProgress() {
        if (this.isDispatchThread()) {
            return;
        }
        this.progress.finish();
        this.progress = ProgressHandle.createHandle((String)Bundle.Save_Progress());
    }

    @Override
    void progress(int n) {
        if (this.isDispatchThread()) {
            return;
        }
        if (this.progress != null) {
            this.progress.progress(n);
        }
    }

    @Override
    boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }
}

