# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "monitor log-analytics workspace show",
)
class Show(AAZCommand):
    """Show a workspace instance.

    :example: Show a workspace instance.
        az monitor log-analytics workspace show --resource-group MyResourceGroup --workspace-name MyWorkspace
    """

    _aaz_info = {
        "version": "2023-09-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.operationalinsights/workspaces/{}", "2023-09-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.workspace_name = AAZStrArg(
            options=["-n", "--name", "--workspace-name"],
            help="Name of the Log Analytics Workspace.",
            required=True,
            id_part="name",
            fmt=AAZStrArgFormat(
                pattern="^[A-Za-z0-9][A-Za-z0-9-]+[A-Za-z0-9]$",
                max_length=63,
                min_length=4,
            ),
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.WorkspacesGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class WorkspacesGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "workspaceName", self.ctx.args.workspace_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-09-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.etag = AAZStrType()
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.identity = AAZObjectType()
            _schema_on_200.location = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _schema_on_200.tags = AAZDictType()
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            identity = cls._schema_on_200.identity
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType(
                flags={"required": True},
            )
            identity.user_assigned_identities = AAZDictType(
                serialized_name="userAssignedIdentities",
            )

            user_assigned_identities = cls._schema_on_200.identity.user_assigned_identities
            user_assigned_identities.Element = AAZObjectType()

            _element = cls._schema_on_200.identity.user_assigned_identities.Element
            _element.client_id = AAZStrType(
                serialized_name="clientId",
                flags={"read_only": True},
            )
            _element.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.created_date = AAZStrType(
                serialized_name="createdDate",
                flags={"read_only": True},
            )
            properties.customer_id = AAZStrType(
                serialized_name="customerId",
                flags={"read_only": True},
            )
            properties.default_data_collection_rule_resource_id = AAZStrType(
                serialized_name="defaultDataCollectionRuleResourceId",
            )
            properties.features = AAZObjectType()
            properties.force_cmk_for_query = AAZBoolType(
                serialized_name="forceCmkForQuery",
            )
            properties.modified_date = AAZStrType(
                serialized_name="modifiedDate",
                flags={"read_only": True},
            )
            properties.private_link_scoped_resources = AAZListType(
                serialized_name="privateLinkScopedResources",
                flags={"read_only": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.public_network_access_for_ingestion = AAZStrType(
                serialized_name="publicNetworkAccessForIngestion",
            )
            properties.public_network_access_for_query = AAZStrType(
                serialized_name="publicNetworkAccessForQuery",
            )
            properties.retention_in_days = AAZIntType(
                serialized_name="retentionInDays",
                nullable=True,
            )
            properties.sku = AAZObjectType()
            properties.workspace_capping = AAZObjectType(
                serialized_name="workspaceCapping",
            )

            features = cls._schema_on_200.properties.features
            features.cluster_resource_id = AAZStrType(
                serialized_name="clusterResourceId",
                nullable=True,
            )
            features.disable_local_auth = AAZBoolType(
                serialized_name="disableLocalAuth",
                nullable=True,
            )
            features.enable_data_export = AAZBoolType(
                serialized_name="enableDataExport",
                nullable=True,
            )
            features.enable_log_access_using_only_resource_permissions = AAZBoolType(
                serialized_name="enableLogAccessUsingOnlyResourcePermissions",
                nullable=True,
            )
            features.immediate_purge_data_on30_days = AAZBoolType(
                serialized_name="immediatePurgeDataOn30Days",
                nullable=True,
            )
            features.unified_sentinel_billing_only = AAZBoolType(
                serialized_name="unifiedSentinelBillingOnly",
                nullable=True,
                flags={"read_only": True},
            )

            private_link_scoped_resources = cls._schema_on_200.properties.private_link_scoped_resources
            private_link_scoped_resources.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.private_link_scoped_resources.Element
            _element.resource_id = AAZStrType(
                serialized_name="resourceId",
            )
            _element.scope_id = AAZStrType(
                serialized_name="scopeId",
            )

            sku = cls._schema_on_200.properties.sku
            sku.capacity_reservation_level = AAZIntType(
                serialized_name="capacityReservationLevel",
            )
            sku.last_sku_update = AAZStrType(
                serialized_name="lastSkuUpdate",
                flags={"read_only": True},
            )
            sku.name = AAZStrType(
                flags={"required": True},
            )

            workspace_capping = cls._schema_on_200.properties.workspace_capping
            workspace_capping.daily_quota_gb = AAZFloatType(
                serialized_name="dailyQuotaGb",
            )
            workspace_capping.data_ingestion_status = AAZStrType(
                serialized_name="dataIngestionStatus",
                flags={"read_only": True},
            )
            workspace_capping.quota_next_reset_time = AAZStrType(
                serialized_name="quotaNextResetTime",
                flags={"read_only": True},
            )

            system_data = cls._schema_on_200.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            tags = cls._schema_on_200.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200


class _ShowHelper:
    """Helper class for Show"""


__all__ = ["Show"]
