# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network list-service-tags",
)
class ListServiceTags(AAZCommand):
    """List all service tags which are below to different resources

    A service tag represents a group of IP address prefixes to help minimize complexity for security rule creation. To learn more about list-service-tags, visit https://docs.microsoft.com/azure/virtual-network/security-overview#service-tags. Note that the location parameter is used as a reference for version (not as a filter based on location). For example, even if you specify --location eastus2 you will get the list of service tags with prefix details across all regions but limited to the cloud that your subscription belongs to (i.e. Public, US government, China or Germany).

    :example: Gets a list of service tag information resources. (autogenerated)
        az network list-service-tags --location westus2
    """

    _aaz_info = {
        "version": "2022-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.network/locations/{}/servicetags", "2022-01-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.location = AAZResourceLocationArg(
            help="Location. Values from: `az account list-locations`. You can configure the default location using `az configure --defaults location=<location>`.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.ServiceTagsList(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class ServiceTagsList(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/serviceTags",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "location", self.ctx.args.location,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.change_number = AAZStrType(
                serialized_name="changeNumber",
                flags={"read_only": True},
            )
            _schema_on_200.cloud = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
                flags={"read_only": True},
            )
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.values = AAZListType(
                flags={"read_only": True},
            )

            values = cls._schema_on_200.values
            values.Element = AAZObjectType(
                flags={"read_only": True},
            )

            _element = cls._schema_on_200.values.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"read_only": True},
            )
            _element.service_tag_change_number = AAZStrType(
                serialized_name="serviceTagChangeNumber",
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.values.Element.properties
            properties.address_prefixes = AAZListType(
                serialized_name="addressPrefixes",
                flags={"read_only": True},
            )
            properties.change_number = AAZStrType(
                serialized_name="changeNumber",
                flags={"read_only": True},
            )
            properties.region = AAZStrType(
                flags={"read_only": True},
            )
            properties.state = AAZStrType(
                flags={"read_only": True},
            )
            properties.system_service = AAZStrType(
                serialized_name="systemService",
                flags={"read_only": True},
            )

            address_prefixes = cls._schema_on_200.values.Element.properties.address_prefixes
            address_prefixes.Element = AAZStrType(
                flags={"read_only": True},
            )

            return cls._schema_on_200


class _ListServiceTagsHelper:
    """Helper class for ListServiceTags"""


__all__ = ["ListServiceTags"]
