import su = require("./schemaUtil");
import tsInterfaces = require("./typesystem-interfaces");
export declare let messageRegistry: any;
export declare type IValidationPath = tsInterfaces.IValidationPath;
export declare class Status implements tsInterfaces.IStatus {
    private takeNodeFromSource;
    static CODE_CONFLICTING_TYPE_KIND: number;
    static CODE_INCORRECT_DISCRIMINATOR: any;
    static CODE_MISSING_DISCRIMINATOR: any;
    static ERROR: number;
    static INFO: number;
    static OK: number;
    static WARNING: number;
    protected code: string;
    protected message: string;
    protected severity: number;
    protected source: any;
    protected filePath: string;
    protected internalRange: tsInterfaces.RangeObject;
    protected subStatus: tsInterfaces.IStatus[];
    protected vp: tsInterfaces.IValidationPath;
    protected internalPath: tsInterfaces.IValidationPath;
    getValidationPath(): tsInterfaces.IValidationPath;
    getValidationPathAsString(): string;
    setValidationPath(_c: tsInterfaces.IValidationPath): void;
    constructor(severity: number, code: string, message: string, source: any, takeNodeFromSource?: boolean);
    addSubStatus(st: tsInterfaces.IStatus, pathName?: string): void;
    getErrors(): tsInterfaces.IStatus[];
    getSubStatuses(): tsInterfaces.IStatus[];
    getSeverity(): number;
    getMessage(): string;
    setMessage(message: string): void;
    getSource(): any;
    getCode(): string;
    setCode(code: string): void;
    isWarning(): boolean;
    isError(): boolean;
    isOk(): boolean;
    isInfo(): boolean;
    setSource(s: any): void;
    toString(): string;
    getExtra(name: string): any;
    putExtra(name: string, value: any): void;
    setInternalRange(range: tsInterfaces.RangeObject): void;
    getInternalRange(): tsInterfaces.RangeObject;
    getInternalPath(): tsInterfaces.IValidationPath;
    setInternalPath(ip: tsInterfaces.IValidationPath): void;
    getFilePath(): string;
    setFilePath(filePath: string): void;
}
export declare function ok(): Status;
export declare const SCHEMA_AND_TYPE = "SCHEMA";
export declare const GLOBAL = "GLOBAL";
export declare const TOPLEVEL = "topLevel";
export declare const SOURCE_EXTRA = "SOURCE";
export declare function error(messageEntry: any, source: any, params?: any, severity?: number, takeNodeFromSource?: boolean): Status;
export declare abstract class TypeInformation implements tsInterfaces.ITypeFacet {
    private _inheritable;
    constructor(_inheritable: boolean);
    _owner: AbstractType;
    _node: parse.ParseNode;
    _annotations: tsInterfaces.IAnnotation[];
    private static CLASS_IDENTIFIER_TypeInformation;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is TypeInformation;
    node(): parse.ParseNode;
    setNode(node: parse.ParseNode): void;
    owner(): AbstractType;
    isInheritable(): boolean;
    validateSelf(registry: TypeRegistry): Status;
    protected validateSelfIndividual(parentStatus: Status, registry: TypeRegistry): Status;
    abstract facetName(): string;
    abstract value(): any;
    abstract requiredType(): AbstractType;
    /**
     * Extension of requiredType() method for the case when there are more than a single type
     * hierarchy roots to cover.
     * requiredType() should return the common superclass for the list.
     *
     * @returns {Array} of types or empty list of there is only a single type set by requiredType() method
     */
    requiredTypes(): AbstractType[];
    abstract kind(): tsInterfaces.MetaInformationKind;
    annotations(): tsInterfaces.IAnnotation[];
    addAnnotation(a: tsInterfaces.IAnnotation): void;
    isConstraint(): boolean;
}
export declare abstract class Constraint extends TypeInformation implements tsInterfaces.IConstraint {
    constructor(_inheritable?: boolean);
    private static CLASS_IDENTIFIER_Constraint;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is Constraint;
    abstract check(i: any, parentPath: tsInterfaces.IValidationPath): Status;
    private static intersections;
    protected intersect(t0: AbstractType, t1: AbstractType): AbstractType;
    protected release(t: AbstractType): void;
    nothing(c: Constraint, message?: string): NothingRestrictionWithLocation;
    /**
     * inner implementation of  compute composed restriction from this and parameter restriction
     * @param restriction
     * @return  composed restriction or null;
     */
    composeWith(r: Constraint): Constraint;
    /**
     * returns optimized restiction or this
     * @returns {Constraint}
     */
    preoptimize(): Constraint;
    protected innerOptimize(): Constraint;
    /**
     * performs attempt to compute composed restriction from this and parameter restriction
     * @param restriction
     * @return  composed restriction or null;
     */
    tryCompose(r: Constraint): Constraint;
    kind(): tsInterfaces.MetaInformationKind;
    conflictMessage(otherPath: string, otherValue: any): string;
    isConstraint(): boolean;
}
import restr = require("./restrictions");
import metaInfo = require("./metainfo");
import { MatchesProperty } from "./restrictions";
export declare var autoCloseFlag: boolean;
/**
 * Registry of the types
 */
export declare class TypeRegistry implements tsInterfaces.ITypeRegistry {
    private _parent;
    protected _c?: parse.TypeCollection;
    protected isAnnotationsReg: boolean;
    private _types;
    private typeList;
    private static CLASS_IDENTIFIER_TypeRegistry;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is TypeRegistry;
    put(alias: string, t: AbstractType): void;
    addType(t: AbstractType): void;
    get(name: string): AbstractType;
    private chainedTypes;
    getByChain(name: string): AbstractType;
    private getTypeByChainFromCollection;
    constructor(_parent?: TypeRegistry, _c?: parse.TypeCollection, isAnnotationsReg?: boolean);
    types(): AbstractType[];
    typeMap(): {
        [name: string]: AbstractType;
    };
    parent(): TypeRegistry;
}
export declare class RestrictionsConflict extends Status {
    protected _conflicting: Constraint;
    protected _stack: RestrictionStackEntry;
    protected source: any;
    constructor(_conflicting: Constraint, _stack: RestrictionStackEntry, source: any);
    private computeMessage;
    getConflictDescription(): string;
    getConflicting(): Constraint;
    getStack(): RestrictionStackEntry;
    toRestriction(): NothingRestrictionWithLocation;
}
export declare var VALIDATED_TYPE: AbstractType;
export declare class PropertyInfo implements tsInterfaces.IPropertyInfo {
    private isMap;
    private isProp;
    private isAdditionalProp;
    private isFacet;
    private _required;
    protected _matches: restr.MatchesProperty;
    protected _facetDecl: metaInfo.FacetDeclaration;
    constructor(obj: restr.MatchesProperty | metaInfo.FacetDeclaration);
    name(): string;
    isPattern(): boolean;
    isAdditional(): boolean;
    declaredAt(): AbstractType;
    range(): AbstractType;
    required(): boolean;
    setRequired(val: boolean): void;
    private property;
    private mapProperty;
    private additionalProperty;
    annotations(): tsInterfaces.IAnnotation[];
}
export declare abstract class AbstractType implements tsInterfaces.IParsedType, tsInterfaces.IHasExtra, tsInterfaces.HasSource {
    protected _name: string;
    protected computeConfluent: boolean;
    protected metaInfo: TypeInformation[];
    _subTypes: AbstractType[];
    protected innerid: number;
    protected extras: {
        [name: string]: any;
    };
    protected supertypeAnnotations: {
        [aName: string]: tsInterfaces.IAnnotation;
    }[];
    protected _collection: tsInterfaces.IParsedTypeCollection;
    protected abstract clone(): AbstractType;
    private static CLASS_IDENTIFIER_AbstractType;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is AbstractType;
    annotation(name: string): any;
    isAssignableFrom(t: tsInterfaces.IParsedType): boolean;
    registry(): tsInterfaces.IParsedTypeCollection;
    cloneWithFilter(x: (y: TypeInformation, transformed?: tsInterfaces.IParsedType) => boolean | TypeInformation, f?: (t: tsInterfaces.IParsedType) => tsInterfaces.IParsedType): AbstractType;
    options(): tsInterfaces.IParsedType[];
    allOptions(): tsInterfaces.IParsedType[];
    examples(): tsInterfaces.IExample[];
    collection(): tsInterfaces.IParsedTypeCollection;
    getExtra(name: string): any;
    putExtra(name: string, v: any): void;
    id(): number;
    knownProperties(): MatchesProperty[];
    abstract kind(): string;
    protected _locked: boolean;
    lock(): void;
    isLocked(): boolean;
    constructor(_name: string);
    patchName(name: string): void;
    allFacets(): TypeInformation[];
    declaredFacets(): TypeInformation[];
    isSubTypeOf(t: AbstractType): boolean;
    isSuperTypeOf(t: AbstractType): boolean;
    addMeta(info: TypeInformation): void;
    name(): string;
    label(): string;
    /**
     * @return directly known sub types of a given type
     */
    subTypes(): AbstractType[];
    /**
     * @return directly known super types of a given type
     */
    superTypes(): AbstractType[];
    addSupertypeAnnotation(arr: tsInterfaces.IAnnotation[], ind: number): void;
    validateType(tr?: TypeRegistry): Status;
    validateHierarchy(rs: Status): void;
    private familyWithArray;
    validateMeta(tr: TypeRegistry): Status;
    private validateFacets;
    allSuperTypes(): AbstractType[];
    private fillSuperTypes;
    allSubTypes(): AbstractType[];
    private fillSubTypes;
    inherit(name: string): InheritedType;
    /**
     *
     * @return true if type is an inplace type and has no name
     */
    isAnonymous(): boolean;
    /**
     *
     * @return true if type has no associated meta information of restrictions
     */
    isEmpty(): boolean;
    /**
     *
     * @return true if type is an array or extends from an array
     */
    isArray(): boolean;
    propertySet(): string[];
    checkConfluent(): Status;
    /**
     *
     * @return true if type is object or inherited from object
     */
    isObject(): boolean;
    /**
     *
     * @return true if type is object or inherited from object
     */
    isExternal(): boolean;
    /**
     *
     * @return true if type is an boolean type or extends from boolean
     */
    isBoolean(): boolean;
    /**
     *
     * @return true if type is string or inherited from string
     */
    isString(): boolean;
    /**
     *
     * @return true if type is number or inherited from number
     */
    isNumber(): boolean;
    /**
     *
     * @return true if type is number or inherited from number
     */
    isFile(): boolean;
    /**
     *
     * @return true if type is scalar or inherited from scalar
     */
    isScalar(): boolean;
    /**
     * returns true if this type inherits from one of date related types
     */
    isDateTime(): boolean;
    /**
     * returns true if this type inherits from one of date related types
     */
    isDateOnly(): boolean;
    /**
     * returns true if this type inherits from one of date related types
     */
    isTimeOnly(): boolean;
    /**
     * returns true if this type inherits from one of date related types
     */
    isInteger(): boolean;
    /**
     * returns true if this type inherits from one of date related types
     */
    isDateTimeOnly(): boolean;
    /**
     *
     * @return true if type is scalar or inherited from scalar
     */
    isUnknown(): boolean;
    /**
     *
     * @return true if type is scalar or inherited from scalar
     */
    isRecurrent(): boolean;
    /**
     *
     * @return true if type is an built-in type
     */
    isBuiltin(): boolean;
    exampleObject(): any;
    /**
     *
     * @return true if type is an polymorphic type
     */
    isPolymorphic(): boolean;
    /**
     * @return all restrictions associated with type
     */
    restrictions(forValidation?: boolean): Constraint[];
    customFacets(): TypeInformation[];
    allCustomFacets(): TypeInformation[];
    isUnion(): boolean;
    isIntersection(): boolean;
    nullable: boolean;
    /**
     * return all type information associated with type
     */
    meta(): TypeInformation[];
    /**
     * validates object against this type without performing AC
     */
    validateDirect(i: any, autoClose?: boolean, nullAllowed?: boolean, path?: tsInterfaces.IValidationPath): Status;
    validate(i: any, autoClose?: boolean, nullAllowed?: boolean): Status;
    /**
     * declares a pattern property on this type,
     * note if type is not inherited from an object type this will move
     * type to inconsistent state
     * @param name - regexp
     * @param type - type of the property
     * @return
     */
    declareMapProperty(name: string, type: AbstractType): AbstractType;
    /**
     * make this type closed type (no unknown properties any more)
     */
    closeUnknownProperties(): void;
    annotations(): metaInfo.Annotation[];
    declaredAnnotations(): metaInfo.Annotation[];
    scalarsAnnotations(): {
        [key: string]: metaInfo.Annotation[][];
    };
    declaredScalarsAnnotations(): {
        [key: string]: metaInfo.Annotation[][];
    };
    private sAnnotations;
    componentType(): tsInterfaces.IParsedType;
    canDoAc(): Status;
    private emptyIntersectionOrDiscriminator;
    protected propertyInfos: PropertyInfo[];
    protected propertiesMap: {
        [key: string]: PropertyInfo;
    };
    protected definedFacetInfos: PropertyInfo[];
    protected definedFacetInfosMap: {
        [key: string]: PropertyInfo;
    };
    properties(): tsInterfaces.IPropertyInfo[];
    declaredProperties(): tsInterfaces.IPropertyInfo[];
    allDefinedFacets(): tsInterfaces.IPropertyInfo[];
    definedFacets(): tsInterfaces.IPropertyInfo[];
    property(name: string): tsInterfaces.IPropertyInfo;
    checkDiscriminator(t1: AbstractType, t2: AbstractType): Status;
    /**
     * performs automatic classification of the instance
     * @param obj
     * @returns {AbstractType}
     */
    ac(obj: any): AbstractType;
    /**
     * adds new property declaration to this type, note if type is not inherited from an object type this will move
     * type to inconsistent state
     * @param name - name of the property
     * @param type - type of the property
     * @param optional true if property is optinal
     * @return the type with property (this)
     */
    declareProperty(name: string, t: AbstractType, optional: boolean): AbstractType;
    private discriminate;
    /**
     * return instance of type information of particular class
     * @param clazz
     * @returns {any}
     */
    oneMeta<T>(clazz: {
        new (v: any): T;
    }): T;
    /**
     * return all instances of meta information of particular class
     * @param clazz
     * @returns {any}
     */
    metaOfType<T>(clazz: {
        new (v: any, x?: any, p?: string): T;
    }): T[];
    declaredMeta(): TypeInformation[];
    descValue(): any;
    isAbstractOrInternal(): boolean;
    typeFamily(): AbstractType[];
    hasPropertiesFacet(): boolean;
    sourceMap(): tsInterfaces.ElementSourceInfo;
}
export declare abstract class Modifier extends TypeInformation {
    requiredType(): RootType;
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class Polymorphic extends Modifier {
    constructor();
    facetName(): string;
    value(): boolean;
}
export declare class Abstract extends Modifier {
    constructor();
    value(): boolean;
    facetName(): string;
}
export declare class Internal extends Modifier {
    constructor();
    facetName(): string;
    value(): boolean;
}
export declare class RootType extends AbstractType {
    private static CLASS_IDENTIFIER_RootType;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is RootType;
    kind(): string;
    clone(): this;
}
export declare class InheritedType extends AbstractType {
    protected _superTypes: AbstractType[];
    protected _contextMeta: restr.MatchesProperty;
    private static CLASS_IDENTIFIER_InheritedType;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is InheritedType;
    superTypes(): AbstractType[];
    clone(): InheritedType;
    knownProperties(): MatchesProperty[];
    kind(): string;
    meta(): TypeInformation[];
    addSuper(t: AbstractType): void;
    label(): string;
    contextMeta(): restr.MatchesProperty;
    setContextMeta(contextMeta: restr.MatchesProperty): void;
    patch(another: InheritedType): void;
}
export declare abstract class DerivedType extends AbstractType implements tsInterfaces.IDerivedType {
    private _options;
    constructor(name: string, _options: AbstractType[]);
    private static CLASS_IDENTIFIER_DerivedType;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is DerivedType;
    cloneWithFilter(x: (y: TypeInformation, transformed?: tsInterfaces.IParsedType) => boolean | TypeInformation, f?: (t: tsInterfaces.IParsedType) => tsInterfaces.IParsedType): AbstractType;
    /**
     *
     * @returns all possible options
     */
    allOptions(): AbstractType[];
    options(): AbstractType[];
}
export declare class UnionType extends DerivedType {
    private static CLASS_IDENTIFIER_UnionType;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is UnionType;
    kind(): string;
    clone(): UnionType;
    constructor(name: string, _options: AbstractType[]);
    isSubTypeOf(t: AbstractType): boolean;
    validate(i: any): Status;
    typeFamily(): AbstractType[];
    knownProperties(): MatchesProperty[];
    validateDirect(i: any, autoClose?: boolean): Status;
    isUnion(): boolean;
    isObject(): boolean;
    restrictions(): OrRestriction[];
    label(): string;
}
export declare class IntersectionType extends DerivedType {
    private static CLASS_IDENTIFIER_IntersectionType;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is IntersectionType;
    kind(): string;
    clone(): IntersectionType;
    restrictions(): AndRestriction[];
    label(): string;
    isIntersection(): boolean;
}
export declare function builtInRegistry(): TypeRegistry;
export declare function union(name: string, t: AbstractType[]): UnionType;
export declare function intersect(name: string, t: AbstractType[]): IntersectionType;
/**
 * allows you to extend a type from other types
 * @param name
 * @param t
 * @returns {InheritedType}
 */
export declare function derive(name: string, t: AbstractType[]): InheritedType;
/**
 * this function allows you to quickly derive a new type from object;
 * @param name
 * @returns {InheritedType}
 */
export declare function deriveObjectType(name: string): InheritedType;
export declare class NothingRestriction extends Constraint {
    check(i: any): Status;
    requiredType(): RootType;
    facetName(): string;
    value(): string;
}
export declare class RestrictionStackEntry {
    private _previous;
    private _restriction;
    private id;
    constructor(_previous: RestrictionStackEntry, _restriction: Constraint, id: string);
    getRestriction(): Constraint;
    pop(): RestrictionStackEntry;
    push(r: Constraint): RestrictionStackEntry;
}
export declare class NothingRestrictionWithLocation extends NothingRestriction {
    private _entry;
    private _message;
    private _another;
    constructor(_entry: RestrictionStackEntry, _message: string, _another: Constraint);
    getMessage(): string;
    getStack(): RestrictionStackEntry;
    another(): Constraint;
}
export declare abstract class GenericTypeOf extends Constraint {
    private static CLASS_IDENTIFIER_GenericTypeOf;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is GenericTypeOf;
}
export declare class TypeOfRestriction extends GenericTypeOf {
    private val;
    constructor(val: string);
    check(i: any): Status;
    value(): string;
    requiredType(): RootType;
    facetName(): string;
    composeWith(r: Constraint): Constraint;
    toString(): string;
}
export declare class IntegerRestriction extends GenericTypeOf {
    constructor();
    check(i: any): Status;
    requiredType(): RootType;
    value(): boolean;
    facetName(): string;
}
export declare class NullRestriction extends TypeOfRestriction {
    constructor();
    check(i: any): Status;
    requiredType(): RootType;
    facetName(): string;
}
export declare class ScalarRestriction extends GenericTypeOf {
    constructor();
    check(i: any): Status;
    requiredType(): RootType;
    facetName(): any;
    value(): boolean;
}
export declare class OrRestriction extends Constraint {
    private val;
    private _extraMessage?;
    private _extraOptionMessage?;
    constructor(val: Constraint[], _extraMessage?: any, _extraOptionMessage?: any);
    check(i: any, p: tsInterfaces.IValidationPath): Status;
    value(): any[];
    requiredType(): RootType;
    facetName(): string;
}
export declare class AndRestriction extends Constraint {
    private val;
    constructor(val: Constraint[]);
    value(): any[];
    options(): Constraint[];
    check(i: any, p: tsInterfaces.IValidationPath): Status;
    requiredType(): RootType;
    facetName(): string;
}
/***
 *
 * lets declare built in types
 */
export declare const ANY: RootType;
export declare const SCALAR: InheritedType;
export declare const OBJECT: InheritedType;
export declare const ARRAY: InheritedType;
export declare const EXTERNAL: InheritedType;
export declare const NUMBER: InheritedType;
export declare const INTEGER: InheritedType;
export declare const BOOLEAN: InheritedType;
export declare const STRING: InheritedType;
export declare const NIL: InheritedType;
export declare const DATE_ONLY: InheritedType;
export declare const TIME_ONLY: InheritedType;
export declare const DATETIME_ONLY: InheritedType;
export declare const DATETIME: InheritedType;
export declare const FILE: InheritedType;
export declare const NOTHING: RootType;
export declare const UNION: InheritedType;
export declare const UNKNOWN: InheritedType;
export declare const REFERENCE: InheritedType;
export declare const RECURRENT: InheritedType;
export declare class ExternalType extends InheritedType {
    private _content;
    private json;
    private provider;
    constructor(name: string, _content: string, json: boolean, provider: su.IContentProvider, typeAttributeProvider?: su.IContentProvider);
    private static CLASS_IDENTIFIER_ExternalType;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is ExternalType;
    getContentProvider(): su.IContentProvider;
    setContentProvider(provider: su.IContentProvider): void;
    kind(): string;
    isJSON(): boolean;
    schema(): string;
}
export declare function typePath(t: AbstractType): string[];
export declare class ValidationError extends Error {
    messageEntry: any;
    parameters: any;
    private static CLASS_IDENTIFIER_ValidationError;
    constructor(messageEntry: any, parameters?: any);
    isWarning: boolean;
    internalRange: tsInterfaces.RangeObject;
    internalPath: string;
    filePath: string;
    additionalErrors: ValidationError[];
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is ValidationError;
}
export declare function setValidationPath(_s: tsInterfaces.IStatus, _c: tsInterfaces.IValidationPath): void;
export declare function patchPath(p: tsInterfaces.IValidationPath): tsInterfaces.IValidationPath;
/**
 * A model of annotated RAML type facet
 */
export declare class AnnotatedFacet implements tsInterfaces.IAnnotatedElement {
    protected _facet: TypeInformation;
    protected reg: tsInterfaces.ITypeRegistry;
    constructor(_facet: TypeInformation, reg: tsInterfaces.ITypeRegistry);
    kind(): string;
    private _annotations;
    private _annotationsMap;
    annotationsMap(): {
        [key: string]: tsInterfaces.IAnnotationInstance;
    };
    annotations(): tsInterfaces.IAnnotationInstance[];
    /**
     * Value of the facet serialized to JSON
     */
    value(): any;
    /**
     * Facet name
     */
    name(): string;
    /**
     * The facet itself
     */
    entry(): tsInterfaces.ITypeFacet;
}
import parse = require("./parse");
/**
 * A model of annotated RAML type
 */
export declare class AnnotatedType implements tsInterfaces.IAnnotatedElement {
    private _type;
    protected reg: tsInterfaces.ITypeRegistry;
    constructor(_type: AbstractType, reg: tsInterfaces.ITypeRegistry);
    private _annotations;
    private _annotationsMap;
    kind(): string;
    annotationsMap(): {
        [key: string]: tsInterfaces.IAnnotationInstance;
    };
    annotations(): tsInterfaces.IAnnotationInstance[];
    /**
     * JSON representation of the type
     */
    value(): any;
    /**
     * Type name
     */
    name(): string;
    /**
     * The type itself
     * @returns {IParsedType}
     */
    entry(): tsInterfaces.IParsedType;
}
export declare class AnnotationInstance implements tsInterfaces.IAnnotationInstance {
    protected actual: tsInterfaces.IAnnotation;
    constructor(actual: tsInterfaces.IAnnotation, reg: tsInterfaces.ITypeRegistry);
    name(): string;
    /**
     * Annotation value
     */
    value(): any;
    /**
     * Annotation definition type
     */
    definition(): tsInterfaces.IParsedType;
    /**
     * Actual annotation model
     */
    annotation(): tsInterfaces.IAnnotation;
}
/**
 * Apply registered type validation plugins to the type
 * @param t type to be validated
 * @param reg context type registry
 * @param skipOk whether to omit OK issues
 * @returns an array of {tsInterfaces.IStatus}
 */
export declare function applyAnnotationValidationPlugins(e: tsInterfaces.IAnnotatedElement): Status[];
/**
 * Apply registered type validation plugins to the type
 * @param t type to be validated
 * @param reg context type registry
 * @param skipOk whether to omit OK issues
 * @returns an array of {tsInterfaces.IStatus}
 */
export declare function applyTypeValidationPlugins(t: tsInterfaces.IParsedType, reg: tsInterfaces.ITypeRegistry): Status[];
export declare function toValidationPath(p: string): tsInterfaces.IValidationPath;
export declare function isUnknown(t: AbstractType): boolean;
