"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.execute = exports.create = void 0;
const lst = __importStar(require("vscode-languageserver-types"));
const common_js_1 = require("./common.js");
function create(startOffset, endOffset, changeTo, changeFrom) {
    const from = (0, common_js_1.getEdgeStr)(changeFrom);
    const to = (0, common_js_1.getEdgeStr)(changeTo);
    return {
        title: `Change "${from}" to "${to}".`,
        command: "DOT.changeEdgeOp",
        arguments: [startOffset, endOffset, to],
    };
}
exports.create = create;
function execute(doc, _sourceFile, cmd) {
    if (!isChangeEdgeOpCommand(cmd))
        return undefined;
    const [startOffset, endOffset, changeTo] = cmd.arguments;
    const startPos = doc.positionAt(startOffset);
    const endPos = doc.positionAt(endOffset);
    return {
        label: `Change of invalid edge to "${changeTo}"'"`,
        edit: {
            changes: {
                [doc.uri]: [
                    lst.TextEdit.replace(lst.Range.create(startPos, endPos), changeTo),
                ],
            }
        }
    };
}
exports.execute = execute;
function isChangeEdgeOpCommand(cmd) {
    return cmd.command === "DOT.changeEdgeOp" && !!cmd.arguments && cmd.arguments.length === 3;
}
//# sourceMappingURL=ChangeEdgeOpCommand.js.map