/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.InputSource;

public class CachedAttributionBingAerialTileSource
extends BingAerialTileSource {
    private Runnable attributionDownloadedTask;

    public CachedAttributionBingAerialTileSource(ImageryInfo info) {
        this(info, null);
    }

    public CachedAttributionBingAerialTileSource(TileSourceInfo info, Runnable attributionDownloadedTask) {
        super(info);
        this.attributionDownloadedTask = attributionDownloadedTask;
        super.setLayer("AerialOSM");
    }

    @Override
    protected Callable<List<BingAerialTileSource.Attribution>> getAttributionLoaderCallable() {
        return () -> {
            BingAttributionData attributionLoader = new BingAttributionData();
            int waitTimeSec = 1;
            while (true) {
                try {
                    String xml = attributionLoader.updateIfRequiredString();
                    List<BingAerialTileSource.Attribution> ret = this.parseAttributionText(new InputSource(new StringReader(xml)));
                    if (this.attributionDownloadedTask != null) {
                        GuiHelper.runInEDT(this.attributionDownloadedTask);
                        this.attributionDownloadedTask = null;
                    }
                    return ret;
                }
                catch (IOException ex) {
                    Logging.log(Logging.LEVEL_WARN, "Could not connect to Bing API. Will retry in " + waitTimeSec + " seconds.", ex);
                    Thread.sleep(TimeUnit.SECONDS.toMillis(waitTimeSec));
                    waitTimeSec *= 2;
                    continue;
                }
                break;
            }
        };
    }

    class BingAttributionData
    extends CacheCustomContent<IOException> {
        BingAttributionData() {
            super("bing.attribution.xml", CacheCustomContent.INTERVAL_HOURLY);
        }

        @Override
        protected byte[] updateData() throws IOException {
            URL u = CachedAttributionBingAerialTileSource.this.getAttributionUrl();
            String r = HttpClient.create(u).connect().fetchContent();
            Logging.info("Successfully loaded Bing attribution data.");
            return r.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        protected boolean isOffline() {
            try {
                return NetworkManager.isOffline(CachedAttributionBingAerialTileSource.this.getAttributionUrl().toExternalForm());
            }
            catch (MalformedURLException e) {
                Logging.error(e);
                return false;
            }
        }
    }
}

