/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.IFilterablePrimitive;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.KeyValueVisitor;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.UniqueIdGenerator;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractPrimitive
implements IPrimitive,
IFilterablePrimitive {
    protected static final short FLAG_MODIFIED = 1;
    protected static final short FLAG_VISIBLE = 2;
    protected static final short FLAG_DELETED = 4;
    protected static final short FLAG_INCOMPLETE = 8;
    protected static final short FLAG_DISABLED = 16;
    protected static final short FLAG_HIDE_IF_DISABLED = 32;
    protected static final short FLAG_DISABLED_TYPE = 64;
    protected static final short FLAG_HIDDEN_TYPE = 128;
    protected static final short FLAG_HAS_DIRECTIONS = 256;
    protected static final short FLAG_TAGGED = 512;
    protected static final short FLAG_DIRECTION_REVERSED = 1024;
    protected static final short FLAG_HIGHLIGHTED = 2048;
    protected static final short FLAG_ANNOTATED = 4096;
    protected static final short FLAG_PRESERVED = 8192;
    protected volatile short flags = (short)2;
    protected short mappaintCacheIdx;
    protected long id;
    protected User user;
    protected int version;
    protected int changesetId;
    protected int timestamp;
    protected volatile String[] keys;
    private static volatile Collection<String> workinprogress;
    private static volatile Collection<String> uninteresting;
    private static volatile Collection<String> discardable;

    public void cloneFrom(AbstractPrimitive other) {
        this.setKeys(other.getKeys());
        this.id = other.id;
        if (this.id <= 0L) {
            this.version = 0;
            this.changesetId = 0;
        }
        this.timestamp = other.timestamp;
        if (this.id > 0L) {
            this.version = other.version;
        }
        this.flags = other.flags;
        this.user = other.user;
        if (this.id > 0L && other.changesetId > 0) {
            this.setChangesetId(other.changesetId);
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getId() {
        return this.id >= 0L ? this.id : 0L;
    }

    @Override
    public long getUniqueId() {
        return this.id;
    }

    @Override
    public boolean isNew() {
        return this.id <= 0L;
    }

    @Override
    public boolean isNewOrUndeleted() {
        return this.isNew() || (this.flags & 6) == 0;
    }

    @Override
    public void setOsmId(long id, int version) {
        if (id <= 0L) {
            throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", id));
        }
        if (version <= 0) {
            throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", version));
        }
        this.id = id;
        this.version = version;
        this.setIncomplete(false);
    }

    public void clearOsmMetadata() {
        this.id = this.getIdGenerator().generateUniqueId();
        this.version = 0;
        this.user = null;
        this.changesetId = 0;
        this.timestamp = 0;
        this.setIncomplete(false);
        this.setDeleted(false);
        this.setVisible(true);
    }

    public abstract UniqueIdGenerator getIdGenerator();

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public int getChangesetId() {
        return this.changesetId;
    }

    @Override
    public void setChangesetId(int changesetId) {
        if (this.changesetId == changesetId) {
            return;
        }
        if (changesetId < 0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' >= 0 expected, got {1}", "changesetId", changesetId));
        }
        if (changesetId > 0 && this.isNew()) {
            throw new IllegalStateException(I18n.tr("Cannot assign a changesetId > 0 to a new primitive. Value of changesetId is {0}", changesetId));
        }
        this.changesetId = changesetId;
    }

    @Override
    @Deprecated
    public void setTimestamp(Date timestamp) {
        this.timestamp = (int)TimeUnit.MILLISECONDS.toSeconds(timestamp.getTime());
    }

    @Override
    public void setInstant(Instant timestamp) {
        this.timestamp = (int)timestamp.getEpochSecond();
    }

    @Override
    public void setRawTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    @Deprecated
    public Date getTimestamp() {
        return Date.from(this.getInstant());
    }

    @Override
    public Instant getInstant() {
        return Instant.ofEpochSecond(Integer.toUnsignedLong(this.timestamp));
    }

    @Override
    public int getRawTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isTimestampEmpty() {
        return this.timestamp == 0;
    }

    protected void updateFlags(short flag, boolean value) {
        this.flags = value ? (short)(this.flags | flag) : (short)(this.flags & (short)(~flag));
    }

    protected boolean updateFlagsChanged(short flag, boolean value) {
        short oldFlags = this.flags;
        this.updateFlags(flag, value);
        return oldFlags != this.flags;
    }

    @Override
    public void setModified(boolean modified) {
        this.updateFlags((short)1, modified);
    }

    @Override
    public boolean isModified() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isDeleted() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isUndeleted() {
        return (this.flags & 6) == 0;
    }

    @Override
    public boolean isUsable() {
        return (this.flags & 0xC) == 0;
    }

    @Override
    public boolean isVisible() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.isNew()) {
            throw new IllegalStateException(I18n.tr("A primitive with ID = 0 cannot be invisible.", new Object[0]));
        }
        this.updateFlags((short)2, visible);
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.updateFlags((short)4, deleted);
        this.setModified(deleted ^ !this.isVisible());
    }

    protected void setIncomplete(boolean incomplete) {
        this.updateFlags((short)8, incomplete);
    }

    @Override
    public boolean isIncomplete() {
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean getHiddenType() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public boolean getDisabledType() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean setDisabledState(boolean hidden) {
        boolean flagDisabled = this.updateFlagsChanged((short)16, true);
        boolean flagHideIfDisabled = this.updateFlagsChanged((short)32, hidden);
        return flagDisabled || flagHideIfDisabled;
    }

    @Override
    public boolean unsetDisabledState() {
        boolean flagDisabled = this.updateFlagsChanged((short)16, false);
        boolean flagHideIfDisabled = this.updateFlagsChanged((short)32, false);
        return flagDisabled || flagHideIfDisabled;
    }

    @Override
    public void setDisabledType(boolean isExplicit) {
        this.updateFlags((short)64, isExplicit);
    }

    @Override
    public void setHiddenType(boolean isExplicit) {
        this.updateFlags((short)128, isExplicit);
    }

    @Override
    public boolean isDrawable() {
        return (this.flags & 0x2C) == 0;
    }

    protected String getFlagsAsString() {
        StringBuilder builder = new StringBuilder();
        if (this.isIncomplete()) {
            builder.append('I');
        }
        if (this.isModified()) {
            builder.append('M');
        }
        if (this.isVisible()) {
            builder.append('V');
        }
        if (this.isDeleted()) {
            builder.append('D');
        }
        return builder.toString();
    }

    public TagMap getKeys() {
        return new TagMap(this.keys);
    }

    @Override
    public void visitKeys(KeyValueVisitor visitor) {
        String[] tKeys = this.keys;
        if (tKeys != null) {
            for (int i = 0; i < tKeys.length; i += 2) {
                visitor.visitKeyValue(this, tKeys[i], tKeys[i + 1]);
            }
        }
    }

    @Override
    public void setKeys(Map<String, String> keys) {
        TagMap originalKeys = this.getKeys();
        if (Utils.isEmpty(keys)) {
            this.keys = null;
            this.keysChangedImpl(originalKeys);
            return;
        }
        String[] newKeys = new String[keys.size() * 2];
        int index = 0;
        for (Map.Entry<String, String> entry : keys.entrySet()) {
            newKeys[index++] = Objects.requireNonNull(entry.getKey());
            newKeys[index++] = Objects.requireNonNull(entry.getValue());
        }
        this.keys = newKeys;
        this.keysChangedImpl(originalKeys);
    }

    public void setKeys(TagMap keys) {
        String[] arr;
        TagMap originalKeys = this.getKeys();
        this.keys = keys == null ? null : ((arr = keys.getTagsArray()).length == 0 ? null : arr);
        this.keysChangedImpl(originalKeys);
    }

    @Override
    public void put(String key, String value) {
        TagMap originalKeys = this.getKeys();
        if (key == null || Utils.isStripEmpty(key)) {
            return;
        }
        if (value == null) {
            this.remove(key);
        } else if (this.keys == null) {
            this.keys = new String[]{key, value};
            this.keysChangedImpl(originalKeys);
        } else {
            int keyIndex = AbstractPrimitive.indexOfKey(this.keys, key);
            int tagArrayLength = this.keys.length;
            if (keyIndex < 0) {
                keyIndex = tagArrayLength;
                tagArrayLength += 2;
            }
            String[] newKeys = Arrays.copyOf(this.keys, tagArrayLength);
            newKeys[keyIndex] = key;
            newKeys[keyIndex + 1] = value;
            this.keys = newKeys;
            this.keysChangedImpl(originalKeys);
        }
    }

    @Override
    public void putAll(Map<String, String> tags) {
        if (tags == null || tags.isEmpty()) {
            return;
        }
        String[] tKeys = this.keys;
        String[] newKeys = tKeys == null ? null : (String[])tKeys.clone();
        TagMap originalKeys = this.getKeys();
        ArrayList<Map.Entry<String, String>> tagsToAdd = new ArrayList<Map.Entry<String, String>>(tags.size());
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            if (Utils.isBlank(tag.getKey())) continue;
            int n = AbstractPrimitive.indexOfKey(newKeys, tag.getKey());
            if (n < 0 || newKeys == null) {
                tagsToAdd.add(tag);
                continue;
            }
            newKeys[n + 1] = tag.getValue();
        }
        if (!tagsToAdd.isEmpty()) {
            int index = newKeys != null ? newKeys.length : 0;
            newKeys = newKeys != null ? Arrays.copyOf(newKeys, newKeys.length + 2 * tagsToAdd.size()) : new String[2 * tagsToAdd.size()];
            for (Map.Entry entry : tagsToAdd) {
                newKeys[index++] = (String)entry.getKey();
                newKeys[index++] = (String)entry.getValue();
            }
        }
        this.keys = newKeys;
        this.keysChangedImpl(originalKeys);
    }

    private static int indexOfKey(String[] keys, String key) {
        if (keys == null) {
            return -1;
        }
        for (int i = 0; i < keys.length; i += 2) {
            if (!keys[i].equals(key)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void remove(String key) {
        if (key == null || this.keys == null) {
            return;
        }
        if (!this.hasKey(key)) {
            return;
        }
        TagMap originalKeys = this.getKeys();
        if (this.keys.length == 2) {
            this.keys = null;
            this.keysChangedImpl(originalKeys);
            return;
        }
        String[] newKeys = new String[this.keys.length - 2];
        int j = 0;
        for (int i = 0; i < this.keys.length; i += 2) {
            if (this.keys[i].equals(key)) continue;
            newKeys[j++] = this.keys[i];
            newKeys[j++] = this.keys[i + 1];
        }
        this.keys = newKeys;
        this.keysChangedImpl(originalKeys);
    }

    @Override
    public void removeAll() {
        if (this.keys != null) {
            TagMap originalKeys = this.getKeys();
            this.keys = null;
            this.keysChangedImpl(originalKeys);
        }
    }

    protected final String doGet(String key, BiPredicate<String, String> predicate) {
        if (key == null) {
            return null;
        }
        if (this.keys == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; i += 2) {
            if (!predicate.test(this.keys[i], key)) continue;
            return this.keys[i + 1];
        }
        return null;
    }

    @Override
    public final String get(String key) {
        return this.doGet(key, String::equals);
    }

    public final String getIgnoreCase(String key) {
        return this.doGet(key, String::equalsIgnoreCase);
    }

    @Override
    public final int getNumKeys() {
        return this.keys == null ? 0 : this.keys.length / 2;
    }

    @Override
    public final Collection<String> keySet() {
        String[] tKeys = this.keys;
        if (tKeys == null) {
            return Collections.emptySet();
        }
        if (tKeys.length == 2) {
            return Collections.singleton(tKeys[0]);
        }
        HashSet<String> result = new HashSet<String>(Utils.hashMapInitialCapacity(tKeys.length / 2));
        for (int i = 0; i < tKeys.length; i += 2) {
            result.add(tKeys[i]);
        }
        return result;
    }

    @Override
    public Stream<String> keys() {
        String[] k = this.keys;
        if (k == null) {
            return Stream.empty();
        }
        if (k.length == 2) {
            return Stream.of(k[0]);
        }
        return IntStream.range(0, k.length / 2).mapToObj(i -> k[i * 2]);
    }

    @Override
    public final boolean hasKeys() {
        return this.keys != null;
    }

    @Override
    public boolean hasKey(String key) {
        return key != null && AbstractPrimitive.indexOfKey(this.keys, key) >= 0;
    }

    public boolean hasKey(String ... keys) {
        if (keys != null) {
            for (String key : keys) {
                if (!this.hasKey(key)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void keysChangedImpl(Map<String, String> var1);

    public static Collection<String> getUninterestingKeys() {
        if (uninteresting == null) {
            LinkedList<String> l = new LinkedList<String>(Arrays.asList("source", "source_ref", "source:", "comment", "import", "watch", "watch:", "description", "attribution", "gpx:"));
            l.addAll(AbstractPrimitive.getDiscardableKeys());
            l.addAll(AbstractPrimitive.getWorkInProgressKeys());
            uninteresting = new HashSet<String>(Config.getPref().getList("tags.uninteresting", l));
        }
        return uninteresting;
    }

    public static Collection<String> getDiscardableKeys() {
        if (discardable == null) {
            discardable = new HashSet<String>(Config.getPref().getList("tags.discardable", Arrays.asList("created_by", "converted_by", "current_id", "geobase:datasetName", "geobase:uuid", "KSJ2:ADS", "KSJ2:ARE", "KSJ2:AdminArea", "KSJ2:COP_label", "KSJ2:DFD", "KSJ2:INT", "KSJ2:INT_label", "KSJ2:LOC", "KSJ2:LPN", "KSJ2:OPC", "KSJ2:PubFacAdmin", "KSJ2:RAC", "KSJ2:RAC_label", "KSJ2:RIC", "KSJ2:RIN", "KSJ2:WSC", "KSJ2:coordinate", "KSJ2:curve_id", "KSJ2:curve_type", "KSJ2:filename", "KSJ2:lake_id", "KSJ2:lat", "KSJ2:long", "KSJ2:river_id", "odbl", "odbl:note", "osmarender:nameDirection", "osmarender:renderName", "osmarender:renderRef", "osmarender:rendernames", "SK53_bulk:load", "sub_sea:type", "tiger:source", "tiger:separated", "tiger:tlid", "tiger:upload_uuid", "import_uuid", "gnis:import_uuid", "yh:LINE_NAME", "yh:LINE_NUM", "yh:STRUCTURE", "yh:TOTYUMONO", "yh:TYPE", "yh:WIDTH", "yh:WIDTH_RANK")));
        }
        return discardable;
    }

    public static Collection<String> getWorkInProgressKeys() {
        if (workinprogress == null) {
            workinprogress = new HashSet<String>(Config.getPref().getList("tags.workinprogress", Arrays.asList("note", "fixme", "FIXME")));
        }
        return workinprogress;
    }

    public static boolean isUninterestingKey(String key) {
        AbstractPrimitive.getUninterestingKeys();
        if (uninteresting.contains(key)) {
            return true;
        }
        int pos = key.indexOf(58);
        if (pos > 0) {
            return uninteresting.contains(key.substring(0, pos + 1));
        }
        return false;
    }

    @Override
    public Map<String, String> getInterestingTags() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; i += 2) {
                if (AbstractPrimitive.isUninterestingKey(this.keys[i])) continue;
                result.put(this.keys[i], this.keys[i + 1]);
            }
        }
        return result;
    }
}

