/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import org.bouncycastle.jcajce.spec.TLSRSAPremasterSecretParameterSpec;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceDefaultTlsCredentialedDecryptor
implements TlsCredentialedDecryptor {
    protected JcaTlsCrypto crypto;
    protected Certificate certificate;
    protected PrivateKey privateKey;

    public JceDefaultTlsCredentialedDecryptor(JcaTlsCrypto jcaTlsCrypto, Certificate certificate, PrivateKey privateKey) {
        if (jcaTlsCrypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!(privateKey instanceof RSAPrivateKey) && !"RSA".equals(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.crypto = jcaTlsCrypto;
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters tlsCryptoParameters, byte[] byArray) throws IOException {
        return this.safeDecryptPreMasterSecret(tlsCryptoParameters, this.privateKey, byArray);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters tlsCryptoParameters, PrivateKey privateKey, byte[] byArray) {
        byte[] byArray2;
        SecureRandom secureRandom = this.crypto.getSecureRandom();
        ProtocolVersion protocolVersion = tlsCryptoParameters.getRSAPreMasterSecretVersion();
        try {
            Cipher cipher = this.crypto.createRSAEncryptionCipher();
            cipher.init(2, (Key)privateKey, (AlgorithmParameterSpec)new TLSRSAPremasterSecretParameterSpec(protocolVersion.getFullVersion()), secureRandom);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            byte[] byArray3 = new byte[48];
            secureRandom.nextBytes(byArray3);
            byArray2 = Arrays.clone((byte[])byArray3);
            try {
                Cipher cipher = this.crypto.createRSAEncryptionCipher();
                cipher.init(2, (Key)privateKey, secureRandom);
                byte[] byArray4 = cipher.doFinal(byArray);
                if (byArray4 != null && byArray4.length == 48) {
                    byArray2 = byArray4;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            int n = protocolVersion.getMajorVersion() ^ byArray2[0] & 0xFF | protocolVersion.getMinorVersion() ^ byArray2[1] & 0xFF;
            n = n - 1 >> 31;
            for (int i = 0; i < 48; ++i) {
                byArray2[i] = (byte)(byArray2[i] & n | byArray3[i] & ~n);
            }
        }
        return this.crypto.createSecret(byArray2);
    }
}

