/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.message;

import java.util.Locale;
import org.jetbrains.kotlin.org.apache.http.HttpEntity;
import org.jetbrains.kotlin.org.apache.http.HttpResponse;
import org.jetbrains.kotlin.org.apache.http.HttpVersion;
import org.jetbrains.kotlin.org.apache.http.ProtocolVersion;
import org.jetbrains.kotlin.org.apache.http.ReasonPhraseCatalog;
import org.jetbrains.kotlin.org.apache.http.StatusLine;
import org.jetbrains.kotlin.org.apache.http.message.AbstractHttpMessage;
import org.jetbrains.kotlin.org.apache.http.message.BasicStatusLine;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public class BasicHttpResponse
extends AbstractHttpMessage
implements HttpResponse {
    private StatusLine statusline;
    private ProtocolVersion ver;
    private int code;
    private String reasonPhrase;
    private HttpEntity entity;
    private final ReasonPhraseCatalog reasonCatalog;
    private Locale locale;

    public BasicHttpResponse(StatusLine statusline, ReasonPhraseCatalog catalog, Locale locale) {
        this.statusline = Args.notNull(statusline, "Status line");
        this.ver = statusline.getProtocolVersion();
        this.code = statusline.getStatusCode();
        this.reasonPhrase = statusline.getReasonPhrase();
        this.reasonCatalog = catalog;
        this.locale = locale;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.ver;
    }

    @Override
    public StatusLine getStatusLine() {
        if (this.statusline == null) {
            this.statusline = new BasicStatusLine(this.ver != null ? this.ver : HttpVersion.HTTP_1_1, this.code, this.reasonPhrase != null ? this.reasonPhrase : this.getReason(this.code));
        }
        return this.statusline;
    }

    @Override
    public HttpEntity getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    protected String getReason(int code) {
        return this.reasonCatalog != null ? this.reasonCatalog.getReason(code, this.locale != null ? this.locale : Locale.getDefault()) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStatusLine());
        sb.append(' ');
        sb.append(this.headergroup);
        if (this.entity != null) {
            sb.append(' ');
            sb.append(this.entity);
        }
        return sb.toString();
    }
}

