/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.RequestTrace;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.ArtifactType;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.DefaultArtifact;
import org.jetbrains.kotlin.org.eclipse.aether.collection.CollectRequest;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyManager;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencySelector;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyTraverser;
import org.jetbrains.kotlin.org.eclipse.aether.collection.VersionFilter;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DefaultDependencyNode;
import org.jetbrains.kotlin.org.eclipse.aether.graph.Dependency;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyNode;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.DataPool;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.DefaultDependencyCollectionContext;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.DefaultDependencyCycle;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.DefaultVersionFilterContext;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.PremanagedDependency;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector$$Lambda$1;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector$$Lambda$2;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector$$Lambda$3;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector$$Lambda$4;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector$DescriptorResolutionResult$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector$ParallelDescriptorResolver$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf.BfDependencyCollector$ParallelDescriptorResolver$$Lambda$1;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf.DependencyProcessingContext;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf.DependencyResolutionSkipper;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRangeRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.VersionRangeResult;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.Service;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.jetbrains.kotlin.org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.jetbrains.kotlin.org.eclipse.aether.util.concurrency.WorkerThreadFactory;
import org.jetbrains.kotlin.org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="bf")
public class BfDependencyCollector
extends DependencyCollectorDelegate
implements Service {
    @Deprecated
    public BfDependencyCollector() {
    }

    @Override
    protected void doCollectDependencies(RepositorySystemSession session, RequestTrace trace, DataPool pool, DefaultDependencyCollectionContext context, DefaultVersionFilterContext versionContext, CollectRequest request, DependencyNode node, List<RemoteRepository> repositories, List<Dependency> dependencies, List<Dependency> managedDependencies, DependencyCollectorDelegate.Results results) {
        boolean useSkip = ConfigUtils.getBoolean(session, true, "aether.dependencyCollector.bf.skipper");
        if (useSkip) {
            this.logger.debug("Collector skip mode enabled");
        }
        Args args = new Args(session, pool, context, versionContext, request, useSkip ? DependencyResolutionSkipper.defaultSkipper() : DependencyResolutionSkipper.neverSkipper(), new ParallelDescriptorResolver(session));
        DependencySelector rootDepSelector = session.getDependencySelector() != null ? session.getDependencySelector().deriveChildSelector(context) : null;
        DependencyManager rootDepManager = session.getDependencyManager() != null ? session.getDependencyManager().deriveChildManager(context) : null;
        DependencyTraverser rootDepTraverser = session.getDependencyTraverser() != null ? session.getDependencyTraverser().deriveChildTraverser(context) : null;
        VersionFilter rootVerFilter = session.getVersionFilter() != null ? session.getVersionFilter().deriveChildFilter(context) : null;
        List<DependencyNode> parents = Collections.singletonList(node);
        for (Dependency dependency : dependencies) {
            RequestTrace childTrace = this.collectStepTrace(trace, args.request.getRequestContext(), parents, dependency);
            DependencyProcessingContext processingContext = new DependencyProcessingContext(rootDepSelector, rootDepManager, rootDepTraverser, rootVerFilter, childTrace, repositories, managedDependencies, parents, dependency, PremanagedDependency.create(rootDepManager, dependency, false, args.premanagedState));
            if (this.filter(processingContext)) continue;
            processingContext.withDependency(processingContext.premanagedDependency.getManagedDependency());
            this.resolveArtifactDescriptorAsync(args, processingContext, results);
            args.dependencyProcessingQueue.add(processingContext);
        }
        while (!args.dependencyProcessingQueue.isEmpty()) {
            this.processDependency(args, results, args.dependencyProcessingQueue.remove(), Collections.emptyList(), false);
        }
        args.resolver.shutdown();
        args.skipper.report();
    }

    private void processDependency(Args args, DependencyCollectorDelegate.Results results, DependencyProcessingContext context, List<Artifact> relocations, boolean disableVersionManagement) {
        VersionRangeResult rangeResult;
        DescriptorResolutionResult resolutionResult;
        Dependency dependency = context.dependency;
        PremanagedDependency preManaged = context.premanagedDependency;
        boolean noDescriptor = BfDependencyCollector.isLackingDescriptor(dependency.getArtifact());
        boolean traverse = !noDescriptor && (context.depTraverser == null || context.depTraverser.traverseDependency(dependency));
        Future<DescriptorResolutionResult> resolutionResultFuture = args.resolver.find(dependency.getArtifact());
        try {
            resolutionResult = resolutionResultFuture.get();
            rangeResult = resolutionResult.rangeResult;
        }
        catch (Exception e) {
            results.addException(dependency, e, context.parents);
            return;
        }
        Set<Version> versions = resolutionResult.descriptors.keySet();
        for (Version version : versions) {
            Artifact originalArtifact = dependency.getArtifact().setVersion(version.toString());
            Dependency d = dependency.setArtifact(originalArtifact);
            ArtifactDescriptorResult descriptorResult = resolutionResult.descriptors.get(version);
            if (descriptorResult != null) {
                DefaultDependencyNode child;
                int cycleEntry = DefaultDependencyCycle.find(context.parents, (d = d.setArtifact(descriptorResult.getArtifact())).getArtifact());
                if (cycleEntry >= 0) {
                    results.addCycle(context.parents, cycleEntry, d);
                    DependencyNode cycleNode = context.parents.get(cycleEntry);
                    if (cycleNode.getDependency() != null) {
                        child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult, cycleNode);
                        context.getParent().getChildren().add(child);
                        continue;
                    }
                }
                if (!descriptorResult.getRelocations().isEmpty()) {
                    boolean disableVersionManagementSubsequently = originalArtifact.getGroupId().equals(d.getArtifact().getGroupId()) && originalArtifact.getArtifactId().equals(d.getArtifact().getArtifactId());
                    PremanagedDependency premanagedDependency = PremanagedDependency.create(context.depManager, d, disableVersionManagementSubsequently, args.premanagedState);
                    DependencyProcessingContext relocatedContext = new DependencyProcessingContext(context.depSelector, context.depManager, context.depTraverser, context.verFilter, context.trace, context.repositories, descriptorResult.getManagedDependencies(), context.parents, d, premanagedDependency);
                    if (!this.filter(relocatedContext)) {
                        relocatedContext.withDependency(premanagedDependency.getManagedDependency());
                        this.resolveArtifactDescriptorAsync(args, relocatedContext, results);
                        this.processDependency(args, results, relocatedContext, descriptorResult.getRelocations(), disableVersionManagementSubsequently);
                    }
                    return;
                }
                d = args.pool.intern(d.setArtifact(args.pool.intern(d.getArtifact())));
                List<RemoteRepository> repos = BfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), context.repositories);
                child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult.getAliases(), repos, args.request.getRequestContext());
                context.getParent().getChildren().add(child);
                boolean recurse = traverse && !descriptorResult.getDependencies().isEmpty();
                DependencyProcessingContext parentContext = context.withDependency(d);
                if (recurse) {
                    this.doRecurse(args, parentContext, descriptorResult, child, results, disableVersionManagement);
                    continue;
                }
                if (args.skipper.skipResolution(child, parentContext.parents)) continue;
                ArrayList<DependencyNode> parents = new ArrayList<DependencyNode>(parentContext.parents.size() + 1);
                parents.addAll(parentContext.parents);
                parents.add(child);
                args.skipper.cache(child, parents);
                continue;
            }
            List<RemoteRepository> repos = BfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), context.repositories);
            DefaultDependencyNode child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, null, repos, args.request.getRequestContext());
            context.getParent().getChildren().add(child);
        }
    }

    private void doRecurse(Args args, DependencyProcessingContext parentContext, ArtifactDescriptorResult descriptorResult, DefaultDependencyNode child, DependencyCollectorDelegate.Results results, boolean disableVersionManagement) {
        DefaultDependencyCollectionContext context = args.collectionContext;
        context.set(parentContext.dependency, descriptorResult.getManagedDependencies());
        DependencySelector childSelector = parentContext.depSelector != null ? parentContext.depSelector.deriveChildSelector(context) : null;
        DependencyManager childManager = parentContext.depManager != null ? parentContext.depManager.deriveChildManager(context) : null;
        DependencyTraverser childTraverser = parentContext.depTraverser != null ? parentContext.depTraverser.deriveChildTraverser(context) : null;
        VersionFilter childFilter = parentContext.verFilter != null ? parentContext.verFilter.deriveChildFilter(context) : null;
        List<RemoteRepository> childRepos = args.ignoreRepos ? parentContext.repositories : this.remoteRepositoryManager.aggregateRepositories(args.session, parentContext.repositories, descriptorResult.getRepositories(), true);
        Object key = args.pool.toKey(parentContext.dependency.getArtifact(), childRepos, childSelector, childManager, childTraverser, childFilter);
        List<DependencyNode> children = args.pool.getChildren(key);
        if (children == null) {
            boolean skipResolution = args.skipper.skipResolution(child, parentContext.parents);
            if (!skipResolution) {
                ArrayList<DependencyNode> parents = new ArrayList<DependencyNode>(parentContext.parents.size() + 1);
                parents.addAll(parentContext.parents);
                parents.add(child);
                for (Dependency dependency : descriptorResult.getDependencies()) {
                    RequestTrace childTrace = this.collectStepTrace(parentContext.trace, args.request.getRequestContext(), parents, dependency);
                    PremanagedDependency premanagedDependency = PremanagedDependency.create(childManager, dependency, disableVersionManagement, args.premanagedState);
                    DependencyProcessingContext processingContext = new DependencyProcessingContext(childSelector, childManager, childTraverser, childFilter, childTrace, childRepos, descriptorResult.getManagedDependencies(), parents, dependency, premanagedDependency);
                    if (this.filter(processingContext)) continue;
                    processingContext.withDependency(processingContext.premanagedDependency.getManagedDependency());
                    this.resolveArtifactDescriptorAsync(args, processingContext, results);
                    args.dependencyProcessingQueue.add(processingContext);
                }
                args.pool.putChildren(key, child.getChildren());
                args.skipper.cache(child, parents);
            }
        } else {
            child.setChildren(children);
        }
    }

    private boolean filter(DependencyProcessingContext context) {
        return context.depSelector != null && !context.depSelector.selectDependency(context.dependency);
    }

    private void resolveArtifactDescriptorAsync(Args args, DependencyProcessingContext context, DependencyCollectorDelegate.Results results) {
        Dependency dependency = context.dependency;
        DependencyCollectorDelegate.Results results2 = results;
        Dependency dependency2 = dependency;
        DependencyProcessingContext dependencyProcessingContext = context;
        Args args2 = args;
        BfDependencyCollector bfDependencyCollector = this;
        args.resolver.resolveDescriptors(dependency.getArtifact(), new BfDependencyCollector$$Lambda$0(bfDependencyCollector, args2, dependencyProcessingContext, dependency2, results2));
    }

    private ArtifactDescriptorResult resolveDescriptorForVersion(Args args, DependencyProcessingContext context, DependencyCollectorDelegate.Results results, Dependency dependency, Version version) {
        Artifact original = dependency.getArtifact();
        DefaultArtifact newArtifact = new DefaultArtifact(original.getGroupId(), original.getArtifactId(), original.getClassifier(), original.getExtension(), version.toString(), original.getProperties(), (ArtifactType)null);
        Dependency newDependency = new Dependency((Artifact)newArtifact, dependency.getScope(), dependency.isOptional(), dependency.getExclusions());
        DependencyProcessingContext newContext = context.copy();
        ArtifactDescriptorRequest descriptorRequest = BfDependencyCollector.createArtifactDescriptorRequest(args.request.getRequestContext(), context.trace, newContext.repositories, newDependency);
        return BfDependencyCollector.isLackingDescriptor(newArtifact) ? new ArtifactDescriptorResult(descriptorRequest) : this.resolveCachedArtifactDescriptor(args.pool, descriptorRequest, args.session, newContext.withDependency(newDependency), results);
    }

    private ArtifactDescriptorResult resolveCachedArtifactDescriptor(DataPool pool, ArtifactDescriptorRequest descriptorRequest, RepositorySystemSession session, DependencyProcessingContext context, DependencyCollectorDelegate.Results results) {
        Object key = pool.toKey(descriptorRequest);
        ArtifactDescriptorResult descriptorResult = pool.getDescriptor(key, descriptorRequest);
        if (descriptorResult == null) {
            try {
                descriptorResult = this.descriptorReader.readArtifactDescriptor(session, descriptorRequest);
                pool.putDescriptor(key, descriptorResult);
            }
            catch (ArtifactDescriptorException e) {
                results.addException(context.dependency, e, context.parents);
                pool.putDescriptor(key, e);
                return null;
            }
        } else if (descriptorResult == DataPool.NO_DESCRIPTOR) {
            return null;
        }
        return descriptorResult;
    }

    private /* synthetic */ DescriptorResolutionResult lambda$resolveArtifactDescriptorAsync$4(Args args, DependencyProcessingContext context, Dependency dependency, DependencyCollectorDelegate.Results results) throws Exception {
        VersionRangeRequest rangeRequest = BfDependencyCollector.createVersionRangeRequest(args.request.getRequestContext(), context.trace, context.repositories, dependency);
        VersionRangeResult rangeResult = this.cachedResolveRangeResult(rangeRequest, args.pool, args.session);
        List<? extends Version> versions = BfDependencyCollector.filterVersions(dependency, rangeResult, context.verFilter, args.versionContext);
        Collections.reverse(versions);
        ConcurrentHashMap descriptors = new ConcurrentHashMap(versions.size());
        Stream stream = versions.size() > 1 ? versions.parallelStream() : versions.stream();
        Object object = descriptors;
        Object object2 = dependency;
        DependencyCollectorDelegate.Results results2 = results;
        DependencyProcessingContext dependencyProcessingContext = context;
        Args args2 = args;
        BfDependencyCollector bfDependencyCollector = this;
        stream.forEach(new BfDependencyCollector$$Lambda$1(bfDependencyCollector, args2, dependencyProcessingContext, results2, (Dependency)object2, (Map)object));
        DescriptorResolutionResult resolutionResult = new DescriptorResolutionResult(dependency.getArtifact(), rangeResult);
        object = descriptors;
        object2 = resolutionResult;
        versions.forEach(new BfDependencyCollector$$Lambda$2((DescriptorResolutionResult)object2, (Map)object));
        object = args;
        resolutionResult.flatten().forEach(new BfDependencyCollector$$Lambda$3((Args)object));
        return resolutionResult;
    }

    private /* synthetic */ void lambda$resolveArtifactDescriptorAsync$1(Args args, DependencyProcessingContext context, DependencyCollectorDelegate.Results results, Dependency dependency, Map descriptors, Version version) {
        Version version2 = version;
        Map map = descriptors;
        Optional.ofNullable(this.resolveDescriptorForVersion(args, context, results, dependency, version)).ifPresent(new BfDependencyCollector$$Lambda$4(map, version2));
    }

    static /* synthetic */ DescriptorResolutionResult accessor$BfDependencyCollector$lambda0(BfDependencyCollector bfDependencyCollector, Args args, DependencyProcessingContext dependencyProcessingContext, Dependency dependency, DependencyCollectorDelegate.Results results) {
        return bfDependencyCollector.lambda$resolveArtifactDescriptorAsync$4(args, dependencyProcessingContext, dependency, results);
    }

    static /* synthetic */ void accessor$BfDependencyCollector$lambda1(BfDependencyCollector bfDependencyCollector, Args args, DependencyProcessingContext dependencyProcessingContext, DependencyCollectorDelegate.Results results, Dependency dependency, Map map, Version version) {
        bfDependencyCollector.lambda$resolveArtifactDescriptorAsync$1(args, dependencyProcessingContext, results, dependency, map, version);
    }

    static /* synthetic */ void accessor$BfDependencyCollector$lambda2(DescriptorResolutionResult descriptorResolutionResult, Map map, Version version) {
        descriptorResolutionResult.descriptors.put(version, (ArtifactDescriptorResult)map.get(version));
    }

    static /* synthetic */ void accessor$BfDependencyCollector$lambda3(Args args, DescriptorResolutionResult descriptorResolutionResult) {
        args.resolver.cacheVersionRangeDescriptor(descriptorResolutionResult.artifact, descriptorResolutionResult);
    }

    static /* synthetic */ void accessor$BfDependencyCollector$lambda4(Map map, Version version, ArtifactDescriptorResult artifactDescriptorResult) {
        map.put(version, artifactDescriptorResult);
    }

    static class Args {
        final RepositorySystemSession session;
        final boolean ignoreRepos;
        final boolean premanagedState;
        final DataPool pool;
        final Queue<DependencyProcessingContext> dependencyProcessingQueue = new ArrayDeque<DependencyProcessingContext>(128);
        final DefaultDependencyCollectionContext collectionContext;
        final DefaultVersionFilterContext versionContext;
        final CollectRequest request;
        final DependencyResolutionSkipper skipper;
        final ParallelDescriptorResolver resolver;

        Args(RepositorySystemSession session, DataPool pool, DefaultDependencyCollectionContext collectionContext, DefaultVersionFilterContext versionContext, CollectRequest request, DependencyResolutionSkipper skipper, ParallelDescriptorResolver resolver) {
            this.session = session;
            this.request = request;
            this.ignoreRepos = session.isIgnoreArtifactDescriptorRepositories();
            this.premanagedState = ConfigUtils.getBoolean(session, false, "aether.dependencyManager.verbose");
            this.pool = pool;
            this.collectionContext = collectionContext;
            this.versionContext = versionContext;
            this.skipper = skipper;
            this.resolver = resolver;
        }
    }

    static class ParallelDescriptorResolver {
        final ExecutorService executorService;
        final Map<String, Future<DescriptorResolutionResult>> results = new ConcurrentHashMap<String, Future<DescriptorResolutionResult>>(256);
        final Logger logger = LoggerFactory.getLogger(this.getClass());

        ParallelDescriptorResolver(RepositorySystemSession session) {
            this.executorService = this.getExecutorService(session);
        }

        void resolveDescriptors(Artifact artifact, Callable<DescriptorResolutionResult> callable) {
            Callable<DescriptorResolutionResult> callable2 = callable;
            ParallelDescriptorResolver parallelDescriptorResolver = this;
            this.results.computeIfAbsent(ArtifactIdUtils.toId(artifact), new BfDependencyCollector$ParallelDescriptorResolver$$Lambda$0(parallelDescriptorResolver, callable2));
        }

        void cacheVersionRangeDescriptor(Artifact artifact, DescriptorResolutionResult resolutionResult) {
            DescriptorResolutionResult descriptorResolutionResult = resolutionResult;
            this.results.computeIfAbsent(ArtifactIdUtils.toId(artifact), new BfDependencyCollector$ParallelDescriptorResolver$$Lambda$1(descriptorResolutionResult));
        }

        Future<DescriptorResolutionResult> find(Artifact artifact) {
            return this.results.get(ArtifactIdUtils.toId(artifact));
        }

        void shutdown() {
            this.executorService.shutdown();
        }

        private ExecutorService getExecutorService(RepositorySystemSession session) {
            int nThreads = ConfigUtils.getInteger(session, 5, "aether.dependencyCollector.bf.threads", "maven.artifact.threads");
            this.logger.debug("Created thread pool with {} threads to resolve descriptors.", (Object)nThreads);
            return new ThreadPoolExecutor(nThreads, nThreads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new WorkerThreadFactory(this.getClass().getSimpleName()));
        }

        private static /* synthetic */ Future lambda$cacheVersionRangeDescriptor$1(DescriptorResolutionResult resolutionResult, String key) {
            return ConcurrentUtils.constantFuture(resolutionResult);
        }

        private /* synthetic */ Future lambda$resolveDescriptors$0(Callable callable, String key) {
            return this.executorService.submit(callable);
        }

        static /* synthetic */ Future accessor$BfDependencyCollector$ParallelDescriptorResolver$lambda0(ParallelDescriptorResolver parallelDescriptorResolver, Callable callable, String string) {
            return parallelDescriptorResolver.lambda$resolveDescriptors$0(callable, string);
        }

        static /* synthetic */ Future accessor$BfDependencyCollector$ParallelDescriptorResolver$lambda1(DescriptorResolutionResult descriptorResolutionResult, String string) {
            return ParallelDescriptorResolver.lambda$cacheVersionRangeDescriptor$1(descriptorResolutionResult, string);
        }
    }

    static class DescriptorResolutionResult {
        Artifact artifact;
        VersionRangeResult rangeResult;
        Map<Version, ArtifactDescriptorResult> descriptors;

        DescriptorResolutionResult(Artifact artifact, VersionRangeResult rangeResult) {
            this.artifact = artifact;
            this.rangeResult = rangeResult;
            this.descriptors = new LinkedHashMap<Version, ArtifactDescriptorResult>(rangeResult.getVersions().size());
        }

        DescriptorResolutionResult(VersionRangeResult rangeResult, Version version, ArtifactDescriptorResult descriptor) {
            this(descriptor.getArtifact(), rangeResult);
            this.descriptors.put(version, descriptor);
        }

        List<DescriptorResolutionResult> flatten() {
            if (this.descriptors.size() > 1) {
                DescriptorResolutionResult descriptorResolutionResult = this;
                return this.descriptors.entrySet().stream().map(new BfDependencyCollector$DescriptorResolutionResult$$Lambda$0(descriptorResolutionResult)).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        private /* synthetic */ DescriptorResolutionResult lambda$flatten$0(Map.Entry e) {
            return new DescriptorResolutionResult(this.rangeResult, (Version)e.getKey(), (ArtifactDescriptorResult)e.getValue());
        }

        static /* synthetic */ DescriptorResolutionResult accessor$BfDependencyCollector$DescriptorResolutionResult$lambda0(DescriptorResolutionResult descriptorResolutionResult, Map.Entry entry) {
            return descriptorResolutionResult.lambda$flatten$0(entry);
        }
    }
}

