/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.k1;

import androidx.compose.compiler.plugins.kotlin.k1.AnnotationUtilsKt;
import androidx.compose.compiler.plugins.kotlin.k1.FrontendWritableSlices;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.synthetic.FunctionInterfaceConstructorDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002\u001a\u000e\u0010\u0007\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0000\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u000b\u001a\u00020\u0001*\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0018\u0010\u0017\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u001a"}, d2={"isReadOnlyComposableInvocation", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isComposableDelegateReference", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isComposableDelegateOperator", "isComposableInvocation", "isMarkedAsComposable", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isComposableCallable", "allowsComposableCalls", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getValueArgumentPosition", "Lorg/jetbrains/kotlin/resolve/calls/context/CallPosition$ValueArgumentPosition;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getValueArgumentPositionFromPsi", "context", "getArgumentDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "hasComposableExpectedType", "hasComposableAnnotation", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "compiler-hosted"})
public final class ComposableCallCheckerKt {
    public static final boolean isReadOnlyComposableInvocation(@NotNull ResolvedCall<?> $this$isReadOnlyComposableInvocation) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isReadOnlyComposableInvocation, (String)"<this>");
        if ($this$isReadOnlyComposableInvocation instanceof VariableAsFunctionResolvedCall) {
            return false;
        }
        CallableDescriptor callableDescriptor = $this$isReadOnlyComposableInvocation.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getCandidateDescriptor(...)");
        CallableDescriptor candidateDescriptor = callableDescriptor;
        if (candidateDescriptor instanceof ValueParameterDescriptor) {
            bl = false;
        } else if (candidateDescriptor instanceof LocalVariableDescriptor) {
            bl = false;
        } else if (candidateDescriptor instanceof PropertyDescriptor) {
            boolean isGetter = $this$isReadOnlyComposableInvocation.getValueArguments().isEmpty();
            PropertyGetterDescriptor getter = ((PropertyDescriptor)candidateDescriptor).getGetter();
            bl = isGetter && getter != null ? AnnotationUtilsKt.hasReadonlyComposableAnnotation((Annotated)getter) : false;
        } else {
            bl = candidateDescriptor instanceof PropertyGetterDescriptor ? AnnotationUtilsKt.hasReadonlyComposableAnnotation((Annotated)candidateDescriptor) : AnnotationUtilsKt.hasReadonlyComposableAnnotation((Annotated)candidateDescriptor);
        }
        return bl;
    }

    public static final boolean isComposableDelegateReference(@NotNull ResolvedCall<?> $this$isComposableDelegateReference, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter($this$isComposableDelegateReference, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        CallableDescriptor callableDescriptor = $this$isComposableDelegateReference.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getCandidateDescriptor(...)");
        CallableDescriptor descriptor = callableDescriptor;
        if (descriptor instanceof VariableDescriptorWithAccessors) {
            ResolvedCall delegateInitCall = (ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, (Object)((VariableDescriptorWithAccessors)descriptor).getGetter());
            ResolvedCall resolvedCall = delegateInitCall;
            return resolvedCall != null && (resolvedCall = (FunctionDescriptor)resolvedCall.getCandidateDescriptor()) != null ? ComposableCallCheckerKt.isMarkedAsComposable((CallableDescriptor)resolvedCall) : false;
        }
        return false;
    }

    public static final boolean isComposableDelegateOperator(@NotNull ResolvedCall<?> $this$isComposableDelegateOperator) {
        Intrinsics.checkNotNullParameter($this$isComposableDelegateOperator, (String)"<this>");
        CallableDescriptor callableDescriptor = $this$isComposableDelegateOperator.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getCandidateDescriptor(...)");
        CallableDescriptor descriptor = callableDescriptor;
        return descriptor instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor).isOperator() && OperatorNameConventions.DELEGATED_PROPERTY_OPERATORS.contains(((FunctionDescriptor)descriptor).getName());
    }

    public static final boolean isComposableInvocation(@NotNull ResolvedCall<?> $this$isComposableInvocation) {
        boolean bl;
        CallableDescriptor callableDescriptor;
        Intrinsics.checkNotNullParameter($this$isComposableInvocation, (String)"<this>");
        if ($this$isComposableInvocation instanceof VariableAsFunctionResolvedCall) {
            KotlinType kotlinType = ((VariableDescriptor)((VariableAsFunctionResolvedCall)$this$isComposableInvocation).getVariableCall().getCandidateDescriptor()).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (AnnotationUtilsKt.hasComposableAnnotation(kotlinType)) {
                return true;
            }
            CallableDescriptor callableDescriptor2 = ((VariableAsFunctionResolvedCall)$this$isComposableInvocation).getFunctionCall().getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor2, (String)"getResultingDescriptor(...)");
            return AnnotationUtilsKt.hasComposableAnnotation((Annotated)callableDescriptor2);
        }
        CallableDescriptor callableDescriptor3 = $this$isComposableInvocation.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor3, (String)"getCandidateDescriptor(...)");
        CallableDescriptor candidateDescriptor = callableDescriptor3;
        if (candidateDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)candidateDescriptor).isOperator() && Intrinsics.areEqual((Object)((FunctionDescriptor)candidateDescriptor).getName(), (Object)OperatorNameConventions.INVOKE)) {
            ReceiverValue receiverValue = $this$isComposableInvocation.getDispatchReceiver();
            boolean bl2 = receiverValue != null && (receiverValue = receiverValue.getType()) != null ? AnnotationUtilsKt.hasComposableAnnotation((KotlinType)receiverValue) : false;
            if (bl2) {
                return true;
            }
        }
        if ((callableDescriptor = candidateDescriptor) instanceof ValueParameterDescriptor) {
            bl = false;
        } else if (callableDescriptor instanceof LocalVariableDescriptor) {
            bl = false;
        } else if (callableDescriptor instanceof PropertyDescriptor) {
            boolean isGetter = $this$isComposableInvocation.getValueArguments().isEmpty();
            PropertyGetterDescriptor getter = ((PropertyDescriptor)candidateDescriptor).getGetter();
            bl = isGetter && getter != null ? AnnotationUtilsKt.hasComposableAnnotation((Annotated)getter) : false;
        } else {
            bl = callableDescriptor instanceof PropertyGetterDescriptor ? AnnotationUtilsKt.hasComposableAnnotation((Annotated)candidateDescriptor) : AnnotationUtilsKt.hasComposableAnnotation((Annotated)candidateDescriptor);
        }
        return bl;
    }

    public static final boolean isMarkedAsComposable(@NotNull CallableDescriptor $this$isMarkedAsComposable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedAsComposable, (String)"<this>");
        CallableDescriptor callableDescriptor = $this$isMarkedAsComposable;
        if (callableDescriptor instanceof PropertyGetterDescriptor) {
            bl = AnnotationUtilsKt.hasComposableAnnotation((Annotated)$this$isMarkedAsComposable);
        } else if (callableDescriptor instanceof ValueParameterDescriptor) {
            KotlinType kotlinType = ((ValueParameterDescriptor)$this$isMarkedAsComposable).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            bl = AnnotationUtilsKt.hasComposableAnnotation(kotlinType);
        } else if (callableDescriptor instanceof LocalVariableDescriptor) {
            KotlinType kotlinType = ((LocalVariableDescriptor)$this$isMarkedAsComposable).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            bl = AnnotationUtilsKt.hasComposableAnnotation(kotlinType);
        } else {
            bl = callableDescriptor instanceof PropertyDescriptor ? false : AnnotationUtilsKt.hasComposableAnnotation((Annotated)$this$isMarkedAsComposable);
        }
        return bl;
    }

    public static final boolean isComposableCallable(@NotNull CallableDescriptor $this$isComposableCallable, @NotNull BindingContext bindingContext) {
        KtLambdaExpression lambdaExpr;
        Intrinsics.checkNotNullParameter((Object)$this$isComposableCallable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        if (ComposableCallCheckerKt.isMarkedAsComposable($this$isComposableCallable)) {
            return true;
        }
        if ($this$isComposableCallable instanceof FunctionDescriptor && Intrinsics.areEqual((Object)bindingContext.get((ReadOnlySlice)FrontendWritableSlices.INSTANCE.getINFERRED_COMPOSABLE_DESCRIPTOR(), (Object)$this$isComposableCallable), (Object)true)) {
            return true;
        }
        PsiElement psiElement = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)$this$isComposableCallable));
        KtFunctionLiteral ktFunctionLiteral = psiElement instanceof KtFunctionLiteral ? (KtFunctionLiteral)psiElement : null;
        if (ktFunctionLiteral == null) {
            return false;
        }
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        List list = functionLiteral.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
        if (ComposableCallCheckerKt.hasComposableAnnotation(list, bindingContext)) {
            return true;
        }
        psiElement = functionLiteral.getParent();
        KtLambdaExpression ktLambdaExpression = lambdaExpr = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
        return lambdaExpr != null && Intrinsics.areEqual((Object)bindingContext.get((ReadOnlySlice)FrontendWritableSlices.INSTANCE.getINFERRED_COMPOSABLE_LITERAL(), (Object)lambdaExpr), (Object)true);
    }

    public static final boolean allowsComposableCalls(@NotNull FunctionDescriptor $this$allowsComposableCalls, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)$this$allowsComposableCalls, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        if (ComposableCallCheckerKt.isComposableCallable((CallableDescriptor)$this$allowsComposableCalls, bindingContext)) {
            return true;
        }
        return Intrinsics.areEqual((Object)bindingContext.get((ReadOnlySlice)FrontendWritableSlices.INSTANCE.getLAMBDA_CAPABLE_OF_COMPOSER_CAPTURE(), (Object)$this$allowsComposableCalls), (Object)true);
    }

    private static final CallPosition.ValueArgumentPosition getValueArgumentPosition(ResolutionContext<?> $this$getValueArgumentPosition, KtExpression expression) {
        CallPosition.ValueArgumentPosition valueArgumentPosition;
        CallPosition callPosition = $this$getValueArgumentPosition.callPosition;
        Intrinsics.checkNotNullExpressionValue((Object)callPosition, (String)"callPosition");
        CallPosition position = callPosition;
        if (position instanceof CallPosition.ValueArgumentPosition) {
            valueArgumentPosition = (CallPosition.ValueArgumentPosition)position;
        } else if (position instanceof CallPosition.Unknown) {
            BindingContext bindingContext = $this$getValueArgumentPosition.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            valueArgumentPosition = ComposableCallCheckerKt.getValueArgumentPositionFromPsi(expression, bindingContext);
        } else {
            valueArgumentPosition = null;
        }
        return valueArgumentPosition;
    }

    private static final CallPosition.ValueArgumentPosition getValueArgumentPositionFromPsi(KtExpression expression, BindingContext context) {
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)KtPsiUtil.getParentCallIfPresent((KtExpression)expression)), (BindingContext)context);
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        Call call = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"getCall(...)");
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression((Call)call, (KtExpression)expression);
        if (valueArgument == null) {
            return null;
        }
        ValueArgument valueArgument2 = valueArgument;
        ArgumentMapping argumentMapping = resolvedCall2.getArgumentMapping(valueArgument2);
        ArgumentMatch argumentMatch = argumentMapping instanceof ArgumentMatch ? (ArgumentMatch)argumentMapping : null;
        if (argumentMatch == null) {
            return null;
        }
        ArgumentMatch argumentMatch2 = argumentMatch;
        return new CallPosition.ValueArgumentPosition(resolvedCall2, argumentMatch2.getValueParameter(), valueArgument2);
    }

    private static final ValueParameterDescriptor getArgumentDescriptor(KtExpression expression, BindingContext context) {
        CallPosition.ValueArgumentPosition valueArgumentPosition = ComposableCallCheckerKt.getValueArgumentPositionFromPsi(expression, context);
        return valueArgumentPosition != null ? valueArgumentPosition.getValueParameter() : null;
    }

    public static final boolean hasComposableExpectedType(@NotNull ResolutionContext<?> $this$hasComposableExpectedType, @NotNull KtExpression expression) {
        ClassDescriptor classDescriptor;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter($this$hasComposableExpectedType, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                KotlinType kotlinType = $this$hasComposableExpectedType.expectedType;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
                if (AnnotationUtilsKt.hasComposableAnnotation(kotlinType)) {
                    return true;
                }
                KotlinType kotlinType2 = $this$hasComposableExpectedType.expectedType;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"expectedType");
                if (AnnotationUtilsKt.isSpecialType(kotlinType2)) break block8;
                KotlinType kotlinType3 = $this$hasComposableExpectedType.expectedType;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"expectedType");
                if (FunctionTypesKt.isBuiltinFunctionalType((KotlinType)kotlinType3)) break block9;
            }
            return false;
        }
        CallPosition.ValueArgumentPosition valueArgumentPosition = ComposableCallCheckerKt.getValueArgumentPosition($this$hasComposableExpectedType, expression);
        if (valueArgumentPosition == null) {
            return false;
        }
        CallPosition.ValueArgumentPosition position = valueArgumentPosition;
        CallableDescriptor callableDescriptor = position.getResolvedCall().getResultingDescriptor().getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getOriginal(...)");
        CallableDescriptor callDescriptor = callableDescriptor;
        if (callDescriptor instanceof FunctionInterfaceConstructorDescriptor) {
            classDescriptor = (ClassDescriptor)((FunctionInterfaceConstructorDescriptor)callDescriptor).getBaseDescriptorForSynthetic();
        } else {
            ClassifierDescriptor classifierDescriptor = position.getValueParameter().getType().getConstructor().getDeclarationDescriptor();
            classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor == null) {
                return false;
            }
        }
        ClassDescriptor samDescriptor = classDescriptor;
        FunctionDescriptor functionDescriptor = SamConversionResolverImplKt.getSingleAbstractMethodOrNull((ClassDescriptor)samDescriptor);
        return functionDescriptor != null ? AnnotationUtilsKt.hasComposableAnnotation((Annotated)functionDescriptor) : false;
    }

    public static final boolean hasComposableAnnotation(@NotNull List<? extends KtAnnotationEntry> $this$hasComposableAnnotation, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter($this$hasComposableAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        for (KtAnnotationEntry ktAnnotationEntry : $this$hasComposableAnnotation) {
            AnnotationDescriptor descriptor;
            if ((AnnotationDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)ktAnnotationEntry) == null || !AnnotationUtilsKt.isComposableAnnotation(descriptor)) continue;
            return true;
        }
        return false;
    }

    public static final /* synthetic */ ValueParameterDescriptor access$getArgumentDescriptor(KtExpression expression, BindingContext context) {
        return ComposableCallCheckerKt.getArgumentDescriptor(expression, context);
    }
}

