<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'AbuseLog' => [ 'AbuseLog' ],
	'AbuseFilter' => [ 'AbuseFilter' ],
	'BlockedExternalDomains' => [ 'BlockedExternalDomains' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'AbuseLog' => [ 'سجل_الإساءة' ],
	'AbuseFilter' => [ 'مرشح_الإساءة', 'فلتر_الإساءة' ],
];

/** Aramaic (ܐܪܡܝܐ) */
$specialPageAliases['arc'] = [
	'AbuseLog' => [ 'ܡܟܬܒܘܬܐ_ܕܚܘܒܠܐ' ],
	'AbuseFilter' => [ 'ܡܨܦܝܢܝܬܐ_ܕܚܘܒܠܐ' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'AbuseLog' => [ 'سجل_الاساءه' ],
	'AbuseFilter' => [ 'فيلتر_الاساءه' ],
];

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = [
	'AbuseLog' => [ 'অপব্যৱহাৰৰ_অভিলেখ' ],
	'AbuseFilter' => [ 'অপব্যৱহাৰৰ_চেকনী' ],
];

/** Avaric (авар) */
$specialPageAliases['av'] = [
	'AbuseLog' => [ 'Ихтияразда_мугъ_чІван_бегьуоарел_пишаби_гьабиялъул_журнал' ],
	'AbuseFilter' => [ 'Ихтияразда_мугъ_чІван_бегьуоарел_пишаби_гьабиял_рацІцІин' ],
];

/** Bashkir (башҡортса) */
$specialPageAliases['ba'] = [
	'AbuseLog' => [ 'Насарға_ҡулланыуҙар_журналы' ],
	'AbuseFilter' => [ 'Насарға_ҡулланыуҙар_фильтры' ],
];

/** Bulgarian (български) */
$specialPageAliases['bg'] = [
	'AbuseLog' => [ 'Дневник_на_филтъра' ],
	'AbuseFilter' => [ 'Филтър_срещу_злоупотреби' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'AbuseLog' => [ 'خرابکاری_ئی_سیاهه' ],
	'AbuseFilter' => [ 'خرابکاری_ئی_پیلتر' ],
];

/** Bhojpuri (भोजपुरी) */
$specialPageAliases['bho'] = [
	'AbuseLog' => [ 'दुरुपयोगी_छनित_पृष्ठ' ],
	'AbuseFilter' => [ 'दुरुपयोगी_छनित_फिल्टर' ],
];

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = [
	'AbuseLog' => [ 'Catatan_panyalahgunaan' ],
	'AbuseFilter' => [ 'Filter_panyalahgunaan' ],
];

/** Bengali (বাংলা) */
$specialPageAliases['bn'] = [
	'AbuseLog' => [ 'অপব্যবহার_লগ' ],
	'AbuseFilter' => [ 'অপব্যবহার_ছাঁকনি' ],
	'BlockedExternalDomains' => [ 'অবরুদ্ধ_বহিঃস্থ_ডোমেইন', 'বহিঃস্থ_ডোমেইন_অবরুদ্ধকরণ', 'অবরুদ্ধ_ডোমেইনের_তালিকা' ],
];

/** Breton (brezhoneg) */
$specialPageAliases['br'] = [
	'AbuseLog' => [ 'Marilh_ar_sil_a-enep_ar_gwallimplij' ],
	'AbuseFilter' => [ 'Sil_a-enep_ar_gwallimplij' ],
];

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = [
	'AbuseLog' => [ 'ZapisZloupotrebe' ],
	'AbuseFilter' => [ 'FilterZloupotrebe' ],
];

/** Catalan (català) */
$specialPageAliases['ca'] = [
	'AbuseLog' => [ 'Registre_dels_abusos' ],
];

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$specialPageAliases['cdo'] = [
	'AbuseLog' => [ '亂使其日誌' ],
	'AbuseFilter' => [ '亂使其過濾' ],
];

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = [
	'AbuseLog' => [ 'Зулам_литтаран_тептар' ],
	'AbuseFilter' => [ 'Зулам_литтар' ],
];

/** Czech (čeština) */
$specialPageAliases['cs'] = [
	'AbuseLog' => [ 'Záznam_filtrů_zneužití' ],
	'AbuseFilter' => [ 'Filtry_zneužití' ],
	'BlockedExternalDomains' => [ 'Seznam_blokovaných_domén' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'AbuseLog' => [ 'Missbrauchsfilter-Logbuch' ],
	'AbuseFilter' => [ 'Missbrauchsfilter' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'AbuseLog' => [ 'QeydêKedweriye' ],
	'AbuseFilter' => [ 'ParzûnêKedweriye' ],
];

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = [
	'AbuseLog' => [ 'Protokol_znjewužywanjow' ],
	'AbuseFilter' => [ 'Filter_znjewužywanjow' ],
];

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = [
	'AbuseLog' => [ 'ΑρχείοΠαρενόχλησης' ],
	'AbuseFilter' => [ 'ΦίλτροΠαρενόχλησης', 'ΦίλτροΚαταχρήσεων' ],
];

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = [
	'AbuseLog' => [ 'Protokolo_pri_misuzado' ],
	'AbuseFilter' => [ 'Filtrilo_kontraŭ_misuzado' ],
];

/** Spanish (español) */
$specialPageAliases['es'] = [
	'AbuseLog' => [ 'RegistroAbusos' ],
	'AbuseFilter' => [ 'FiltroAntiAbusos' ],
];

/** Estonian (eesti) */
$specialPageAliases['et'] = [
	'AbuseLog' => [ 'Väärtarvituslogi' ],
	'AbuseFilter' => [ 'Väärtarvitusfilter' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'AbuseLog' => [ 'سیاههٔ_خرابکاری', 'سیاهه_خرابکاری' ],
	'AbuseFilter' => [ 'پالایهٔ_خرابکاری', 'پالایه_خرابکاری' ],
];

/** Finnish (suomi) */
$specialPageAliases['fi'] = [
	'AbuseLog' => [ 'Väärinkäyttöloki' ],
	'AbuseFilter' => [ 'Väärinkäyttösuodatin' ],
];

/** French (français) */
$specialPageAliases['fr'] = [
	'AbuseLog' => [ 'Journal_du_filtre_antiabus', 'Journal_du_filtre_anti-abus', 'JournalFiltreAntiabus', 'Journal_des_abus', 'JournalDesAbus' ],
	'AbuseFilter' => [ 'Filtre_antiabus', 'Filtre_anti-abus', 'FiltreAntiabus', 'Filtre_d\'abus', 'FiltredAbus', 'FilterAbus' ],
];

/** Arpitan (arpetan) */
$specialPageAliases['frp'] = [
	'AbuseLog' => [ 'Jornal_des_abus', 'JornalDesAbus' ],
	'AbuseFilter' => [ 'Filtro_d\'abus', 'FiltroDAbus' ],
];

/** Galician (galego) */
$specialPageAliases['gl'] = [
	'AbuseLog' => [ 'Rexistro_de_abusos' ],
	'AbuseFilter' => [ 'Filtro_de_abusos' ],
];

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = [
	'AbuseLog' => [ 'Missbruchsfilter-Logbuech' ],
	'AbuseFilter' => [ 'Missbruchsfilter' ],
];

/** Gujarati (ગુજરાતી) */
$specialPageAliases['gu'] = [
	'AbuseLog' => [ 'દુરુપયોગ_લોગ' ],
	'AbuseFilter' => [ 'દુરુપયોગ_ગળણી' ],
];

/** Hebrew (עברית) */
$specialPageAliases['he'] = [
	'AbuseLog' => [ 'יומן_ההשחתות' ],
	'AbuseFilter' => [ 'מסנן_ההשחתות' ],
];

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = [
	'AbuseLog' => [ 'दुरुपयोग_लॉग', 'दुरुपयोग_लौग' ],
	'AbuseFilter' => [ 'दुरुपयोग_फ़िल्टर', 'दुरुपयोग_फिल्टर' ],
];

/** Croatian (hrvatski) */
$specialPageAliases['hr'] = [
	'AbuseLog' => [ 'Evidencija_zloporaba' ],
	'AbuseFilter' => [ 'Filtar_zloporaba' ],
];

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = [
	'AbuseLog' => [ 'Protokol_znjewužiwanjow' ],
	'AbuseFilter' => [ 'Filter_znjewužiwanjow' ],
];

/** Xiang Chinese (湘语) */
$specialPageAliases['hsn'] = [
	'AbuseLog' => [ '滥用日志' ],
	'AbuseFilter' => [ '滥用过滤器' ],
];

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = [
	'AbuseLog' => [ 'JounalAbi' ],
	'AbuseFilter' => [ 'FiltAbi' ],
];

/** Hungarian (magyar) */
$specialPageAliases['hu'] = [
	'AbuseLog' => [ 'Vandálszűrő-napló' ],
	'AbuseFilter' => [ 'Vandálszűrő' ],
];

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = [
	'AbuseLog' => [ 'Registro_de_abusos' ],
	'AbuseFilter' => [ 'Filtro_anti-abuso', 'Filtro_antiabuso' ],
];

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = [
	'AbuseLog' => [ 'Catatan_penyalahgunaan', 'CatatanPenyalahgunaan' ],
	'AbuseFilter' => [ 'Filter_penyalahgunaan', 'FilterPenyalahgunaan' ],
];

/** Icelandic (íslenska) */
$specialPageAliases['is'] = [
	'AbuseLog' => [ 'Misnotkunarskrá' ],
	'AbuseFilter' => [ 'Misnotkunarsía' ],
];

/** Italian (italiano) */
$specialPageAliases['it'] = [
	'AbuseLog' => [ 'RegistroAbusi' ],
	'AbuseFilter' => [ 'FiltroAntiAbusi' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'AbuseLog' => [ '不正利用記録' ],
	'AbuseFilter' => [ '不正利用フィルター' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'AbuseLog' => [ '편집필터기록', '부정행위기록' ],
	'AbuseFilter' => [ '편집필터', '부정행위필터' ],
];

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = [
	'AbuseLog' => [ 'Logbooch_vum_Meßbruchsfellter' ],
	'AbuseFilter' => [ 'Meßbruchsfellter' ],
];

/** Cornish (kernowek) */
$specialPageAliases['kw'] = [
	'AbuseLog' => [ 'KovnotenAbusyans' ],
	'AbuseFilter' => [ 'SidhlaAbusyans' ],
];

/** Ladino (Ladino) */
$specialPageAliases['lad'] = [
	'AbuseLog' => [ 'Rējistros_de_abuso' ],
	'AbuseFilter' => [ 'FiltroAbuso' ],
];

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = [
	'AbuseLog' => [ 'Lëscht_vum_Mëssbrauch' ],
	'AbuseFilter' => [ 'Mëssbrauchsfilter' ],
];

/** Northern Luri (لۊری شومالی) */
$specialPageAliases['lrc'] = [
	'AbuseLog' => [ 'پئھرستنوٙمە_خئراڤکاری' ],
	'AbuseFilter' => [ 'فیلتئر_خئراڤکاری' ],
];

/** Lithuanian (lietuvių) */
$specialPageAliases['lt'] = [
	'AbuseLog' => [ 'Piktnaudžiavimų_sąrašas' ],
	'AbuseFilter' => [ 'Piktnaudžiavimų_filtras' ],
];

/** Malagasy (Malagasy) */
$specialPageAliases['mg'] = [
	'AbuseLog' => [ 'Tati-panararaotana' ],
	'AbuseFilter' => [ 'Fanakanam-panararaotana' ],
];

/** Minangkabau (Baso Minangkabau) */
$specialPageAliases['min'] = [
	'AbuseLog' => [ 'CatatanPanyalahgunoan' ],
	'AbuseFilter' => [ 'SariangPanyalahgunoan' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'AbuseLog' => [ 'ДневникНаЗлоупотреба' ],
	'AbuseFilter' => [ 'ФилтерНаЗлоупотреба' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'AbuseLog' => [ 'ദുരുപയോഗരേഖ' ],
	'AbuseFilter' => [ 'ദുരുപയോഗയരിപ്പ', 'ദുരുപയോഗ‌‌അരിപ്പ' ],
];

/** Marathi (मराठी) */
$specialPageAliases['mr'] = [
	'AbuseLog' => [ 'संपादनगाळणी_नोंदी' ],
	'AbuseFilter' => [ 'संपादन_गाळणी' ],
];

/** Malay (Bahasa Melayu) */
$specialPageAliases['ms'] = [
	'AbuseLog' => [ 'Log_penyalahgunaan' ],
	'AbuseFilter' => [ 'Penapis_penyalahgunaan' ],
];

/** Maltese (Malti) */
$specialPageAliases['mt'] = [
	'AbuseLog' => [ 'ReġistruAbbuż' ],
	'AbuseFilter' => [ 'FiltruAbbuż' ],
];

/** Erzya (эрзянь) */
$specialPageAliases['myv'] = [
	'AbuseLog' => [ 'АТевсНолдамодо' ],
	'AbuseFilter' => [ 'АТевсНолдамоньФильтра' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = [
	'AbuseLog' => [ 'Misbrukslogg' ],
	'AbuseFilter' => [ 'Misbruksfilter' ],
];

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = [
	'AbuseLog' => [ 'Misbruuklogboek' ],
	'AbuseFilter' => [ 'Misbruukfilter' ],
];

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = [
	'AbuseLog' => [ 'Filterlogboek', 'Misbruiklogboek' ],
	'AbuseFilter' => [ 'Filter', 'Misbruikfilter' ],
];

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = [
	'AbuseLog' => [ 'Endringsfilterlogg', 'Misbrukslogg' ],
	'AbuseFilter' => [ 'Endringsfilter', 'Misbruksfilter' ],
];

/** Occitan (occitan) */
$specialPageAliases['oc'] = [
	'AbuseLog' => [ 'Jornal_dels_abuses', 'JornalDelsAbuses' ],
	'AbuseFilter' => [ 'Filtre_d\'abuses', 'FiltredAbuses', 'FilterAbus' ],
];

/** Punjabi (ਪੰਜਾਬੀ) */
$specialPageAliases['pa'] = [
	'AbuseLog' => [ 'ਕੁਵਰਤੋਂ_ਦਾ_ਚਿੱਠਾ' ],
	'AbuseFilter' => [ 'ਕੁਵਰਤੋਂ_ਛਣਨੀ' ],
];

/** Polish (polski) */
$specialPageAliases['pl'] = [
	'AbuseLog' => [ 'Rejestr_nadużyć' ],
	'AbuseFilter' => [ 'Filtr_nadużyć' ],
	'BlockedExternalDomains' => [ 'Zablokowane_zewnętrzne_domeny', 'Zablokowane_domeny' ],
];

/** Brazilian Portuguese (português do Brasil) */
$specialPageAliases['pt-br'] = [
	'AbuseLog' => [ 'Registro_de_abusos' ],
	'AbuseFilter' => [ 'Filtro_de_abusos' ],
];

/** Romanian (română) */
$specialPageAliases['ro'] = [
	'AbuseLog' => [ 'Jurnal_abuzuri' ],
	'AbuseFilter' => [ 'Filtru_abuzuri' ],
];

/** Russian (русский) */
$specialPageAliases['ru'] = [
	'AbuseLog' => [ 'Журнал_злоупотреблений' ],
	'AbuseFilter' => [ 'Фильтр_злоупотреблений' ],
];

/** Sanskrit (संस्कृतम्) */
$specialPageAliases['sa'] = [
	'AbuseLog' => [ 'दुरुपयोगअङ्कन' ],
	'AbuseFilter' => [ 'दुरुपयोगशोधबन्धन' ],
];

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = [
	'AbuseLog' => [ 'RegistroAbusi' ],
	'AbuseFilter' => [ 'FiltroAntiAbusi' ],
];

/** Serbo-Croatian (srpskohrvatski / српскохрватски) */
$specialPageAliases['sh'] = [
	'AbuseLog' => [ 'Evidencija_zloupotreba' ],
	'AbuseFilter' => [ 'Filter_zloupotreba' ],
];

/** Sinhala (සිංහල) */
$specialPageAliases['si'] = [
	'AbuseLog' => [ 'අපයෙදුම්_ලඝු-සටහන' ],
	'AbuseFilter' => [ 'අපයෙදුම්_පෙරහන' ],
];

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = [
	'AbuseLog' => [ 'ZáznamZneužití' ],
	'AbuseFilter' => [ 'FilterZneužití' ],
];

/** Serbian Cyrillic (српски (ћирилица)) */
$specialPageAliases['sr-ec'] = [
	'AbuseLog' => [ 'Дневник_злоупотребе' ],
	'AbuseFilter' => [ 'Филтер_злоупотребе' ],
];

/** Serbian Latin (srpski (latinica)) */
$specialPageAliases['sr-el'] = [
	'AbuseLog' => [ 'Dnevnik_zloupotrebe' ],
	'AbuseFilter' => [ 'Filter_zloupotrebe' ],
];

/** Swedish (svenska) */
$specialPageAliases['sv'] = [
	'AbuseLog' => [ 'Missbrukslogg' ],
	'AbuseFilter' => [ 'Missbruksfilter' ],
];

/** Thai (ไทย) */
$specialPageAliases['th'] = [
	'AbuseLog' => [ 'ปูมการละเมิด' ],
	'AbuseFilter' => [ 'ตัวกรองการละเมิด' ],
];

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = [
	'AbuseLog' => [ 'Talaan_ng_pang-aabuso' ],
	'AbuseFilter' => [ 'Talaan_ng_pansala' ],
];

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = [
	'AbuseLog' => [ 'İstismarGünlüğü', 'DeğişiklikGünlüğü' ],
	'AbuseFilter' => [ 'İstismarSüzgeci', 'DeğişiklikSüzgeci' ],
];

/** Ukrainian (українська) */
$specialPageAliases['uk'] = [
	'AbuseLog' => [ 'Журнал_зловживань', 'Журнал_злоупотреблений' ],
	'AbuseFilter' => [ 'Фільтр_редагувань', 'Фільтр_зловживань', 'Фильтр_злоупотреблений' ],
];

/** Urdu (اردو) */
$specialPageAliases['ur'] = [
	'AbuseLog' => [ 'نوشتہ_غلط_کاری' ],
	'AbuseFilter' => [ 'مقطر_غلط_کاری', 'مقطار_غلط_کاری' ],
];

/** Venetian (vèneto) */
$specialPageAliases['vec'] = [
	'AbuseLog' => [ 'RegistroAbusi' ],
	'AbuseFilter' => [ 'FiltroAbusi' ],
];

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = [
	'AbuseLog' => [ 'Nhật_trình_sai_phạm' ],
	'AbuseFilter' => [ 'Bộ_lọc_sai_phạm' ],
];

/** Yiddish (ייִדיש) */
$specialPageAliases['yi'] = [
	'AbuseLog' => [ 'שעדיקונג_לאגבוך' ],
	'AbuseFilter' => [ 'שעדיקונג_פילטער' ],
];

/** Cantonese (粵語) */
$specialPageAliases['yue'] = [
	'AbuseLog' => [ '濫用日誌' ],
	'AbuseFilter' => [ '濫用過濾器' ],
];

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = [
	'AbuseLog' => [ '滥用日志', '过滤日志' ],
	'AbuseFilter' => [ '滥用过滤器', '防滥用过滤器' ],
];

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = [
	'AbuseLog' => [ '濫用日誌' ],
	'AbuseFilter' => [ '濫用過濾器' ],
];
