<?php
namespace MediaWiki\Extension\Math\WikiTexVC\MMLmappings;

use MediaWiki\Extension\Math\WikiTexVC\MMLmappings\Util\MMLutil;

/**
 * Based on OperatorDictionary.js in MML3
 * Only importing infix atm
 * Singleton
 *
 * Some of the entries are commented since they parse to mi elements, values are not used atm.
 */
class OperatorDictionary {

	private static $instance = null;

	private const INFIX = [ // Implemented elements have [something, true] for custom parsing
		'!=' => [ " exports.MO.BIN4" ],
		'#' => [ " exports.MO.ORD" ],
		'$' => [ " exports.MO.ORD" ],
		'%' => [ " [3, 3, MmlNode_js_1.TEXCLASS.ORD], null]" ],
		'&&' => [ " exports.MO.BIN4" ],
		'' => [ " exports.MO.ORD" ],
		'*' => [ " exports.MO.BIN3" ],
		'**' => [ " OPDEF(1\"], 1)" ],
		'*=' => [ " exports.MO.BIN4" ],
		'+' => [ " exports.MO.BIN4" ],
		'+=' => [ " exports.MO.BIN4" ],
		',' => [ " [0, 3], MmlNode_js_1.TEXCLASS.PUNCT\"]," .
			"{ linebreakstyle=> [\" 'after'\"], separator=> [\" true }]", true ],
		'-' => [ " exports.MO.BIN4" ],
		'-=' => [ " exports.MO.BIN4" ],
		'->' => [ " exports.MO.BIN5" ],
		'.' => [ " [0, 3], MmlNode_js_1.TEXCLASS.PUNCT\"], { separator=> [ true }]" ],
		'/' => [ " exports.MO.ORD11" ],
		'//' => [ " OPDEF(1\"], 1)" ],
		'/=' => [ " exports.MO.BIN4" ],
		'=>' => [ " [1, 2], MmlNode_js_1.TEXCLASS.REL\"], null]" ],
		'=>=' => [ " exports.MO.BIN4" ],
		';' => [ " [0, 3], MmlNode_js_1.TEXCLASS.PUNCT]," .
			"{ linebreakstyle=> ['after'], separator=> [ true }]", true ],
		'<' => [ " exports.MO.REL", true ],
		'<=' => [ " exports.MO.BIN5" ],
		'<>' => [ " OPDEF(1, 1)" ],
		'=' => [ " exports.MO.REL" ],
		'==' => [ " exports.MO.BIN4" ],
		'>' => [ " exports.MO.REL", true ],
		'>=' => [ " exports.MO.BIN5" ],
		'?' => [ " [1, 1], MmlNode_js_1.TEXCLASS.CLOSE], null]" ],
		'@' => [ " exports.MO.ORD11" ],
		'\\' => [ " exports.MO.ORD", true ],
		'^' => [ " exports.MO.ORD11" ],
		'_' => [ " exports.MO.ORD11" ],
		'|' => [ " [2, 2], MmlNode_js_1.TEXCLASS.ORD]," .
			"{ fence=> [\"true\"], stretchy=> [\"true\"], symmetric=> [\" true }]" ],
		'||' => [ " [2, 2], MmlNode_js_1.TEXCLASS.ORD]," .
			"{ fence=> [\"true\"], stretchy=> [\"true\"], symmetric=> [\" true }]" ],
		'|||' => [ " [2, 2], MmlNode_js_1.TEXCLASS.ORD]," .
			"{ fence=> [\"true\"], stretchy=> [\"true\"], symmetric=> [\" true }]" ],
		'\u00B1' => [ " exports.MO.BIN4" ],
		'\u00B7' => [ " exports.MO.BIN4" ],
		'\u00D7' => [ " exports.MO.BIN4" ],
		'\u00F7' => [ " exports.MO.BIN4" ],
		'\u02B9' => [ " exports.MO.ORD" ],
		'\u0300' => [ " exports.MO.ACCENT" ],
		'\u0301' => [ " exports.MO.ACCENT" ],
		'\u0303' => [ " exports.MO.WIDEACCENT" ],
		'\u0304' => [ " exports.MO.ACCENT" ],
		'\u0306' => [ " exports.MO.ACCENT" ],
		'\u0307' => [ " exports.MO.ACCENT" ],
		'\u0308' => [ " exports.MO.ACCENT" ],
		'\u030C' => [ " exports.MO.ACCENT" ],
		'\u0332' => [ " exports.MO.WIDEACCENT" ],
		'\u0338' => [ " exports.MO.REL4" ],
		'\u2015' => [ " [0, 0], MmlNode_js_1.TEXCLASS.ORD\"], { stretchy=> [\" true }]" ],
		'\u2017' => [ " [0, 0], MmlNode_js_1.TEXCLASS.ORD\"], { stretchy=> [\" true }]" ],
		'\u2020' => [ " exports.MO.BIN3" ],
		'\u2021' => [ " exports.MO.BIN3" ],
		'\u2022' => [ " exports.MO.BIN4" ],
		'\u2026' => [ " exports.MO.INNER" ],
		'\u2043' => [ " exports.MO.BIN4" ],
		'\u2044' => [ " exports.MO.TALLBIN" ],
		'\u2061' => [ " exports.MO.NONE" ],
		'\u2062' => [ " exports.MO.NONE" ],
		'\u2063' => [ " [0, 0], MmlNode_js_1.TEXCLASS.NONE]," .
			"{ linebreakstyle=> [\" 'after'\"], separator=> [\" true }]" ],
		'\u2064' => [ " exports.MO.NONE" ],
		'\u20D7' => [ " exports.MO.ACCENT" ],
		// '\u2111'=> [" exports.MO.ORD"],
		//'\u2113'=> [" exports.MO.ORD"],
		'\u2118' => [ " exports.MO.ORD" ],
		// '\u211C'=> [" exports.MO.ORD"],
		'\u2190' => [ " exports.MO.WIDEREL" ],
		'\u2191' => [ " exports.MO.RELSTRETCH" ],
		'\u2192' => [ " exports.MO.WIDEREL" ],
		'\u2193' => [ " exports.MO.RELSTRETCH" ],
		'\u2194' => [ " exports.MO.WIDEREL" ],
		'\u2195' => [ " exports.MO.RELSTRETCH" ],
		'\u2196' => [ " exports.MO.RELSTRETCH" ],
		'\u2197' => [ " exports.MO.RELSTRETCH" ],
		'\u2198' => [ " exports.MO.RELSTRETCH" ],
		'\u2199' => [ " exports.MO.RELSTRETCH" ],
		'\u219A' => [ " exports.MO.RELACCENT" ],
		'\u219B' => [ " exports.MO.RELACCENT" ],
		'\u219C' => [ " exports.MO.WIDEREL" ],
		'\u219D' => [ " exports.MO.WIDEREL" ],
		'\u219E' => [ " exports.MO.WIDEREL" ],
		'\u219F' => [ " exports.MO.WIDEREL" ],
		'\u21A0' => [ " exports.MO.WIDEREL" ],
		'\u21A1' => [ " exports.MO.RELSTRETCH" ],
		'\u21A2' => [ " exports.MO.WIDEREL" ],
		'\u21A3' => [ " exports.MO.WIDEREL" ],
		'\u21A4' => [ " exports.MO.WIDEREL" ],
		'\u21A5' => [ " exports.MO.RELSTRETCH" ],
		'\u21A6' => [ " exports.MO.WIDEREL" ],
		'\u21A7' => [ " exports.MO.RELSTRETCH" ],
		'\u21A8' => [ " exports.MO.RELSTRETCH" ],
		'\u21A9' => [ " exports.MO.WIDEREL" ],
		'\u21AA' => [ " exports.MO.WIDEREL" ],
		'\u21AB' => [ " exports.MO.WIDEREL" ],
		'\u21AC' => [ " exports.MO.WIDEREL" ],
		'\u21AD' => [ " exports.MO.WIDEREL" ],
		'\u21AE' => [ " exports.MO.RELACCENT" ],
		'\u21AF' => [ " exports.MO.RELSTRETCH" ],
		'\u21B0' => [ " exports.MO.RELSTRETCH" ],
		'\u21B1' => [ " exports.MO.RELSTRETCH" ],
		'\u21B2' => [ " exports.MO.RELSTRETCH" ],
		'\u21B3' => [ " exports.MO.RELSTRETCH" ],
		'\u21B4' => [ " exports.MO.RELSTRETCH" ],
		'\u21B5' => [ " exports.MO.RELSTRETCH" ],
		'\u21B6' => [ " exports.MO.RELACCENT" ],
		'\u21B7' => [ " exports.MO.RELACCENT" ],
		'\u21B8' => [ " exports.MO.REL" ],
		'\u21B9' => [ " exports.MO.WIDEREL" ],
		'\u21BA' => [ " exports.MO.REL" ],
		'\u21BB' => [ " exports.MO.REL" ],
		'\u21BC' => [ " exports.MO.WIDEREL" ],
		'\u21BD' => [ " exports.MO.WIDEREL" ],
		'\u21BE' => [ " exports.MO.RELSTRETCH" ],
		'\u21BF' => [ " exports.MO.RELSTRETCH" ],
		'\u21C0' => [ " exports.MO.WIDEREL" ],
		'\u21C1' => [ " exports.MO.WIDEREL" ],
		'\u21C2' => [ " exports.MO.RELSTRETCH" ],
		'\u21C3' => [ " exports.MO.RELSTRETCH" ],
		'\u21C4' => [ " exports.MO.WIDEREL" ],
		'\u21C5' => [ " exports.MO.RELSTRETCH" ],
		'\u21C6' => [ " exports.MO.WIDEREL" ],
		'\u21C7' => [ " exports.MO.WIDEREL" ],
		'\u21C8' => [ " exports.MO.RELSTRETCH" ],
		'\u21C9' => [ " exports.MO.WIDEREL" ],
		'\u21CA' => [ " exports.MO.RELSTRETCH" ],
		'\u21CB' => [ " exports.MO.WIDEREL" ],
		'\u21CC' => [ " exports.MO.WIDEREL" ],
		'\u21CD' => [ " exports.MO.RELACCENT" ],
		'\u21CE' => [ " exports.MO.RELACCENT" ],
		'\u21CF' => [ " exports.MO.RELACCENT" ],
		'\u21D0' => [ " exports.MO.WIDEREL" ],
		'\u21D1' => [ " exports.MO.RELSTRETCH" ],
		'\u21D2' => [ " exports.MO.WIDEREL" ],
		'\u21D3' => [ " exports.MO.RELSTRETCH" ],
		'\u21D4' => [ " exports.MO.WIDEREL" ],
		'\u21D5' => [ " exports.MO.RELSTRETCH" ],
		'\u21D6' => [ " exports.MO.RELSTRETCH" ],
		'\u21D7' => [ " exports.MO.RELSTRETCH" ],
		'\u21D8' => [ " exports.MO.RELSTRETCH" ],
		'\u21D9' => [ " exports.MO.RELSTRETCH" ],
		'\u21DA' => [ " exports.MO.WIDEREL" ],
		'\u21DB' => [ " exports.MO.WIDEREL" ],
		'\u21DC' => [ " exports.MO.WIDEREL" ],
		'\u21DD' => [ " exports.MO.WIDEREL" ],
		'\u21DE' => [ " exports.MO.REL" ],
		'\u21DF' => [ " exports.MO.REL" ],
		'\u21E0' => [ " exports.MO.WIDEREL" ],
		'\u21E1' => [ " exports.MO.RELSTRETCH" ],
		'\u21E2' => [ " exports.MO.WIDEREL" ],
		'\u21E3' => [ " exports.MO.RELSTRETCH" ],
		'\u21E4' => [ " exports.MO.WIDEREL" ],
		'\u21E5' => [ " exports.MO.WIDEREL" ],
		'\u21E6' => [ " exports.MO.WIDEREL" ],
		'\u21E7' => [ " exports.MO.RELSTRETCH" ],
		'\u21E8' => [ " exports.MO.WIDEREL" ],
		'\u21E9' => [ " exports.MO.RELSTRETCH" ],
		'\u21EA' => [ " exports.MO.RELSTRETCH" ],
		'\u21EB' => [ " exports.MO.RELSTRETCH" ],
		'\u21EC' => [ " exports.MO.RELSTRETCH" ],
		'\u21ED' => [ " exports.MO.RELSTRETCH" ],
		'\u21EE' => [ " exports.MO.RELSTRETCH" ],
		'\u21EF' => [ " exports.MO.RELSTRETCH" ],
		'\u21F0' => [ " exports.MO.WIDEREL" ],
		'\u21F1' => [ " exports.MO.REL" ],
		'\u21F2' => [ " exports.MO.REL" ],
		'\u21F3' => [ " exports.MO.RELSTRETCH" ],
		'\u21F4' => [ " exports.MO.RELACCENT" ],
		'\u21F5' => [ " exports.MO.RELSTRETCH" ],
		'\u21F6' => [ " exports.MO.WIDEREL" ],
		'\u21F7' => [ " exports.MO.RELACCENT" ],
		'\u21F8' => [ " exports.MO.RELACCENT" ],
		'\u21F9' => [ " exports.MO.RELACCENT" ],
		'\u21FA' => [ " exports.MO.RELACCENT" ],
		'\u21FB' => [ " exports.MO.RELACCENT" ],
		'\u21FC' => [ " exports.MO.RELACCENT" ],
		'\u21FD' => [ " exports.MO.WIDEREL" ],
		'\u21FE' => [ " exports.MO.WIDEREL" ],
		'\u21FF' => [ " exports.MO.WIDEREL" ],
		'\u2201' => [ " OPDEF(1, 2), MmlNode_js_1.TEXCLASS.ORD)" ],
		'\u2205' => [ " exports.MO.ORD" ],
		'\u2206' => [ " exports.MO.BIN3" ],
		'\u2208' => [ " exports.MO.REL" ],
		'\u2209' => [ " exports.MO.REL" ],
		'\u220A' => [ " exports.MO.REL" ],
		'\u220B' => [ " exports.MO.REL" ],
		'\u220C' => [ " exports.MO.REL" ],
		'\u220D' => [ " exports.MO.REL" ],
		'\u220E' => [ " exports.MO.BIN3" ],
		'\u2212' => [ " exports.MO.BIN4" ],
		'\u2213' => [ " exports.MO.BIN4" ],
		'\u2214' => [ " exports.MO.BIN4" ],
		'\u2215' => [ " exports.MO.TALLBIN" ],
		'\u2216' => [ " exports.MO.BIN4" ],
		'\u2217' => [ " exports.MO.BIN4" ],
		'\u2218' => [ " exports.MO.BIN4" ],
		'\u2219' => [ " exports.MO.BIN4" ],
		'\u221D' => [ " exports.MO.REL" ],
		// '\u221E'=> [" exports.MO.ORD"],
		'\u221F' => [ " exports.MO.REL" ],
		'\u2223' => [ " exports.MO.REL" ],
		'\u2224' => [ " exports.MO.REL" ],
		'\u2225' => [ " exports.MO.REL" ],
		'\u2226' => [ " exports.MO.REL" ],
		'\u2227' => [ " exports.MO.BIN4" ],
		'\u2228' => [ " exports.MO.BIN4" ],
		'\u2229' => [ " exports.MO.BIN4" ],
		'\u222A' => [ " exports.MO.BIN4" ],
		'\u2234' => [ " exports.MO.REL" ],
		'\u2235' => [ " exports.MO.REL" ],
		'\u2236' => [ " exports.MO.REL" ],
		'\u2237' => [ " exports.MO.REL" ],
		'\u2238' => [ " exports.MO.BIN4" ],
		'\u2239' => [ " exports.MO.REL" ],
		'\u223A' => [ " exports.MO.BIN4" ],
		'\u223B' => [ " exports.MO.REL" ],
		'\u223C' => [ " exports.MO.REL" ],
		'\u223D' => [ " exports.MO.REL" ],
		'\u223D\u0331' => [ " exports.MO.BIN3" ],
		'\u223E' => [ " exports.MO.REL" ],
		'\u223F' => [ " exports.MO.BIN3" ],
		'\u2240' => [ " exports.MO.BIN4" ],
		'\u2241' => [ " exports.MO.REL" ],
		'\u2242' => [ " exports.MO.REL" ],
		'\u2242\u0338' => [ " exports.MO.REL" ],
		'\u2243' => [ " exports.MO.REL" ],
		'\u2244' => [ " exports.MO.REL" ],
		'\u2245' => [ " exports.MO.REL" ],
		'\u2246' => [ " exports.MO.REL" ],
		'\u2247' => [ " exports.MO.REL" ],
		'\u2248' => [ " exports.MO.REL" ],
		'\u2249' => [ " exports.MO.REL" ],
		'\u224A' => [ " exports.MO.REL" ],
		'\u224B' => [ " exports.MO.REL" ],
		'\u224C' => [ " exports.MO.REL" ],
		'\u224D' => [ " exports.MO.REL" ],
		'\u224E' => [ " exports.MO.REL" ],
		'\u224E\u0338' => [ " exports.MO.REL" ],
		'\u224F' => [ " exports.MO.REL" ],
		'\u224F\u0338' => [ " exports.MO.REL" ],
		'\u2250' => [ " exports.MO.REL" ],
		'\u2251' => [ " exports.MO.REL" ],
		'\u2252' => [ " exports.MO.REL" ],
		'\u2253' => [ " exports.MO.REL" ],
		'\u2254' => [ " exports.MO.REL" ],
		'\u2255' => [ " exports.MO.REL" ],
		'\u2256' => [ " exports.MO.REL" ],
		'\u2257' => [ " exports.MO.REL" ],
		'\u2258' => [ " exports.MO.REL" ],
		'\u2259' => [ " exports.MO.REL" ],
		'\u225A' => [ " exports.MO.REL" ],
		'\u225B' => [ " exports.MO.REL" ],
		'\u225C' => [ " exports.MO.REL" ],
		'\u225D' => [ " exports.MO.REL" ],
		'\u225E' => [ " exports.MO.REL" ],
		'\u225F' => [ " exports.MO.REL" ],
		'\u2260' => [ " exports.MO.REL" ],
		'\u2261' => [ " exports.MO.REL" ],
		'\u2262' => [ " exports.MO.REL" ],
		'\u2263' => [ " exports.MO.REL" ],
		'\u2264' => [ " exports.MO.REL" ],
		'\u2265' => [ " exports.MO.REL" ],
		'\u2266' => [ " exports.MO.REL" ],
		'\u2266\u0338' => [ " exports.MO.REL" ],
		'\u2267' => [ " exports.MO.REL" ],
		'\u2268' => [ " exports.MO.REL" ],
		'\u2269' => [ " exports.MO.REL" ],
		'\u226A' => [ " exports.MO.REL" ],
		'\u226A\u0338' => [ " exports.MO.REL" ],
		'\u226B' => [ " exports.MO.REL" ],
		'\u226B\u0338' => [ " exports.MO.REL" ],
		'\u226C' => [ " exports.MO.REL" ],
		'\u226D' => [ " exports.MO.REL" ],
		'\u226E' => [ " exports.MO.REL" ],
		'\u226F' => [ " exports.MO.REL" ],
		'\u2270' => [ " exports.MO.REL" ],
		'\u2271' => [ " exports.MO.REL" ],
		'\u2272' => [ " exports.MO.REL" ],
		'\u2273' => [ " exports.MO.REL" ],
		'\u2274' => [ " exports.MO.REL" ],
		'\u2275' => [ " exports.MO.REL" ],
		'\u2276' => [ " exports.MO.REL" ],
		'\u2277' => [ " exports.MO.REL" ],
		'\u2278' => [ " exports.MO.REL" ],
		'\u2279' => [ " exports.MO.REL" ],
		'\u227A' => [ " exports.MO.REL" ],
		'\u227B' => [ " exports.MO.REL" ],
		'\u227C' => [ " exports.MO.REL" ],
		'\u227D' => [ " exports.MO.REL" ],
		'\u227E' => [ " exports.MO.REL" ],
		'\u227F' => [ " exports.MO.REL" ],
		'\u227F\u0338' => [ " exports.MO.REL" ],
		'\u2280' => [ " exports.MO.REL" ],
		'\u2281' => [ " exports.MO.REL" ],
		'\u2282' => [ " exports.MO.REL" ],
		'\u2282\u20D2' => [ " exports.MO.REL" ],
		'\u2283' => [ " exports.MO.REL" ],
		'\u2283\u20D2' => [ " exports.MO.REL" ],
		'\u2284' => [ " exports.MO.REL" ],
		'\u2285' => [ " exports.MO.REL" ],
		'\u2286' => [ " exports.MO.REL" ],
		'\u2287' => [ " exports.MO.REL" ],
		'\u2288' => [ " exports.MO.REL" ],
		'\u2289' => [ " exports.MO.REL" ],
		'\u228A' => [ " exports.MO.REL" ],
		'\u228B' => [ " exports.MO.REL" ],
		'\u228C' => [ " exports.MO.BIN4" ],
		'\u228D' => [ " exports.MO.BIN4" ],
		'\u228E' => [ " exports.MO.BIN4" ],
		'\u228F' => [ " exports.MO.REL" ],
		'\u228F\u0338' => [ " exports.MO.REL" ],
		'\u2290' => [ " exports.MO.REL" ],
		'\u2290\u0338' => [ " exports.MO.REL" ],
		'\u2291' => [ " exports.MO.REL" ],
		'\u2292' => [ " exports.MO.REL" ],
		'\u2293' => [ " exports.MO.BIN4" ],
		'\u2294' => [ " exports.MO.BIN4" ],
		'\u2295' => [ " exports.MO.BIN4" ],
		'\u2296' => [ " exports.MO.BIN4" ],
		'\u2297' => [ " exports.MO.BIN4" ],
		'\u2298' => [ " exports.MO.BIN4" ],
		'\u2299' => [ " exports.MO.BIN4" ],
		'\u229A' => [ " exports.MO.BIN4" ],
		'\u229B' => [ " exports.MO.BIN4" ],
		'\u229C' => [ " exports.MO.BIN4" ],
		'\u229D' => [ " exports.MO.BIN4" ],
		'\u229E' => [ " exports.MO.BIN4" ],
		'\u229F' => [ " exports.MO.BIN4" ],
		'\u22A0' => [ " exports.MO.BIN4" ],
		'\u22A1' => [ " exports.MO.BIN4" ],
		'\u22A2' => [ " exports.MO.REL" ],
		'\u22A3' => [ " exports.MO.REL" ],
		'\u22A4' => [ " exports.MO.ORD55" ],
		'\u22A5' => [ " exports.MO.REL" ],
		'\u22A6' => [ " exports.MO.REL" ],
		'\u22A7' => [ " exports.MO.REL" ],
		'\u22A8' => [ " exports.MO.REL" ],
		'\u22A9' => [ " exports.MO.REL" ],
		'\u22AA' => [ " exports.MO.REL" ],
		'\u22AB' => [ " exports.MO.REL" ],
		'\u22AC' => [ " exports.MO.REL" ],
		'\u22AD' => [ " exports.MO.REL" ],
		'\u22AE' => [ " exports.MO.REL" ],
		'\u22AF' => [ " exports.MO.REL" ],
		'\u22B0' => [ " exports.MO.REL" ],
		'\u22B1' => [ " exports.MO.REL" ],
		'\u22B2' => [ " exports.MO.REL" ],
		'\u22B3' => [ " exports.MO.REL" ],
		'\u22B4' => [ " exports.MO.REL" ],
		'\u22B5' => [ " exports.MO.REL" ],
		'\u22B6' => [ " exports.MO.REL" ],
		'\u22B7' => [ " exports.MO.REL" ],
		'\u22B8' => [ " exports.MO.REL" ],
		'\u22B9' => [ " exports.MO.REL" ],
		'\u22BA' => [ " exports.MO.BIN4" ],
		'\u22BB' => [ " exports.MO.BIN4" ],
		'\u22BC' => [ " exports.MO.BIN4" ],
		'\u22BD' => [ " exports.MO.BIN4" ],
		'\u22BE' => [ " exports.MO.BIN3" ],
		'\u22BF' => [ " exports.MO.BIN3" ],
		'\u22C4' => [ " exports.MO.BIN4" ],
		'\u22C5' => [ " exports.MO.BIN4" ],
		'\u22C6' => [ " exports.MO.BIN4" ],
		'\u22C7' => [ " exports.MO.BIN4" ],
		'\u22C8' => [ " exports.MO.REL" ],
		'\u22C9' => [ " exports.MO.BIN4" ],
		'\u22CA' => [ " exports.MO.BIN4" ],
		'\u22CB' => [ " exports.MO.BIN4" ],
		'\u22CC' => [ " exports.MO.BIN4" ],
		'\u22CD' => [ " exports.MO.REL" ],
		'\u22CE' => [ " exports.MO.BIN4" ],
		'\u22CF' => [ " exports.MO.BIN4" ],
		'\u22D0' => [ " exports.MO.REL" ],
		'\u22D1' => [ " exports.MO.REL" ],
		'\u22D2' => [ " exports.MO.BIN4" ],
		'\u22D3' => [ " exports.MO.BIN4" ],
		'\u22D4' => [ " exports.MO.REL" ],
		'\u22D5' => [ " exports.MO.REL" ],
		'\u22D6' => [ " exports.MO.REL" ],
		'\u22D7' => [ " exports.MO.REL" ],
		'\u22D8' => [ " exports.MO.REL" ],
		'\u22D9' => [ " exports.MO.REL" ],
		'\u22DA' => [ " exports.MO.REL" ],
		'\u22DB' => [ " exports.MO.REL" ],
		'\u22DC' => [ " exports.MO.REL" ],
		'\u22DD' => [ " exports.MO.REL" ],
		'\u22DE' => [ " exports.MO.REL" ],
		'\u22DF' => [ " exports.MO.REL" ],
		'\u22E0' => [ " exports.MO.REL" ],
		'\u22E1' => [ " exports.MO.REL" ],
		'\u22E2' => [ " exports.MO.REL" ],
		'\u22E3' => [ " exports.MO.REL" ],
		'\u22E4' => [ " exports.MO.REL" ],
		'\u22E5' => [ " exports.MO.REL" ],
		'\u22E6' => [ " exports.MO.REL" ],
		'\u22E7' => [ " exports.MO.REL" ],
		'\u22E8' => [ " exports.MO.REL" ],
		'\u22E9' => [ " exports.MO.REL" ],
		'\u22EA' => [ " exports.MO.REL" ],
		'\u22EB' => [ " exports.MO.REL" ],
		'\u22EC' => [ " exports.MO.REL" ],
		'\u22ED' => [ " exports.MO.REL" ],
		'\u22EE' => [ " exports.MO.ORD55" ],
		'\u22EF' => [ " exports.MO.INNER" ],
		'\u22F0' => [ " exports.MO.REL" ],
		'\u22F1' => [ " [5, 5], MmlNode_js_1.TEXCLASS.INNER], null]" ],
		'\u22F2' => [ " exports.MO.REL" ],
		'\u22F3' => [ " exports.MO.REL" ],
		'\u22F4' => [ " exports.MO.REL" ],
		'\u22F5' => [ " exports.MO.REL" ],
		'\u22F6' => [ " exports.MO.REL" ],
		'\u22F7' => [ " exports.MO.REL" ],
		'\u22F8' => [ " exports.MO.REL" ],
		'\u22F9' => [ " exports.MO.REL" ],
		'\u22FA' => [ " exports.MO.REL" ],
		'\u22FB' => [ " exports.MO.REL" ],
		'\u22FC' => [ " exports.MO.REL" ],
		'\u22FD' => [ " exports.MO.REL" ],
		'\u22FE' => [ " exports.MO.REL" ],
		'\u22FF' => [ " exports.MO.REL" ],
		'\u2305' => [ " exports.MO.BIN3" ],
		'\u2306' => [ " exports.MO.BIN3" ],
		'\u2322' => [ " exports.MO.REL4" ],
		'\u2323' => [ " exports.MO.REL4" ],
		'\u2329' => [ " exports.MO.OPEN" ],
		'\u232A' => [ " exports.MO.CLOSE" ],
		'\u23AA' => [ " exports.MO.ORD" ],
		'\u23AF' => [ " [0, 0], MmlNode_js_1.TEXCLASS.ORD], { stretchy=> [\" true }]" ],
		'\u23B0' => [ " exports.MO.OPEN" ],
		'\u23B1' => [ " exports.MO.CLOSE" ],
		'\u2500' => [ " exports.MO.ORD" ],
		'\u25B3' => [ " exports.MO.BIN4" ],
		'\u25B5' => [ " exports.MO.BIN4" ],
		'\u25B9' => [ " exports.MO.BIN4" ],
		'\u25BD' => [ " exports.MO.BIN4" ],
		'\u25BF' => [ " exports.MO.BIN4" ],
		'\u25C3' => [ " exports.MO.BIN4" ],
		'\u25EF' => [ " exports.MO.BIN3" ],
		'\u2660' => [ " exports.MO.ORD" ],
		'\u2661' => [ " exports.MO.ORD" ],
		'\u2662' => [ " exports.MO.ORD" ],
		'\u2663' => [ " exports.MO.ORD" ],
		'\u2758' => [ " exports.MO.REL" ],
		'\u27F0' => [ " exports.MO.RELSTRETCH" ],
		'\u27F1' => [ " exports.MO.RELSTRETCH" ],
		'\u27F5' => [ " exports.MO.WIDEREL" ],
		'\u27F6' => [ " exports.MO.WIDEREL" ],
		'\u27F7' => [ " exports.MO.WIDEREL" ],
		'\u27F8' => [ " exports.MO.WIDEREL" ],
		'\u27F9' => [ " exports.MO.WIDEREL" ],
		'\u27FA' => [ " exports.MO.WIDEREL" ],
		'\u27FB' => [ " exports.MO.WIDEREL" ],
		'\u27FC' => [ " exports.MO.WIDEREL" ],
		'\u27FD' => [ " exports.MO.WIDEREL" ],
		'\u27FE' => [ " exports.MO.WIDEREL" ],
		'\u27FF' => [ " exports.MO.WIDEREL" ],
		'\u2900' => [ " exports.MO.RELACCENT" ],
		'\u2901' => [ " exports.MO.RELACCENT" ],
		'\u2902' => [ " exports.MO.RELACCENT" ],
		'\u2903' => [ " exports.MO.RELACCENT" ],
		'\u2904' => [ " exports.MO.RELACCENT" ],
		'\u2905' => [ " exports.MO.RELACCENT" ],
		'\u2906' => [ " exports.MO.RELACCENT" ],
		'\u2907' => [ " exports.MO.RELACCENT" ],
		'\u2908' => [ " exports.MO.REL" ],
		'\u2909' => [ " exports.MO.REL" ],
		'\u290A' => [ " exports.MO.RELSTRETCH" ],
		'\u290B' => [ " exports.MO.RELSTRETCH" ],
		'\u290C' => [ " exports.MO.WIDEREL" ],
		'\u290D' => [ " exports.MO.WIDEREL" ],
		'\u290E' => [ " exports.MO.WIDEREL" ],
		'\u290F' => [ " exports.MO.WIDEREL" ],
		'\u2910' => [ " exports.MO.WIDEREL" ],
		'\u2911' => [ " exports.MO.RELACCENT" ],
		'\u2912' => [ " exports.MO.RELSTRETCH" ],
		'\u2913' => [ " exports.MO.RELSTRETCH" ],
		'\u2914' => [ " exports.MO.RELACCENT" ],
		'\u2915' => [ " exports.MO.RELACCENT" ],
		'\u2916' => [ " exports.MO.RELACCENT" ],
		'\u2917' => [ " exports.MO.RELACCENT" ],
		'\u2918' => [ " exports.MO.RELACCENT" ],
		'\u2919' => [ " exports.MO.RELACCENT" ],
		'\u291A' => [ " exports.MO.RELACCENT" ],
		'\u291B' => [ " exports.MO.RELACCENT" ],
		'\u291C' => [ " exports.MO.RELACCENT" ],
		'\u291D' => [ " exports.MO.RELACCENT" ],
		'\u291E' => [ " exports.MO.RELACCENT" ],
		'\u291F' => [ " exports.MO.RELACCENT" ],
		'\u2920' => [ " exports.MO.RELACCENT" ],
		'\u2921' => [ " exports.MO.RELSTRETCH" ],
		'\u2922' => [ " exports.MO.RELSTRETCH" ],
		'\u2923' => [ " exports.MO.REL" ],
		'\u2924' => [ " exports.MO.REL" ],
		'\u2925' => [ " exports.MO.REL" ],
		'\u2926' => [ " exports.MO.REL" ],
		'\u2927' => [ " exports.MO.REL" ],
		'\u2928' => [ " exports.MO.REL" ],
		'\u2929' => [ " exports.MO.REL" ],
		'\u292A' => [ " exports.MO.REL" ],
		'\u292B' => [ " exports.MO.REL" ],
		'\u292C' => [ " exports.MO.REL" ],
		'\u292D' => [ " exports.MO.REL" ],
		'\u292E' => [ " exports.MO.REL" ],
		'\u292F' => [ " exports.MO.REL" ],
		'\u2930' => [ " exports.MO.REL" ],
		'\u2931' => [ " exports.MO.REL" ],
		'\u2932' => [ " exports.MO.REL" ],
		'\u2933' => [ " exports.MO.RELACCENT" ],
		'\u2934' => [ " exports.MO.REL" ],
		'\u2935' => [ " exports.MO.REL" ],
		'\u2936' => [ " exports.MO.REL" ],
		'\u2937' => [ " exports.MO.REL" ],
		'\u2938' => [ " exports.MO.REL" ],
		'\u2939' => [ " exports.MO.REL" ],
		'\u293A' => [ " exports.MO.RELACCENT" ],
		'\u293B' => [ " exports.MO.RELACCENT" ],
		'\u293C' => [ " exports.MO.RELACCENT" ],
		'\u293D' => [ " exports.MO.RELACCENT" ],
		'\u293E' => [ " exports.MO.REL" ],
		'\u293F' => [ " exports.MO.REL" ],
		'\u2940' => [ " exports.MO.REL" ],
		'\u2941' => [ " exports.MO.REL" ],
		'\u2942' => [ " exports.MO.RELACCENT" ],
		'\u2943' => [ " exports.MO.RELACCENT" ],
		'\u2944' => [ " exports.MO.RELACCENT" ],
		'\u2945' => [ " exports.MO.RELACCENT" ],
		'\u2946' => [ " exports.MO.RELACCENT" ],
		'\u2947' => [ " exports.MO.RELACCENT" ],
		'\u2948' => [ " exports.MO.RELACCENT" ],
		'\u2949' => [ " exports.MO.REL" ],
		'\u294A' => [ " exports.MO.RELACCENT" ],
		'\u294B' => [ " exports.MO.RELACCENT" ],
		'\u294C' => [ " exports.MO.REL" ],
		'\u294D' => [ " exports.MO.REL" ],
		'\u294E' => [ " exports.MO.WIDEREL" ],
		'\u294F' => [ " exports.MO.RELSTRETCH" ],
		'\u2950' => [ " exports.MO.WIDEREL" ],
		'\u2951' => [ " exports.MO.RELSTRETCH" ],
		'\u2952' => [ " exports.MO.WIDEREL" ],
		'\u2953' => [ " exports.MO.WIDEREL" ],
		'\u2954' => [ " exports.MO.RELSTRETCH" ],
		'\u2955' => [ " exports.MO.RELSTRETCH" ],
		'\u2956' => [ " exports.MO.RELSTRETCH" ],
		'\u2957' => [ " exports.MO.RELSTRETCH" ],
		'\u2958' => [ " exports.MO.RELSTRETCH" ],
		'\u2959' => [ " exports.MO.RELSTRETCH" ],
		'\u295A' => [ " exports.MO.WIDEREL" ],
		'\u295B' => [ " exports.MO.WIDEREL" ],
		'\u295C' => [ " exports.MO.RELSTRETCH" ],
		'\u295D' => [ " exports.MO.RELSTRETCH" ],
		'\u295E' => [ " exports.MO.WIDEREL" ],
		'\u295F' => [ " exports.MO.WIDEREL" ],
		'\u2960' => [ " exports.MO.RELSTRETCH" ],
		'\u2961' => [ " exports.MO.RELSTRETCH" ],
		'\u2962' => [ " exports.MO.RELACCENT" ],
		'\u2963' => [ " exports.MO.REL" ],
		'\u2964' => [ " exports.MO.RELACCENT" ],
		'\u2965' => [ " exports.MO.REL" ],
		'\u2966' => [ " exports.MO.RELACCENT" ],
		'\u2967' => [ " exports.MO.RELACCENT" ],
		'\u2968' => [ " exports.MO.RELACCENT" ],
		'\u2969' => [ " exports.MO.RELACCENT" ],
		'\u296A' => [ " exports.MO.RELACCENT" ],
		'\u296B' => [ " exports.MO.RELACCENT" ],
		'\u296C' => [ " exports.MO.RELACCENT" ],
		'\u296D' => [ " exports.MO.RELACCENT" ],
		'\u296E' => [ " exports.MO.RELSTRETCH" ],
		'\u296F' => [ " exports.MO.RELSTRETCH" ],
		'\u2970' => [ " exports.MO.RELACCENT" ],
		'\u2971' => [ " exports.MO.RELACCENT" ],
		'\u2972' => [ " exports.MO.RELACCENT" ],
		'\u2973' => [ " exports.MO.RELACCENT" ],
		'\u2974' => [ " exports.MO.RELACCENT" ],
		'\u2975' => [ " exports.MO.RELACCENT" ],
		'\u2976' => [ " exports.MO.RELACCENT" ],
		'\u2977' => [ " exports.MO.RELACCENT" ],
		'\u2978' => [ " exports.MO.RELACCENT" ],
		'\u2979' => [ " exports.MO.RELACCENT" ],
		'\u297A' => [ " exports.MO.RELACCENT" ],
		'\u297B' => [ " exports.MO.RELACCENT" ],
		'\u297C' => [ " exports.MO.RELACCENT" ],
		'\u297D' => [ " exports.MO.RELACCENT" ],
		'\u297E' => [ " exports.MO.REL" ],
		'\u297F' => [ " exports.MO.REL" ],
		'\u2981' => [ " exports.MO.BIN3" ],
		'\u2982' => [ " exports.MO.BIN3" ],
		'\u2999' => [ " exports.MO.BIN3" ],
		'\u299A' => [ " exports.MO.BIN3" ],
		'\u299B' => [ " exports.MO.BIN3" ],
		'\u299C' => [ " exports.MO.BIN3" ],
		'\u299D' => [ " exports.MO.BIN3" ],
		'\u299E' => [ " exports.MO.BIN3" ],
		'\u299F' => [ " exports.MO.BIN3" ],
		'\u29A0' => [ " exports.MO.BIN3" ],
		'\u29A1' => [ " exports.MO.BIN3" ],
		'\u29A2' => [ " exports.MO.BIN3" ],
		'\u29A3' => [ " exports.MO.BIN3" ],
		'\u29A4' => [ " exports.MO.BIN3" ],
		'\u29A5' => [ " exports.MO.BIN3" ],
		'\u29A6' => [ " exports.MO.BIN3" ],
		'\u29A7' => [ " exports.MO.BIN3" ],
		'\u29A8' => [ " exports.MO.BIN3" ],
		'\u29A9' => [ " exports.MO.BIN3" ],
		'\u29AA' => [ " exports.MO.BIN3" ],
		'\u29AB' => [ " exports.MO.BIN3" ],
		'\u29AC' => [ " exports.MO.BIN3" ],
		'\u29AD' => [ " exports.MO.BIN3" ],
		'\u29AE' => [ " exports.MO.BIN3" ],
		'\u29AF' => [ " exports.MO.BIN3" ],
		'\u29B0' => [ " exports.MO.BIN3" ],
		'\u29B1' => [ " exports.MO.BIN3" ],
		'\u29B2' => [ " exports.MO.BIN3" ],
		'\u29B3' => [ " exports.MO.BIN3" ],
		'\u29B4' => [ " exports.MO.BIN3" ],
		'\u29B5' => [ " exports.MO.BIN3" ],
		'\u29B6' => [ " exports.MO.BIN4" ],
		'\u29B7' => [ " exports.MO.BIN4" ],
		'\u29B8' => [ " exports.MO.BIN4" ],
		'\u29B9' => [ " exports.MO.BIN4" ],
		'\u29BA' => [ " exports.MO.BIN4" ],
		'\u29BB' => [ " exports.MO.BIN4" ],
		'\u29BC' => [ " exports.MO.BIN4" ],
		'\u29BD' => [ " exports.MO.BIN4" ],
		'\u29BE' => [ " exports.MO.BIN4" ],
		'\u29BF' => [ " exports.MO.BIN4" ],
		'\u29C0' => [ " exports.MO.REL" ],
		'\u29C1' => [ " exports.MO.REL" ],
		'\u29C2' => [ " exports.MO.BIN3" ],
		'\u29C3' => [ " exports.MO.BIN3" ],
		'\u29C4' => [ " exports.MO.BIN4" ],
		'\u29C5' => [ " exports.MO.BIN4" ],
		'\u29C6' => [ " exports.MO.BIN4" ],
		'\u29C7' => [ " exports.MO.BIN4" ],
		'\u29C8' => [ " exports.MO.BIN4" ],
		'\u29C9' => [ " exports.MO.BIN3" ],
		'\u29CA' => [ " exports.MO.BIN3" ],
		'\u29CB' => [ " exports.MO.BIN3" ],
		'\u29CC' => [ " exports.MO.BIN3" ],
		'\u29CD' => [ " exports.MO.BIN3" ],
		'\u29CE' => [ " exports.MO.REL" ],
		'\u29CF' => [ " exports.MO.REL" ],
		'\u29CF\u0338' => [ " exports.MO.REL" ],
		'\u29D0' => [ " exports.MO.REL" ],
		'\u29D0\u0338' => [ " exports.MO.REL" ],
		'\u29D1' => [ " exports.MO.REL" ],
		'\u29D2' => [ " exports.MO.REL" ],
		'\u29D3' => [ " exports.MO.REL" ],
		'\u29D4' => [ " exports.MO.REL" ],
		'\u29D5' => [ " exports.MO.REL" ],
		'\u29D6' => [ " exports.MO.BIN4" ],
		'\u29D7' => [ " exports.MO.BIN4" ],
		'\u29D8' => [ " exports.MO.BIN3" ],
		'\u29D9' => [ " exports.MO.BIN3" ],
		'\u29DB' => [ " exports.MO.BIN3" ],
		'\u29DC' => [ " exports.MO.BIN3" ],
		'\u29DD' => [ " exports.MO.BIN3" ],
		'\u29DE' => [ " exports.MO.REL" ],
		'\u29DF' => [ " exports.MO.BIN3" ],
		'\u29E0' => [ " exports.MO.BIN3" ],
		'\u29E1' => [ " exports.MO.REL" ],
		'\u29E2' => [ " exports.MO.BIN4" ],
		'\u29E3' => [ " exports.MO.REL" ],
		'\u29E4' => [ " exports.MO.REL" ],
		'\u29E5' => [ " exports.MO.REL" ],
		'\u29E6' => [ " exports.MO.REL" ],
		'\u29E7' => [ " exports.MO.BIN3" ],
		'\u29E8' => [ " exports.MO.BIN3" ],
		'\u29E9' => [ " exports.MO.BIN3" ],
		'\u29EA' => [ " exports.MO.BIN3" ],
		'\u29EB' => [ " exports.MO.BIN3" ],
		'\u29EC' => [ " exports.MO.BIN3" ],
		'\u29ED' => [ " exports.MO.BIN3" ],
		'\u29EE' => [ " exports.MO.BIN3" ],
		'\u29EF' => [ " exports.MO.BIN3" ],
		'\u29F0' => [ " exports.MO.BIN3" ],
		'\u29F1' => [ " exports.MO.BIN3" ],
		'\u29F2' => [ " exports.MO.BIN3" ],
		'\u29F3' => [ " exports.MO.BIN3" ],
		'\u29F4' => [ " exports.MO.REL" ],
		'\u29F5' => [ " exports.MO.BIN4" ],
		'\u29F6' => [ " exports.MO.BIN4" ],
		'\u29F7' => [ " exports.MO.BIN4" ],
		'\u29F8' => [ " exports.MO.BIN3" ],
		'\u29F9' => [ " exports.MO.BIN3" ],
		'\u29FA' => [ " exports.MO.BIN3" ],
		'\u29FB' => [ " exports.MO.BIN3" ],
		'\u29FE' => [ " exports.MO.BIN4" ],
		'\u29FF' => [ " exports.MO.BIN4" ],
		'\u2A1D' => [ " exports.MO.BIN3" ],
		'\u2A1E' => [ " exports.MO.BIN3" ],
		'\u2A1F' => [ " exports.MO.BIN3" ],
		'\u2A20' => [ " exports.MO.BIN3" ],
		'\u2A21' => [ " exports.MO.BIN3" ],
		'\u2A22' => [ " exports.MO.BIN4" ],
		'\u2A23' => [ " exports.MO.BIN4" ],
		'\u2A24' => [ " exports.MO.BIN4" ],
		'\u2A25' => [ " exports.MO.BIN4" ],
		'\u2A26' => [ " exports.MO.BIN4" ],
		'\u2A27' => [ " exports.MO.BIN4" ],
		'\u2A28' => [ " exports.MO.BIN4" ],
		'\u2A29' => [ " exports.MO.BIN4" ],
		'\u2A2A' => [ " exports.MO.BIN4" ],
		'\u2A2B' => [ " exports.MO.BIN4" ],
		'\u2A2C' => [ " exports.MO.BIN4" ],
		'\u2A2D' => [ " exports.MO.BIN4" ],
		'\u2A2E' => [ " exports.MO.BIN4" ],
		'\u2A2F' => [ " exports.MO.BIN4" ],
		'\u2A30' => [ " exports.MO.BIN4" ],
		'\u2A31' => [ " exports.MO.BIN4" ],
		'\u2A32' => [ " exports.MO.BIN4" ],
		'\u2A33' => [ " exports.MO.BIN4" ],
		'\u2A34' => [ " exports.MO.BIN4" ],
		'\u2A35' => [ " exports.MO.BIN4" ],
		'\u2A36' => [ " exports.MO.BIN4" ],
		'\u2A37' => [ " exports.MO.BIN4" ],
		'\u2A38' => [ " exports.MO.BIN4" ],
		'\u2A39' => [ " exports.MO.BIN4" ],
		'\u2A3A' => [ " exports.MO.BIN4" ],
		'\u2A3B' => [ " exports.MO.BIN4" ],
		'\u2A3C' => [ " exports.MO.BIN4" ],
		'\u2A3D' => [ " exports.MO.BIN4" ],
		'\u2A3E' => [ " exports.MO.BIN4" ],
		'\u2A3F' => [ " exports.MO.BIN4" ],
		'\u2A40' => [ " exports.MO.BIN4" ],
		'\u2A41' => [ " exports.MO.BIN4" ],
		'\u2A42' => [ " exports.MO.BIN4" ],
		'\u2A43' => [ " exports.MO.BIN4" ],
		'\u2A44' => [ " exports.MO.BIN4" ],
		'\u2A45' => [ " exports.MO.BIN4" ],
		'\u2A46' => [ " exports.MO.BIN4" ],
		'\u2A47' => [ " exports.MO.BIN4" ],
		'\u2A48' => [ " exports.MO.BIN4" ],
		'\u2A49' => [ " exports.MO.BIN4" ],
		'\u2A4A' => [ " exports.MO.BIN4" ],
		'\u2A4B' => [ " exports.MO.BIN4" ],
		'\u2A4C' => [ " exports.MO.BIN4" ],
		'\u2A4D' => [ " exports.MO.BIN4" ],
		'\u2A4E' => [ " exports.MO.BIN4" ],
		'\u2A4F' => [ " exports.MO.BIN4" ],
		'\u2A50' => [ " exports.MO.BIN4" ],
		'\u2A51' => [ " exports.MO.BIN4" ],
		'\u2A52' => [ " exports.MO.BIN4" ],
		'\u2A53' => [ " exports.MO.BIN4" ],
		'\u2A54' => [ " exports.MO.BIN4" ],
		'\u2A55' => [ " exports.MO.BIN4" ],
		'\u2A56' => [ " exports.MO.BIN4" ],
		'\u2A57' => [ " exports.MO.BIN4" ],
		'\u2A58' => [ " exports.MO.BIN4" ],
		'\u2A59' => [ " exports.MO.REL" ],
		'\u2A5A' => [ " exports.MO.BIN4" ],
		'\u2A5B' => [ " exports.MO.BIN4" ],
		'\u2A5C' => [ " exports.MO.BIN4" ],
		'\u2A5D' => [ " exports.MO.BIN4" ],
		'\u2A5E' => [ " exports.MO.BIN4" ],
		'\u2A5F' => [ " exports.MO.BIN4" ],
		'\u2A60' => [ " exports.MO.BIN4" ],
		'\u2A61' => [ " exports.MO.BIN4" ],
		'\u2A62' => [ " exports.MO.BIN4" ],
		'\u2A63' => [ " exports.MO.BIN4" ],
		'\u2A64' => [ " exports.MO.BIN4" ],
		'\u2A65' => [ " exports.MO.BIN4" ],
		'\u2A66' => [ " exports.MO.REL" ],
		'\u2A67' => [ " exports.MO.REL" ],
		'\u2A68' => [ " exports.MO.REL" ],
		'\u2A69' => [ " exports.MO.REL" ],
		'\u2A6A' => [ " exports.MO.REL" ],
		'\u2A6B' => [ " exports.MO.REL" ],
		'\u2A6C' => [ " exports.MO.REL" ],
		'\u2A6D' => [ " exports.MO.REL" ],
		'\u2A6E' => [ " exports.MO.REL" ],
		'\u2A6F' => [ " exports.MO.REL" ],
		'\u2A70' => [ " exports.MO.REL" ],
		'\u2A71' => [ " exports.MO.BIN4" ],
		'\u2A72' => [ " exports.MO.BIN4" ],
		'\u2A73' => [ " exports.MO.REL" ],
		'\u2A74' => [ " exports.MO.REL" ],
		'\u2A75' => [ " exports.MO.REL" ],
		'\u2A76' => [ " exports.MO.REL" ],
		'\u2A77' => [ " exports.MO.REL" ],
		'\u2A78' => [ " exports.MO.REL" ],
		'\u2A79' => [ " exports.MO.REL" ],
		'\u2A7A' => [ " exports.MO.REL" ],
		'\u2A7B' => [ " exports.MO.REL" ],
		'\u2A7C' => [ " exports.MO.REL" ],
		'\u2A7D' => [ " exports.MO.REL" ],
		'\u2A7D\u0338' => [ " exports.MO.REL" ],
		'\u2A7E' => [ " exports.MO.REL" ],
		'\u2A7E\u0338' => [ " exports.MO.REL" ],
		'\u2A7F' => [ " exports.MO.REL" ],
		'\u2A80' => [ " exports.MO.REL" ],
		'\u2A81' => [ " exports.MO.REL" ],
		'\u2A82' => [ " exports.MO.REL" ],
		'\u2A83' => [ " exports.MO.REL" ],
		'\u2A84' => [ " exports.MO.REL" ],
		'\u2A85' => [ " exports.MO.REL" ],
		'\u2A86' => [ " exports.MO.REL" ],
		'\u2A87' => [ " exports.MO.REL" ],
		'\u2A88' => [ " exports.MO.REL" ],
		'\u2A89' => [ " exports.MO.REL" ],
		'\u2A8A' => [ " exports.MO.REL" ],
		'\u2A8B' => [ " exports.MO.REL" ],
		'\u2A8C' => [ " exports.MO.REL" ],
		'\u2A8D' => [ " exports.MO.REL" ],
		'\u2A8E' => [ " exports.MO.REL" ],
		'\u2A8F' => [ " exports.MO.REL" ],
		'\u2A90' => [ " exports.MO.REL" ],
		'\u2A91' => [ " exports.MO.REL" ],
		'\u2A92' => [ " exports.MO.REL" ],
		'\u2A93' => [ " exports.MO.REL" ],
		'\u2A94' => [ " exports.MO.REL" ],
		'\u2A95' => [ " exports.MO.REL" ],
		'\u2A96' => [ " exports.MO.REL" ],
		'\u2A97' => [ " exports.MO.REL" ],
		'\u2A98' => [ " exports.MO.REL" ],
		'\u2A99' => [ " exports.MO.REL" ],
		'\u2A9A' => [ " exports.MO.REL" ],
		'\u2A9B' => [ " exports.MO.REL" ],
		'\u2A9C' => [ " exports.MO.REL" ],
		'\u2A9D' => [ " exports.MO.REL" ],
		'\u2A9E' => [ " exports.MO.REL" ],
		'\u2A9F' => [ " exports.MO.REL" ],
		'\u2AA0' => [ " exports.MO.REL" ],
		'\u2AA1' => [ " exports.MO.REL" ],
		'\u2AA1\u0338' => [ " exports.MO.REL" ],
		'\u2AA2' => [ " exports.MO.REL" ],
		'\u2AA2\u0338' => [ " exports.MO.REL" ],
		'\u2AA3' => [ " exports.MO.REL" ],
		'\u2AA4' => [ " exports.MO.REL" ],
		'\u2AA5' => [ " exports.MO.REL" ],
		'\u2AA6' => [ " exports.MO.REL" ],
		'\u2AA7' => [ " exports.MO.REL" ],
		'\u2AA8' => [ " exports.MO.REL" ],
		'\u2AA9' => [ " exports.MO.REL" ],
		'\u2AAA' => [ " exports.MO.REL" ],
		'\u2AAB' => [ " exports.MO.REL" ],
		'\u2AAC' => [ " exports.MO.REL" ],
		'\u2AAD' => [ " exports.MO.REL" ],
		'\u2AAE' => [ " exports.MO.REL" ],
		'\u2AAF' => [ " exports.MO.REL" ],
		'\u2AAF\u0338' => [ " exports.MO.REL" ],
		'\u2AB0' => [ " exports.MO.REL" ],
		'\u2AB0\u0338' => [ " exports.MO.REL" ],
		'\u2AB1' => [ " exports.MO.REL" ],
		'\u2AB2' => [ " exports.MO.REL" ],
		'\u2AB3' => [ " exports.MO.REL" ],
		'\u2AB4' => [ " exports.MO.REL" ],
		'\u2AB5' => [ " exports.MO.REL" ],
		'\u2AB6' => [ " exports.MO.REL" ],
		'\u2AB7' => [ " exports.MO.REL" ],
		'\u2AB8' => [ " exports.MO.REL" ],
		'\u2AB9' => [ " exports.MO.REL" ],
		'\u2ABA' => [ " exports.MO.REL" ],
		'\u2ABB' => [ " exports.MO.REL" ],
		'\u2ABC' => [ " exports.MO.REL" ],
		'\u2ABD' => [ " exports.MO.REL" ],
		'\u2ABE' => [ " exports.MO.REL" ],
		'\u2ABF' => [ " exports.MO.REL" ],
		'\u2AC0' => [ " exports.MO.REL" ],
		'\u2AC1' => [ " exports.MO.REL" ],
		'\u2AC2' => [ " exports.MO.REL" ],
		'\u2AC3' => [ " exports.MO.REL" ],
		'\u2AC4' => [ " exports.MO.REL" ],
		'\u2AC5' => [ " exports.MO.REL" ],
		'\u2AC6' => [ " exports.MO.REL" ],
		'\u2AC7' => [ " exports.MO.REL" ],
		'\u2AC8' => [ " exports.MO.REL" ],
		'\u2AC9' => [ " exports.MO.REL" ],
		'\u2ACA' => [ " exports.MO.REL" ],
		'\u2ACB' => [ " exports.MO.REL" ],
		'\u2ACC' => [ " exports.MO.REL" ],
		'\u2ACD' => [ " exports.MO.REL" ],
		'\u2ACE' => [ " exports.MO.REL" ],
		'\u2ACF' => [ " exports.MO.REL" ],
		'\u2AD0' => [ " exports.MO.REL" ],
		'\u2AD1' => [ " exports.MO.REL" ],
		'\u2AD2' => [ " exports.MO.REL" ],
		'\u2AD3' => [ " exports.MO.REL" ],
		'\u2AD4' => [ " exports.MO.REL" ],
		'\u2AD5' => [ " exports.MO.REL" ],
		'\u2AD6' => [ " exports.MO.REL" ],
		'\u2AD7' => [ " exports.MO.REL" ],
		'\u2AD8' => [ " exports.MO.REL" ],
		'\u2AD9' => [ " exports.MO.REL" ],
		'\u2ADA' => [ " exports.MO.REL" ],
		'\u2ADB' => [ " exports.MO.REL" ],
		'\u2ADD' => [ " exports.MO.REL" ],
		'\u2ADD\u0338' => [ " exports.MO.REL" ],
		'\u2ADE' => [ " exports.MO.REL" ],
		'\u2ADF' => [ " exports.MO.REL" ],
		'\u2AE0' => [ " exports.MO.REL" ],
		'\u2AE1' => [ " exports.MO.REL" ],
		'\u2AE2' => [ " exports.MO.REL" ],
		'\u2AE3' => [ " exports.MO.REL" ],
		'\u2AE4' => [ " exports.MO.REL" ],
		'\u2AE5' => [ " exports.MO.REL" ],
		'\u2AE6' => [ " exports.MO.REL" ],
		'\u2AE7' => [ " exports.MO.REL" ],
		'\u2AE8' => [ " exports.MO.REL" ],
		'\u2AE9' => [ " exports.MO.REL" ],
		'\u2AEA' => [ " exports.MO.REL" ],
		'\u2AEB' => [ " exports.MO.REL" ],
		'\u2AEC' => [ " exports.MO.REL" ],
		'\u2AED' => [ " exports.MO.REL" ],
		'\u2AEE' => [ " exports.MO.REL" ],
		'\u2AEF' => [ " exports.MO.REL" ],
		'\u2AF0' => [ " exports.MO.REL" ],
		'\u2AF1' => [ " exports.MO.REL" ],
		'\u2AF2' => [ " exports.MO.REL" ],
		'\u2AF3' => [ " exports.MO.REL" ],
		'\u2AF4' => [ " exports.MO.BIN4" ],
		'\u2AF5' => [ " exports.MO.BIN4" ],
		'\u2AF6' => [ " exports.MO.BIN4" ],
		'\u2AF7' => [ " exports.MO.REL" ],
		'\u2AF8' => [ " exports.MO.REL" ],
		'\u2AF9' => [ " exports.MO.REL" ],
		'\u2AFA' => [ " exports.MO.REL" ],
		'\u2AFB' => [ " exports.MO.BIN4" ],
		'\u2AFD' => [ " exports.MO.BIN4" ],
		'\u2AFE' => [ " exports.MO.BIN3" ],
		'\u2B45' => [ " exports.MO.RELSTRETCH" ],
		'\u2B46' => [ " exports.MO.RELSTRETCH" ],
		'\u3008' => [ " exports.MO.OPEN" ],
		'\u3009' => [ " exports.MO.CLOSE" ],
		'\uFE37' => [ " exports.MO.WIDEACCENT" ],
		'\uFE38' => [ " exports.MO.WIDEACCENT" ],

	];

	private const ALL = [
		"infix" => self::INFIX
	];

	private function __construct() {
		// Just an empty private constructor, for singleton pattern
	}

	public static function removeInstance() {
		self::$instance = null;
	}

	public static function getInstance() {
		if ( self::$instance == null ) {
			self::$instance = new OperatorDictionary();
		}

		return self::$instance;
	}

	public static function getEntryFromList( $keylist, $key ) {
		if ( isset( self::ALL[$keylist][$key] ) ) {
			return self::ALL[$keylist][$key];
		}
		return null;
	}

	public static function getOperatorByKey( $key ) {
		$key = MMLutil::uc2xNotation( $key );
		return MMLutil::getMappingByKey( $key, self::INFIX );
	}

}
