/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabe";
        final String metaValue_hy = "arm\u00e9nien";
        final String metaValue_ae = "avestique";
        final String metaValue_ban = "balinais";
        final String metaValue_bn = "bengali";
        final String metaValue_zbl = "symboles Bliss";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "copte";
        final String metaValue_ka = "g\u00e9orgien";
        final String metaValue_got = "gotique";
        final String metaValue_el = "grec";
        final String metaValue_he = "h\u00e9breu";
        final String metaValue_jv = "javanais";
        final String metaValue_ja = "japonais";
        final String metaValue_km = "khmer";
        final String metaValue_ko = "cor\u00e9en";
        final String metaValue_lo = "lao";
        final String metaValue_la = "latin";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birman";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_or = "odia";
        final String metaValue_phn = "ph\u00e9nicien";
        final String metaValue_saz = "saurashtra";
        final String metaValue_si = "cingalais";
        final String metaValue_syr = "syriaque";
        final String metaValue_ta = "tamoul";
        final String metaValue_te = "t\u00e9lougou";
        final String metaValue_th = "tha\u00ef";
        final String metaValue_bo = "tib\u00e9tain";
        final String metaValue_uga = "ougaritique";
        final String metaValue_vai = "va\u00ef";
        final Object[][] data = new Object[][] {
            { "001", "Monde" },
            { "002", "Afrique" },
            { "003", "Am\u00e9rique du Nord" },
            { "005", "Am\u00e9rique du Sud" },
            { "009", "Oc\u00e9anie" },
            { "011", "Afrique occidentale" },
            { "013", "Am\u00e9rique centrale" },
            { "014", "Afrique orientale" },
            { "015", "Afrique septentrionale" },
            { "017", "Afrique centrale" },
            { "018", "Afrique australe" },
            { "019", "Am\u00e9riques" },
            { "021", "Am\u00e9rique septentrionale" },
            { "029", "Cara\u00efbes" },
            { "030", "Asie de l\u2019Est" },
            { "034", "Asie du Sud" },
            { "035", "Asie du Sud-Est" },
            { "039", "Europe du Sud" },
            { "053", "Australasie" },
            { "054", "M\u00e9lan\u00e9sie" },
            { "057", "r\u00e9gion micron\u00e9sienne" },
            { "061", "Polyn\u00e9sie" },
            { "142", "Asie" },
            { "143", "Asie centrale" },
            { "145", "Asie de l\u2019Ouest" },
            { "150", "Europe" },
            { "151", "Europe de l\u2019Est" },
            { "154", "Europe du Nord" },
            { "155", "Europe de l\u2019Ouest" },
            { "202", "Afrique subsaharienne" },
            { "419", "Am\u00e9rique latine" },
            { "AC", "\u00cele de l\u2019Ascension" },
            { "AD", "Andorre" },
            { "AE", "\u00c9mirats arabes unis" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua-et-Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanie" },
            { "AM", "Arm\u00e9nie" },
            { "AO", "Angola" },
            { "AQ", "Antarctique" },
            { "AR", "Argentine" },
            { "AS", "Samoa am\u00e9ricaines" },
            { "AT", "Autriche" },
            { "AU", "Australie" },
            { "AW", "Aruba" },
            { "AX", "\u00celes \u00c5land" },
            { "AZ", "Azerba\u00efdjan" },
            { "BA", "Bosnie-Herz\u00e9govine" },
            { "BB", "Barbade" },
            { "BD", "Bangladesh" },
            { "BE", "Belgique" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarie" },
            { "BH", "Bahre\u00efn" },
            { "BI", "Burundi" },
            { "BJ", "B\u00e9nin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermudes" },
            { "BN", "Brunei" },
            { "BO", "Bolivie" },
            { "BQ", "Pays-Bas carib\u00e9ens" },
            { "BR", "Br\u00e9sil" },
            { "BS", "Bahamas" },
            { "BT", "Bhoutan" },
            { "BV", "\u00cele Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bi\u00e9lorussie" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "\u00celes Cocos" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "R\u00e9publique centrafricaine" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Suisse" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "\u00celes Cook" },
            { "CL", "Chili" },
            { "CM", "Cameroun" },
            { "CN", "Chine" },
            { "CO", "Colombie" },
            { "CP", "\u00cele Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cap-Vert" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "\u00cele Christmas" },
            { "CY", "Chypre" },
            { "CZ", "Tch\u00e9quie" },
            { "DE", "Allemagne" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danemark" },
            { "DM", "Dominique" },
            { "DO", "R\u00e9publique dominicaine" },
            { "DZ", "Alg\u00e9rie" },
            { "EA", "Ceuta et Melilla" },
            { "EC", "\u00c9quateur" },
            { "EE", "Estonie" },
            { "EG", "\u00c9gypte" },
            { "EH", "Sahara occidental" },
            { "ER", "\u00c9rythr\u00e9e" },
            { "ES", "Espagne" },
            { "ET", "\u00c9thiopie" },
            { "EU", "Union europ\u00e9enne" },
            { "EZ", "zone euro" },
            { "FI", "Finlande" },
            { "FJ", "Fidji" },
            { "FK", "\u00celes Malouines" },
            { "FM", "Micron\u00e9sie" },
            { "FO", "\u00celes F\u00e9ro\u00e9" },
            { "FR", "France" },
            { "GA", "Gabon" },
            { "GB", "Royaume-Uni" },
            { "GD", "Grenade" },
            { "GE", "G\u00e9orgie" },
            { "GF", "Guyane fran\u00e7aise" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenland" },
            { "GM", "Gambie" },
            { "GN", "Guin\u00e9e" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guin\u00e9e \u00e9quatoriale" },
            { "GR", "Gr\u00e8ce" },
            { "GS", "G\u00e9orgie du Sud-et-les \u00celes Sandwich du Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guin\u00e9e-Bissau" },
            { "GY", "Guyana" },
            { "HK", "R.A.S. chinoise de Hong Kong" },
            { "HM", "\u00celes Heard-et-MacDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatie" },
            { "HT", "Ha\u00efti" },
            { "HU", "Hongrie" },
            { "IC", "\u00celes Canaries" },
            { "ID", "Indon\u00e9sie" },
            { "IE", "Irlande" },
            { "IL", "Isra\u00ebl" },
            { "IM", "\u00cele de Man" },
            { "IN", "Inde" },
            { "IO", "Territoire britannique de l\u2019oc\u00e9an Indien" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islande" },
            { "IT", "Italie" },
            { "JE", "Jersey" },
            { "JM", "Jama\u00efque" },
            { "JO", "Jordanie" },
            { "JP", "Japon" },
            { "KE", "Kenya" },
            { "KG", "Kirghizstan" },
            { "KH", "Cambodge" },
            { "KI", "Kiribati" },
            { "KM", "Comores" },
            { "KN", "Saint-Christophe-et-Ni\u00e9v\u00e8s" },
            { "KP", "Cor\u00e9e du Nord" },
            { "KR", "Cor\u00e9e du Sud" },
            { "KW", "Kowe\u00eft" },
            { "KY", "\u00celes Ca\u00efmans" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Sainte-Lucie" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituanie" },
            { "LU", "Luxembourg" },
            { "LV", "Lettonie" },
            { "LY", "Libye" },
            { "MA", "Maroc" },
            { "MC", "Monaco" },
            { "MD", "Moldavie" },
            { "ME", "Mont\u00e9n\u00e9gro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagascar" },
            { "MH", "\u00celes Marshall" },
            { "MK", "Mac\u00e9doine du Nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmanie)" },
            { "MN", "Mongolie" },
            { "MO", "R.A.S. chinoise de Macao" },
            { "MP", "\u00celes Mariannes du Nord" },
            { "MQ", "Martinique" },
            { "MR", "Mauritanie" },
            { "MS", "Montserrat" },
            { "MT", "Malte" },
            { "MU", "Maurice" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexique" },
            { "MY", "Malaisie" },
            { "MZ", "Mozambique" },
            { "NA", "Namibie" },
            { "NC", "Nouvelle-Cal\u00e9donie" },
            { "NE", "Niger" },
            { "NF", "\u00cele Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Pays-Bas" },
            { "NO", "Norv\u00e8ge" },
            { "NP", "N\u00e9pal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nouvelle-Z\u00e9lande" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "P\u00e9rou" },
            { "PF", "Polyn\u00e9sie fran\u00e7aise" },
            { "PG", "Papouasie-Nouvelle-Guin\u00e9e" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Pologne" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "\u00celes Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Territoires palestiniens" },
            { "PT", "Portugal" },
            { "PW", "Palaos" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "r\u00e9gions \u00e9loign\u00e9es de l\u2019Oc\u00e9anie" },
            { "RE", "La R\u00e9union" },
            { "RO", "Roumanie" },
            { "RS", "Serbie" },
            { "RU", "Russie" },
            { "RW", "Rwanda" },
            { "SA", "Arabie saoudite" },
            { "SB", "\u00celes Salomon" },
            { "SC", "Seychelles" },
            { "SD", "Soudan" },
            { "SE", "Su\u00e8de" },
            { "SG", "Singapour" },
            { "SH", "Sainte-H\u00e9l\u00e8ne" },
            { "SI", "Slov\u00e9nie" },
            { "SJ", "Svalbard et Jan Mayen" },
            { "SK", "Slovaquie" },
            { "SL", "Sierra Leone" },
            { "SM", "Saint-Marin" },
            { "SN", "S\u00e9n\u00e9gal" },
            { "SO", "Somalie" },
            { "SR", "Suriname" },
            { "SS", "Soudan du Sud" },
            { "ST", "Sao Tom\u00e9-et-Principe" },
            { "SV", "Salvador" },
            { "SX", "Saint-Martin (partie n\u00e9erlandaise)" },
            { "SY", "Syrie" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "\u00celes Turques-et-Ca\u00efques" },
            { "TD", "Tchad" },
            { "TF", "Terres australes fran\u00e7aises" },
            { "TG", "Togo" },
            { "TH", "Tha\u00eflande" },
            { "TJ", "Tadjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor oriental" },
            { "TM", "Turkm\u00e9nistan" },
            { "TN", "Tunisie" },
            { "TO", "Tonga" },
            { "TR", "Turquie" },
            { "TT", "Trinit\u00e9-et-Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Ta\u00efwan" },
            { "TZ", "Tanzanie" },
            { "UA", "Ukraine" },
            { "UG", "Ouganda" },
            { "UM", "\u00celes mineures \u00e9loign\u00e9es des \u00c9tats-Unis" },
            { "UN", "Nations Unies" },
            { "US", "\u00c9tats-Unis" },
            { "UY", "Uruguay" },
            { "UZ", "Ouzb\u00e9kistan" },
            { "VA", "\u00c9tat de la Cit\u00e9 du Vatican" },
            { "VC", "Saint-Vincent-et-les Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "\u00celes Vierges britanniques" },
            { "VI", "\u00celes Vierges des \u00c9tats-Unis" },
            { "VN", "Vi\u00eat Nam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis-et-Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudo-accents" },
            { "XB", "pseudo-bidi" },
            { "XK", "Kosovo" },
            { "YE", "Y\u00e9men" },
            { "YT", "Mayotte" },
            { "ZA", "Afrique du Sud" },
            { "ZM", "Zambie" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "r\u00e9gion ind\u00e9termin\u00e9e" },
            { "aa", "afar" },
            { "ab", "abkhaze" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharique" },
            { "an", "aragonais" },
            { "ar", metaValue_ar },
            { "as", "assamais" },
            { "av", "avar" },
            { "ay", "aymara" },
            { "az", "azerba\u00efdjanais" },
            { "ba", "bachkir" },
            { "be", "bi\u00e9lorusse" },
            { "bg", "bulgare" },
            { "bi", "bichelamar" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "breton" },
            { "bs", "bosniaque" },
            { "ca", "catalan" },
            { "ce", "tch\u00e9tch\u00e8ne" },
            { "ch", "chamorro" },
            { "co", "corse" },
            { "cr", "cree" },
            { "cs", "tch\u00e8que" },
            { "cu", "slavon d\u2019\u00e9glise" },
            { "cv", "tchouvache" },
            { "cy", "gallois" },
            { "da", "danois" },
            { "de", "allemand" },
            { "dv", "maldivien" },
            { "dz", "dzongkha" },
            { "ee", "\u00e9w\u00e9" },
            { "el", metaValue_el },
            { "en", "anglais" },
            { "eo", "esp\u00e9ranto" },
            { "es", "espagnol" },
            { "et", "estonien" },
            { "eu", "basque" },
            { "fa", "persan" },
            { "ff", "peul" },
            { "fi", "finnois" },
            { "fj", "fidjien" },
            { "fo", "f\u00e9ro\u00efen" },
            { "fr", "fran\u00e7ais" },
            { "fy", "frison occidental" },
            { "ga", "irlandais" },
            { "gd", "ga\u00e9lique \u00e9cossais" },
            { "gl", "galicien" },
            { "gn", "guarani" },
            { "gu", "goudjarati" },
            { "gv", "mannois" },
            { "ha", "haoussa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croate" },
            { "ht", "cr\u00e9ole ha\u00eftien" },
            { "hu", "hongrois" },
            { "hy", metaValue_hy },
            { "hz", "h\u00e9r\u00e9ro" },
            { "ia", "interlingua" },
            { "id", "indon\u00e9sien" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi du Sichuan" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islandais" },
            { "it", "italien" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kikongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazakh" },
            { "kl", "groenlandais" },
            { "km", metaValue_km },
            { "kn", "kannada" },
            { "ko", metaValue_ko },
            { "kr", "kanouri" },
            { "ks", "cachemiri" },
            { "ku", "kurde" },
            { "kv", "komi" },
            { "kw", "cornique" },
            { "ky", "kirghize" },
            { "la", metaValue_la },
            { "lb", "luxembourgeois" },
            { "lg", "ganda" },
            { "li", "limbourgeois" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituanien" },
            { "lu", "luba-katanga (kiluba)" },
            { "lv", "letton" },
            { "mg", "malgache" },
            { "mh", "marshallais" },
            { "mi", "maori" },
            { "mk", "mac\u00e9donien" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malais" },
            { "mt", "maltais" },
            { "my", metaValue_my },
            { "na", "nauruan" },
            { "nb", "norv\u00e9gien bokm\u00e5l" },
            { "nd", "nd\u00e9b\u00e9l\u00e9 du Nord" },
            { "ne", "n\u00e9palais" },
            { "ng", "ndonga" },
            { "nl", "n\u00e9erlandais" },
            { "nn", "norv\u00e9gien nynorsk" },
            { "no", "norv\u00e9gien" },
            { "nr", "nd\u00e9b\u00e9l\u00e9 du Sud" },
            { "nv", "navajo" },
            { "ny", "chewa" },
            { "oc", "occitan" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "oss\u00e8te" },
            { "pa", "pendjabi" },
            { "pi", "pali" },
            { "pl", "polonais" },
            { "ps", "pachto" },
            { "pt", "portugais" },
            { "qu", "quechua" },
            { "rm", "romanche" },
            { "rn", "roundi" },
            { "ro", "roumain" },
            { "ru", "russe" },
            { "rw", "kinyarwanda" },
            { "sa", "sanskrit" },
            { "sc", "sarde" },
            { "sd", "sindhi" },
            { "se", "same du Nord" },
            { "sg", "sango" },
            { "sh", "serbo-croate" },
            { "si", metaValue_si },
            { "sk", "slovaque" },
            { "sl", "slov\u00e8ne" },
            { "sm", "samoan" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albanais" },
            { "sr", "serbe" },
            { "ss", "swati" },
            { "st", "sotho du Sud" },
            { "su", "soundanais" },
            { "sv", "su\u00e9dois" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadjik" },
            { "th", metaValue_th },
            { "ti", "tigrigna" },
            { "tk", "turkm\u00e8ne" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tongien" },
            { "tr", "turc" },
            { "ts", "tsonga" },
            { "tt", "tatar" },
            { "tw", "twi" },
            { "ty", "tahitien" },
            { "ug", "ou\u00efghour" },
            { "uk", "ukrainien" },
            { "ur", "ourdou" },
            { "uz", "ouzbek" },
            { "ve", "venda" },
            { "vi", "vietnamien" },
            { "vo", "volap\u00fck" },
            { "wa", "wallon" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "chinois" },
            { "zu", "zoulou" },
            { "ace", "aceh" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adygu\u00e9en" },
            { "aeb", "arabe tunisien" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "a\u00efnou" },
            { "akk", "akkadien" },
            { "akz", "alabama" },
            { "ale", "al\u00e9oute" },
            { "aln", "gu\u00e8gue" },
            { "alt", "alta\u00ef du Sud" },
            { "ang", "ancien anglais" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aram\u00e9en" },
            { "arn", "mapuche" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "arabe alg\u00e9rien" },
            { "ars", "arabe najdi" },
            { "arw", "arawak" },
            { "ary", "arabe marocain" },
            { "arz", "arabe \u00e9gyptien" },
            { "asa", "asu" },
            { "ase", "langue des signes am\u00e9ricaine" },
            { "ast", "asturien" },
            { "atj", "atikamekw" },
            { "avk", "kotava" },
            { "awa", "awadhi" },
            { "bal", "baloutchi" },
            { "ban", metaValue_ban },
            { "bar", "bavarois" },
            { "bas", "bassa" },
            { "bax", "bamoun" },
            { "bbc", "batak toba" },
            { "bbj", "ghomala\u02bc" },
            { "bej", "bedja" },
            { "bem", "bemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "badaga" },
            { "bgc", "haryanvi" },
            { "bgn", "baloutchi occidental" },
            { "bho", "bhodjpouri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bjn", "banjar" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "bpy", "bishnupriya" },
            { "bqi", "bakhtiari" },
            { "bra", "braj" },
            { "brh", "brahoui" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "bouriate" },
            { "bug", "bugi" },
            { "bum", "boulou" },
            { "byn", "blin" },
            { "byv", "m\u00e9dumba" },
            { "cad", "caddo" },
            { "car", "caribe" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", "changma kodha" },
            { "ceb", "cebuano" },
            { "cgg", "kiga" },
            { "chb", "chibcha" },
            { "chg", "tchaghata\u00ef" },
            { "chk", "chuuk" },
            { "chm", "mari" },
            { "chn", "jargon chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "sorani" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "cps", "capiznon" },
            { "crg", "mitchif" },
            { "crh", "tatar de Crim\u00e9e" },
            { "crj", "cri de l\u2019Est (dialecte du Sud)" },
            { "crk", "cri des plaines" },
            { "crl", "cri de l\u2019Est (dialecte du Nord)" },
            { "crm", "cri de Moose" },
            { "crr", "algonquin de Caroline" },
            { "crs", "cr\u00e9ole seychellois" },
            { "csb", "kachoube" },
            { "csw", "cri des marais" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "esclave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "bas-sorabe" },
            { "dtp", "dusun central" },
            { "dua", "douala" },
            { "dum", "moyen n\u00e9erlandais" },
            { "dyo", "diola-fogny" },
            { "dyu", "dioula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "\u00e9fik" },
            { "egl", "\u00e9milien" },
            { "egy", "\u00e9gyptien ancien" },
            { "eka", "\u00e9kadjouk" },
            { "elx", "\u00e9lamite" },
            { "enm", "moyen anglais" },
            { "esu", "youpik central" },
            { "ewo", "\u00e9wondo" },
            { "ext", "estr\u00e9m\u00e8gne" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fit", "finnois torn\u00e9dalien" },
            { "fon", "fon" },
            { "frc", "fran\u00e7ais cadien" },
            { "frm", "moyen fran\u00e7ais" },
            { "fro", "ancien fran\u00e7ais" },
            { "frp", "francoproven\u00e7al" },
            { "frr", "frison septentrional" },
            { "frs", "frison oriental" },
            { "fur", "frioulan" },
            { "gaa", "ga" },
            { "gag", "gagaouze" },
            { "gan", "gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gbz", "dari zoroastrien" },
            { "gez", "gu\u00e8ze" },
            { "gil", "gilbertin" },
            { "glk", "gilaki" },
            { "gmh", "moyen haut-allemand" },
            { "goh", "ancien haut allemand" },
            { "gom", "konkani de Goa" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "grec ancien" },
            { "gsw", "suisse allemand" },
            { "guc", "wayuu" },
            { "gur", "gurenne" },
            { "guz", "gusii" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "ha\u00efda" },
            { "hak", "hakka" },
            { "haw", "hawa\u00efen" },
            { "hax", "ha\u00efda du Sud" },
            { "hif", "hindi fidjien" },
            { "hil", "hiligaynon" },
            { "hit", "hittite" },
            { "hmn", "hmong" },
            { "hsb", "haut-sorabe" },
            { "hsn", "xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut de l\u2019Ouest canadien" },
            { "ilo", "ilocano" },
            { "inh", "ingouche" },
            { "izh", "ingrien" },
            { "jam", "cr\u00e9ole jama\u00efcain" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "matcham\u00e9" },
            { "jpr", "jud\u00e9o-persan" },
            { "jrb", "jud\u00e9o-arabe" },
            { "jut", "jute" },
            { "kaa", "karakalpak" },
            { "kab", "kabyle" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabarde" },
            { "kbl", "kanembou" },
            { "kcg", "tyap" },
            { "kde", "makond\u00e9" },
            { "kea", "capverdien" },
            { "ken", "k\u00e9nyang" },
            { "kfo", "koro" },
            { "kgp", "caingangue" },
            { "kha", "khasi" },
            { "kho", "khotanais" },
            { "khq", "koyra chiini" },
            { "khw", "khowar" },
            { "kiu", "kirmanjki" },
            { "kkj", "kako" },
            { "kln", "kalendjin" },
            { "kmb", "kimboundou" },
            { "koi", "komi-permiak" },
            { "kok", "konkani" },
            { "kos", "kosra\u00e9en" },
            { "kpe", "kpell\u00e9" },
            { "krc", "karatcha\u00ef balkar" },
            { "kri", "krio" },
            { "krj", "kinaray-a" },
            { "krl", "car\u00e9lien" },
            { "kru", "kouroukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f6lsch" },
            { "kum", "koumyk" },
            { "kut", "kutenai" },
            { "kwk", "kwak\u2019wala" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghien" },
            { "lfn", "lingua franca nova" },
            { "lij", "ligure" },
            { "lil", "lillooet" },
            { "liv", "livonien" },
            { "lkt", "lakota" },
            { "lmo", "lombard" },
            { "lol", "mongo" },
            { "lou", "cr\u00e9ole louisianais" },
            { "loz", "lozi" },
            { "lrc", "lori du Nord" },
            { "lsm", "samia" },
            { "ltg", "latgalien" },
            { "lua", "luba-kasa\u00ef (ciluba)" },
            { "lui", "luise\u00f1o" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lusha\u00ef" },
            { "luy", "luyia" },
            { "lzh", "chinois litt\u00e9raire" },
            { "lzz", "laze" },
            { "mad", "madurais" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "ma\u00efthili" },
            { "mak", "makassar" },
            { "man", "mandingue" },
            { "mas", "maasa\u00ef" },
            { "mde", "maba" },
            { "mdf", "mokcha" },
            { "mdr", "mandar" },
            { "men", "mend\u00e9" },
            { "mer", "meru" },
            { "mfe", "cr\u00e9ole mauricien" },
            { "mga", "moyen irlandais" },
            { "mgh", "makua" },
            { "mgo", "meta\u02bc" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "mandchou" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mor\u00e9" },
            { "mrj", "mari occidental" },
            { "mua", "moundang" },
            { "mul", "multilingue" },
            { "mus", "creek" },
            { "mwl", "mirandais" },
            { "mwr", "marwar\u00ee" },
            { "mwv", "mentawa\u00ef" },
            { "mye", "my\u00e8n\u00e8" },
            { "myv", "erzya" },
            { "mzn", "mazand\u00e9rani" },
            { "nan", "minnan" },
            { "nap", "napolitain" },
            { "naq", "nama" },
            { "nds", "bas-allemand" },
            { "new", "newari" },
            { "nia", "niha" },
            { "niu", "niu\u00e9en" },
            { "njo", "Ao" },
            { "nmg", "ngoumba" },
            { "nnh", "ngiemboon" },
            { "nog", "noga\u00ef" },
            { "non", "vieux norrois" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho du Nord" },
            { "nus", "nuer" },
            { "nwc", "newar\u00ee classique" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankol\u00e9" },
            { "nyo", "nyoro" },
            { "nzi", "nzema" },
            { "ojb", "ojibw\u00e9 du Nord-Ouest" },
            { "ojc", "ojibw\u00e9 central" },
            { "ojs", "oji-cri" },
            { "ojw", "ojibw\u00e9 occidental" },
            { "oka", "colville-okanagan" },
            { "osa", "osage" },
            { "ota", "turc ottoman" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampangan" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "pcd", "picard" },
            { "pcm", "pidgin nig\u00e9rian" },
            { "pdc", "pennsilfaanisch" },
            { "pdt", "bas-prussien" },
            { "peo", "persan ancien" },
            { "pfl", "allemand palatin" },
            { "phn", metaValue_phn },
            { "pis", "pijin" },
            { "pms", "pi\u00e9montais" },
            { "pnt", "pontique" },
            { "pon", "pohnpei" },
            { "pqm", "mal\u00e9cite-passamaquoddy" },
            { "prg", "prussien" },
            { "pro", "proven\u00e7al ancien" },
            { "quc", "quich\u00e9" },
            { "qug", "quichua du Haut-Chimborazo" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongien" },
            { "rgn", "romagnol" },
            { "rhg", "rohingya" },
            { "rif", "rifain" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rtm", "rotuman" },
            { "rue", "ruth\u00e8ne" },
            { "rug", "roviana" },
            { "rup", "aroumain" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "iakoute" },
            { "sam", "aram\u00e9en samaritain" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "saz", metaValue_saz },
            { "sba", "ngambay" },
            { "sbp", "isangu" },
            { "scn", "sicilien" },
            { "sco", "\u00e9cossais" },
            { "sdc", "sarde sassarais" },
            { "sdh", "kurde du Sud" },
            { "see", "seneca" },
            { "seh", "cisena" },
            { "sei", "s\u00e9ri" },
            { "sel", "selkoupe" },
            { "ses", "koyraboro senni" },
            { "sga", "ancien irlandais" },
            { "sgs", "samogitien" },
            { "shi", "chleuh" },
            { "shn", "shan" },
            { "shu", "arabe tchadien" },
            { "sid", "sidamo" },
            { "slh", "lushootseed du Sud" },
            { "sli", "bas-sil\u00e9sien" },
            { "sly", "s\u00e9layar" },
            { "sma", "same du Sud" },
            { "smj", "same de Lule" },
            { "smn", "same d\u2019Inari" },
            { "sms", "same skolt" },
            { "snk", "sonink\u00e9" },
            { "sog", "sogdien" },
            { "srn", "sranan tongo" },
            { "srr", "s\u00e9r\u00e8re" },
            { "ssy", "saho" },
            { "stq", "saterlandais" },
            { "str", "salish des d\u00e9troits" },
            { "suk", "soukouma" },
            { "sus", "soussou" },
            { "sux", "sum\u00e9rien" },
            { "swb", "comorien" },
            { "syc", "syriaque classique" },
            { "syr", metaValue_syr },
            { "szl", "sil\u00e9sien" },
            { "tce", "tutchone du Sud" },
            { "tcy", "toulou" },
            { "tem", "timn\u00e9" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "t\u00e9toum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigr\u00e9" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tkr", "tsakhour" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tly", "talysh" },
            { "tmh", "tamacheq" },
            { "tog", "tonga nyasa" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "tru", "touroyo" },
            { "trv", "taroko" },
            { "tsd", "tsakonien" },
            { "tsi", "tsimshian" },
            { "ttm", "tutchone du Nord" },
            { "ttt", "tati caucasien" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "touvain" },
            { "tzm", "amazighe de l\u2019Atlas central" },
            { "udm", "oudmourte" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "langue ind\u00e9termin\u00e9e" },
            { "vai", metaValue_vai },
            { "vec", "v\u00e9nitien" },
            { "vep", "vepse" },
            { "vls", "flamand occidental" },
            { "vmf", "franconien du Main" },
            { "vot", "vote" },
            { "vro", "v\u00f5ro" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "kalmouk" },
            { "xmf", "mingr\u00e9lien" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yapois" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatou" },
            { "yue", "cantonais" },
            { "zap", "zapot\u00e8que" },
            { "zbl", metaValue_zbl },
            { "zea", "z\u00e9landais" },
            { "zen", "zenaga" },
            { "zgh", "amazighe standard marocain" },
            { "zun", "zu\u00f1i" },
            { "zxx", "sans contenu linguistique" },
            { "zza", "zazaki" },
            { "Adlm", "adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armi", "aram\u00e9en imp\u00e9rial" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Blis", metaValue_zbl },
            { "Bopo", "bopomofo" },
            { "Brah", "br\u00e2hm\u00ee" },
            { "Brai", "braille" },
            { "Bugi", "bouguis" },
            { "Buhd", "bouhide" },
            { "Cakm", "chakma" },
            { "Cans", "syllabaire autochtone canadien unifi\u00e9" },
            { "Cari", "carien" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Cirt", "cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "syllabaire chypriote" },
            { "Cyrl", "cyrillique" },
            { "Cyrs", "cyrillique (variante slavonne)" },
            { "Deva", "d\u00e9vanagari" },
            { "Dsrt", "d\u00e9s\u00e9ret" },
            { "Egyd", "d\u00e9motique \u00e9gyptien" },
            { "Egyh", "hi\u00e9ratique \u00e9gyptien" },
            { "Egyp", "hi\u00e9roglyphes \u00e9gyptiens" },
            { "Elym", "\u00e9lyma\u00efque" },
            { "Ethi", "\u00e9thiopique" },
            { "Geok", "g\u00e9orgien khoutsouri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolitique" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", "goudjar\u00e2t\u00ee" },
            { "Guru", "gourmoukh\u00ee" },
            { "Hanb", "han avec bopomofo" },
            { "Hang", "hang\u00fbl" },
            { "Hani", "sinogrammes" },
            { "Hano", "hanoun\u00f3o" },
            { "Hans", "simplifi\u00e9" },
            { "Hant", "traditionnel" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "Hrkt", "katakana ou hiragana" },
            { "Hung", "ancien hongrois" },
            { "Inds", "indus" },
            { "Ital", "ancien italique" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharochth\u00ee" },
            { "Khmr", metaValue_km },
            { "Knda", "kannara" },
            { "Kore", metaValue_ko },
            { "Kthi", "kaith\u00ee" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "latin (variante bris\u00e9e)" },
            { "Latg", "latin (variante ga\u00e9lique)" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbou" },
            { "Lina", "lin\u00e9aire A" },
            { "Linb", "lin\u00e9aire B" },
            { "Lyci", "lycien" },
            { "Lydi", "lydien" },
            { "Mand", "mand\u00e9en" },
            { "Mani", "manich\u00e9en" },
            { "Maya", "hi\u00e9roglyphes mayas" },
            { "Mero", "m\u00e9ro\u00eftique" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mtei", "meitei mayek" },
            { "Mymr", metaValue_my },
            { "Nand", "nandinagari" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ogam" },
            { "Olck", "ol-chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osma", "osmanais" },
            { "Perm", "ancien permien" },
            { "Phag", "phags pa" },
            { "Phli", "pehlevi des inscriptions" },
            { "Phlp", "pehlevi des psautiers" },
            { "Phlv", "pehlevi des livres" },
            { "Phnx", metaValue_phn },
            { "Plrd", "phon\u00e9tique de Pollard" },
            { "Prti", "parthe des inscriptions" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "runique" },
            { "Samr", "samaritain" },
            { "Sara", "sarati" },
            { "Saur", metaValue_saz },
            { "Sgnw", "\u00e9criture des signes" },
            { "Shaw", "shavien" },
            { "Sinh", metaValue_si },
            { "Sund", "sundanais" },
            { "Sylo", "sylot\u00ee n\u00e2gr\u00ee" },
            { "Syrc", metaValue_syr },
            { "Syre", "syriaque estrangh\u00e9lo" },
            { "Syrj", "syriaque occidental" },
            { "Syrn", "syriaque oriental" },
            { "Tagb", "tagbanoua" },
            { "Tale", "ta\u00ef-le" },
            { "Talu", "nouveau ta\u00ef-lue" },
            { "Taml", metaValue_ta },
            { "Tavt", "ta\u00ef vi\u00eat" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", "tagal" },
            { "Thaa", "th\u00e2na" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "parole visible" },
            { "Wcho", "wantcho" },
            { "Xpeo", "cun\u00e9iforme pers\u00e9politain" },
            { "Xsux", "cun\u00e9iforme sum\u00e9ro-akkadien" },
            { "Yiii", "yi" },
            { "Zinh", "h\u00e9rit\u00e9" },
            { "Zmth", "notation math\u00e9matique" },
            { "Zsye", "emoji" },
            { "Zsym", "symboles" },
            { "Zxxx", "non \u00e9crit" },
            { "Zyyy", "commun" },
            { "Zzzz", "\u00e9criture inconnue" },
            { "de_AT", "allemand autrichien" },
            { "de_CH", "allemand suisse" },
            { "en_AU", "anglais australien" },
            { "en_CA", "anglais canadien" },
            { "en_GB", "anglais britannique" },
            { "en_US", "anglais am\u00e9ricain" },
            { "es_ES", "espagnol d\u2019Espagne" },
            { "es_MX", "espagnol du Mexique" },
            { "fa_AF", "dari" },
            { "fr_CA", "fran\u00e7ais canadien" },
            { "fr_CH", "fran\u00e7ais suisse" },
            { "nl_BE", "flamand" },
            { "pt_BR", "portugais br\u00e9silien" },
            { "pt_PT", "portugais europ\u00e9en" },
            { "ro_MD", "moldave" },
            { "sw_CD", "swahili du Congo" },
            { "%%1901", "orthographe allemande traditionnelle" },
            { "%%1994", "orthographe normalis\u00e9e de Resia" },
            { "%%1996", "orthographe allemande de 1996" },
            { "ar_001", "arabe standard moderne" },
            { "es_419", "espagnol d\u2019Am\u00e9rique latine" },
            { "key.ca", "calendrier" },
            { "key.cf", "format de devise" },
            { "key.co", "ordre de tri" },
            { "key.cu", "devise" },
            { "key.hc", "syst\u00e8me horaire (12 ou 24 heures)" },
            { "key.lb", "style de saut de ligne" },
            { "key.ms", "syst\u00e8me de mesure" },
            { "key.nu", "nombres" },
            { "key.tz", "fuseau horaire" },
            { "key.va", "variante locale" },
            { "nds_NL", "bas-saxon n\u00e9erlandais" },
            { "%%BISKE", "dialecte de San Giorgio / Bila" },
            { "%%BOONT", "dialecte boontling" },
            { "%%LIPAW", "dialecte lipovaz de Resia" },
            { "%%NEDIS", "dialecte de Natisone" },
            { "%%NJIVA", "dialecte de Gniva / Njiva" },
            { "%%OSOJS", "dialecte d\u2019Oseacco / Osojane" },
            { "%%POSIX", "informatique" },
            { "%%ROZAJ", "dialecte de Resia" },
            { "%%SAAHO", "dialecte saho" },
            { "%%SOLBA", "dialecte de Stolvizza / Solbica" },
            { "zh_Hans", "chinois simplifi\u00e9" },
            { "zh_Hant", "chinois traditionnel" },
            { "%%FONIPA", "alphabet phon\u00e9tique international" },
            { "%%FONUPA", "alphabet phon\u00e9tique ouralique" },
            { "%%PINYIN", "pinyin" },
            { "%%SCOUSE", "dialecte scouse" },
            { "%%TARASK", "orthographe taraskievica" },
            { "%%AREVELA", "arm\u00e9nien oriental" },
            { "%%AREVMDA", "arm\u00e9nien occidental" },
            { "%%MONOTON", "monotonique" },
            { "%%POLYTON", "polytonique" },
            { "%%REVISED", "orthographe r\u00e9vis\u00e9e" },
            { "%%1606NICT", "fran\u00e7oys de 1606" },
            { "%%1694ACAD", "fran\u00e7ois acad\u00e9mique de 1694" },
            { "%%BAKU1926", "alphabet latin alta\u00efque unifi\u00e9" },
            { "%%SCOTLAND", "anglais standard \u00e9cossais" },
            { "%%VALENCIA", "valencien" },
            { "%%WADEGILE", "Wade-Giles" },
            { "type.ca.roc", "calendrier r\u00e9publicain chinois" },
            { "type.co.eor", "r\u00e8gles de classement europ\u00e9en" },
            { "type.hc.h11", "syst\u00e8me horaire de 12 heures (0\u201311)" },
            { "type.hc.h12", "syst\u00e8me horaire de 12 heures (1\u201312)" },
            { "type.hc.h23", "syst\u00e8me horaire de 24 heures (0\u201323)" },
            { "type.hc.h24", "syst\u00e8me horaire de 24 heures (1\u201324)" },
            { "type.m0.bgn", "BGN" },
            { "type.nu.arab", "chiffres arabes" },
            { "type.nu.armn", "chiffres arm\u00e9niens" },
            { "type.nu.beng", "chiffres bengalis" },
            { "type.nu.cakm", "chiffres chakmas" },
            { "type.nu.deva", "chiffres d\u00e9vanagaris" },
            { "type.nu.ethi", "chiffres \u00e9thiopiens" },
            { "type.nu.geor", "chiffres g\u00e9orgiens" },
            { "type.nu.grek", "chiffres grecs" },
            { "type.nu.gujr", "chiffres goudjar\u00e2t\u00ees" },
            { "type.nu.guru", "chiffres gourmoukh\u00ees" },
            { "type.nu.hans", "chiffres en chinois simplifi\u00e9" },
            { "type.nu.hant", "chiffres en chinois traditionnel" },
            { "type.nu.hebr", "chiffres h\u00e9breux" },
            { "type.nu.hmnp", "chiffres nyiakeng puachue hmong" },
            { "type.nu.java", "chiffres javanais" },
            { "type.nu.jpan", "chiffres japonais" },
            { "type.nu.khmr", "chiffres khmers" },
            { "type.nu.knda", "chiffres en kannada" },
            { "type.nu.laoo", "chiffres laotiens" },
            { "type.nu.latn", "chiffres occidentaux" },
            { "type.nu.mlym", "chiffres malay\u00e2lams" },
            { "type.nu.mong", "chiffres mongols" },
            { "type.nu.mtei", "chiffres meitei-mayeks" },
            { "type.nu.mymr", "chiffres birmans" },
            { "type.nu.olck", "chiffres ol-chikis" },
            { "type.nu.orya", "chiffres oriyas" },
            { "type.nu.taml", "chiffres tamouls traditionnels" },
            { "type.nu.telu", "chiffres t\u00e9lougous" },
            { "type.nu.thai", "chiffres tha\u00efs" },
            { "type.nu.tibt", "chiffres tib\u00e9tains" },
            { "type.nu.vaii", "chiffres en va\u00ef" },
            { "type.nu.wcho", "chiffres wantcho" },
            { "type.ca.dangi", "calendrier dangi" },
            { "type.co.ducet", "ordre de tri Unicode par d\u00e9faut" },
            { "type.lb.loose", "style de saut de ligne permissif" },
            { "type.nu.roman", "chiffres romains" },
            { "type.ca.coptic", "calendrier copte" },
            { "type.ca.hebrew", "calendrier h\u00e9bra\u00efque" },
            { "type.ca.indian", "calendrier indien" },
            { "type.co.compat", "ancien ordre de tri pour compatibilit\u00e9" },
            { "type.co.pinyin", "ordre pinyin" },
            { "type.co.search", "recherche g\u00e9n\u00e9rique" },
            { "type.co.stroke", "ordre des traits" },
            { "type.co.unihan", "ordre de tri radical-traits" },
            { "type.co.zhuyin", "ordre zhuyin" },
            { "type.d0.fwidth", "en pleine chasse" },
            { "type.d0.hwidth", "en demi-chasse" },
            { "type.lb.normal", "style de saut de ligne normal" },
            { "type.lb.strict", "style de saut de ligne strict" },
            { "type.m0.ungegn", "UNGEGN" },
            { "type.ms.metric", "syst\u00e8me m\u00e9trique" },
            { "type.nu.native", "chiffres natifs" },
            { "type.ca.chinese", "calendrier chinois" },
            { "type.ca.islamic", "calendrier h\u00e9girien" },
            { "type.ca.iso8601", "calendrier ISO 8601" },
            { "type.ca.persian", "calendrier persan" },
            { "type.cf.account", "format de devise comptable" },
            { "type.co.big5han", "ordre chinois traditionnel - Big5" },
            { "type.d0.npinyin", "Num\u00e9rique" },
            { "type.nu.arabext", "chiffres arabes \u00e9tendus" },
            { "type.nu.armnlow", "chiffres arm\u00e9niens minuscules" },
            { "type.nu.finance", "Chiffres financiers" },
            { "type.nu.greklow", "chiffres grecs minuscules" },
            { "type.nu.hanidec", "nombres d\u00e9cimaux chinois" },
            { "type.nu.hansfin", "chiffres financiers en chinois simplifi\u00e9" },
            { "type.nu.hantfin", "chiffres financiers en chinois traditionnel" },
            { "type.nu.jpanfin", "chiffres japonais financiers" },
            { "type.nu.tamldec", "chiffres tamouls" },
            { "type.ca.buddhist", "calendrier bouddhiste" },
            { "type.ca.ethiopic", "calendrier \u00e9thiopien" },
            { "type.ca.japanese", "calendrier japonais" },
            { "type.cf.standard", "format de devise standard" },
            { "type.co.phonetic", "ordre de tri phon\u00e9tique" },
            { "type.co.reformed", "ordre r\u00e9form\u00e9" },
            { "type.co.searchjl", "rechercher par consonne initiale en hangeul" },
            { "type.co.standard", "ordre de tri standard" },
            { "type.ms.uksystem", "syst\u00e8me imp\u00e9rial" },
            { "type.ms.ussystem", "syst\u00e8me am\u00e9ricain" },
            { "type.nu.fullwide", "chiffres pleine chasse" },
            { "type.nu.romanlow", "chiffres romains minuscules" },
            { "type.ca.gregorian", "calendrier gr\u00e9gorien" },
            { "type.co.gb2312han", "ordre chinois simplifi\u00e9 - GB2312" },
            { "type.co.phonebook", "ordre de l\u2019annuaire" },
            { "ListKeyTypePattern", "{0}\u202f: {1}" },
            { "type.co.dictionary", "ordre du dictionnaire" },
            { "type.co.traditional", "ordre traditionnel" },
            { "type.nu.traditional", "Chiffres traditionnels" },
            { "type.ca.islamic-tbla", "calendrier h\u00e9girien (tabulaire, \u00e9poque astronomique)" },
            { "type.ca.islamic-civil", "calendrier h\u00e9girien (tabulaire, \u00e9poque civile)" },
            { "type.ca.islamic-umalqura", "calendrier h\u00e9girien (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "calendrier \u00e9thiopien Amete Alem" },
        };
        return data;
    }
}
