/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_tt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u0433\u0430\u0440\u04d9\u043f";
        final String metaValue_la = "\u043b\u0430\u0442\u0438\u043d";
        final Object[][] data = new Object[][] {
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "ban", "\u0431\u0430\u043b\u0438" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u0411\u0435\u0440\u043b\u04d9\u0448\u043a\u04d9\u043d \u0413\u0430\u0440\u04d9\u043f \u04d8\u043c\u0438\u0440\u043b\u0435\u043a\u043b\u04d9\u0440\u0435" },
            { "AF", "\u04d8\u0444\u0433\u0430\u043d\u0441\u0442\u0430\u043d" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u0430\u043d\u0441" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u04bb\u04d9\u043c \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "AI", "\u0410\u043d\u0433\u0438\u043b\u044c\u044f" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438\u044f" },
            { "AM", "\u04d8\u0440\u043c\u04d9\u043d\u0441\u0442\u0430\u043d" },
            { "am", "\u0430\u043c\u0445\u0430\u0440" },
            { "Arab", metaValue_ar },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u043a\u0430" },
            { "ar", metaValue_ar },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0421\u0430\u043c\u043e\u0430\u0441\u044b" },
            { "as", "\u0430\u0441\u0441\u0430\u043c" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "AZ", "\u04d8\u0437\u04d9\u0440\u0431\u0430\u0439\u0497\u0430\u043d" },
            { "az", "\u04d9\u0437\u04d9\u0440\u0431\u0430\u0439\u0497\u0430\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438\u044f \u04bb\u04d9\u043c \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430" },
            { "ba", "\u0431\u0430\u0448\u043a\u043e\u0440\u0442" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u043e" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0438\u044f" },
            { "be", "\u0431\u0435\u043b\u043e\u0440\u0443\u0441" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430-\u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f" },
            { "bg", "\u0431\u043e\u043b\u0433\u0430\u0440" },
            { "BH", "\u0411\u04d9\u0445\u0440\u04d9\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u0435\u043b\u044c\u043c\u0438" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439" },
            { "bn", "\u0431\u0435\u043d\u0433\u0430\u043b\u0438" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438\u044f" },
            { "bo", "\u0442\u0438\u0431\u0435\u0442" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f" },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "bs", "\u0431\u043e\u0441\u043d\u0438\u044f" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0411\u0443\u0432\u0435 \u0443\u0442\u0440\u0430\u0432\u044b" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "BY", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u0430\u043d" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u043b\u0438\u043d\u0433) \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "CF", "\u04ae\u0437\u04d9\u043a \u0410\u0444\u0440\u0438\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f" },
            { "CI", "\u041a\u043e\u0442-\u0434\u2019\u0418\u0432\u0443\u0430\u0440" },
            { "CK", "\u041a\u0443\u043a \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u041a\u044b\u0442\u0430\u0439" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u044f" },
            { "co", "\u043a\u043e\u0440\u0441\u0438\u043a\u0430" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430" },
            { "cs", "\u0447\u0435\u0445" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u044e\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u0420\u0430\u0448\u0442\u0443\u0430 \u0443\u0442\u0440\u0430\u0432\u044b" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "cy", "\u0443\u044d\u043b\u044c\u0441" },
            { "CZ", "\u0427\u0435\u0445\u0438\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b" },
            { "da", "\u0434\u0430\u043d\u0438\u044f" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f" },
            { "de", "\u0430\u043b\u043c\u0430\u043d" },
            { "DJ", "\u0496\u0438\u0431\u04af\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438\u044f" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "DO", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "dv", "\u043c\u0430\u043b\u044c\u0434\u0438\u0432" },
            { "es_419", "\u0438\u0441\u043f\u0430\u043d (\u041b\u0430\u0442\u0438\u043d \u0410\u043c\u0435\u0440\u0438\u043a\u0430\u0441\u044b)" },
            { "DZ", "\u0410\u043b\u0436\u0438\u0440" },
            { "dz", "\u0434\u0437\u043e\u043d\u0433-\u043a\u0445\u0430" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "pap", "\u043f\u0430\u043f\u044c\u044f\u043c\u0435\u043d\u0442\u043e" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0438\u044f" },
            { "EG", "\u041c\u0438\u0441\u044b\u0440" },
            { "el", "\u0433\u0440\u0435\u043a" },
            { "en", "\u0438\u043d\u0433\u043b\u0438\u0437" },
            { "chm", "\u043c\u0430\u0440\u0438" },
            { "eo", "\u044d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "chr", "\u0447\u0435\u0440\u043e\u043a\u0438" },
            { "ER", "\u042d\u0440\u0438\u0442\u0440\u0435\u044f" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438\u044f" },
            { "es", "\u0438\u0441\u043f\u0430\u043d" },
            { "ET", "\u042d\u0444\u0438\u043e\u043f\u0438\u044f" },
            { "et", "\u044d\u0441\u0442\u043e\u043d" },
            { "eu", "\u0431\u0430\u0441\u043a" },
            { "type.ca.gregorian", "\u0433\u0440\u0438\u0433\u043e\u0440\u0438\u0430\u043d \u0435\u043b \u0438\u0441\u04d9\u0431\u0435" },
            { "hsb", "\u044e\u0433\u0430\u0440\u044b \u0441\u043e\u0440\u0431" },
            { "fa", "\u0444\u0430\u0440\u0441\u044b" },
            { "Hans", "\u0433\u0430\u0434\u0438\u043b\u04d9\u0448\u0442\u0435\u0440\u0435\u043b\u0433\u04d9\u043d" },
            { "type.nu.latn", "\u043a\u04e9\u043d\u0431\u0430\u0442\u044b\u0448 \u0446\u0438\u0444\u0440\u043b\u0430\u0440\u044b" },
            { "Hant", "\u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d" },
            { "ff", "\u0444\u0443\u043b\u0430" },
            { "FI", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f" },
            { "fi", "\u0444\u0438\u043d" },
            { "FJ", "\u0424\u0438\u0434\u0436\u0438" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "FO", "\u0424\u0430\u0440\u0435\u0440 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "fo", "\u0444\u0430\u0440\u0435\u0440" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u0438\u044f" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "ga", "\u0438\u0440\u043b\u0430\u043d\u0434" },
            { "GB", "\u0411\u04e9\u0435\u043a\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u044f" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "gd", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434 \u0433\u044d\u043b\u044c" },
            { "GE", "\u0413\u0440\u0443\u0437\u0438\u044f" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437 \u0413\u0432\u0438\u0430\u043d\u0430\u0441\u044b" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "gl", "\u0433\u0430\u043b\u0438\u0441\u0438\u044f" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438\u044f" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u044f" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b\u044c \u0413\u0432\u0438\u043d\u0435\u044f" },
            { "und", "\u0431\u0438\u043b\u0433\u0435\u0441\u0435\u0437 \u0442\u0435\u043b" },
            { "GR", "\u0413\u0440\u0435\u0446\u0438\u044f" },
            { "GS", "\u041a\u04e9\u043d\u044c\u044f\u043a \u0413\u0435\u043e\u0440\u0433\u0438\u044f \u04bb\u04d9\u043c \u041a\u04e9\u043d\u044c\u044f\u043a \u0421\u0430\u043d\u0434\u0432\u0438\u0447 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "gu", "\u0433\u0443\u0497\u0430\u0440\u0430\u0442\u0438" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u044f-\u0411\u0438\u0441\u0430\u0443" },
            { "GY", "\u0413\u0430\u0439\u0430\u043d\u0430" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "ckb", "\u04af\u0437\u04d9\u043a \u043a\u04e9\u0440\u0434" },
            { "he", "\u044f\u04bb\u04af\u0434" },
            { "hi", "\u04bb\u0438\u043d\u0434" },
            { "HK", "\u0413\u043e\u043d\u043a\u043e\u043d\u0433 \u041c\u0430\u0445\u0441\u0443\u0441 \u0418\u0434\u0430\u0440\u04d9\u043b\u0435 \u0422\u04e9\u0431\u04d9\u0433\u0435" },
            { "HM", "\u0425\u0435\u0440\u0434 \u0443\u0442\u0440\u0430\u0432\u044b \u04bb\u04d9\u043c \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442\u0438\u044f" },
            { "hr", "\u0445\u043e\u0440\u0432\u0430\u0442" },
            { "HT", "\u0413\u0430\u0438\u0442\u0438" },
            { "ht", "\u0433\u0430\u0438\u0442\u0438 \u043a\u0440\u0435\u043e\u043b" },
            { "HU", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f" },
            { "hu", "\u0432\u0435\u043d\u0433\u0440" },
            { "hy", "\u04d9\u0440\u043c\u04d9\u043d" },
            { "hz", "\u0433\u0435\u0440\u0435\u0440\u043e" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "IL", "\u0418\u0437\u0440\u0430\u0438\u043b\u044c" },
            { "IM", "\u041c\u044d\u043d \u0443\u0442\u0440\u0430\u0432\u044b" },
            { "IN", "\u0418\u043d\u0434\u0438\u044f" },
            { "IO", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f\u043d\u0435\u04a3 \u04ba\u0438\u043d\u0434 \u041e\u043a\u0435\u0430\u043d\u044b\u043d\u0434\u0430\u0433\u044b \u0422\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f\u0441\u0435" },
            { "IQ", "\u0413\u044b\u0439\u0440\u0430\u043a" },
            { "IR", "\u0418\u0440\u0430\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438\u044f" },
            { "it", "\u0438\u0442\u0430\u043b\u044c\u044f\u043d" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u043a\u0443\u0442" },
            { "ja", "\u044f\u043f\u043e\u043d" },
            { "JE", "\u0414\u0436\u0435\u0440\u0441\u0438" },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "JO", "\u0418\u043e\u0440\u0434\u0430\u043d\u0438\u044f" },
            { "JP", "\u042f\u043f\u043e\u043d\u0438\u044f" },
            { "sma", "\u043a\u04e9\u043d\u044c\u044f\u043a \u0441\u0430\u0430\u043c" },
            { "smj", "\u043b\u0443\u043b\u0435-\u0441\u0430\u0430\u043c" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438-\u0441\u0430\u0430\u043c" },
            { "ka", "\u0433\u0440\u0443\u0437\u0438\u043d" },
            { "sms", "\u043a\u043e\u043b\u0442\u0442\u0430-\u0441\u0430\u0430\u043c" },
            { "KE", "\u041a\u0435\u043d\u0438\u044f" },
            { "KG", "\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "kk", "\u043a\u0430\u0437\u0430\u043a\u044a" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "km", "\u043a\u0445\u043c\u0435\u0440" },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u04bb\u04d9\u043c \u041d\u0435\u0432\u0438\u0441" },
            { "kn", "\u043a\u0430\u043d\u043d\u0430\u0434\u0430" },
            { "ko", "\u043a\u043e\u0440\u0435\u044f" },
            { "KP", "\u0422\u04e9\u043d\u044c\u044f\u043a \u041a\u043e\u0440\u0435\u044f" },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u0438" },
            { "ks", "\u043a\u0430\u0448\u043c\u0438\u0440\u0438" },
            { "ku", "\u043a\u04e9\u0440\u0434" },
            { "KW", "\u041a\u04af\u0432\u04d9\u0439\u0442" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "ky", "\u043a\u044b\u0440\u0433\u044b\u0437" },
            { "KZ", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d" },
            { "Cyrl", "\u043a\u0438\u0440\u0438\u043b\u043b" },
            { "la", metaValue_la },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0432\u0430\u043d" },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438\u044f" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "LK", "\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430" },
            { "lo", "\u043b\u0430\u043e\u0441" },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438\u044f" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "lt", "\u043b\u0438\u0442\u0432\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438\u044f" },
            { "lv", "\u043b\u0430\u0442\u044b\u0448" },
            { "LY", "\u041b\u0438\u0432\u0438\u044f" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u043a\u043e" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u043e\u0432\u0430" },
            { "ME", "\u0427\u0435\u0440\u043d\u043e\u0433\u043e\u0440\u0438\u044f" },
            { "MF", "\u0421\u0435\u043d\u0442-\u041c\u0430\u0440\u0442\u0438\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0438" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u043b \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "mi", "\u043c\u0430\u043e\u0440\u0438" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "ml", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u044f" },
            { "mn", "\u043c\u043e\u043d\u0433\u043e\u043b" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e \u041c\u0430\u0445\u0441\u0443\u0441 \u0418\u0434\u0430\u0440\u04d9\u043b\u0435 \u0422\u04e9\u0431\u04d9\u0433\u0435" },
            { "MP", "\u0422\u04e9\u043d\u044c\u044f\u043a \u041c\u0430\u0440\u0438\u0430\u043d\u0430 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a\u0430" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0445\u0438" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "mt", "\u043c\u0430\u043b\u044c\u0442\u0430" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u0438\u0432 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u044f" },
            { "my", "\u0431\u0438\u0440\u043c\u0430" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "dsb", "\u0442\u04af\u0431\u04d9\u043d \u0441\u043e\u0440\u0431" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438\u044f" },
            { "NC", "\u042f\u04a3\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b\u0438" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0443\u0442\u0440\u0430\u0432\u044b" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438\u044f" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434" },
            { "nl", "\u0433\u043e\u043b\u043b\u0430\u043d\u0434" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0438\u044f" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u044d" },
            { "ny", "\u043d\u044c\u044f\u043d\u0497\u0430" },
            { "NZ", "\u042f\u04a3\u0430 \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d" },
            { "men", "\u043c\u0435\u043d\u0434\u0435" },
            { "OM", "\u041e\u043c\u0430\u043d" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "or", "\u043e\u0440\u0438\u044f" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "pa", "\u043f\u04d9\u043d\u0497\u0430\u0431\u0438" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f\u0441\u0435" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 - \u042f\u04a3\u0430 \u0413\u0432\u0438\u043d\u0435\u044f" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448\u0430" },
            { "pl", "\u043f\u043e\u043b\u044f\u043a" },
            { "PM", "\u0421\u0435\u043d-\u041f\u044c\u0435\u0440 \u04bb\u04d9\u043c \u041c\u0438\u043a\u0435\u043b\u043e\u043d" },
            { "PN", "\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u044f" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "niu", "\u043d\u0438\u0443\u044d" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "RE", "\u0420\u0435\u044e\u043d\u044c\u043e\u043d" },
            { "rm", "\u0440\u0435\u0442\u043e\u0440\u043e\u043c\u0430\u043d" },
            { "RO", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f" },
            { "ro", "\u0440\u0443\u043c\u044b\u043d" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438\u044f" },
            { "RU", "\u0420\u043e\u0441\u0441\u0438\u044f" },
            { "ru", "\u0440\u0443\u0441" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "rw", "\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "SA", "\u0421\u043e\u0433\u0443\u0434 \u0413\u0430\u0440\u04d9\u0431\u0441\u0442\u0430\u043d\u044b" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "SB", "\u0421\u04e9\u043b\u04d9\u0439\u043c\u0430\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "sd", "\u0441\u0438\u043d\u0434\u04bb\u0438" },
            { "SE", "\u0428\u0432\u0435\u0446\u0438\u044f" },
            { "se", "\u0442\u04e9\u043d\u044c\u044f\u043a \u0441\u0430\u0430\u043c" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u044f" },
            { "si", "\u0441\u0438\u043d\u0433\u0430\u043b" },
            { "SJ", "\u0428\u043f\u0438\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u04bb\u04d9\u043c \u042f\u043d-\u041c\u0430\u0439\u0435\u043d" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a\u0438\u044f" },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u043a" },
            { "SL", "\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0438" },
            { "arn", "\u043c\u0430\u043f\u0443\u0447\u0435" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "sr", "\u0441\u0435\u0440\u0431" },
            { "SS", "\u041a\u04e9\u043d\u044c\u044f\u043a \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u04bb\u04d9\u043c \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "SV", "\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "sv", "\u0448\u0432\u0435\u0434" },
            { "SX", "\u0421\u0438\u043d\u0442-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0421\u04af\u0440\u0438\u044f" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434" },
            { "ibb", "\u0438\u0431\u0438\u0431\u0438\u043e" },
            { "ta", "\u0442\u0430\u043c\u0438\u043b" },
            { "TC", "\u0422\u0435\u0440\u043a\u0441 \u04bb\u04d9\u043c \u041a\u0430\u0439\u043a\u043e\u0441 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "TD", "\u0427\u0430\u0434" },
            { "te", "\u0442\u0435\u043b\u0443\u0433\u0443" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0438\u044f\u043d\u0435\u04a3 \u041a\u04e9\u043d\u044c\u044f\u043a \u0422\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f\u043b\u04d9\u0440\u0435" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "tg", "\u0442\u0430\u0497\u0438\u043a" },
            { "TH", "\u0422\u0430\u0439\u043b\u0430\u043d\u0434" },
            { "th", "\u0442\u0430\u0439" },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u043d\u044c\u044f" },
            { "TJ", "\u0422\u0430\u0497\u0438\u043a\u0441\u0442\u0430\u043d" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "tk", "\u0442\u04e9\u0440\u0435\u043a\u043c\u04d9\u043d" },
            { "TL", "\u0422\u0438\u043c\u043e\u0440-\u041b\u0435\u0441\u0442\u0435" },
            { "TM", "\u0422\u04e9\u0440\u043a\u043c\u04d9\u043d\u0441\u0442\u0430\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "to", "\u0442\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u04e9\u0440\u043a\u0438\u044f" },
            { "tr", "\u0442\u04e9\u0440\u0435\u043a" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u04bb\u04d9\u043c \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d\u044c" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u044f" },
            { "Zzzz", "\u0431\u0438\u043b\u0433\u0435\u0441\u0435\u0437 \u044f\u0437\u0443" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d\u0430" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "ug", "\u0443\u0439\u0433\u044b\u0440" },
            { "uk", "\u0443\u043a\u0440\u0430\u0438\u043d" },
            { "UM", "\u0410\u041a\u0428 \u041a\u0435\u0447\u0435 \u0427\u0438\u0442\u0442\u04d9\u0433\u0435 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "US", "\u0410\u041a\u0428" },
            { "haw", "\u0433\u0430\u0432\u0430\u0439\u0438" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "UZ", "\u04ae\u0437\u0431\u04d9\u043a\u0441\u0442\u0430\u043d" },
            { "uz", "\u04af\u0437\u0431\u04d9\u043a" },
            { "tzm", "\u04af\u0437\u04d9\u043a \u0430\u0442\u043b\u0430\u0441 \u0442\u0430\u043c\u0430\u0437\u0438\u0433\u0442" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u04bb\u04d9\u043c \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "VG", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f \u0412\u0438\u0440\u0433\u0438\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "VI", "\u0410\u041a\u0428 \u0412\u0438\u0440\u0433\u0438\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "vi", "\u0432\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "VN", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "quc", "\u043a\u0438\u0447\u0435" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "syr", "\u0441\u04af\u0440\u0438\u044f" },
            { "WF", "\u0423\u043e\u043b\u043b\u0438\u0441 \u04bb\u04d9\u043c \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "mni", "\u043c\u0430\u043d\u0438\u043f\u0443\u0440\u0438" },
            { "Latn", metaValue_la },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "Zxxx", "\u044f\u0437\u0443\u0441\u044b\u0437" },
            { "moh", "\u043c\u043e\u0433\u0430\u0443\u043a" },
            { "YE", "\u0419\u04d9\u043c\u04d9\u043d" },
            { "type.co.standard", "\u0433\u0430\u0434\u04d9\u0442\u0438 \u0442\u04d9\u0440\u0442\u0438\u043f\u043b\u04d9\u04af \u044b\u0441\u0443\u043b\u044b" },
            { "yi", "\u0438\u0434\u0438\u0448" },
            { "yo", "\u0439\u043e\u0440\u0443\u0431\u0430" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0430" },
            { "ZA", "\u041a\u04e9\u043d\u044c\u044f\u043a \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "zh", "\u043a\u044b\u0442\u0430\u0439 (\u0442\u04d9\u0440\u0497\u0435\u043c\u04d9 \u043a\u0438\u04a3\u04d9\u0448\u0435: \u0430\u0435\u0440\u044b\u043c \u0430\u043b\u0433\u0430\u043d\u0434\u0430, \u043c\u0430\u043d\u0434\u0430\u0440\u0438\u043d \u043a\u044b\u0442\u0430\u0439\u0447\u0430\u0441\u044b)" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438\u044f" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u0431\u0438\u043b\u0433\u0435\u0441\u0435\u0437 \u0442\u04e9\u0431\u04d9\u043a" },
            { "zh_Hans", "\u0433\u0430\u0434\u0438\u043b\u04d9\u0448\u0442\u0435\u0440\u0435\u043b\u0433\u04d9\u043d \u043a\u044b\u0442\u0430\u0439" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "hil", "\u0445\u0438\u043b\u0438\u0433\u0430\u0439\u043d\u043e\u043d" },
            { "zh_Hant", "\u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d \u043a\u044b\u0442\u0430\u0439" },
            { "sah", "\u0441\u0430\u0445\u0430" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u0438" },
            { "kru", "\u043a\u0443\u0440\u0443\u0445" },
        };
        return data;
    }
}
