/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ku extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "ereb\u00ee";
        final String metaValue_bn = "bengal\u00ee";
        final String metaValue_bo = "t\u00eebet\u00ee";
        final String metaValue_el = "yewnan\u00ee";
        final String metaValue_hy = "ermen\u00ee";
        final String metaValue_ka = "gurc\u00ee";
        final String metaValue_km = "xim\u00ear\u00ee";
        final String metaValue_mn = "mongol\u00ee";
        final Object[][] data = new Object[][] {
            { "ksh", "r\u00eepwar\u00ee" },
            { "Zsym", "sembol" },
            { "fil", "f\u00eel\u00eep\u00eenoy\u00ee" },
            { "ban", "bal\u00een\u00ee" },
            { "sco", "skot\u00ee" },
            { "scn", "sic\u00eel\u00ee" },
            { "aa", "afar\u00ee" },
            { "rap", "rapanuy\u00ee" },
            { "ab", "abxaz\u00ee" },
            { "rar", "rarotong\u00ee" },
            { "tet", "tet\u00fbm\u00ee" },
            { "AD", "Andorra" },
            { "AE", "Em\u00eertiy\u00ean Ereb\u00ee y\u00ean Yekb\u00fby\u00ee" },
            { "nl_BE", "flam\u00ee" },
            { "AF", "Efxanistan" },
            { "af", "afr\u00eekans\u00ee" },
            { "AG", "Ant\u00eegua \u00fb Berb\u00fbda" },
            { "AL", "Albanya" },
            { "AM", "Ermenistan" },
            { "am", "amhar\u00ee" },
            { "Arab", metaValue_ar },
            { "an", "aragon\u00ee" },
            { "AO", "Angola" },
            { "AQ", "Antarkt\u00eeka" },
            { "ar", metaValue_ar },
            { "AR", "Arjent\u00een" },
            { "AS", "Samoaya Amer\u00eekan\u00ee" },
            { "as", "asam\u00ee" },
            { "AT", "Awistirya" },
            { "AU", "Awistralya" },
            { "av", "avar\u00ee" },
            { "AW", "Ar\u00fbba" },
            { "ay", "aymaray\u00ee" },
            { "AZ", "Azerbaycan" },
            { "az", "azer\u00ee" },
            { "BA", "Bosniya \u00fb Herzegov\u00eena" },
            { "ba", "ba\u015fk\u00eer\u00ee" },
            { "BB", "Barbados" },
            { "ceb", "sebwanoy\u00ee" },
            { "BD", "Banglade\u015f" },
            { "BE", "Bel\u00e7\u00eeka" },
            { "be", "belarus\u00ee" },
            { "BF", "Burk\u00eena Faso" },
            { "BG", "Bulgaristan" },
            { "bg", "bulgar\u00ee" },
            { "BH", "Behreyn" },
            { "BI", "Burund\u00ee" },
            { "bi", "b\u00eeslamay\u00ee" },
            { "BJ", "B\u00ean\u00een" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Berm\u00fbda" },
            { "bm", "bambaray\u00ee" },
            { "myv", "erzay\u00ee" },
            { "bn", metaValue_bn },
            { "BN", "Br\u00fbney" },
            { "bo", metaValue_bo },
            { "BO", "Bol\u00eevya" },
            { "BR", "Braz\u00eel" },
            { "br", "breton\u00ee" },
            { "BS", "Bahama" },
            { "bs", "bosn\u00ee" },
            { "BT", "B\u00fbtan" },
            { "BW", "Botswana" },
            { "BY", "Belar\u00fbs" },
            { "BZ", "Bel\u00eeze" },
            { "type.ca.persian", "salnameya \u00eeran\u00ee" },
            { "CA", "Kanada" },
            { "ca", "katalan\u00ee" },
            { "mzn", "mazenderan\u00ee" },
            { "CD", "Kongo - K\u00een\u015fasa" },
            { "ce", "\u00e7e\u00e7en\u00ee" },
            { "CF", "Komara Afr\u00eekaya Navend" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Sw\u00eesre" },
            { "ch", "\u00e7amoroy\u00ee" },
            { "CI", "Perav\u00ea Diranf\u00eel" },
            { "CK", "Girav\u00ean Cook" },
            { "CL", "\u015e\u00eele" },
            { "CM", "Kamer\u00fbn" },
            { "CN", "\u00c7\u00een" },
            { "CO", "Kolombiya" },
            { "co", "kors\u00eekay\u00ee" },
            { "CR", "Kosta R\u00eeka" },
            { "cs", "\u00e7ek\u00ee" },
            { "CU", "K\u00fbba" },
            { "CV", "Kap Verde" },
            { "cv", "\u00e7uva\u015f\u00ee" },
            { "CY", "K\u00eepros" },
            { "cy", "weyls\u00ee" },
            { "CZ", "\u00c7ekya" },
            { "da", "danmark\u00ee" },
            { "DE", "Almanya" },
            { "de", "elman\u00ee" },
            { "ace", "a\u00e7eh\u00ee" },
            { "DJ", "C\u00eeb\u00fbt\u00ee" },
            { "DK", "Dan\u00eemarka" },
            { "DM", "Dom\u00een\u00eeka" },
            { "DO", "Komara Dom\u00een\u00eek" },
            { "bem", "bembay\u00ee" },
            { "gor", "gorontaloy\u00ee" },
            { "dv", "diveh\u00ee" },
            { "DZ", "Cezayir" },
            { "dz", "conxay\u00ee" },
            { "type.ca.chinese", "salnameya \u00e7\u00een\u00ee" },
            { "pam", "kapampangan\u00ee" },
            { "EC", "Ekuador" },
            { "pap", "papyamentoy\u00ee" },
            { "EE", "Estonya" },
            { "ee", "ewey\u00ee" },
            { "EG", "Misir" },
            { "EH", "Sahraya Rojava" },
            { "pau", "palaw\u00ee" },
            { "el", metaValue_el },
            { "chk", "\u00e7\u00fbk\u00ee" },
            { "en", "\u00eengil\u00eez\u00ee" },
            { "chm", "mar\u00ee" },
            { "eo", "esperantoy\u00ee" },
            { "chr", "\u00e7erok\u00ee" },
            { "ER", "Er\u00eetrea" },
            { "ES", "Spanya" },
            { "es", "span\u00ee" },
            { "ET", "Etiyopya" },
            { "et", "eston\u00ee" },
            { "EU", "Yek\u00eetiya Ewropay\u00ea" },
            { "eu", "bask\u00ee" },
            { "type.ca.gregorian", "salnameya gregor\u00ee" },
            { "chy", "\u00e7eyen\u00ee" },
            { "hsb", "sorbiya jor\u00een" },
            { "ady", "ad\u00eegey\u00ee" },
            { "fa", "faris\u00ee" },
            { "ff", "fulah\u00ee" },
            { "FI", "F\u00eenlenda" },
            { "fi", "f\u00een\u00ee" },
            { "FJ", "F\u00eej\u00ee" },
            { "fj", "f\u00eej\u00ee" },
            { "FK", "Girav\u00ean Malv\u00een" },
            { "FM", "M\u00eekronezya" },
            { "yue", "kanton\u00ee" },
            { "FO", "Girav\u00ean Feroe" },
            { "fo", "fer\u00ee" },
            { "FR", "Fransa" },
            { "fr", "frens\u00ee" },
            { "fy", "fr\u00ees\u00ee" },
            { "GA", "Gabon" },
            { "ga", "\u00eer\u00ee" },
            { "GB", "Keyaniya Yekb\u00fby\u00ee" },
            { "GD", "Grenada" },
            { "gd", "gael\u00eeka skot\u00ee" },
            { "GE", "Gurcistan" },
            { "GF", "Guyanaya Frans\u00ee" },
            { "GH", "Gana" },
            { "GI", "C\u00eebraltar" },
            { "GL", "Gr\u00eenlenda" },
            { "gl", "gal\u00ees\u00ee" },
            { "GM", "Gambiya" },
            { "GN", "G\u00eene" },
            { "gn", "guwaran\u00ee" },
            { "bho", "bojp\u00fbr\u00ee" },
            { "GP", "Guadeloupe" },
            { "GQ", "G\u00eeneya Rojbend\u00ee" },
            { "GR", "Yewnanistan" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "gu", "gujarat\u00ee" },
            { "gv", "manks\u00ee" },
            { "GW", "G\u00eene-Bissau" },
            { "tlh", "kl\u00eengon\u00ee" },
            { "GY", "Guyana" },
            { "ha", "hawsay\u00ee" },
            { "ckb", "soran\u00ee" },
            { "he", "\u00eebran\u00ee" },
            { "hi", "hind\u00ee" },
            { "HN", "Hond\u00fbras" },
            { "HR", "Kroatya" },
            { "hr", "xirwat\u00ee" },
            { "gsw", "elman\u00ee\u015f\u00ee" },
            { "HT", "Ha\u00eet\u00ee" },
            { "ht", "ha\u00eet\u00ee" },
            { "HU", "Macaristan" },
            { "hu", "mecar\u00ee" },
            { "hy", metaValue_hy },
            { "hz", "hereroy\u00ee" },
            { "ia", "interlingua" },
            { "IC", "Girav\u00ean Qenariy\u00ea" },
            { "ID", "\u00cendonezya" },
            { "id", "indonez\u00ee" },
            { "IE", "\u00cerlenda" },
            { "nap", "napol\u00eetan\u00ee" },
            { "ig", "\u00eegboy\u00ee" },
            { "zza", "zazak\u00ee" },
            { "IL", "\u00cesra\u00eal" },
            { "IM", "Girava Man" },
            { "IN", "Hindistan" },
            { "io", "\u00eedoy\u00ee" },
            { "IQ", "Iraq" },
            { "IR", "\u00ceran" },
            { "IS", "\u00ceslenda" },
            { "is", "\u00eezlend\u00ee" },
            { "IT", "\u00cetalya" },
            { "it", "\u00eetal\u00ee" },
            { "iu", "\u00eenu\u00eet\u00ee" },
            { "ja", "japon\u00ee" },
            { "type.ca.islamic", "salnameya ko\u00e7\u00ee" },
            { "Beng", metaValue_bn },
            { "JM", "Jama\u00eeka" },
            { "JO", "Urdun" },
            { "JP", "Japon" },
            { "ain", "aynuy\u00ee" },
            { "jv", "javay\u00ee" },
            { "mad", "maduray\u00ee" },
            { "smn", "samiya \u00eenar\u00ee" },
            { "ka", metaValue_ka },
            { "bla", "blakfot\u00ee" },
            { "KE", "Kenya" },
            { "419", "Amer\u00eekaya Lat\u00een\u00ee" },
            { "KG", "Qirgizistan" },
            { "KH", "Kamboca" },
            { "KI", "Kir\u00eebat\u00ee" },
            { "mas", "masay\u00ee" },
            { "kk", "qazax\u00ee" },
            { "kl", "kalal\u00ees\u00fbt\u00ee" },
            { "km", metaValue_km },
            { "KM", "Komor" },
            { "KN", "Saint Kitts \u00fb Nev\u00ees" },
            { "kn", "kannaday\u00ee" },
            { "ko", "korey\u00ee" },
            { "KP", "Kor\u00eaya Bakur" },
            { "KR", "Kor\u00eaya Ba\u015f\u00fbr" },
            { "ks", "ke\u015fm\u00eer\u00ee" },
            { "ku", "kurd\u00ee" },
            { "kv", "kom\u00ee" },
            { "KW", "Kuweyt" },
            { "kw", "korn\u00ee" },
            { "tpi", "tokpisin\u00ee" },
            { "KY", "Girav\u00ean Kayman\u00ea" },
            { "ky", "kirgiz\u00ee" },
            { "KZ", "Qazaxistan" },
            { "Cyrl", "kir\u00eel\u00ee" },
            { "LA", "Laos" },
            { "LB", "Libnan" },
            { "lb", "luksemb\u00fbrg\u00ee" },
            { "LC", "Saint Lucia" },
            { "lg", "luganday\u00ee" },
            { "LI", "Liechtenstein" },
            { "li", "l\u00eemb\u00fbrg\u00ee" },
            { "LK", "Sr\u00ee Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "lingalay\u00ee" },
            { "fur", "friyol\u00ee" },
            { "lo", "laws\u00ee" },
            { "LR", "L\u00eeberya" },
            { "LS", "Lesoto" },
            { "LT", "L\u00eetvanya" },
            { "lt", "l\u00eetwan\u00ee" },
            { "LU", "L\u00fbksemb\u00fbrg" },
            { "LV", "Letonya" },
            { "lv", "latviyay\u00ee" },
            { "LY", "L\u00eebya" },
            { "lad", "lad\u00eenoy\u00ee" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MG", "Madagaskar" },
            { "mg", "malagas\u00ee" },
            { "MH", "Girav\u00ean Mar\u015fal" },
            { "mh", "mar\u015fal\u00ee" },
            { "ale", "al\u00eaw\u00eet\u00ee" },
            { "mi", "maor\u00ee" },
            { "MK", "Makedonya" },
            { "mk", "makedon\u00ee" },
            { "ML", "Mal\u00ee" },
            { "ml", "malayalam\u00ee" },
            { "MM", "Myanmar (Birmanya)" },
            { "mn", metaValue_mn },
            { "MN", "Mongolya" },
            { "MP", "Girav\u00ean Bakur\u00ea Marianan" },
            { "MQ", "Martinique" },
            { "MR", "Mor\u00eetanya" },
            { "mr", "marat\u00ee" },
            { "ms", "malez\u00ee" },
            { "MT", "Malta" },
            { "mt", "maltay\u00ee" },
            { "MU", "Maur\u00eetius" },
            { "MV", "Mald\u00eev" },
            { "MW", "Malaw\u00ee" },
            { "MX", "Meks\u00eek" },
            { "type.ca.japanese", "salnameya japon\u00ee" },
            { "MY", "Malezya" },
            { "my", "burmay\u00ee" },
            { "Armn", metaValue_hy },
            { "MZ", "Mozamb\u00eek" },
            { "mdf", "mok\u015fay\u00ee" },
            { "dsb", "sorbiya j\u00ear\u00een" },
            { "NA", "Nam\u00eebya" },
            { "na", "nawr\u00fby\u00ee" },
            { "nb", "norwec\u00ee (bokm\u00e5l)" },
            { "type.ca.hebrew", "salnameya \u00eebran\u00ee" },
            { "NC", "Kaledonyaya N\u00fb" },
            { "NE", "N\u00eejer" },
            { "ne", "nepal\u00ee" },
            { "NF", "Girava Norfolk" },
            { "NG", "N\u00eejerya" },
            { "trv", "tarokoy\u00ee" },
            { "NI", "N\u00eekaragua" },
            { "NL", "Holenda" },
            { "nl", "holend\u00ee" },
            { "nn", "norwec\u00ee (nynorsk)" },
            { "NO", "Norw\u00eac" },
            { "NP", "Nepal" },
            { "NR", "Na\u00fbr\u00fb" },
            { "NU", "Ni\u00fbe" },
            { "nv", "navajoy\u00ee" },
            { "NZ", "N\u00fb Zelenda" },
            { "kab", "kab\u00eel\u00ee" },
            { "oc", "oks\u00eetan\u00ee" },
            { "OM", "Oman" },
            { "om", "oromoy\u00ee" },
            { "or", "oriyay\u00ee" },
            { "os", "oset\u00ee" },
            { "srn", "siranan\u00ee" },
            { "PA", "Panama" },
            { "pa", "puncab\u00ee" },
            { "dua", "diwalay\u00ee" },
            { "PE", "Per\u00fb" },
            { "PF", "Pol\u00eenezyaya Frans\u00ee" },
            { "PG", "Papua G\u00eeneya N\u00fb" },
            { "PH", "Fil\u00eep\u00een" },
            { "PK", "Pakistan" },
            { "PL", "Polonya" },
            { "pl", "polon\u00ee" },
            { "PM", "Saint-Pierre \u00fb Miquelon" },
            { "PN", "Girav\u00ean Pitcairn" },
            { "PR", "Porto R\u00eeko" },
            { "PS", "Xak\u00ean filist\u00een\u00ee" },
            { "ps", "pe\u015ft\u00fby\u00ee" },
            { "PT", "Port\u00fbgal" },
            { "pt", "portugal\u00ee" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "tum", "tumbukay\u00ee" },
            { "QA", "Qeter" },
            { "key.ca", "salname" },
            { "niu", "n\u00eew\u00ee" },
            { "lez", "lezg\u00een\u00ee" },
            { "qu", "ke\u00e7way\u00ee" },
            { "tvl", "tuval\u00fby\u00ee" },
            { "001", "C\u00eehan" },
            { "002", "Afr\u00eeka" },
            { "003", "Amer\u00eekaya Bakur" },
            { "RE", "R\u00e9union" },
            { "005", "Amer\u00eekaya Ba\u015f\u00fbr" },
            { "jbo", "lojban\u00ee" },
            { "009", "Okyan\u00fbsya" },
            { "rm", "romanc\u00ee" },
            { "key.cu", "diw\u00eez" },
            { "RO", "Romanya" },
            { "ro", "roman\u00ee" },
            { "RS", "Serbistan" },
            { "RU", "R\u00fbsya" },
            { "ru", "rus\u00ee" },
            { "RW", "Rwanda" },
            { "rw", "k\u00eenyariwanday\u00ee" },
            { "kea", "kapverd\u00ee" },
            { "mic", "m\u00eekmak\u00ee" },
            { "SA", "Erebistana Siy\u00fbd\u00ee" },
            { "sa", "sanskr\u00eet\u00ee" },
            { "SB", "Girav\u00ean Salomon" },
            { "SC", "Sey\u015fel" },
            { "sc", "sard\u00een\u00ee" },
            { "SD", "S\u00fbdan" },
            { "sd", "sindh\u00ee" },
            { "013", "Amer\u00eekaya Nav\u00een" },
            { "SE", "Sw\u00ead" },
            { "se", "samiya bakur" },
            { "min", "m\u00eenangkabaw\u00ee" },
            { "015", "Afr\u00eekaya Bakur" },
            { "SG", "Singap\u00fbr" },
            { "SI", "Slovenya" },
            { "si", "k\u00eengal\u00ee" },
            { "019", "Amer\u00eeka" },
            { "SK", "Slovakya" },
            { "sk", "slovak\u00ee" },
            { "SL", "Sierra Leone" },
            { "sl", "sloven\u00ee" },
            { "SM", "San Mar\u00eeno" },
            { "sm", "samoay\u00ee" },
            { "SN", "Senegal" },
            { "sn", "\u015fonay\u00ee" },
            { "SO", "Somalya" },
            { "so", "somal\u00ee" },
            { "sq", "elban\u00ee" },
            { "SR", "S\u00fbr\u00eenam" },
            { "sr", "sirb\u00ee" },
            { "SS", "S\u00fbdana Ba\u015f\u00fbr" },
            { "ss", "swaz\u00ee" },
            { "ST", "Sao Tome \u00fb Pr\u00eens\u00eepe" },
            { "st", "sotoyiya ba\u015f\u00fbr" },
            { "su", "sundan\u00ee" },
            { "SV", "El Salvador" },
            { "sv", "sw\u00ead\u00ee" },
            { "sw", "swah\u00eel\u00ee" },
            { "SY", "S\u00fbr\u00ee" },
            { "SZ", "Swaz\u00eelenda" },
            { "ta", "tam\u00eel\u00ee" },
            { "142", "Asya" },
            { "TC", "Girav\u00ean Turk \u00fb Ka\u00eekos" },
            { "TD", "\u00c7ad" },
            { "te", "tel\u00fbg\u00fby\u00ee" },
            { "TG", "Togo" },
            { "tg", "tacik\u00ee" },
            { "TH", "Taylenda" },
            { "th", "tay\u00ee" },
            { "ti", "tigr\u00een\u00ee" },
            { "bug", "bug\u00ee" },
            { "TJ", "Tac\u00eekistan" },
            { "029", "Kar\u00eeb" },
            { "TK", "Tokelau" },
            { "tk", "tirkmen\u00ee" },
            { "TL", "T\u00eemora-Leste" },
            { "TM", "Tirkmenistan" },
            { "TN", "T\u00fbnis" },
            { "tn", "tswanay\u00ee" },
            { "TO", "Tonga" },
            { "to", "tong\u00ee" },
            { "TR", "Tirkiye" },
            { "tr", "tirk\u00ee" },
            { "ts", "tsongay\u00ee" },
            { "swb", "komor\u00ee" },
            { "TT", "Tr\u00een\u00eedad \u00fb Tobago" },
            { "tt", "teter\u00ee" },
            { "TV", "T\u00fbval\u00fb" },
            { "TW", "Taywan" },
            { "ast", "ast\u00fbr\u00ee" },
            { "ty", "tah\u00eet\u00ee" },
            { "TZ", "Tanzanya" },
            { "Zzzz", "niv\u00eesa nenas" },
            { "150", "Ewropa" },
            { "UA", "\u00dbkrayna" },
            { "rup", "aroman\u00ee" },
            { "151", "Ewropaya Rojhilat" },
            { "155", "Ewropaya Rojava" },
            { "UG", "\u00dbganda" },
            { "ug", "oygur\u00ee" },
            { "Zyyy", "hevpar" },
            { "uk", "ukrayn\u00ee" },
            { "UN", "Netewey\u00ean Yekb\u00fby\u00ee" },
            { "ur", "urd\u00fby\u00ee" },
            { "US", "Dewlet\u00ean Yekb\u00fby\u00ee y\u00ean Amer\u00eekay\u00ea" },
            { "haw", "haway\u00ee" },
            { "UY", "\u00dbr\u00fbguay" },
            { "prg", "pr\u00fbsyay\u00ee" },
            { "UZ", "\u00dbzb\u00eakistan" },
            { "uz", "ozbek\u00ee" },
            { "tzm", "temaz\u00eext\u00ee" },
            { "VA", "Vat\u00eekan" },
            { "VC", "Saint Vincent \u00fb Girav\u00ean Grenad\u00een" },
            { "VE", "Venezuela" },
            { "type.ca.roc", "salnameya Komara \u00c7\u00een\u00ea" },
            { "vi", "viyetnam\u00ee" },
            { "VN", "Viyetnam" },
            { "vo", "volap\u00fbk\u00ee" },
            { "VU", "Van\u00fbat\u00fb" },
            { "wa", "walon\u00ee" },
            { "syr", "siryan\u00ee" },
            { "053", "Awistralasya" },
            { "054", "Melanezya" },
            { "WF", "Wallis \u00fb Futuna" },
            { "Grek", metaValue_el },
            { "057", "Her\u00eama M\u00eekronezya" },
            { "lkt", "lakotay\u00ee" },
            { "wo", "wolof\u00ee" },
            { "ar_001", "erebiya standard" },
            { "WS", "Samoa" },
            { "Mong", metaValue_mn },
            { "war", "waray\u00ee" },
            { "061", "Pol\u00eenezya" },
            { "Latn", "lat\u00een\u00ee" },
            { "xh", "xosay\u00ee" },
            { "XK", "Kosovo" },
            { "Zxxx", "ne niv\u00eesand\u00ee" },
            { "moh", "mohawk\u00ee" },
            { "YE", "Yemen" },
            { "yi", "yid\u00ee\u015f\u00ee" },
            { "yo", "yorubay\u00ee" },
            { "ZA", "Afr\u00eekaya Ba\u015f\u00fbr" },
            { "Deva", "devanagar\u00ee" },
            { "ZM", "Zambiya" },
            { "zu", "zuluy\u00ee" },
            { "ZW", "Z\u00eembabwe" },
            { "Geor", metaValue_ka },
            { "type.ca.iso8601", "salnameya ISO-8601" },
            { "nso", "sotoyiya bakur" },
            { "kok", "konkan\u00ee" },
            { "hil", "h\u00eel\u00eegaynon\u00ee" },
            { "lrc", "luriya bakur" },
            { "ilo", "\u00eelokanoy\u00ee" },
            { "udm", "udmurt\u00ee" },
            { "Khmr", metaValue_km },
            { "gil", "k\u00eer\u00eebat\u00ee" },
            { "type.nu.roman", "hejmar\u00ean rom\u00ee" },
            { "inh", "\u00eeng\u00fb\u015f\u00ee" },
        };
        return data;
    }
}
