/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXFontSize;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.FontSizeDeclaration;
import java.io.IOException;

public class L2HFontSizeDeclaration
extends FontSizeDeclaration {
    public L2HFontSizeDeclaration(String string, TeXFontSize teXFontSize) {
        super(string, teXFontSize);
    }

    public L2HFontSizeDeclaration(String string, int n) {
        super(string, n);
    }

    @Override
    public Object clone() {
        return new L2HFontSizeDeclaration(this.getName(), this.getSize());
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        super.process(teXParser);
        String string = "";
        switch (this.getSize()) {
            case NORMAL: {
                string = "font-size: medium; ";
                break;
            }
            case LARGE: {
                string = "font-size: large; ";
                break;
            }
            case XLARGE: {
                string = "font-size: x-large; ";
                break;
            }
            case XXLARGE: {
                string = "font-size: xx-large; ";
                break;
            }
            case HUGE: {
                string = "font-size: xx-large; ";
                break;
            }
            case XHUGE: {
                string = "font-size: xx-large; ";
                break;
            }
            case XXHUGE: {
                string = "font-size: xx-large; ";
                break;
            }
            case SMALL: {
                string = "font-size: small; ";
                break;
            }
            case FOOTNOTE: {
                string = "font-size: x-small; ";
                break;
            }
            case SCRIPT: {
                string = "font-size: xx-small; ";
                break;
            }
            case TINY: {
                string = "font-size: xx-small; ";
            }
        }
        if (!string.isEmpty()) {
            teXParser.getListener().getWriteable().writeliteral("<span style=\"" + string + "\">");
        } else {
            teXParser.getListener().getWriteable().writeliteral("<span>");
        }
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXParser.getListener().getWriteable().writeliteral("</span>");
        super.end(teXParser, teXObjectList);
    }
}

