/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.Jdbc41Bridge;
import org.apache.tomcat.dbcp.dbcp2.LifetimeExceededException;
import org.apache.tomcat.dbcp.dbcp2.PStmtKey;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolingConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.DestroyMode;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.impl.BaseObjectPoolConfig;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPoolConfig;

public class PoolableConnectionFactory
implements PooledObjectFactory<PoolableConnection> {
    private static final Log log = LogFactory.getLog(PoolableConnectionFactory.class);
    static final int UNKNOWN_TRANSACTION_ISOLATION = -1;
    private final ConnectionFactory connectionFactory;
    private final ObjectName dataSourceJmxObjectName;
    private volatile String validationQuery;
    private volatile Duration validationQueryTimeoutDuration = Duration.ofSeconds(-1L);
    private Collection<String> connectionInitSqls;
    private Collection<String> disconnectionSqlCodes;
    private boolean fastFailValidation = true;
    private volatile ObjectPool<PoolableConnection> pool;
    private Boolean defaultReadOnly;
    private Boolean defaultAutoCommit;
    private boolean autoCommitOnReturn = true;
    private boolean rollbackOnReturn = true;
    private int defaultTransactionIsolation = -1;
    private String defaultCatalog;
    private String defaultSchema;
    private boolean cacheState;
    private boolean poolStatements;
    private boolean clearStatementPoolOnReturn;
    private int maxOpenPreparedStatements = 8;
    private Duration maxConnDuration = Duration.ofMillis(-1L);
    private final AtomicLong connectionIndex = new AtomicLong();
    private Duration defaultQueryTimeoutDuration;

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectName objectName) {
        this.connectionFactory = connectionFactory;
        this.dataSourceJmxObjectName = objectName;
    }

    @Override
    public void activateObject(PooledObject<PoolableConnection> pooledObject) throws SQLException {
        this.validateLifetime(pooledObject);
        PoolableConnection poolableConnection = pooledObject.getObject();
        poolableConnection.activate();
        if (this.defaultAutoCommit != null && poolableConnection.getAutoCommit() != this.defaultAutoCommit.booleanValue()) {
            poolableConnection.setAutoCommit(this.defaultAutoCommit);
        }
        if (this.defaultTransactionIsolation != -1 && poolableConnection.getTransactionIsolation() != this.defaultTransactionIsolation) {
            poolableConnection.setTransactionIsolation(this.defaultTransactionIsolation);
        }
        if (this.defaultReadOnly != null && poolableConnection.isReadOnly() != this.defaultReadOnly.booleanValue()) {
            poolableConnection.setReadOnly(this.defaultReadOnly);
        }
        if (this.defaultCatalog != null && !this.defaultCatalog.equals(poolableConnection.getCatalog())) {
            poolableConnection.setCatalog(this.defaultCatalog);
        }
        if (this.defaultSchema != null && !this.defaultSchema.equals(Jdbc41Bridge.getSchema(poolableConnection))) {
            Jdbc41Bridge.setSchema(poolableConnection, this.defaultSchema);
        }
        poolableConnection.setDefaultQueryTimeout(this.defaultQueryTimeoutDuration);
    }

    @Override
    public void destroyObject(PooledObject<PoolableConnection> pooledObject) throws SQLException {
        pooledObject.getObject().reallyClose();
    }

    @Override
    public void destroyObject(PooledObject<PoolableConnection> pooledObject, DestroyMode destroyMode) throws SQLException {
        if (destroyMode == DestroyMode.ABANDONED) {
            pooledObject.getObject().getInnermostDelegate().abort(Runnable::run);
        } else {
            pooledObject.getObject().reallyClose();
        }
    }

    public boolean getCacheState() {
        return this.cacheState;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected AtomicLong getConnectionIndex() {
        return this.connectionIndex;
    }

    public Collection<String> getConnectionInitSqls() {
        return this.connectionInitSqls;
    }

    public ObjectName getDataSourceJmxName() {
        return this.dataSourceJmxObjectName;
    }

    public ObjectName getDataSourceJmxObjectName() {
        return this.dataSourceJmxObjectName;
    }

    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @Deprecated
    public Integer getDefaultQueryTimeout() {
        return this.getDefaultQueryTimeoutSeconds();
    }

    public Duration getDefaultQueryTimeoutDuration() {
        return this.defaultQueryTimeoutDuration;
    }

    @Deprecated
    public Integer getDefaultQueryTimeoutSeconds() {
        return this.defaultQueryTimeoutDuration == null ? null : Integer.valueOf((int)this.defaultQueryTimeoutDuration.getSeconds());
    }

    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public Collection<String> getDisconnectionSqlCodes() {
        return this.disconnectionSqlCodes;
    }

    public Duration getMaxConnDuration() {
        return this.maxConnDuration;
    }

    public long getMaxConnLifetimeMillis() {
        return this.maxConnDuration.toMillis();
    }

    protected int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    public synchronized ObjectPool<PoolableConnection> getPool() {
        return this.pool;
    }

    public boolean getPoolStatements() {
        return this.poolStatements;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public Duration getValidationQueryTimeoutDuration() {
        return this.validationQueryTimeoutDuration;
    }

    @Deprecated
    public int getValidationQueryTimeoutSeconds() {
        return (int)this.validationQueryTimeoutDuration.getSeconds();
    }

    protected void initializeConnection(Connection connection) throws SQLException {
        Collection<String> collection = this.connectionInitSqls;
        if (connection.isClosed()) {
            throw new SQLException("initializeConnection: connection closed");
        }
        if (!Utils.isEmpty(collection)) {
            try (Statement statement = connection.createStatement();){
                for (String string : collection) {
                    statement.execute(Objects.requireNonNull(string, "null connectionInitSqls element"));
                }
            }
        }
    }

    public boolean isAutoCommitOnReturn() {
        return this.autoCommitOnReturn;
    }

    @Deprecated
    public boolean isEnableAutoCommitOnReturn() {
        return this.autoCommitOnReturn;
    }

    public boolean isFastFailValidation() {
        return this.fastFailValidation;
    }

    public boolean isRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    @Override
    public PooledObject<PoolableConnection> makeObject() throws SQLException {
        Object object;
        Object object2;
        Connection connection = this.connectionFactory.createConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        try {
            this.initializeConnection(connection);
        }
        catch (SQLException sQLException) {
            Utils.closeQuietly((AutoCloseable)connection);
            throw sQLException;
        }
        long l = this.connectionIndex.getAndIncrement();
        if (this.poolStatements) {
            connection = new PoolingConnection(connection);
            object2 = new GenericKeyedObjectPoolConfig();
            ((GenericKeyedObjectPoolConfig)object2).setMaxTotalPerKey(-1);
            ((BaseObjectPoolConfig)object2).setBlockWhenExhausted(false);
            ((BaseObjectPoolConfig)object2).setMaxWait(Duration.ZERO);
            ((GenericKeyedObjectPoolConfig)object2).setMaxIdlePerKey(1);
            ((GenericKeyedObjectPoolConfig)object2).setMaxTotal(this.maxOpenPreparedStatements);
            if (this.dataSourceJmxObjectName != null) {
                object = new StringBuilder(this.dataSourceJmxObjectName.toString());
                ((StringBuilder)object).append(",connectionpool=connections,connection=");
                ((StringBuilder)object).append(l);
                ((BaseObjectPoolConfig)object2).setJmxNameBase(((StringBuilder)object).toString());
                ((BaseObjectPoolConfig)object2).setJmxNamePrefix(",statementpool=statements");
            } else {
                ((BaseObjectPoolConfig)object2).setJmxEnabled(false);
            }
            object = (PoolingConnection)connection;
            GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement> genericKeyedObjectPool = new GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement>((KeyedPooledObjectFactory<PStmtKey, DelegatingPreparedStatement>)object, (GenericKeyedObjectPoolConfig<DelegatingPreparedStatement>)object2);
            ((PoolingConnection)object).setStatementPool(genericKeyedObjectPool);
            ((PoolingConnection)object).setClearStatementPoolOnReturn(this.clearStatementPoolOnReturn);
            ((DelegatingConnection)object).setCacheState(this.cacheState);
        }
        if (this.dataSourceJmxObjectName == null) {
            object2 = null;
        } else {
            object = this.dataSourceJmxObjectName.toString() + ",connectionpool=connections,connection=" + l;
            try {
                object2 = new ObjectName((String)object);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                Utils.closeQuietly((AutoCloseable)connection);
                throw new SQLException((String)object, malformedObjectNameException);
            }
        }
        object = new PoolableConnection(connection, this.pool, (ObjectName)object2, this.disconnectionSqlCodes, this.fastFailValidation);
        ((DelegatingConnection)object).setCacheState(this.cacheState);
        return new DefaultPooledObject<Object>(object);
    }

    @Override
    public void passivateObject(PooledObject<PoolableConnection> pooledObject) throws SQLException {
        this.validateLifetime(pooledObject);
        PoolableConnection poolableConnection = pooledObject.getObject();
        Boolean bl = null;
        if (this.rollbackOnReturn && !(bl = Boolean.valueOf(poolableConnection.getAutoCommit())).booleanValue() && !poolableConnection.isReadOnly()) {
            poolableConnection.rollback();
        }
        poolableConnection.clearWarnings();
        if (this.autoCommitOnReturn) {
            if (bl == null) {
                bl = poolableConnection.getAutoCommit();
            }
            if (!bl.booleanValue()) {
                poolableConnection.setAutoCommit(true);
            }
        }
        poolableConnection.passivate();
    }

    public void setAutoCommitOnReturn(boolean bl) {
        this.autoCommitOnReturn = bl;
    }

    public void setCacheState(boolean bl) {
        this.cacheState = bl;
    }

    public void setClearStatementPoolOnReturn(boolean bl) {
        this.clearStatementPoolOnReturn = bl;
    }

    public void setConnectionInitSql(Collection<String> collection) {
        this.connectionInitSqls = collection;
    }

    public void setDefaultAutoCommit(Boolean bl) {
        this.defaultAutoCommit = bl;
    }

    public void setDefaultCatalog(String string) {
        this.defaultCatalog = string;
    }

    public void setDefaultQueryTimeout(Duration duration) {
        this.defaultQueryTimeoutDuration = duration;
    }

    @Deprecated
    public void setDefaultQueryTimeout(Integer n) {
        this.defaultQueryTimeoutDuration = n == null ? null : Duration.ofSeconds(n.longValue());
    }

    public void setDefaultReadOnly(Boolean bl) {
        this.defaultReadOnly = bl;
    }

    public void setDefaultSchema(String string) {
        this.defaultSchema = string;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.defaultTransactionIsolation = n;
    }

    public void setDisconnectionSqlCodes(Collection<String> collection) {
        this.disconnectionSqlCodes = collection;
    }

    @Deprecated
    public void setEnableAutoCommitOnReturn(boolean bl) {
        this.autoCommitOnReturn = bl;
    }

    public void setFastFailValidation(boolean bl) {
        this.fastFailValidation = bl;
    }

    public void setMaxConn(Duration duration) {
        this.maxConnDuration = duration;
    }

    @Deprecated
    public void setMaxConnLifetimeMillis(long l) {
        this.maxConnDuration = Duration.ofMillis(l);
    }

    public void setMaxOpenPreparedStatements(int n) {
        this.maxOpenPreparedStatements = n;
    }

    @Deprecated
    public void setMaxOpenPrepatedStatements(int n) {
        this.setMaxOpenPreparedStatements(n);
    }

    public synchronized void setPool(ObjectPool<PoolableConnection> objectPool) {
        if (null != this.pool && objectPool != this.pool) {
            Utils.closeQuietly(this.pool);
        }
        this.pool = objectPool;
    }

    public void setPoolStatements(boolean bl) {
        this.poolStatements = bl;
    }

    public void setRollbackOnReturn(boolean bl) {
        this.rollbackOnReturn = bl;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = string;
    }

    public void setValidationQueryTimeout(Duration duration) {
        this.validationQueryTimeoutDuration = duration;
    }

    @Deprecated
    public void setValidationQueryTimeout(int n) {
        this.validationQueryTimeoutDuration = Duration.ofSeconds(n);
    }

    public void validateConnection(PoolableConnection poolableConnection) throws SQLException {
        if (poolableConnection.isClosed()) {
            throw new SQLException("validateConnection: connection closed");
        }
        poolableConnection.validate(this.validationQuery, this.validationQueryTimeoutDuration);
    }

    private void validateLifetime(PooledObject<PoolableConnection> pooledObject) throws LifetimeExceededException {
        Utils.validateLifetime(pooledObject, this.maxConnDuration);
    }

    @Override
    public boolean validateObject(PooledObject<PoolableConnection> pooledObject) {
        try {
            this.validateLifetime(pooledObject);
            this.validateConnection(pooledObject.getObject());
            return true;
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Utils.getMessage("poolableConnectionFactory.validateObject.fail"), (Throwable)exception);
            }
            return false;
        }
    }
}

