/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.tomcat.dbcp.dbcp2.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;

public class PoolablePreparedStatement<K>
extends DelegatingPreparedStatement {
    private final KeyedObjectPool<K, PoolablePreparedStatement<K>> pool;
    private final K key;
    private volatile boolean batchAdded;

    public PoolablePreparedStatement(PreparedStatement preparedStatement, K k, KeyedObjectPool<K, PoolablePreparedStatement<K>> keyedObjectPool, DelegatingConnection<?> delegatingConnection) {
        super(delegatingConnection, preparedStatement);
        this.pool = keyedObjectPool;
        this.key = k;
        this.removeThisTrace(delegatingConnection);
    }

    @Override
    public void activate() throws SQLException {
        this.setClosedInternal(false);
        AbandonedTrace.add(this.getConnectionInternal(), this);
        super.activate();
    }

    @Override
    public void addBatch() throws SQLException {
        super.addBatch();
        this.batchAdded = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchAdded = false;
        super.clearBatch();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this.pool.returnObject(this.key, this);
            }
            catch (RuntimeException | SQLException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new SQLException("Cannot close preparedstatement (return to pool failed)", exception);
            }
        }
    }

    K getKey() {
        return this.key;
    }

    @Override
    public void passivate() throws SQLException {
        if (this.batchAdded) {
            this.clearBatch();
        }
        this.prepareToReturn();
    }
}

