/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.tld;

import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagVariableInfo;
import java.lang.reflect.Method;
import org.apache.tomcat.util.descriptor.tld.TagFileXml;
import org.apache.tomcat.util.descriptor.tld.TagXml;
import org.apache.tomcat.util.descriptor.tld.TaglibXml;
import org.apache.tomcat.util.descriptor.tld.ValidatorXml;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.digester.RuleSet;
import org.xml.sax.Attributes;

public class TldRuleSet
implements RuleSet {
    private static final String PREFIX = "taglib";
    private static final String VALIDATOR_PREFIX = "taglib/validator";
    private static final String TAG_PREFIX = "taglib/tag";
    private static final String TAGFILE_PREFIX = "taglib/tag-file";
    private static final String FUNCTION_PREFIX = "taglib/function";

    @Override
    public void addRuleInstances(Digester digester) {
        digester.addCallMethod("taglib/tlibversion", "setTlibVersion", 0);
        digester.addCallMethod("taglib/tlib-version", "setTlibVersion", 0);
        digester.addCallMethod("taglib/jspversion", "setJspVersion", 0);
        digester.addCallMethod("taglib/jsp-version", "setJspVersion", 0);
        digester.addRule(PREFIX, new Rule(){

            @Override
            public void begin(String string, String string2, Attributes attributes) {
                TaglibXml taglibXml = (TaglibXml)this.digester.peek();
                taglibXml.setJspVersion(attributes.getValue("version"));
                StringBuilder stringBuilder = this.digester.getGeneratedCode();
                if (stringBuilder != null) {
                    stringBuilder.append(this.digester.toVariableName(taglibXml)).append(".setJspVersion(\"");
                    stringBuilder.append(attributes.getValue("version")).append("\");");
                    stringBuilder.append(System.lineSeparator());
                }
            }
        });
        digester.addCallMethod("taglib/shortname", "setShortName", 0);
        digester.addCallMethod("taglib/short-name", "setShortName", 0);
        digester.addCallMethod("taglib/uri", "setUri", 0);
        digester.addCallMethod("taglib/info", "setInfo", 0);
        digester.addCallMethod("taglib/description", "setInfo", 0);
        digester.addCallMethod("taglib/listener/listener-class", "addListener", 0);
        digester.addObjectCreate(VALIDATOR_PREFIX, ValidatorXml.class.getName());
        digester.addCallMethod("taglib/validator/validator-class", "setValidatorClass", 0);
        digester.addCallMethod("taglib/validator/init-param", "addInitParam", 2);
        digester.addCallParam("taglib/validator/init-param/param-name", 0);
        digester.addCallParam("taglib/validator/init-param/param-value", 1);
        digester.addSetNext(VALIDATOR_PREFIX, "setValidator", ValidatorXml.class.getName());
        digester.addObjectCreate(TAG_PREFIX, TagXml.class.getName());
        this.addDescriptionGroup(digester, TAG_PREFIX);
        digester.addCallMethod("taglib/tag/name", "setName", 0);
        digester.addCallMethod("taglib/tag/tagclass", "setTagClass", 0);
        digester.addCallMethod("taglib/tag/tag-class", "setTagClass", 0);
        digester.addCallMethod("taglib/tag/teiclass", "setTeiClass", 0);
        digester.addCallMethod("taglib/tag/tei-class", "setTeiClass", 0);
        digester.addCallMethod("taglib/tag/bodycontent", "setBodyContent", 0);
        digester.addCallMethod("taglib/tag/body-content", "setBodyContent", 0);
        digester.addRule("taglib/tag/variable", new ScriptVariableRule());
        digester.addCallMethod("taglib/tag/variable/name-given", "setNameGiven", 0);
        digester.addCallMethod("taglib/tag/variable/name-from-attribute", "setNameFromAttribute", 0);
        digester.addCallMethod("taglib/tag/variable/variable-class", "setClassName", 0);
        digester.addRule("taglib/tag/variable/declare", new GenericBooleanRule(Variable.class, "setDeclare"));
        digester.addCallMethod("taglib/tag/variable/scope", "setScope", 0);
        digester.addRule("taglib/tag/attribute", new TagAttributeRule());
        digester.addCallMethod("taglib/tag/attribute/description", "setDescription", 0);
        digester.addCallMethod("taglib/tag/attribute/name", "setName", 0);
        digester.addRule("taglib/tag/attribute/required", new GenericBooleanRule(Attribute.class, "setRequired"));
        digester.addRule("taglib/tag/attribute/rtexprvalue", new GenericBooleanRule(Attribute.class, "setRequestTime"));
        digester.addCallMethod("taglib/tag/attribute/type", "setType", 0);
        digester.addCallMethod("taglib/tag/attribute/deferred-value", "setDeferredValue");
        digester.addCallMethod("taglib/tag/attribute/deferred-value/type", "setExpectedTypeName", 0);
        digester.addCallMethod("taglib/tag/attribute/deferred-method", "setDeferredMethod");
        digester.addCallMethod("taglib/tag/attribute/deferred-method/method-signature", "setMethodSignature", 0);
        digester.addRule("taglib/tag/attribute/fragment", new GenericBooleanRule(Attribute.class, "setFragment"));
        digester.addRule("taglib/tag/dynamic-attributes", new GenericBooleanRule(TagXml.class, "setDynamicAttributes"));
        digester.addSetNext(TAG_PREFIX, "addTag", TagXml.class.getName());
        digester.addObjectCreate(TAGFILE_PREFIX, TagFileXml.class.getName());
        this.addDescriptionGroup(digester, TAGFILE_PREFIX);
        digester.addCallMethod("taglib/tag-file/name", "setName", 0);
        digester.addCallMethod("taglib/tag-file/path", "setPath", 0);
        digester.addSetNext(TAGFILE_PREFIX, "addTagFile", TagFileXml.class.getName());
        digester.addCallMethod(FUNCTION_PREFIX, "addFunction", 3);
        digester.addCallParam("taglib/function/name", 0);
        digester.addCallParam("taglib/function/function-class", 1);
        digester.addCallParam("taglib/function/function-signature", 2);
    }

    private void addDescriptionGroup(Digester digester, String string) {
        digester.addCallMethod(string + "/info", "setInfo", 0);
        digester.addCallMethod(string + "small-icon", "setSmallIcon", 0);
        digester.addCallMethod(string + "large-icon", "setLargeIcon", 0);
        digester.addCallMethod(string + "/description", "setInfo", 0);
        digester.addCallMethod(string + "/display-name", "setDisplayName", 0);
        digester.addCallMethod(string + "/icon/small-icon", "setSmallIcon", 0);
        digester.addCallMethod(string + "/icon/large-icon", "setLargeIcon", 0);
    }

    private static class ScriptVariableRule
    extends Rule {
        private ScriptVariableRule() {
        }

        @Override
        public void begin(String string, String string2, Attributes attributes) throws Exception {
            Variable variable = new Variable();
            this.digester.push(variable);
            StringBuilder stringBuilder = this.digester.getGeneratedCode();
            if (stringBuilder != null) {
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append(TldRuleSet.class.getName()).append(".Variable ").append(this.digester.toVariableName(variable)).append(" = new ");
                stringBuilder.append(TldRuleSet.class.getName()).append(".Variable").append("();").append(System.lineSeparator());
            }
        }

        @Override
        public void end(String string, String string2) throws Exception {
            Variable variable = (Variable)this.digester.pop();
            TagXml tagXml = (TagXml)this.digester.peek();
            tagXml.getVariables().add(variable.toTagVariableInfo());
            StringBuilder stringBuilder = this.digester.getGeneratedCode();
            if (stringBuilder != null) {
                stringBuilder.append(this.digester.toVariableName(tagXml)).append(".getVariables().add(");
                stringBuilder.append(this.digester.toVariableName(variable)).append(".toTagVariableInfo());");
                stringBuilder.append(System.lineSeparator());
            }
        }
    }

    private static class GenericBooleanRule
    extends Rule {
        private final Method setter;

        private GenericBooleanRule(Class<?> clazz, String string) {
            try {
                this.setter = clazz.getMethod(string, Boolean.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException(noSuchMethodException);
            }
        }

        @Override
        public void body(String string, String string2, String string3) throws Exception {
            if (null != string3) {
                string3 = string3.trim();
            }
            boolean bl = "true".equalsIgnoreCase(string3) || "yes".equalsIgnoreCase(string3);
            this.setter.invoke(this.digester.peek(), bl);
            StringBuilder stringBuilder = this.digester.getGeneratedCode();
            if (stringBuilder != null) {
                stringBuilder.append(this.digester.toVariableName(this.digester.peek())).append('.').append(this.setter.getName());
                stringBuilder.append('(').append((Object)bl).append(");");
                stringBuilder.append(System.lineSeparator());
            }
        }
    }

    public static class Variable {
        private String nameGiven;
        private String nameFromAttribute;
        private String className = "java.lang.String";
        private boolean declare = true;
        private int scope = 0;

        public void setNameGiven(String string) {
            this.nameGiven = string;
        }

        public void setNameFromAttribute(String string) {
            this.nameFromAttribute = string;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public void setDeclare(boolean bl) {
            this.declare = bl;
        }

        public void setScope(String string) {
            switch (string) {
                case "NESTED": {
                    this.scope = 0;
                    break;
                }
                case "AT_BEGIN": {
                    this.scope = 1;
                    break;
                }
                case "AT_END": {
                    this.scope = 2;
                }
            }
        }

        public TagVariableInfo toTagVariableInfo() {
            return new TagVariableInfo(this.nameGiven, this.nameFromAttribute, this.className, this.declare, this.scope);
        }
    }

    private static class TagAttributeRule
    extends Rule {
        private boolean allowShortNames = false;

        private TagAttributeRule() {
        }

        @Override
        public void begin(String string, String string2, Attributes attributes) throws Exception {
            TaglibXml taglibXml = (TaglibXml)this.digester.peek(this.digester.getCount() - 1);
            this.allowShortNames = "1.2".equals(taglibXml.getJspVersion());
            Attribute attribute = new Attribute(this.allowShortNames);
            this.digester.push(attribute);
            StringBuilder stringBuilder = this.digester.getGeneratedCode();
            if (stringBuilder != null) {
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append(TldRuleSet.class.getName()).append(".Attribute ").append(this.digester.toVariableName(attribute)).append(" = new ");
                stringBuilder.append(TldRuleSet.class.getName()).append(".Attribute").append('(').append(Boolean.toString(this.allowShortNames));
                stringBuilder.append(");").append(System.lineSeparator());
            }
        }

        @Override
        public void end(String string, String string2) throws Exception {
            Attribute attribute = (Attribute)this.digester.pop();
            TagXml tagXml = (TagXml)this.digester.peek();
            tagXml.getAttributes().add(attribute.toTagAttributeInfo());
            StringBuilder stringBuilder = this.digester.getGeneratedCode();
            if (stringBuilder != null) {
                stringBuilder.append(this.digester.toVariableName(tagXml)).append(".getAttributes().add(");
                stringBuilder.append(this.digester.toVariableName(attribute)).append(".toTagAttributeInfo());");
                stringBuilder.append(System.lineSeparator());
            }
        }
    }

    public static class Attribute {
        private final boolean allowShortNames;
        private String name;
        private boolean required;
        private String type;
        private boolean requestTime;
        private boolean fragment;
        private String description;
        private boolean deferredValue;
        private boolean deferredMethod;
        private String expectedTypeName;
        private String methodSignature;

        private Attribute(boolean bl) {
            this.allowShortNames = bl;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setRequired(boolean bl) {
            this.required = bl;
        }

        public void setType(String string) {
            if (this.allowShortNames) {
                switch (string) {
                    case "Boolean": {
                        this.type = "java.lang.Boolean";
                        break;
                    }
                    case "Character": {
                        this.type = "java.lang.Character";
                        break;
                    }
                    case "Byte": {
                        this.type = "java.lang.Byte";
                        break;
                    }
                    case "Short": {
                        this.type = "java.lang.Short";
                        break;
                    }
                    case "Integer": {
                        this.type = "java.lang.Integer";
                        break;
                    }
                    case "Long": {
                        this.type = "java.lang.Long";
                        break;
                    }
                    case "Float": {
                        this.type = "java.lang.Float";
                        break;
                    }
                    case "Double": {
                        this.type = "java.lang.Double";
                        break;
                    }
                    case "String": {
                        this.type = "java.lang.String";
                        break;
                    }
                    case "Object": {
                        this.type = "java.lang.Object";
                        break;
                    }
                    default: {
                        this.type = string;
                        break;
                    }
                }
            } else {
                this.type = string;
            }
        }

        public void setRequestTime(boolean bl) {
            this.requestTime = bl;
        }

        public void setFragment(boolean bl) {
            this.fragment = bl;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public void setDeferredValue() {
            this.deferredValue = true;
        }

        public void setDeferredMethod() {
            this.deferredMethod = true;
        }

        public void setExpectedTypeName(String string) {
            this.expectedTypeName = string;
        }

        public void setMethodSignature(String string) {
            this.methodSignature = string;
        }

        public TagAttributeInfo toTagAttributeInfo() {
            if (this.fragment) {
                this.type = "jakarta.servlet.jsp.tagext.JspFragment";
                this.requestTime = true;
            } else if (this.deferredValue) {
                this.type = "jakarta.el.ValueExpression";
                if (this.expectedTypeName == null) {
                    this.expectedTypeName = "java.lang.Object";
                }
            } else if (this.deferredMethod) {
                this.type = "jakarta.el.MethodExpression";
                if (this.methodSignature == null) {
                    this.methodSignature = "java.lang.Object method()";
                }
            }
            if (!this.requestTime && this.type == null) {
                this.type = "java.lang.String";
            }
            return new TagAttributeInfo(this.name, this.required, this.type, this.requestTime, this.fragment, this.description, this.deferredValue, this.deferredMethod, this.expectedTypeName, this.methodSignature);
        }
    }
}

