/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload.util.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.tomcat.util.http.fileupload.util.mime.ParseException;
import org.apache.tomcat.util.http.fileupload.util.mime.QuotedPrintableDecoder;

public final class MimeUtility {
    private static final String BASE64_ENCODING_MARKER = "B";
    private static final String QUOTEDPRINTABLE_ENCODING_MARKER = "Q";
    private static final String ENCODED_TOKEN_MARKER = "=?";
    private static final String ENCODED_TOKEN_FINISHER = "?=";
    private static final String LINEAR_WHITESPACE = " \t\r\n";
    private static final Map<String, String> MIME2JAVA = new HashMap<String, String>();

    private MimeUtility() {
    }

    public static String decodeText(String string) throws UnsupportedEncodingException {
        if (!string.contains(ENCODED_TOKEN_MARKER)) {
            return string;
        }
        int n = 0;
        int n2 = string.length();
        int n3 = -1;
        int n4 = -1;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        block2: while (n < n2) {
            char c = string.charAt(n);
            if (LINEAR_WHITESPACE.indexOf(c) != -1) {
                n3 = n;
                while (n < n2) {
                    c = string.charAt(n);
                    if (LINEAR_WHITESPACE.indexOf(c) == -1) {
                        n4 = n;
                        continue block2;
                    }
                    ++n;
                }
                continue;
            }
            int n5 = n;
            while (n < n2 && LINEAR_WHITESPACE.indexOf(c = string.charAt(n)) == -1) {
                ++n;
            }
            String string2 = string.substring(n5, n);
            if (string2.startsWith(ENCODED_TOKEN_MARKER)) {
                try {
                    String string3 = MimeUtility.decodeWord(string2);
                    if (!bl && n3 != -1) {
                        stringBuilder.append(string, n3, n4);
                        n3 = -1;
                    }
                    bl = true;
                    stringBuilder.append(string3);
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (n3 != -1) {
                stringBuilder.append(string, n3, n4);
                n3 = -1;
            }
            bl = false;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static String decodeWord(String string) throws ParseException, UnsupportedEncodingException {
        if (!string.startsWith(ENCODED_TOKEN_MARKER)) {
            throw new ParseException("Invalid RFC 2047 encoded-word: " + string);
        }
        int n = string.indexOf(63, 2);
        if (n == -1) {
            throw new ParseException("Missing charset in RFC 2047 encoded-word: " + string);
        }
        String string2 = string.substring(2, n).toLowerCase(Locale.ENGLISH);
        int n2 = string.indexOf(63, n + 1);
        if (n2 == -1) {
            throw new ParseException("Missing encoding in RFC 2047 encoded-word: " + string);
        }
        String string3 = string.substring(n + 1, n2);
        int n3 = string.indexOf(ENCODED_TOKEN_FINISHER, n2 + 1);
        if (n3 == -1) {
            throw new ParseException("Missing encoded text in RFC 2047 encoded-word: " + string);
        }
        String string4 = string.substring(n2 + 1, n3);
        if (string4.isEmpty()) {
            return "";
        }
        try {
            byte[] byArray;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string4.length());
            if (string3.equals(BASE64_ENCODING_MARKER)) {
                byArray = Base64.getDecoder().decode(string4);
            } else if (string3.equals(QUOTEDPRINTABLE_ENCODING_MARKER)) {
                byte[] byArray2 = string4.getBytes(StandardCharsets.US_ASCII);
                QuotedPrintableDecoder.decode(byArray2, byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            } else {
                throw new UnsupportedEncodingException("Unknown RFC 2047 encoding: " + string3);
            }
            return new String(byArray, MimeUtility.javaCharset(string2));
        }
        catch (IOException iOException) {
            throw new UnsupportedEncodingException("Invalid RFC 2047 encoding");
        }
    }

    private static String javaCharset(String string) {
        if (string == null) {
            return null;
        }
        String string2 = MIME2JAVA.get(string.toLowerCase(Locale.ENGLISH));
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    static {
        MIME2JAVA.put("iso-2022-cn", "ISO2022CN");
        MIME2JAVA.put("iso-2022-kr", "ISO2022KR");
        MIME2JAVA.put("utf-8", "UTF8");
        MIME2JAVA.put("utf8", "UTF8");
        MIME2JAVA.put("ja_jp.iso2022-7", "ISO2022JP");
        MIME2JAVA.put("ja_jp.eucjp", "EUCJIS");
        MIME2JAVA.put("euc-kr", "KSC5601");
        MIME2JAVA.put("euckr", "KSC5601");
        MIME2JAVA.put("us-ascii", "ISO-8859-1");
        MIME2JAVA.put("x-us-ascii", "ISO-8859-1");
    }
}

