/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager.host;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.util.LifecycleBase;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.res.StringManager;

public class HostManagerServlet
extends HttpServlet
implements ContainerServlet {
    private static final long serialVersionUID = 1L;
    protected transient Context context = null;
    protected int debug = 1;
    protected transient Host installedHost = null;
    protected transient Engine engine = null;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.manager.host");
    protected transient Wrapper wrapper = null;

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper == null) {
            this.context = null;
            this.installedHost = null;
            this.engine = null;
        } else {
            this.context = (Context)wrapper.getParent();
            this.installedHost = (Host)this.context.getParent();
            this.engine = (Engine)this.installedHost.getParent();
        }
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.manager.host", (Enumeration)httpServletRequest.getLocales());
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        String string2 = httpServletRequest.getParameter("name");
        httpServletResponse.setContentType("text/plain; charset=utf-8");
        httpServletResponse.setHeader("X-Content-Type-Options", "nosniff");
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (string == null) {
            printWriter.println(stringManager.getString("hostManagerServlet.noCommand"));
        } else if (string.equals("/add")) {
            this.add(httpServletRequest, printWriter, string2, false, stringManager);
        } else if (string.equals("/remove")) {
            this.remove(printWriter, string2, stringManager);
        } else if (string.equals("/list")) {
            this.list(printWriter, stringManager);
        } else if (string.equals("/start")) {
            this.start(printWriter, string2, stringManager);
        } else if (string.equals("/stop")) {
            this.stop(printWriter, string2, stringManager);
        } else if (string.equals("/persist")) {
            this.persist(printWriter, stringManager);
        } else {
            printWriter.println(stringManager.getString("hostManagerServlet.unknownCommand", new Object[]{string}));
        }
        printWriter.flush();
        printWriter.close();
    }

    protected void add(HttpServletRequest httpServletRequest, PrintWriter printWriter, String string, boolean bl, StringManager stringManager) {
        String string2 = httpServletRequest.getParameter("aliases");
        String string3 = httpServletRequest.getParameter("appBase");
        boolean bl2 = this.booleanParameter(httpServletRequest, "manager", false, bl);
        boolean bl3 = this.booleanParameter(httpServletRequest, "autoDeploy", true, bl);
        boolean bl4 = this.booleanParameter(httpServletRequest, "deployOnStartup", true, bl);
        boolean bl5 = this.booleanParameter(httpServletRequest, "deployXML", true, bl);
        boolean bl6 = this.booleanParameter(httpServletRequest, "unpackWARs", true, bl);
        boolean bl7 = this.booleanParameter(httpServletRequest, "copyXML", false, bl);
        this.add(printWriter, string, string2, string3, bl2, bl3, bl4, bl5, bl6, bl7, stringManager);
    }

    protected boolean booleanParameter(HttpServletRequest httpServletRequest, String string, boolean bl, boolean bl2) {
        String string2 = httpServletRequest.getParameter(string);
        boolean bl3 = bl;
        if (string2 != null) {
            if (bl2) {
                if (string2.equals("on")) {
                    bl3 = true;
                }
            } else if (bl) {
                if (string2.equals("false")) {
                    bl3 = false;
                }
            } else if (string2.equals("true")) {
                bl3 = true;
            }
        } else if (bl2) {
            bl3 = false;
        }
        return bl3;
    }

    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("hostManagerServlet.noWrapper"));
        }
        String string = null;
        try {
            string = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
    }

    protected synchronized void add(PrintWriter printWriter, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, StringManager stringManager) {
        Object object;
        Object object2;
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.add", new Object[]{string}));
        }
        if (string == null || string.length() == 0) {
            printWriter.println(stringManager.getString("hostManagerServlet.invalidHostName", new Object[]{string}));
            return;
        }
        if (this.engine.findChild(string) != null) {
            printWriter.println(stringManager.getString("hostManagerServlet.alreadyHost", new Object[]{string}));
            return;
        }
        File file = null;
        File file2 = null;
        String string4 = string3;
        if (string4 == null || string4.length() == 0) {
            string4 = string;
        }
        if (!(file2 = new File(string4)).isAbsolute()) {
            file2 = new File(this.engine.getCatalinaBase(), file2.getPath());
        }
        try {
            file = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file2;
        }
        if (!file.mkdirs() && !file.isDirectory()) {
            printWriter.println(stringManager.getString("hostManagerServlet.appBaseCreateFail", new Object[]{file.toString(), string}));
            return;
        }
        File file3 = this.getConfigBase(string);
        if (bl) {
            if (file3 == null) {
                printWriter.println(stringManager.getString("hostManagerServlet.configBaseCreateFail", new Object[]{string}));
                return;
            }
            try {
                object2 = this.getServletContext().getResourceAsStream("/WEB-INF/manager.xml");
                try {
                    if (object2 == null) {
                        printWriter.println(stringManager.getString("hostManagerServlet.managerXml"));
                        return;
                    }
                    object = new File(file3, "manager.xml").toPath();
                    Files.copy((InputStream)object2, (Path)object, new CopyOption[0]);
                }
                finally {
                    if (object2 != null) {
                        ((InputStream)object2).close();
                    }
                }
            }
            catch (IOException iOException) {
                printWriter.println(stringManager.getString("hostManagerServlet.managerXml"));
                return;
            }
        }
        object2 = new StandardHost();
        ((StandardHost)object2).setAppBase(string4);
        ((StandardHost)object2).setName(string);
        ((LifecycleBase)object2).addLifecycleListener(new HostConfig());
        if (string2 != null && !string2.isEmpty()) {
            object = new StringTokenizer(string2, ", ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                ((StandardHost)object2).addAlias(((StringTokenizer)object).nextToken());
            }
        }
        ((StandardHost)object2).setAutoDeploy(bl2);
        ((StandardHost)object2).setDeployOnStartup(bl3);
        ((StandardHost)object2).setDeployXML(bl4);
        ((StandardHost)object2).setUnpackWARs(bl5);
        ((StandardHost)object2).setCopyXML(bl6);
        try {
            this.engine.addChild((Container)object2);
        }
        catch (Exception exception) {
            printWriter.println(stringManager.getString("hostManagerServlet.exception", new Object[]{exception.toString()}));
            return;
        }
        object2 = (StandardHost)this.engine.findChild(string);
        if (object2 != null) {
            printWriter.println(stringManager.getString("hostManagerServlet.addSuccess", new Object[]{string}));
        } else {
            printWriter.println(stringManager.getString("hostManagerServlet.addFailed", new Object[]{string}));
        }
    }

    protected synchronized void remove(PrintWriter printWriter, String string, StringManager stringManager) {
        Container container;
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.remove", new Object[]{string}));
        }
        if (string == null || string.length() == 0) {
            printWriter.println(stringManager.getString("hostManagerServlet.invalidHostName", new Object[]{string}));
            return;
        }
        if (this.engine.findChild(string) == null) {
            printWriter.println(stringManager.getString("hostManagerServlet.noHost", new Object[]{string}));
            return;
        }
        if (this.engine.findChild(string) == this.installedHost) {
            printWriter.println(stringManager.getString("hostManagerServlet.cannotRemoveOwnHost", new Object[]{string}));
            return;
        }
        try {
            container = this.engine.findChild(string);
            this.engine.removeChild(container);
            if (container instanceof ContainerBase) {
                container.destroy();
            }
        }
        catch (Exception exception) {
            printWriter.println(stringManager.getString("hostManagerServlet.exception", new Object[]{exception.toString()}));
            return;
        }
        container = (StandardHost)this.engine.findChild(string);
        if (container == null) {
            printWriter.println(stringManager.getString("hostManagerServlet.removeSuccess", new Object[]{string}));
        } else {
            printWriter.println(stringManager.getString("hostManagerServlet.removeFailed", new Object[]{string}));
        }
    }

    protected void list(PrintWriter printWriter, StringManager stringManager) {
        Container[] containerArray;
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.list", new Object[]{this.engine.getName()}));
        }
        printWriter.println(stringManager.getString("hostManagerServlet.listed", new Object[]{this.engine.getName()}));
        for (Container container : containerArray = this.engine.findChildren()) {
            Host host = (Host)container;
            String string = host.getName();
            String[] stringArray = host.findAliases();
            printWriter.println(String.format("[%s]:[%s]", string, StringUtils.join((String[])stringArray)));
        }
    }

    protected void start(PrintWriter printWriter, String string, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.start", new Object[]{string}));
        }
        if (string == null || string.length() == 0) {
            printWriter.println(stringManager.getString("hostManagerServlet.invalidHostName", new Object[]{string}));
            return;
        }
        Container container = this.engine.findChild(string);
        if (container == null) {
            printWriter.println(stringManager.getString("hostManagerServlet.noHost", new Object[]{string}));
            return;
        }
        if (container == this.installedHost) {
            printWriter.println(stringManager.getString("hostManagerServlet.cannotStartOwnHost", new Object[]{string}));
            return;
        }
        if (container.getState().isAvailable()) {
            printWriter.println(stringManager.getString("hostManagerServlet.alreadyStarted", new Object[]{string}));
            return;
        }
        try {
            container.start();
            printWriter.println(stringManager.getString("hostManagerServlet.started", new Object[]{string}));
        }
        catch (Exception exception) {
            this.getServletContext().log(sm.getString("hostManagerServlet.startFailed", new Object[]{string}), (Throwable)exception);
            printWriter.println(stringManager.getString("hostManagerServlet.startFailed", new Object[]{string}));
            printWriter.println(stringManager.getString("hostManagerServlet.exception", new Object[]{exception.toString()}));
        }
    }

    protected void stop(PrintWriter printWriter, String string, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.stop", new Object[]{string}));
        }
        if (string == null || string.length() == 0) {
            printWriter.println(stringManager.getString("hostManagerServlet.invalidHostName", new Object[]{string}));
            return;
        }
        Container container = this.engine.findChild(string);
        if (container == null) {
            printWriter.println(stringManager.getString("hostManagerServlet.noHost", new Object[]{string}));
            return;
        }
        if (container == this.installedHost) {
            printWriter.println(stringManager.getString("hostManagerServlet.cannotStopOwnHost", new Object[]{string}));
            return;
        }
        if (!container.getState().isAvailable()) {
            printWriter.println(stringManager.getString("hostManagerServlet.alreadyStopped", new Object[]{string}));
            return;
        }
        try {
            container.stop();
            printWriter.println(stringManager.getString("hostManagerServlet.stopped", new Object[]{string}));
        }
        catch (Exception exception) {
            this.getServletContext().log(sm.getString("hostManagerServlet.stopFailed", new Object[]{string}), (Throwable)exception);
            printWriter.println(stringManager.getString("hostManagerServlet.stopFailed", new Object[]{string}));
            printWriter.println(stringManager.getString("hostManagerServlet.exception", new Object[]{exception.toString()}));
        }
    }

    protected void persist(PrintWriter printWriter, StringManager stringManager) {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.persist"));
        }
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(this.engine.getDomain() + ":type=StoreConfig");
            mBeanServer.invoke(objectName, "storeConfig", null, null);
            printWriter.println(stringManager.getString("hostManagerServlet.persisted"));
        }
        catch (Exception exception) {
            this.getServletContext().log(sm.getString("hostManagerServlet.persistFailed"), (Throwable)exception);
            printWriter.println(stringManager.getString("hostManagerServlet.persistFailed"));
            if (exception instanceof InstanceNotFoundException) {
                printWriter.println(stringManager.getString("hostManagerServlet.noStoreConfig"));
            }
            printWriter.println(stringManager.getString("hostManagerServlet.exception", new Object[]{exception.toString()}));
        }
    }

    protected File getConfigBase(String string) {
        File file = new File(this.context.getCatalinaBase(), "conf");
        if (!file.exists()) {
            return null;
        }
        if (this.engine != null) {
            file = new File(file, this.engine.getName());
        }
        if (this.installedHost != null) {
            file = new File(file, string);
        }
        if (!file.mkdirs() && !file.isDirectory()) {
            return null;
        }
        return file;
    }
}

