/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.netbeans.core.startup.logging.NbFormatter;

final class MessagesHandler
extends StreamHandler {
    static final int MAX_REPEAT_COUNT_FLUSH = 10;
    private final File dir;
    private final File[] files;
    private final long limit;
    private final boolean filterRepeats;
    private LogRecord lastLogRecord;
    private LogRecord repeatingRecord;
    private long repeatCounter;
    private long lastRecordAllRepeatsCounter = 1L;

    MessagesHandler(File file) {
        this(file, -1, 0x100000L);
    }

    MessagesHandler(File file, int n, long l) {
        this.dir = file;
        if (n == -1 && (n = Integer.getInteger("org.netbeans.log.numberOfFiles", 3).intValue()) < 3) {
            n = 3;
        }
        File[] fileArray = new File[n];
        fileArray[0] = new File(file, "messages.log");
        for (int i = 1; i < fileArray.length; ++i) {
            fileArray[i] = new File(file, "messages.log." + i);
        }
        this.files = fileArray;
        this.limit = l;
        this.filterRepeats = !Boolean.getBoolean("org.netbeans.log.disableRepeatingMessagesFilter");
        this.setFormatter(NbFormatter.FORMATTER);
        this.setLevel(Level.ALL);
        this.checkRotate(true);
        this.initStream();
    }

    private boolean checkRotate(boolean bl) {
        if (!bl && this.files[0].length() < this.limit) {
            return false;
        }
        this.flush();
        this.doRotate();
        return true;
    }

    private void initStream() {
        try {
            this.setOutputStream(new FileOutputStream(this.files[0], false));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setOutputStream(System.err);
        }
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        if (this.filterRepeats) {
            if (this.lastLogRecord != null) {
                if (this.compareRepeating(this.lastLogRecord, logRecord)) {
                    ++this.repeatCounter;
                    ++this.lastRecordAllRepeatsCounter;
                    LogRecord logRecord2 = this.createRepeatingRecord(logRecord, this.repeatCounter);
                    if (logRecord2 != null) {
                        this.repeatingRecord = logRecord2;
                    }
                    return;
                }
                if (this.repeatCounter > 0L || this.lastRecordAllRepeatsCounter > 1L) {
                    if (this.lastRecordAllRepeatsCounter > 10L) {
                        this.repeatingRecord = this.createAllRepeatsRecord(this.lastLogRecord, this.lastRecordAllRepeatsCounter);
                    }
                    this.flushRepeatCounter();
                    this.lastRecordAllRepeatsCounter = 1L;
                }
            }
            this.lastLogRecord = logRecord;
        }
        super.publish(logRecord);
        if (this.checkRotate(false)) {
            this.initStream();
        }
    }

    @Override
    public synchronized void flush() {
        this.flushRepeatCounter();
        super.flush();
    }

    private synchronized void doRotate() {
        this.close();
        int n = this.files.length;
        if (this.files[n - 1].exists()) {
            this.files[n - 1].delete();
        }
        for (int i = n - 2; i >= 0; --i) {
            if (!this.files[i].exists()) continue;
            this.files[i].renameTo(this.files[i + 1]);
        }
    }

    private synchronized void flushRepeatCounter() {
        if (this.repeatingRecord != null) {
            super.publish(this.repeatingRecord);
            this.repeatingRecord = null;
        }
        this.repeatCounter = 0L;
    }

    private boolean compareRepeating(LogRecord logRecord, LogRecord logRecord2) {
        return logRecord.getLevel().equals(logRecord2.getLevel()) && Objects.equals(logRecord.getLoggerName(), logRecord2.getLoggerName()) && Objects.equals(logRecord.getMessage(), logRecord2.getMessage()) && Objects.deepEquals(logRecord.getParameters(), logRecord2.getParameters()) && Objects.equals(logRecord.getResourceBundle(), logRecord2.getResourceBundle()) && Objects.equals(logRecord.getResourceBundleName(), logRecord2.getResourceBundleName()) && Objects.equals(logRecord.getSourceClassName(), logRecord2.getSourceClassName()) && Objects.equals(logRecord.getSourceMethodName(), logRecord2.getSourceMethodName()) && this.compareThrown(logRecord.getThrown(), logRecord2.getThrown());
    }

    private boolean compareThrown(Throwable throwable, Throwable throwable2) {
        if (throwable == null) {
            return throwable2 == null;
        }
        if (throwable2 == null) {
            return false;
        }
        return throwable.getClass().equals(throwable2.getClass()) && Objects.equals(throwable.getMessage(), throwable2.getMessage()) && Objects.equals(throwable.getLocalizedMessage(), throwable2.getLocalizedMessage()) && Arrays.deepEquals(throwable.getStackTrace(), throwable2.getStackTrace()) && this.compareThrown(throwable.getCause(), throwable2.getCause());
    }

    private LogRecord createRepeatingRecord(LogRecord logRecord, long l) {
        if (this.lastRecordAllRepeatsCounter <= 11L) {
            return new LogRecord(logRecord.getLevel(), MessagesHandler.getRepeatingMessage(l, this.lastRecordAllRepeatsCounter));
        }
        return null;
    }

    private LogRecord createAllRepeatsRecord(LogRecord logRecord, long l) {
        return new LogRecord(logRecord.getLevel(), MessagesHandler.getAllRepeatsMessage(l));
    }

    static String getRepeatingMessage(long l, long l2) {
        String string = l2 > 10L ? "Last record repeated more than 10 times, further logs of this record are ignored until the log record changes." : (l == 1L ? "Last record repeated again." : "Last record repeated " + l + " more times.");
        return string;
    }

    static String getAllRepeatsMessage(long l) {
        return "Last record repeated " + l + " times in total.";
    }
}

