/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import com.ibm.icu.text.Normalizer2;
import java.io.InputStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUFoldingFilter;
import org.apache.lucene.analysis.icu.ICUNormalizer2Filter;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;
import org.opensearch.index.analysis.IcuNormalizerTokenFilterFactory;
import org.opensearch.index.analysis.NormalizingTokenFilterFactory;

public class IcuFoldingTokenFilterFactory
extends AbstractTokenFilterFactory
implements NormalizingTokenFilterFactory {
    private static final Normalizer2 ICU_FOLDING_NORMALIZER = Normalizer2.getInstance((InputStream)ICUFoldingFilter.class.getResourceAsStream("utr30.nrm"), (String)"utr30", (Normalizer2.Mode)Normalizer2.Mode.COMPOSE);
    private final Normalizer2 normalizer;

    public IcuFoldingTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.normalizer = IcuNormalizerTokenFilterFactory.wrapWithUnicodeSetFilter(indexSettings, ICU_FOLDING_NORMALIZER, settings);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ICUNormalizer2Filter(tokenStream, this.normalizer);
    }
}

