/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.knn.index.codec.params.KNNScalarQuantizedVectorsFormatParams;
import org.opensearch.knn.index.codec.params.KNNVectorsFormatParams;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.util.KNNEngine;

public abstract class BasePerFieldKnnVectorsFormat
extends PerFieldKnnVectorsFormat {
    @Generated
    private static final Logger log = LogManager.getLogger(BasePerFieldKnnVectorsFormat.class);
    private final Optional<MapperService> mapperService;
    private final int defaultMaxConnections;
    private final int defaultBeamWidth;
    private final Supplier<KnnVectorsFormat> defaultFormatSupplier;
    private final Function<KNNVectorsFormatParams, KnnVectorsFormat> vectorsFormatSupplier;
    private Function<KNNScalarQuantizedVectorsFormatParams, KnnVectorsFormat> scalarQuantizedVectorsFormatSupplier;
    private static final String MAX_CONNECTIONS = "max_connections";
    private static final String BEAM_WIDTH = "beam_width";

    public BasePerFieldKnnVectorsFormat(Optional<MapperService> mapperService, int defaultMaxConnections, int defaultBeamWidth, Supplier<KnnVectorsFormat> defaultFormatSupplier, Function<KNNVectorsFormatParams, KnnVectorsFormat> vectorsFormatSupplier) {
        this.mapperService = mapperService;
        this.defaultMaxConnections = defaultMaxConnections;
        this.defaultBeamWidth = defaultBeamWidth;
        this.defaultFormatSupplier = defaultFormatSupplier;
        this.vectorsFormatSupplier = vectorsFormatSupplier;
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        KNNScalarQuantizedVectorsFormatParams knnScalarQuantizedVectorsFormatParams;
        if (!this.isKnnVectorFieldType(field)) {
            log.debug("Initialize KNN vector format for field [{}] with default params [{}] = \"{}\" and [{}] = \"{}\"", (Object)field, (Object)MAX_CONNECTIONS, (Object)this.defaultMaxConnections, (Object)BEAM_WIDTH, (Object)this.defaultBeamWidth);
            return this.defaultFormatSupplier.get();
        }
        KNNVectorFieldMapper.KNNVectorFieldType type = (KNNVectorFieldMapper.KNNVectorFieldType)this.mapperService.orElseThrow(() -> new IllegalStateException(String.format("Cannot read field type for field [%s] because mapper service is not available", field))).fieldType(field);
        Map<String, Object> params = type.getKnnMethodContext().getMethodComponentContext().getParameters();
        if (type.getKnnMethodContext().getKnnEngine() == KNNEngine.LUCENE && params != null && params.containsKey("encoder") && (knnScalarQuantizedVectorsFormatParams = new KNNScalarQuantizedVectorsFormatParams(params, this.defaultMaxConnections, this.defaultBeamWidth)).validate(params)) {
            log.debug("Initialize KNN vector format for field [{}] with params [{}] = \"{}\", [{}] = \"{}\", [{}] = \"{}\", [{}] = \"{}\"", (Object)field, (Object)MAX_CONNECTIONS, (Object)knnScalarQuantizedVectorsFormatParams.getMaxConnections(), (Object)BEAM_WIDTH, (Object)knnScalarQuantizedVectorsFormatParams.getBeamWidth(), (Object)"confidence_interval", (Object)knnScalarQuantizedVectorsFormatParams.getConfidenceInterval(), (Object)"bits", (Object)knnScalarQuantizedVectorsFormatParams.getBits());
            return this.scalarQuantizedVectorsFormatSupplier.apply(knnScalarQuantizedVectorsFormatParams);
        }
        KNNVectorsFormatParams knnVectorsFormatParams = new KNNVectorsFormatParams(params, this.defaultMaxConnections, this.defaultBeamWidth);
        log.debug("Initialize KNN vector format for field [{}] with params [{}] = \"{}\" and [{}] = \"{}\"", (Object)field, (Object)MAX_CONNECTIONS, (Object)knnVectorsFormatParams.getMaxConnections(), (Object)BEAM_WIDTH, (Object)knnVectorsFormatParams.getBeamWidth());
        return this.vectorsFormatSupplier.apply(knnVectorsFormatParams);
    }

    public int getMaxDimensions(String fieldName) {
        return this.getKnnVectorsFormatForField(fieldName).getMaxDimensions(fieldName);
    }

    private boolean isKnnVectorFieldType(String field) {
        return this.mapperService.isPresent() && this.mapperService.get().fieldType(field) instanceof KNNVectorFieldMapper.KNNVectorFieldType;
    }

    @Generated
    public BasePerFieldKnnVectorsFormat(Optional<MapperService> mapperService, int defaultMaxConnections, int defaultBeamWidth, Supplier<KnnVectorsFormat> defaultFormatSupplier, Function<KNNVectorsFormatParams, KnnVectorsFormat> vectorsFormatSupplier, Function<KNNScalarQuantizedVectorsFormatParams, KnnVectorsFormat> scalarQuantizedVectorsFormatSupplier) {
        this.mapperService = mapperService;
        this.defaultMaxConnections = defaultMaxConnections;
        this.defaultBeamWidth = defaultBeamWidth;
        this.defaultFormatSupplier = defaultFormatSupplier;
        this.vectorsFormatSupplier = vectorsFormatSupplier;
        this.scalarQuantizedVectorsFormatSupplier = scalarQuantizedVectorsFormatSupplier;
    }
}

