/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import lombok.NonNull;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.document.KnnVectorField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.opensearch.common.Explicit;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.VectorField;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;
import org.opensearch.knn.index.util.KNNEngine;

public class LuceneFieldMapper
extends KNNVectorFieldMapper {
    private final FieldType vectorFieldType;
    private final VectorDataType vectorDataType;

    LuceneFieldMapper(CreateLuceneFieldMapperInput input) {
        super(input.getName(), input.getMappedFieldType(), input.getMultiFields(), input.getCopyTo(), input.getIgnoreMalformed(), input.isStored(), input.isHasDocValues(), input.getKnnMethodContext().getMethodComponentContext().getIndexVersion());
        this.vectorDataType = input.getVectorDataType();
        this.knnMethod = input.getKnnMethodContext();
        VectorSimilarityFunction vectorSimilarityFunction = this.knnMethod.getSpaceType().getKnnVectorSimilarityFunction().getVectorSimilarityFunction();
        int dimension = input.getMappedFieldType().getDimension();
        if (dimension > KNNEngine.getMaxDimensionByEngine(KNNEngine.LUCENE)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Dimension value cannot be greater than [%s] but got [%s] for vector [%s]", KNNEngine.getMaxDimensionByEngine(KNNEngine.LUCENE), dimension, input.getName()));
        }
        this.fieldType = this.vectorDataType.createKnnVectorFieldType(dimension, vectorSimilarityFunction);
        this.vectorFieldType = this.hasDocValues ? KNNVectorFieldMapperUtil.buildDocValuesFieldType(this.knnMethod.getKnnEngine()) : null;
    }

    @Override
    protected List<Field> getFieldsForFloatVector(float[] array, FieldType fieldType) {
        ArrayList<Field> fieldsToBeAdded = new ArrayList<Field>();
        fieldsToBeAdded.add((Field)new KnnVectorField(this.name(), array, fieldType));
        if (this.hasDocValues && this.vectorFieldType != null) {
            fieldsToBeAdded.add(new VectorField(this.name(), array, (IndexableFieldType)this.vectorFieldType));
        }
        if (this.stored) {
            fieldsToBeAdded.add((Field)KNNVectorFieldMapperUtil.createStoredFieldForFloatVector(this.name(), array));
        }
        return fieldsToBeAdded;
    }

    @Override
    protected List<Field> getFieldsForByteVector(byte[] array, FieldType fieldType) {
        ArrayList<Field> fieldsToBeAdded = new ArrayList<Field>();
        fieldsToBeAdded.add((Field)new KnnByteVectorField(this.name(), array, fieldType));
        if (this.hasDocValues && this.vectorFieldType != null) {
            fieldsToBeAdded.add(new VectorField(this.name(), array, (IndexableFieldType)this.vectorFieldType));
        }
        if (this.stored) {
            fieldsToBeAdded.add((Field)KNNVectorFieldMapperUtil.createStoredFieldForByteVector(this.name(), array));
        }
        return fieldsToBeAdded;
    }

    @Override
    void updateEngineStats() {
        KNNEngine.LUCENE.setInitialized(true);
    }

    static class CreateLuceneFieldMapperInput {
        @NonNull
        String name;
        @NonNull
        KNNVectorFieldMapper.KNNVectorFieldType mappedFieldType;
        @NonNull
        FieldMapper.MultiFields multiFields;
        @NonNull
        FieldMapper.CopyTo copyTo;
        @NonNull
        Explicit<Boolean> ignoreMalformed;
        boolean stored;
        boolean hasDocValues;
        VectorDataType vectorDataType;
        @NonNull
        KNNMethodContext knnMethodContext;

        @Generated
        public static CreateLuceneFieldMapperInputBuilder builder() {
            return new CreateLuceneFieldMapperInputBuilder();
        }

        @Generated
        public CreateLuceneFieldMapperInput(@NonNull String name, @NonNull KNNVectorFieldMapper.KNNVectorFieldType mappedFieldType, @NonNull FieldMapper.MultiFields multiFields, @NonNull FieldMapper.CopyTo copyTo, @NonNull Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, VectorDataType vectorDataType, @NonNull KNNMethodContext knnMethodContext) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (mappedFieldType == null) {
                throw new NullPointerException("mappedFieldType is marked non-null but is null");
            }
            if (multiFields == null) {
                throw new NullPointerException("multiFields is marked non-null but is null");
            }
            if (copyTo == null) {
                throw new NullPointerException("copyTo is marked non-null but is null");
            }
            if (ignoreMalformed == null) {
                throw new NullPointerException("ignoreMalformed is marked non-null but is null");
            }
            if (knnMethodContext == null) {
                throw new NullPointerException("knnMethodContext is marked non-null but is null");
            }
            this.name = name;
            this.mappedFieldType = mappedFieldType;
            this.multiFields = multiFields;
            this.copyTo = copyTo;
            this.ignoreMalformed = ignoreMalformed;
            this.stored = stored;
            this.hasDocValues = hasDocValues;
            this.vectorDataType = vectorDataType;
            this.knnMethodContext = knnMethodContext;
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public KNNVectorFieldMapper.KNNVectorFieldType getMappedFieldType() {
            return this.mappedFieldType;
        }

        @NonNull
        @Generated
        public FieldMapper.MultiFields getMultiFields() {
            return this.multiFields;
        }

        @NonNull
        @Generated
        public FieldMapper.CopyTo getCopyTo() {
            return this.copyTo;
        }

        @NonNull
        @Generated
        public Explicit<Boolean> getIgnoreMalformed() {
            return this.ignoreMalformed;
        }

        @Generated
        public boolean isStored() {
            return this.stored;
        }

        @Generated
        public boolean isHasDocValues() {
            return this.hasDocValues;
        }

        @Generated
        public VectorDataType getVectorDataType() {
            return this.vectorDataType;
        }

        @NonNull
        @Generated
        public KNNMethodContext getKnnMethodContext() {
            return this.knnMethodContext;
        }

        @Generated
        public static class CreateLuceneFieldMapperInputBuilder {
            @Generated
            private String name;
            @Generated
            private KNNVectorFieldMapper.KNNVectorFieldType mappedFieldType;
            @Generated
            private FieldMapper.MultiFields multiFields;
            @Generated
            private FieldMapper.CopyTo copyTo;
            @Generated
            private Explicit<Boolean> ignoreMalformed;
            @Generated
            private boolean stored;
            @Generated
            private boolean hasDocValues;
            @Generated
            private VectorDataType vectorDataType;
            @Generated
            private KNNMethodContext knnMethodContext;

            @Generated
            CreateLuceneFieldMapperInputBuilder() {
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder mappedFieldType(@NonNull KNNVectorFieldMapper.KNNVectorFieldType mappedFieldType) {
                if (mappedFieldType == null) {
                    throw new NullPointerException("mappedFieldType is marked non-null but is null");
                }
                this.mappedFieldType = mappedFieldType;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder multiFields(@NonNull FieldMapper.MultiFields multiFields) {
                if (multiFields == null) {
                    throw new NullPointerException("multiFields is marked non-null but is null");
                }
                this.multiFields = multiFields;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder copyTo(@NonNull FieldMapper.CopyTo copyTo) {
                if (copyTo == null) {
                    throw new NullPointerException("copyTo is marked non-null but is null");
                }
                this.copyTo = copyTo;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder ignoreMalformed(@NonNull Explicit<Boolean> ignoreMalformed) {
                if (ignoreMalformed == null) {
                    throw new NullPointerException("ignoreMalformed is marked non-null but is null");
                }
                this.ignoreMalformed = ignoreMalformed;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder stored(boolean stored) {
                this.stored = stored;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder hasDocValues(boolean hasDocValues) {
                this.hasDocValues = hasDocValues;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder vectorDataType(VectorDataType vectorDataType) {
                this.vectorDataType = vectorDataType;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder knnMethodContext(@NonNull KNNMethodContext knnMethodContext) {
                if (knnMethodContext == null) {
                    throw new NullPointerException("knnMethodContext is marked non-null but is null");
                }
                this.knnMethodContext = knnMethodContext;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInput build() {
                return new CreateLuceneFieldMapperInput(this.name, this.mappedFieldType, this.multiFields, this.copyTo, this.ignoreMalformed, this.stored, this.hasDocValues, this.vectorDataType, this.knnMethodContext);
            }

            @Generated
            public String toString() {
                return "LuceneFieldMapper.CreateLuceneFieldMapperInput.CreateLuceneFieldMapperInputBuilder(name=" + this.name + ", mappedFieldType=" + this.mappedFieldType + ", multiFields=" + this.multiFields + ", copyTo=" + this.copyTo + ", ignoreMalformed=" + this.ignoreMalformed + ", stored=" + this.stored + ", hasDocValues=" + this.hasDocValues + ", vectorDataType=" + this.vectorDataType + ", knnMethodContext=" + this.knnMethodContext + ")";
            }
        }
    }
}

