/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.profiler.api.GoToSource;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.locks.LiveLocksViewUpdater;
import org.graalvm.visualvm.lib.ui.locks.LockContentionPanel;
import org.graalvm.visualvm.lib.ui.swing.ActionPopupButton;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.graalvm.visualvm.profiler.Bundle;
import org.graalvm.visualvm.profiler.ProfilingResultsSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

class LocksLivePanel
extends ProfilingResultsSupport.ResultsView {
    private ProfilerToolbar toolbar;
    private LockContentionPanel locksView;
    private LiveLocksViewUpdater updater;
    private ProfilingResultsSupport.ResultsResetter resetter;
    private JLabel lrLabel;
    private JToggleButton lrPauseButton;
    private JButton lrRefreshButton;
    private boolean popupPause;
    private JLabel shLabel;
    private ActionPopupButton shAggregation;

    LocksLivePanel(Application application) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.initUI(application);
        this.add((Component)this.toolbar.getComponent(), "North");
        this.add((Component)this.locksView, "Center");
    }

    @Override
    void refreshResults() {
        this.refreshResults(false);
    }

    @Override
    void resetResults() {
        if (this.locksView != null) {
            this.locksView.resetData();
        }
    }

    @Override
    void sessionStateChanged(int sessionState) {
        this.refreshToolbar(sessionState);
    }

    private void refreshResults(final boolean forceRefresh) {
        RESULTS_PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (LocksLivePanel.this.updater != null) {
                        if (forceRefresh) {
                            LocksLivePanel.this.updater.setForceRefresh(true);
                        }
                        LocksLivePanel.this.updater.update();
                    }
                }
                catch (Throwable t) {
                    LocksLivePanel.this.cleanup();
                }
            }
        });
    }

    @Override
    void cleanup() {
        if (this.updater != null) {
            this.updater.cleanup();
            this.updater = null;
        }
        if (this.resetter != null) {
            this.resetter.unregisterView(this);
            this.resetter = null;
        }
    }

    private void initUI(Application application) {
        assert (SwingUtilities.isEventDispatchThread());
        this.locksView = new LockContentionPanel(){

            protected boolean showSourceSupported() {
                return GoToSource.isAvailable();
            }

            protected boolean profileMethodSupported() {
                return false;
            }

            protected boolean profileClassSupported() {
                return false;
            }

            protected void showSource(ClientUtils.SourceCodeSelection value) {
                Lookup.Provider project = null;
                String className = value.getClassName();
                String methodName = value.getMethodName();
                String methodSig = value.getMethodSignature();
                GoToSource.openSource(project, (String)className, (String)methodName, (String)methodSig);
            }

            protected void selectForProfiling(ClientUtils.SourceCodeSelection value) {
            }

            protected void popupShowing() {
                if (LocksLivePanel.this.lrPauseButton.isEnabled() && !LocksLivePanel.this.lrRefreshButton.isEnabled()) {
                    LocksLivePanel.this.popupPause = true;
                    LocksLivePanel.this.lrPauseButton.setSelected(true);
                }
            }

            protected void popupHidden() {
                if (LocksLivePanel.this.lrPauseButton.isEnabled() && LocksLivePanel.this.popupPause) {
                    LocksLivePanel.this.popupPause = false;
                    LocksLivePanel.this.lrPauseButton.setSelected(false);
                }
            }

            protected ProfilerClient getProfilerClient() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            protected void showSQLQuery(String query, String htmlQuery) {
                HTMLTextArea area = new HTMLTextArea(htmlQuery);
                JScrollPane areaScroll = new JScrollPane((Component)area);
                areaScroll.setPreferredSize(new Dimension(500, 250));
                JLabel label = new JLabel(Bundle.JDBCLivePanel_SqlQueryLabel(), 10);
                label.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
                label.setLabelFor((Component)area);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)label, "North");
                panel.add((Component)areaScroll, "Center");
                panel.setBorder(BorderFactory.createEmptyBorder(12, 10, 0, 10));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)panel, Bundle.JDBCLivePanel_SqlQueryCaption(), false, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null));
            }
        };
        this.locksView.lockContentionEnabled();
        this.locksView.putClientProperty((Object)"HelpCtx.Key", (Object)"ProfileMethods.HelpCtx");
        this.locksView.putClientProperty((Object)"profiled_application", (Object)application);
        this.updater = new LiveLocksViewUpdater(this.locksView, Profiler.getDefault().getTargetAppRunner().getProfilerClient());
        this.resetter = ProfilingResultsSupport.ResultsResetter.registerView(this);
        this.lrLabel = new GrayLabel(Bundle.MethodsFeatureUI_liveResults());
        this.lrPauseButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Pause")){

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                boolean paused = this.isSelected();
                LocksLivePanel.this.updater.setPaused(paused);
                LocksLivePanel.this.lrRefreshButton.setEnabled(paused && !LocksLivePanel.this.popupPause);
                if (!paused) {
                    LocksLivePanel.this.refreshResults(true);
                }
            }
        };
        this.lrPauseButton.setToolTipText(Bundle.MethodsFeatureUI_pauseResults());
        this.lrRefreshButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                LocksLivePanel.this.refreshResults(true);
            }
        };
        this.lrRefreshButton.setToolTipText(Bundle.MethodsFeatureUI_updateResults());
        this.lrRefreshButton.setEnabled(false);
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.lrPauseButton);
        this.toolbar.add((Component)this.lrRefreshButton);
        this.toolbar.addSpace(5);
        this.toolbar.addSpace(2);
        this.shLabel = new GrayLabel(Bundle.LocksFeatureUI_show());
        AbstractAction aThreads = new AbstractAction(){
            {
                this.putValue("Name", Bundle.LocksFeatureUI_aggregationByThreads());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LocksLivePanel.this.locksView.setAggregation(LockContentionPanel.Aggregation.BY_THREADS);
            }
        };
        AbstractAction aMonitors = new AbstractAction(){
            {
                this.putValue("Name", Bundle.LocksFeatureUI_aggregationByMonitors());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LocksLivePanel.this.locksView.setAggregation(LockContentionPanel.Aggregation.BY_MONITORS);
            }
        };
        this.shAggregation = new ActionPopupButton(new Action[]{aThreads, aMonitors});
        this.shAggregation.setToolTipText(Bundle.LocksFeatureUI_aggregationHint());
        this.toolbar.add((Component)this.shLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.shAggregation);
        this.toolbar.addSpace(2);
    }

    private void refreshToolbar(final int state) {
        if (this.toolbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean running = state == 4;
                    LocksLivePanel.this.lrPauseButton.setEnabled(running);
                    LocksLivePanel.this.lrRefreshButton.setEnabled(!LocksLivePanel.this.popupPause && running && LocksLivePanel.this.lrPauseButton.isSelected());
                }
            });
        }
    }
}

