/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JasperTagInfo;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.tomcat.Jar;

class TagFileProcessor {
    private List<Compiler> tempVector;

    TagFileProcessor() {
    }

    public static TagInfo parseTagFileDirectives(ParserController parserController, String string, String string2, Jar jar, TagLibraryInfo tagLibraryInfo) throws JasperException {
        ErrorDispatcher errorDispatcher = parserController.getCompiler().getErrorDispatcher();
        Node.Nodes nodes = null;
        try {
            nodes = parserController.parseTagFileDirectives(string2, jar);
        }
        catch (IOException iOException) {
            errorDispatcher.jspError("jsp.error.file.not.found", string2);
        }
        TagFileDirectiveVisitor tagFileDirectiveVisitor = new TagFileDirectiveVisitor(parserController.getCompiler(), tagLibraryInfo, string, string2);
        nodes.visit(tagFileDirectiveVisitor);
        tagFileDirectiveVisitor.postCheck();
        return tagFileDirectiveVisitor.getTagInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadTagFile(Compiler compiler, String string, TagInfo tagInfo, PageInfo pageInfo) throws JasperException {
        Jar jar = null;
        try (Jar jar2 = null;){
            JspRuntimeContext jspRuntimeContext;
            if (string.startsWith("/META-INF/")) {
                try {
                    jar2 = compiler.getCompilationContext().getTldResourcePath(tagInfo.getTagLibrary().getURI()).openJar();
                }
                catch (IOException iOException) {
                    throw new JasperException(iOException);
                }
            }
            String string2 = jar2 == null ? string : jar2.getURL(string);
            JspCompilationContext jspCompilationContext = compiler.getCompilationContext();
            JspRuntimeContext jspRuntimeContext2 = jspRuntimeContext = jspCompilationContext.getRuntimeContext();
            synchronized (jspRuntimeContext2) {
                Object object;
                block27: {
                    JspServletWrapper jspServletWrapper = null;
                    try {
                        Class<?> clazz;
                        jspServletWrapper = jspRuntimeContext.getWrapper(string2);
                        if (jspServletWrapper == null) {
                            jspServletWrapper = new JspServletWrapper(jspCompilationContext.getServletContext(), jspCompilationContext.getOptions(), string, tagInfo, jspCompilationContext.getRuntimeContext(), jar2);
                            jspServletWrapper.getJspEngineContext().setClassLoader(jspCompilationContext.getClassLoader());
                            jspServletWrapper.getJspEngineContext().setClassPath(jspCompilationContext.getClassPath());
                            jspRuntimeContext.addWrapper(string2, jspServletWrapper);
                        } else {
                            jspServletWrapper.getJspEngineContext().setTagInfo(tagInfo);
                            jar = jspServletWrapper.getJspEngineContext().getTagFileJar();
                            jspServletWrapper.getJspEngineContext().setTagFileJar(jar2);
                        }
                        int n = jspServletWrapper.incTripCount();
                        try {
                            if (n > 0) {
                                object = new JspServletWrapper(jspCompilationContext.getServletContext(), jspCompilationContext.getOptions(), string, tagInfo, jspCompilationContext.getRuntimeContext(), jar2);
                                ((JspServletWrapper)object).getJspEngineContext().setClassLoader(jspCompilationContext.getClassLoader());
                                ((JspServletWrapper)object).getJspEngineContext().setClassPath(jspCompilationContext.getClassPath());
                                clazz = ((JspServletWrapper)object).loadTagFilePrototype();
                                this.tempVector.add(((JspServletWrapper)object).getJspEngineContext().getCompiler());
                            } else {
                                clazz = jspServletWrapper.loadTagFile();
                            }
                        }
                        finally {
                            jspServletWrapper.decTripCount();
                        }
                        try {
                            object = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                            if (object instanceof JspSourceDependent) {
                                for (Map.Entry<String, Long> entry : ((JspSourceDependent)object).getDependants().entrySet()) {
                                    pageInfo.addDependant(entry.getKey(), entry.getValue());
                                }
                            }
                        }
                        catch (ReflectiveOperationException | RuntimeException exception) {
                            // empty catch block
                        }
                        object = clazz;
                        if (jspServletWrapper == null || jar == null) break block27;
                        jspServletWrapper.getJspEngineContext().setTagFileJar(jar);
                    }
                    catch (Throwable throwable) {
                        if (jspServletWrapper != null && jar != null) {
                            jspServletWrapper.getJspEngineContext().setTagFileJar(jar);
                        }
                        throw throwable;
                    }
                }
                return object;
            }
        }
    }

    public void loadTagFiles(Compiler compiler, Node.Nodes nodes) throws JasperException {
        this.tempVector = new ArrayList<Compiler>();
        nodes.visit(new TagFileLoaderVisitor(compiler));
    }

    public void removeProtoTypeFiles(String string) {
        for (Compiler compiler : this.tempVector) {
            if (string == null) {
                compiler.removeGeneratedClassFiles();
                continue;
            }
            if (!string.equals(compiler.getCompilationContext().getClassFileName())) continue;
            compiler.removeGeneratedClassFiles();
            this.tempVector.remove(compiler);
            return;
        }
    }

    private static class TagFileDirectiveVisitor
    extends Node.Visitor {
        private static final JspUtil.ValidAttribute[] tagDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("display-name"), new JspUtil.ValidAttribute("body-content"), new JspUtil.ValidAttribute("dynamic-attributes"), new JspUtil.ValidAttribute("small-icon"), new JspUtil.ValidAttribute("large-icon"), new JspUtil.ValidAttribute("description"), new JspUtil.ValidAttribute("example"), new JspUtil.ValidAttribute("pageEncoding"), new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("deferredSyntaxAllowedAsLiteral"), new JspUtil.ValidAttribute("trimDirectiveWhitespaces"), new JspUtil.ValidAttribute("isELIgnored")};
        private static final JspUtil.ValidAttribute[] attributeDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("required"), new JspUtil.ValidAttribute("fragment"), new JspUtil.ValidAttribute("rtexprvalue"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("deferredValue"), new JspUtil.ValidAttribute("deferredValueType"), new JspUtil.ValidAttribute("deferredMethod"), new JspUtil.ValidAttribute("deferredMethodSignature"), new JspUtil.ValidAttribute("description")};
        private static final JspUtil.ValidAttribute[] variableDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name-given"), new JspUtil.ValidAttribute("name-from-attribute"), new JspUtil.ValidAttribute("alias"), new JspUtil.ValidAttribute("variable-class"), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("declare"), new JspUtil.ValidAttribute("description")};
        private ErrorDispatcher err;
        private TagLibraryInfo tagLibInfo;
        private String name = null;
        private String path = null;
        private String bodycontent = null;
        private String description = null;
        private String displayName = null;
        private String smallIcon = null;
        private String largeIcon = null;
        private String dynamicAttrsMapName;
        private String example = null;
        private List<TagAttributeInfo> attributeList;
        private List<TagVariableInfo> variableList;
        private static final String ATTR_NAME = "the name attribute of the attribute directive";
        private static final String VAR_NAME_GIVEN = "the name-given attribute of the variable directive";
        private static final String VAR_NAME_FROM = "the name-from-attribute attribute of the variable directive";
        private static final String VAR_ALIAS = "the alias attribute of the variable directive";
        private static final String TAG_DYNAMIC = "the dynamic-attributes attribute of the tag directive";
        private Map<String, NameEntry> nameTable = new HashMap<String, NameEntry>();
        private Map<String, NameEntry> nameFromTable = new HashMap<String, NameEntry>();

        TagFileDirectiveVisitor(Compiler compiler, TagLibraryInfo tagLibraryInfo, String string, String string2) {
            this.err = compiler.getErrorDispatcher();
            this.tagLibInfo = tagLibraryInfo;
            this.name = string;
            this.path = string2;
            this.attributeList = new ArrayList<TagAttributeInfo>();
            this.variableList = new ArrayList<TagVariableInfo>();
        }

        @Override
        public void visit(Node.TagDirective tagDirective) throws JasperException {
            JspUtil.checkAttributes("Tag directive", tagDirective, tagDirectiveAttrs, this.err);
            this.bodycontent = this.checkConflict(tagDirective, this.bodycontent, "body-content");
            if (!(this.bodycontent == null || this.bodycontent.equalsIgnoreCase("empty") || this.bodycontent.equalsIgnoreCase("tagdependent") || this.bodycontent.equalsIgnoreCase("scriptless"))) {
                this.err.jspError((Node)tagDirective, "jsp.error.tagdirective.badbodycontent", this.bodycontent);
            }
            this.dynamicAttrsMapName = this.checkConflict(tagDirective, this.dynamicAttrsMapName, "dynamic-attributes");
            if (this.dynamicAttrsMapName != null) {
                this.checkUniqueName(this.dynamicAttrsMapName, TAG_DYNAMIC, tagDirective);
            }
            this.smallIcon = this.checkConflict(tagDirective, this.smallIcon, "small-icon");
            this.largeIcon = this.checkConflict(tagDirective, this.largeIcon, "large-icon");
            this.description = this.checkConflict(tagDirective, this.description, "description");
            this.displayName = this.checkConflict(tagDirective, this.displayName, "display-name");
            this.example = this.checkConflict(tagDirective, this.example, "example");
        }

        private String checkConflict(Node node, String string, String string2) throws JasperException {
            String string3 = string;
            String string4 = node.getAttributeValue(string2);
            if (string4 != null) {
                if (string != null && !string.equals(string4)) {
                    this.err.jspError(node, "jsp.error.tag.conflict.attr", string2, string, string4);
                }
                string3 = string4;
            }
            return string3;
        }

        @Override
        public void visit(Node.AttributeDirective attributeDirective) throws JasperException {
            String string;
            String string2;
            JspUtil.checkAttributes("Attribute directive", attributeDirective, attributeDirectiveAttrs, this.err);
            boolean bl = false;
            boolean bl2 = false;
            String string3 = attributeDirective.getAttributeValue("deferredValue");
            if (string3 != null) {
                bl2 = true;
                bl = JspUtil.booleanValue(string3);
            }
            if ((string2 = attributeDirective.getAttributeValue("deferredValueType")) != null) {
                if (bl2 && !bl) {
                    this.err.jspError((Node)attributeDirective, "jsp.error.deferredvaluetypewithoutdeferredvalue", new String[0]);
                } else {
                    bl = true;
                }
            } else {
                string2 = bl ? "java.lang.Object" : "java.lang.String";
            }
            boolean bl3 = false;
            boolean bl4 = false;
            String string4 = attributeDirective.getAttributeValue("deferredMethod");
            if (string4 != null) {
                bl4 = true;
                bl3 = JspUtil.booleanValue(string4);
            }
            if ((string = attributeDirective.getAttributeValue("deferredMethodSignature")) != null) {
                if (bl4 && !bl3) {
                    this.err.jspError((Node)attributeDirective, "jsp.error.deferredmethodsignaturewithoutdeferredmethod", new String[0]);
                } else {
                    bl3 = true;
                }
            } else if (bl3) {
                string = "void methodname()";
            }
            if (bl3 && bl) {
                this.err.jspError((Node)attributeDirective, "jsp.error.deferredmethodandvalue", new String[0]);
            }
            String string5 = attributeDirective.getAttributeValue("name");
            boolean bl5 = JspUtil.booleanValue(attributeDirective.getAttributeValue("required"));
            boolean bl6 = true;
            String string6 = attributeDirective.getAttributeValue("rtexprvalue");
            if (string6 != null) {
                bl6 = JspUtil.booleanValue(string6);
            }
            boolean bl7 = JspUtil.booleanValue(attributeDirective.getAttributeValue("fragment"));
            String string7 = attributeDirective.getAttributeValue("type");
            if (bl7) {
                if (string7 != null) {
                    this.err.jspError((Node)attributeDirective, "jsp.error.fragmentwithtype", JspFragment.class.getName());
                }
                bl6 = true;
                if (string6 != null) {
                    this.err.jspError((Node)attributeDirective, "jsp.error.frgmentwithrtexprvalue", new String[0]);
                }
            } else {
                if (string7 == null) {
                    string7 = "java.lang.String";
                }
                if (bl) {
                    string7 = ValueExpression.class.getName();
                } else if (bl3) {
                    string7 = MethodExpression.class.getName();
                }
            }
            if (("2.0".equals(this.tagLibInfo.getRequiredVersion()) || "1.2".equals(this.tagLibInfo.getRequiredVersion())) && (bl4 || bl3 || bl2 || bl)) {
                this.err.jspError("jsp.error.invalid.version", this.path);
            }
            TagAttributeInfo tagAttributeInfo = new TagAttributeInfo(string5, bl5, string7, bl6, bl7, null, bl, bl3, string2, string);
            this.attributeList.add(tagAttributeInfo);
            this.checkUniqueName(string5, ATTR_NAME, attributeDirective, tagAttributeInfo);
        }

        @Override
        public void visit(Node.VariableDirective variableDirective) throws JasperException {
            String string;
            JspUtil.checkAttributes("Variable directive", variableDirective, variableDirectiveAttrs, this.err);
            String string2 = variableDirective.getAttributeValue("name-given");
            String string3 = variableDirective.getAttributeValue("name-from-attribute");
            if (string2 == null && string3 == null) {
                this.err.jspError("jsp.error.variable.either.name", new String[0]);
            }
            if (string2 != null && string3 != null) {
                this.err.jspError("jsp.error.variable.both.name", new String[0]);
            }
            String string4 = variableDirective.getAttributeValue("alias");
            if (string3 != null && string4 == null || string3 == null && string4 != null) {
                this.err.jspError("jsp.error.variable.alias", new String[0]);
            }
            if ((string = variableDirective.getAttributeValue("variable-class")) == null) {
                string = "java.lang.String";
            }
            String string5 = variableDirective.getAttributeValue("declare");
            boolean bl = true;
            if (string5 != null) {
                bl = JspUtil.booleanValue(string5);
            }
            int n = 0;
            String string6 = variableDirective.getAttributeValue("scope");
            if (string6 != null && !"NESTED".equals(string6)) {
                if ("AT_BEGIN".equals(string6)) {
                    n = 1;
                } else if ("AT_END".equals(string6)) {
                    n = 2;
                }
            }
            if (string3 != null) {
                string2 = string4;
                this.checkUniqueName(string3, VAR_NAME_FROM, variableDirective);
                this.checkUniqueName(string4, VAR_ALIAS, variableDirective);
            } else {
                this.checkUniqueName(string2, VAR_NAME_GIVEN, variableDirective);
            }
            this.variableList.add(new TagVariableInfo(string2, string3, string, bl, n));
        }

        public TagInfo getTagInfo() throws JasperException {
            if (this.name == null) {
                // empty if block
            }
            if (this.bodycontent == null) {
                this.bodycontent = "scriptless";
            }
            String string = JspUtil.getTagHandlerClassName(this.path, this.tagLibInfo.getReliableURN(), this.err);
            TagVariableInfo[] tagVariableInfoArray = this.variableList.toArray(new TagVariableInfo[0]);
            TagAttributeInfo[] tagAttributeInfoArray = this.attributeList.toArray(new TagAttributeInfo[0]);
            return new JasperTagInfo(this.name, string, this.bodycontent, this.description, this.tagLibInfo, null, tagAttributeInfoArray, this.displayName, this.smallIcon, this.largeIcon, tagVariableInfoArray, this.dynamicAttrsMapName);
        }

        private void checkUniqueName(String string, String string2, Node node) throws JasperException {
            this.checkUniqueName(string, string2, node, null);
        }

        private void checkUniqueName(String string, String string2, Node node, TagAttributeInfo tagAttributeInfo) throws JasperException {
            Map<String, NameEntry> map = VAR_NAME_FROM.equals(string2) ? this.nameFromTable : this.nameTable;
            NameEntry nameEntry = map.get(string);
            if (nameEntry != null) {
                if (!TAG_DYNAMIC.equals(string2) || !TAG_DYNAMIC.equals(nameEntry.getType())) {
                    int n = nameEntry.getNode().getStart().getLineNumber();
                    this.err.jspError(node, "jsp.error.tagfile.nameNotUnique", string2, nameEntry.getType(), Integer.toString(n));
                }
            } else {
                map.put(string, new NameEntry(string2, node, tagAttributeInfo));
            }
        }

        void postCheck() throws JasperException {
            for (Map.Entry<String, NameEntry> entry : this.nameFromTable.entrySet()) {
                String string = entry.getKey();
                NameEntry nameEntry = this.nameTable.get(string);
                NameEntry nameEntry2 = entry.getValue();
                Node node = nameEntry2.getNode();
                if (nameEntry == null) {
                    this.err.jspError(node, "jsp.error.tagfile.nameFrom.noAttribute", string);
                    continue;
                }
                Node node2 = nameEntry.getNode();
                TagAttributeInfo tagAttributeInfo = nameEntry.getTagAttributeInfo();
                if ("java.lang.String".equals(tagAttributeInfo.getTypeName()) && tagAttributeInfo.isRequired() && !tagAttributeInfo.canBeRequestTime()) continue;
                this.err.jspError(node, "jsp.error.tagfile.nameFrom.badAttribute", string, Integer.toString(node2.getStart().getLineNumber()));
            }
        }

        static class NameEntry {
            private String type;
            private Node node;
            private TagAttributeInfo attr;

            NameEntry(String string, Node node, TagAttributeInfo tagAttributeInfo) {
                this.type = string;
                this.node = node;
                this.attr = tagAttributeInfo;
            }

            String getType() {
                return this.type;
            }

            Node getNode() {
                return this.node;
            }

            TagAttributeInfo getTagAttributeInfo() {
                return this.attr;
            }
        }
    }

    private class TagFileLoaderVisitor
    extends Node.Visitor {
        private Compiler compiler;
        private PageInfo pageInfo;

        TagFileLoaderVisitor(Compiler compiler) {
            this.compiler = compiler;
            this.pageInfo = compiler.getPageInfo();
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            TagFileInfo tagFileInfo = customTag.getTagFileInfo();
            if (tagFileInfo != null) {
                Object object;
                String string = tagFileInfo.getPath();
                if (string.startsWith("/META-INF/")) {
                    object = this.compiler.getCompilationContext().getTldResourcePath(tagFileInfo.getTagInfo().getTagLibrary().getURI());
                    try (Jar jar = object.openJar();){
                        if (jar != null) {
                            this.pageInfo.addDependant(jar.getURL(object.getEntryName()), jar.getLastModified(object.getEntryName()));
                            this.pageInfo.addDependant(jar.getURL(string.substring(1)), jar.getLastModified(string.substring(1)));
                        }
                        this.pageInfo.addDependant(string, this.compiler.getCompilationContext().getLastModified(string));
                    }
                    catch (IOException iOException) {
                        throw new JasperException(iOException);
                    }
                } else {
                    this.pageInfo.addDependant(string, this.compiler.getCompilationContext().getLastModified(string));
                }
                object = TagFileProcessor.this.loadTagFile(this.compiler, string, customTag.getTagInfo(), this.pageInfo);
                customTag.setTagHandlerClass((Class<?>)object);
            }
            this.visitBody(customTag);
        }
    }
}

