/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.T4;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class UnitCell
extends SimpleUnitCell
implements Cloneable {
    private static final double twoP2 = 19.739208802178716;
    private static final V3[] unitVectors = new V3[]{JC.axisX, JC.axisY, JC.axisZ};
    Lst<String> moreInfo;
    public String name = "";
    private P3[] vertices;
    private P3 fractionalOffset;
    private boolean allFractionalRelative;
    private final P3 cartesianOffset = new P3();
    private T3 unitCellMultiplier;
    private UnitCell unitCellMultiplied;
    private float[][] f2c;

    private UnitCell() {
    }

    public static UnitCell fromOABC(T3[] oabc, boolean setRelative) {
        UnitCell c = new UnitCell();
        if (oabc.length == 3) {
            oabc = new T3[]{new P3(), oabc[0], oabc[1], oabc[2]};
        }
        float[] parameters = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, oabc[1].x, oabc[1].y, oabc[1].z, oabc[2].x, oabc[2].y, oabc[2].z, oabc[3].x, oabc[3].y, oabc[3].z};
        c.init(parameters);
        c.allFractionalRelative = setRelative;
        c.initUnitcellVertices();
        c.setCartesianOffset(oabc[0]);
        return c;
    }

    public static UnitCell fromParams(float[] params, boolean setRelative, float slop) {
        UnitCell c = new UnitCell();
        c.init(params);
        c.initUnitcellVertices();
        c.allFractionalRelative = setRelative;
        c.setPrecision(slop);
        if (params.length > 26) {
            params[26] = slop;
        }
        return c;
    }

    static UnitCell cloneUnitCell(UnitCell uc) {
        UnitCell ucnew = null;
        try {
            ucnew = (UnitCell)uc.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return ucnew;
    }

    public boolean checkDistance(P3 f1, P3 f2, float distance, float dx, int iRange, int jRange, int kRange, P3 ptOffset) {
        P3 p1 = P3.newP(f1);
        this.toCartesian(p1, true);
        for (int i = -iRange; i <= iRange; ++i) {
            for (int j = -jRange; j <= jRange; ++j) {
                for (int k = -kRange; k <= kRange; ++k) {
                    ptOffset.set(f2.x + (float)i, f2.y + (float)j, f2.z + (float)k);
                    this.toCartesian(ptOffset, true);
                    float d = p1.distance(ptOffset);
                    if (!(dx > 0.0f ? Math.abs(d - distance) <= dx : d <= distance && d > 0.1f)) continue;
                    ptOffset.set(i, j, k);
                    return true;
                }
            }
        }
        return false;
    }

    boolean checkPeriodic(P3 pt) {
        switch (this.dimension) {
            case 3: {
                if (pt.z < -this.slop || pt.z > 1.0f - this.slop) {
                    return false;
                }
            }
            case 2: {
                if (pt.y < -this.slop || pt.y > 1.0f - this.slop) {
                    return false;
                }
            }
            case 1: {
                if (!(pt.x < -this.slop) && !(pt.x > 1.0f - this.slop)) break;
                return false;
            }
        }
        return true;
    }

    String dumpInfo(boolean isDebug, boolean multiplied) {
        UnitCell m;
        UnitCell unitCell = m = multiplied ? this.getUnitCellMultiplied() : this;
        if (m != this) {
            return m.dumpInfo(isDebug, false);
        }
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + "\noabc=" + Escape.eAP(this.getUnitCellVectors()) + "\nvolume=" + this.volume + (isDebug ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    private float fix000(float x) {
        return Math.abs(x) < 0.001f ? 0.0f : x;
    }

    private float fixFloor(float d) {
        return d == 1.0f ? 0.0f : d;
    }

    P3[] getCanonicalCopy(float scale, boolean withOffset) {
        P3[] pts = this.getScaledCell(withOffset);
        return BoxInfo.getCanonicalCopy(pts, scale);
    }

    public P3[] getCanonicalCopyTrimmed(P3 frac, float scale) {
        P3[] pts = this.getScaledCellMult(frac, true);
        return BoxInfo.getCanonicalCopy(pts, scale);
    }

    P3 getCartesianOffset() {
        return this.cartesianOffset;
    }

    float getCellWeight(P3 pt) {
        float f = 1.0f;
        if (pt.x <= this.slop || pt.x >= 1.0f - this.slop) {
            f /= 2.0f;
        }
        if (pt.y <= this.slop || pt.y >= 1.0f - this.slop) {
            f /= 2.0f;
        }
        if (pt.z <= this.slop || pt.z >= 1.0f - this.slop) {
            f /= 2.0f;
        }
        return f;
    }

    public T3[] getConventionalUnitCell(String latticeType, M3 primitiveToCrystal) {
        T3[] oabc = this.getUnitCellVectors();
        if (!latticeType.equals("P") || primitiveToCrystal != null) {
            this.toFromPrimitive(false, latticeType.charAt(0), oabc, primitiveToCrystal);
        }
        return oabc;
    }

    Lst<P3> getEquivPoints(P3 pt, String flags, M4[] ops, Lst<P3> list, int i0, int n0, int dup0) {
        int i;
        boolean packed;
        boolean fromfractional = flags.indexOf("fromfractional") >= 0;
        boolean tofractional = flags.indexOf("tofractional") >= 0;
        boolean bl = packed = flags.indexOf("packed") >= 0;
        if (list == null) {
            list = new Lst();
        }
        P3 pf = P3.newP(pt);
        if (!fromfractional) {
            this.toFractional(pf, true);
        }
        int n = list.size();
        int nops = ops.length;
        for (i = 0; i < nops; ++i) {
            P3 p = P3.newP(pf);
            ops[i].rotTrans(p);
            p.x = this.fixFloor(p.x - (float)Math.floor(p.x));
            p.y = this.fixFloor(p.y - (float)Math.floor(p.y));
            p.z = this.fixFloor(p.z - (float)Math.floor(p.z));
            list.addLast(p);
            ++n;
        }
        if (packed) {
            for (i = n0; i < n; ++i) {
                pf.setT((T3)list.get(i));
                this.unitizeRnd(pf);
                if (pf.x == 0.0f) {
                    list.addLast(P3.new3(0.0f, pf.y, pf.z));
                    list.addLast(P3.new3(1.0f, pf.y, pf.z));
                    if (pf.y == 0.0f) {
                        list.addLast(P3.new3(1.0f, 1.0f, pf.z));
                        list.addLast(P3.new3(0.0f, 0.0f, pf.z));
                        if (pf.z == 0.0f) {
                            list.addLast(P3.new3(1.0f, 1.0f, 1.0f));
                            list.addLast(P3.new3(0.0f, 0.0f, 0.0f));
                        }
                    }
                }
                if (pf.y == 0.0f) {
                    list.addLast(P3.new3(pf.x, 0.0f, pf.z));
                    list.addLast(P3.new3(pf.x, 1.0f, pf.z));
                    if (pf.z == 0.0f) {
                        list.addLast(P3.new3(pf.x, 0.0f, 0.0f));
                        list.addLast(P3.new3(pf.x, 1.0f, 1.0f));
                    }
                }
                if (pf.z != 0.0f) continue;
                list.addLast(P3.new3(pf.x, pf.y, 0.0f));
                list.addLast(P3.new3(pf.x, pf.y, 1.0f));
                if (pf.x != 0.0f) continue;
                list.addLast(P3.new3(0.0f, pf.y, 0.0f));
                list.addLast(P3.new3(1.0f, pf.y, 1.0f));
            }
        }
        UnitCell.removeDuplicates(list, i0, dup0, -1);
        if (!tofractional) {
            i = list.size();
            while (--i >= n0) {
                this.toCartesian((T3)list.get(i), true);
            }
        }
        return list;
    }

    P3 getFractionalOffset() {
        return this.fractionalOffset;
    }

    Map<String, Object> getInfo() {
        UnitCell m = this.getUnitCellMultiplied();
        if (m != this) {
            return m.getInfo();
        }
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("params", this.unitCellParams);
        info.put("oabc", this.getUnitCellVectors());
        info.put("volume", this.volume);
        info.put("matFtoC", this.matrixFractionalToCartesian);
        info.put("matCtoF", this.matrixCartesianToFractional);
        return info;
    }

    Quat getQuaternionRotation(String abc) {
        V3 P32;
        V3 v2;
        V3 v1;
        int quadrant;
        String abc0;
        int mul;
        V3 a = V3.newVsub(this.vertices[4], this.vertices[0]);
        V3 b = V3.newVsub(this.vertices[2], this.vertices[0]);
        V3 c = V3.newVsub(this.vertices[1], this.vertices[0]);
        P3 x = new P3();
        P3 v = new P3();
        int n = mul = abc.charAt(0) == '-' ? -1 : 1;
        if (mul < 0) {
            abc = abc.substring(1);
        }
        boolean isFace = !(abc0 = abc).equals(abc = PT.rep(PT.rep(PT.rep(PT.rep(PT.rep(PT.rep(abc, "ab", "A"), "bc", "B"), "ca", "C"), "ba", "D"), "cb", "E"), "ac", "F"));
        int n2 = quadrant = isFace ? 1 : 0;
        if (abc.length() == 2) {
            quadrant = abc.charAt(1) - 48;
            abc = abc.substring(0, 1);
        }
        boolean isEven = quadrant % 2 == 0;
        int axis = "abcABCDEF".indexOf(abc);
        switch (axis) {
            case 7: {
                mul = -mul;
            }
            case 4: {
                a.cross(c, b);
                quadrant = (5 - quadrant) % 4 + 1;
            }
            default: {
                v1 = a;
                v2 = c;
                P32 = b;
                break;
            }
            case 8: {
                mul = -mul;
            }
            case 5: {
                mul = -mul;
                b.cross(c, a);
                quadrant = (2 + quadrant) % 4 + 1;
            }
            case 1: {
                v1 = b;
                v2 = a;
                P32 = c;
                mul = -mul;
                break;
            }
            case 3: {
                mul = -mul;
            }
            case 6: {
                c.cross(a, b);
                if (isEven) {
                    quadrant = 6 - quadrant;
                }
            }
            case 2: {
                v1 = c;
                v2 = a;
                P32 = b;
                if (isFace || quadrant <= 0) break;
                quadrant = 5 - quadrant;
            }
        }
        if (quadrant > 0 && mul > 0 != isEven) {
            v2 = P32;
            v1.scale(-1.0f);
        }
        switch (quadrant) {
            default: {
                break;
            }
            case 2: {
                v1.scale(-1.0f);
                v2.scale(-1.0f);
                break;
            }
            case 3: {
                v2.scale(-1.0f);
                break;
            }
            case 4: {
                v1.scale(-1.0f);
            }
        }
        x.cross(v1, v2);
        v.cross(x, v1);
        return Quat.getQuaternionFrame(null, v, x).inv();
    }

    private P3[] getScaledCell(boolean withOffset) {
        return this.getScaledCellMult(null, withOffset);
    }

    private P3[] getScaledCellMult(T3 mult, boolean withOffset) {
        boolean isFrac;
        P3[] pts = new P3[8];
        P3 cell0 = null;
        P3 cell1 = null;
        boolean bl = isFrac = mult != null;
        if (!isFrac) {
            mult = this.unitCellMultiplier;
        }
        if (withOffset && mult != null && mult.z == 0.0f) {
            cell0 = new P3();
            cell1 = new P3();
            UnitCell.ijkToPoint3f((int)mult.x, cell0, 0, 0);
            UnitCell.ijkToPoint3f((int)mult.y, cell1, 0, 0);
            cell1.sub(cell0);
        }
        float scale = isFrac || mult == null || mult.z == 0.0f ? 1.0f : Math.abs(mult.z);
        for (int i = 0; i < 8; ++i) {
            P3 pt = pts[i] = P3.newP(BoxInfo.unitCubePoints[i]);
            if (cell0 != null) {
                pts[i].add3(cell0.x + cell1.x * pt.x, cell0.y + cell1.y * pt.y, cell0.z + cell1.z * pt.z);
            } else if (isFrac) {
                pt.scaleT(mult);
            }
            pts[i].scale(scale);
            this.matrixFractionalToCartesian.rotTrans(pt);
            if (withOffset) continue;
            pt.sub(this.cartesianOffset);
        }
        return pts;
    }

    String getState() {
        String s = "";
        if (this.fractionalOffset != null && this.fractionalOffset.lengthSquared() != 0.0f) {
            s = s + "  unitcell offset " + Escape.eP(this.fractionalOffset) + ";\n";
        }
        if (this.unitCellMultiplier != null) {
            s = s + "  unitcell range " + UnitCell.escapeMultiplier(this.unitCellMultiplier) + ";\n";
        }
        return s;
    }

    public Tensor getTensor(Viewer vwr, float[] parBorU) {
        Tensor t = (Tensor)Interface.getUtil("Tensor", vwr, "file");
        if (parBorU[0] == 0.0f && parBorU[1] == 0.0f && parBorU[2] == 0.0f) {
            float f = parBorU[7];
            float[] eigenValues = new float[]{f, f, f};
            return t.setFromEigenVectors(unitVectors, eigenValues, "iso", "Uiso=" + f, null);
        }
        t.parBorU = parBorU;
        double[] Bcart = new double[6];
        int ortepType = (int)parBorU[6];
        if (ortepType == 12) {
            Bcart[0] = (double)parBorU[0] * 19.739208802178716;
            Bcart[1] = (double)parBorU[1] * 19.739208802178716;
            Bcart[2] = (double)parBorU[2] * 19.739208802178716;
            Bcart[3] = (double)parBorU[3] * 19.739208802178716 * 2.0;
            Bcart[4] = (double)parBorU[4] * 19.739208802178716 * 2.0;
            Bcart[5] = (double)parBorU[5] * 19.739208802178716 * 2.0;
            parBorU[7] = (parBorU[0] + parBorU[1] + parBorU[3]) / 3.0f;
        } else {
            boolean isFractional = ortepType == 4 || ortepType == 5 || ortepType == 8 || ortepType == 9;
            double cc = 2 - ortepType % 2;
            double dd = ortepType == 8 || ortepType == 9 || ortepType == 10 ? 19.739208802178716 : (ortepType == 4 || ortepType == 5 ? 0.25 : (ortepType == 2 || ortepType == 3 ? Math.log(2.0) : 1.0));
            double B11 = (double)parBorU[0] * dd * (isFractional ? this.a_ * this.a_ : 1.0);
            double B22 = (double)parBorU[1] * dd * (isFractional ? this.b_ * this.b_ : 1.0);
            double B33 = (double)parBorU[2] * dd * (isFractional ? this.c_ * this.c_ : 1.0);
            double B12 = (double)parBorU[3] * dd * (isFractional ? this.a_ * this.b_ : 1.0) * cc;
            double B13 = (double)parBorU[4] * dd * (isFractional ? this.a_ * this.c_ : 1.0) * cc;
            double B23 = (double)parBorU[5] * dd * (isFractional ? this.b_ * this.c_ : 1.0) * cc;
            parBorU[7] = (float)Math.pow(B11 / 19.739208802178716 / this.a_ / this.a_ * B22 / 19.739208802178716 / this.b_ / this.b_ * B33 / 19.739208802178716 / this.c_ / this.c_, 0.3333);
            Bcart[0] = (double)(this.a * this.a) * B11 + (double)(this.b * this.b) * this.cosGamma * this.cosGamma * B22 + (double)(this.c * this.c) * this.cosBeta * this.cosBeta * B33 + (double)(this.a * this.b) * this.cosGamma * B12 + (double)(this.b * this.c) * this.cosGamma * this.cosBeta * B23 + (double)(this.a * this.c) * this.cosBeta * B13;
            Bcart[1] = (double)(this.b * this.b) * this.sinGamma * this.sinGamma * B22 + (double)(this.c * this.c) * this.cA_ * this.cA_ * B33 + (double)(this.b * this.c) * this.cA_ * this.sinGamma * B23;
            Bcart[2] = (double)(this.c * this.c) * this.cB_ * this.cB_ * B33;
            Bcart[3] = (double)(2.0f * this.b * this.b) * this.cosGamma * this.sinGamma * B22 + (double)(2.0f * this.c * this.c) * this.cA_ * this.cosBeta * B33 + (double)(this.a * this.b) * this.sinGamma * B12 + (double)(this.b * this.c) * (this.cA_ * this.cosGamma + this.sinGamma * this.cosBeta) * B23 + (double)(this.a * this.c) * this.cA_ * B13;
            Bcart[4] = (double)(2.0f * this.c * this.c) * this.cB_ * this.cosBeta * B33 + (double)(this.b * this.c) * this.cosGamma * B23 + (double)(this.a * this.c) * this.cB_ * B13;
            Bcart[5] = (double)(2.0f * this.c * this.c) * this.cA_ * this.cB_ * B33 + (double)(this.b * this.c) * this.cB_ * this.sinGamma * B23;
        }
        return t.setFromThermalEquation(Bcart, Escape.eAF(parBorU));
    }

    UnitCell getUnitCellMultiplied() {
        if (this.unitCellMultiplier == null || this.unitCellMultiplier.z > 0.0f && this.unitCellMultiplier.z == (float)((int)this.unitCellMultiplier.z)) {
            return this;
        }
        if (this.unitCellMultiplied == null) {
            T3[] pts = BoxInfo.toOABC(this.getScaledCell(true), null);
            this.unitCellMultiplied = UnitCell.fromOABC(pts, false);
        }
        return this.unitCellMultiplied;
    }

    T3 getUnitCellMultiplier() {
        return this.unitCellMultiplier;
    }

    boolean isStandard() {
        return this.unitCellMultiplier == null || this.unitCellMultiplier.x == this.unitCellMultiplier.y;
    }

    P3[] getUnitCellVectors() {
        M4 m = this.matrixFractionalToCartesian;
        return new P3[]{P3.newP(this.cartesianOffset), P3.new3(this.fix000(m.m00), this.fix000(m.m10), this.fix000(m.m20)), P3.new3(this.fix000(m.m01), this.fix000(m.m11), this.fix000(m.m21)), P3.new3(this.fix000(m.m02), this.fix000(m.m12), this.fix000(m.m22))};
    }

    public static M4 toTrm(String transform, M4 trm) {
        if (trm == null) {
            trm = new M4();
        }
        UnitCell.getMatrixAndUnitCell(null, transform, trm);
        return trm;
    }

    public static T3[] getMatrixAndUnitCell(SimpleUnitCell uc, Object def, M4 retMatrix) {
        M4 m;
        if (def == null) {
            def = "a,b,c";
        }
        T3[] pts = new P3[4];
        P3 pt = pts[0] = P3.new3(0.0f, 0.0f, 0.0f);
        pts[1] = P3.new3(1.0f, 0.0f, 0.0f);
        pts[2] = P3.new3(0.0f, 1.0f, 0.0f);
        pts[3] = P3.new3(0.0f, 0.0f, 1.0f);
        M3 m3 = new M3();
        if (AU.isAD(def)) {
            return UnitCell.setAbcFromParams((float[])def, pts);
        }
        boolean isString = def instanceof String;
        if (isString) {
            boolean isABC;
            String strans;
            String sdef = (String)def;
            String strans2 = null;
            if (sdef.indexOf("a=") == 0) {
                return UnitCell.setAbc(sdef, null, pts);
            }
            if (sdef.indexOf(">") > 0) {
                if (uc != null || retMatrix == null) {
                    return null;
                }
                String[] sdefs = sdef.split(">");
                retMatrix.setIdentity();
                M4 m4 = new M4();
                int i = sdefs.length;
                while (--i >= 0) {
                    UnitCell.getMatrixAndUnitCell(null, sdefs[i], m4);
                    retMatrix.mul2(m4, retMatrix);
                }
                return pts;
            }
            String[] ret = new String[1];
            int ptc = sdef.indexOf(";");
            if (ptc >= 0) {
                strans = sdef.substring(ptc + 1).trim();
                ret[0] = sdef = sdef.substring(0, ptc);
                strans2 = UnitCell.fixABC(ret);
                if (sdef != ret[0]) {
                    sdef = ret[0];
                }
            } else if (sdef.equals("a,b,c")) {
                strans = null;
            } else {
                ret[0] = sdef;
                strans = UnitCell.fixABC(ret);
                sdef = ret[0];
            }
            sdef = sdef + ";0,0,0";
            while (sdef.startsWith("!!")) {
                sdef = sdef.substring(2);
            }
            boolean isRev = sdef.startsWith("!");
            if (isRev) {
                sdef = sdef.substring(1);
            }
            if (sdef.equals("r;0,0,0")) {
                sdef = "2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c" + sdef.substring(1);
            } else if (sdef.equals("h;0,0,0")) {
                sdef = "a-b,b-c,a+b+c" + sdef.substring(1);
            }
            Symmetry symTemp = new Symmetry();
            symTemp.setSpaceGroup(false);
            int i = symTemp.addSpaceGroupOperation("=" + sdef, 0);
            if (i < 0) {
                return null;
            }
            m = symTemp.getSpaceGroupOperation(i);
            ((SymmetryOperation)m).doFinalize();
            P3 t = new P3();
            UnitCell.addTrans(strans, t);
            UnitCell.addTrans(strans2, t);
            m.setTranslation(t);
            boolean bl = isABC = sdef.indexOf("c") >= 0;
            if (isABC) {
                m.transpose33();
            }
            if (isRev) {
                m.invert();
            }
            if (retMatrix != null) {
                retMatrix.setM4(m);
            }
            if (uc == null) {
                return pts;
            }
        } else {
            if (retMatrix != null || uc == null) {
                return null;
            }
            if (def instanceof M3) {
                m = M4.newMV((M3)def, new P3());
            } else if (def instanceof M4) {
                m = (M4)def;
            } else {
                M4 m2 = (M4)((Object[])def)[0];
                m2.getRotationScale(m3);
                m2.rotTrans(pt);
                uc.toCartesian(pt, false);
                for (int i = 1; i < 4; ++i) {
                    m3.rotate(pts[i]);
                    uc.toCartesian(pts[i], true);
                }
                return pts;
            }
        }
        m.getRotationScale(m3);
        m.getTranslation(pt);
        uc.toCartesian(pt, false);
        for (int i = 1; i < 4; ++i) {
            m3.rotate(pts[i]);
            uc.toCartesian(pts[i], true);
        }
        return pts;
    }

    private static void addTrans(String strans, P3 t) {
        if (strans == null) {
            return;
        }
        String[] atrans = PT.split(strans, ",");
        float[] ftrans = new float[3];
        if (atrans.length == 3) {
            for (int j = 0; j < 3; ++j) {
                String s = atrans[j];
                int sfpt = s.indexOf("/");
                ftrans[j] = sfpt >= 0 ? PT.parseFloat(s.substring(0, sfpt)) / PT.parseFloat(s.substring(sfpt + 1)) : PT.parseFloat(s);
            }
        }
        t.add3(ftrans[0], ftrans[1], ftrans[2]);
    }

    private static String fixABC(String[] ret) {
        String[] tokens = PT.split(ret[0], ",");
        if (tokens.length != 3) {
            return null;
        }
        String trans = "";
        String abc = "";
        boolean haveT = false;
        for (int i = 0; i < 3; ++i) {
            String a = tokens[i];
            int n = 0;
            int p = a.length();
            block5: while (--p >= 0) {
                char c = a.charAt(p);
                switch (c) {
                    default: {
                        if (c < 'a') continue block5;
                        p = 0;
                        continue block5;
                    }
                    case '+': {
                        n = 1;
                    }
                    case '-': 
                }
                p = -p;
            }
            if ((p = -1 - p) == 0) {
                trans = trans + ",0";
                abc = abc + "," + a;
                continue;
            }
            haveT = true;
            trans = trans + "," + a.substring(p + n);
            abc = abc + "," + a.substring(0, p);
        }
        ret[0] = abc.substring(1);
        return haveT ? trans.substring(1) : null;
    }

    P3[] getVertices() {
        return this.vertices;
    }

    boolean hasOffset() {
        return this.fractionalOffset != null && this.fractionalOffset.lengthSquared() != 0.0f;
    }

    void initOrientation(M3 mat) {
        if (mat == null) {
            return;
        }
        M4 m = new M4();
        m.setToM3(mat);
        this.matrixFractionalToCartesian.mul2(m, this.matrixFractionalToCartesian);
        this.matrixCartesianToFractional.setM4(this.matrixFractionalToCartesian).invert();
        this.initUnitcellVertices();
    }

    private void initUnitcellVertices() {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixCtoFNoOffset = M4.newM4(this.matrixCartesianToFractional);
        this.matrixFtoCNoOffset = M4.newM4(this.matrixFractionalToCartesian);
        this.vertices = new P3[8];
        int i = 8;
        while (--i >= 0) {
            this.vertices[i] = (P3)this.matrixFractionalToCartesian.rotTrans2(BoxInfo.unitCubePoints[i], new P3());
        }
    }

    boolean isSameAs(float[][] f2c2) {
        if (f2c2 == null) {
            return false;
        }
        float[][] f2c = this.getF2C();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (UnitCell.approx0(f2c[i][j] - f2c2[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    public float[][] getF2C() {
        if (this.f2c == null) {
            this.f2c = new float[3][4];
            for (int i = 0; i < 3; ++i) {
                this.matrixFractionalToCartesian.getRow(i, this.f2c[i]);
            }
        }
        return this.f2c;
    }

    boolean isWithinUnitCell(double a, double b, double c, P3 pt) {
        switch (this.dimension) {
            case 3: {
                if ((double)pt.z < c - 1.0 - (double)this.slop || (double)pt.z > c + (double)this.slop) {
                    return false;
                }
            }
            case 2: {
                if ((double)pt.y < b - 1.0 - (double)this.slop || (double)pt.y > b + (double)this.slop) {
                    return false;
                }
            }
            case 1: {
                if (!((double)pt.x < a - 1.0 - (double)this.slop) && !((double)pt.x > a + (double)this.slop)) break;
                return false;
            }
        }
        return true;
    }

    void setCartesianOffset(T3 origin) {
        this.cartesianOffset.setT(origin);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        boolean wasOffset = this.hasOffset();
        this.fractionalOffset = P3.newP(this.cartesianOffset);
        this.matrixCartesianToFractional.rotate(this.fractionalOffset);
        this.matrixCartesianToFractional.m03 = -this.fractionalOffset.x;
        this.matrixCartesianToFractional.m13 = -this.fractionalOffset.y;
        this.matrixCartesianToFractional.m23 = -this.fractionalOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFNoOffset.setM4(this.matrixCartesianToFractional);
            this.matrixFtoCNoOffset.setM4(this.matrixFractionalToCartesian);
        }
        if (!wasOffset && this.fractionalOffset.lengthSquared() == 0.0f) {
            this.fractionalOffset = null;
        }
        this.f2c = null;
    }

    void setOffset(T3 pt) {
        boolean isCell555P4;
        if (pt == null) {
            return;
        }
        this.unitCellMultiplied = null;
        T4 pt4 = pt instanceof T4 ? (T4)pt : null;
        float w = pt4 == null ? Float.MIN_VALUE : pt4.w;
        boolean bl = isCell555P4 = w > 999999.0f;
        if (pt4 != null ? w <= 0.0f || isCell555P4 : pt.x >= 100.0f || pt.y >= 100.0f) {
            this.unitCellMultiplier = pt.z == 0.0f && pt.x == pt.y && !isCell555P4 ? null : (isCell555P4 ? P4.newPt((P4)pt4) : P3.newP(pt));
            this.unitCellMultiplied = null;
            if (pt4 == null || pt4.w == 0.0f || isCell555P4) {
                return;
            }
        }
        if (this.hasOffset() || pt.lengthSquared() > 0.0f) {
            this.fractionalOffset = P3.newP(pt);
        }
        this.matrixCartesianToFractional.m03 = -pt.x;
        this.matrixCartesianToFractional.m13 = -pt.y;
        this.matrixCartesianToFractional.m23 = -pt.z;
        this.cartesianOffset.setT(pt);
        this.matrixFractionalToCartesian.rotate(this.cartesianOffset);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFNoOffset.setM4(this.matrixCartesianToFractional);
            this.matrixFtoCNoOffset.setM4(this.matrixFractionalToCartesian);
        }
        this.f2c = null;
    }

    boolean toFromPrimitive(boolean toPrimitive, char type, T3[] uc, M3 primitiveToCrystal) {
        int offset = uc.length - 3;
        M3 mf = null;
        if (type == 'r' || primitiveToCrystal == null) {
            switch (type) {
                default: {
                    return false;
                }
                case 'r': {
                    UnitCell.getReciprocal(uc, uc, 1.0f);
                    return true;
                }
                case 'P': {
                    toPrimitive = true;
                    mf = M3.newA9(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
                    break;
                }
                case 'A': {
                    mf = M3.newA9(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f, -0.5f, 0.5f});
                    break;
                }
                case 'B': {
                    mf = M3.newA9(new float[]{0.5f, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f, -0.5f, 0.0f, 0.5f});
                    break;
                }
                case 'C': {
                    mf = M3.newA9(new float[]{0.5f, 0.5f, 0.0f, -0.5f, 0.5f, 0.0f, 0.0f, 0.0f, 1.0f});
                    break;
                }
                case 'R': {
                    mf = M3.newA9(new float[]{0.6666667f, -0.33333334f, -0.33333334f, 0.33333334f, 0.33333334f, -0.6666667f, 0.33333334f, 0.33333334f, 0.33333334f});
                    break;
                }
                case 'I': {
                    mf = M3.newA9(new float[]{-0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, -0.5f});
                    break;
                }
                case 'F': {
                    mf = M3.newA9(new float[]{0.0f, 0.5f, 0.5f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 0.0f});
                }
            }
            if (!toPrimitive) {
                mf.invert();
            }
        } else {
            mf = M3.newM3(primitiveToCrystal);
            if (toPrimitive) {
                mf.invert();
            }
        }
        int i = uc.length;
        while (--i >= offset) {
            T3 p = uc[i];
            this.toFractional(p, true);
            mf.rotate(p);
            this.toCartesian(p, true);
        }
        return true;
    }

    final void toUnitCell(T3 pt, T3 offset) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        if (offset == null) {
            this.matrixCartesianToFractional.rotTrans(pt);
            this.unitize(pt);
            this.matrixFractionalToCartesian.rotTrans(pt);
        } else {
            this.matrixCtoFNoOffset.rotTrans(pt);
            this.unitize(pt);
            pt.add(offset);
            this.matrixFtoCNoOffset.rotTrans(pt);
        }
    }

    public final void toUnitCellRnd(T3 pt, T3 offset) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        if (offset == null) {
            this.matrixCartesianToFractional.rotTrans(pt);
            this.unitizeRnd(pt);
            this.matrixFractionalToCartesian.rotTrans(pt);
        } else {
            this.matrixCtoFNoOffset.rotTrans(pt);
            this.unitizeRnd(pt);
            pt.add(offset);
            this.matrixFtoCNoOffset.rotTrans(pt);
        }
    }

    void unitize(T3 pt) {
        this.unitizeDim(this.dimension, pt);
    }

    void unitizeRnd(T3 pt) {
        UnitCell.unitizeDimRnd(this.dimension, pt, this.slop);
    }

    public static boolean createCompatibleUnitCell(SpaceGroup sg, float[] params, float[] newParams, boolean allowSame) {
        boolean isRhom;
        if (newParams == null) {
            newParams = params;
        }
        float a = params[0];
        float b = params[1];
        float c = params[2];
        float alpha = params[3];
        float beta = params[4];
        float gamma = params[5];
        int n = sg == null || sg.itaNumber == null ? 0 : PT.parseInt(sg.itaNumber);
        boolean toHex = n != 0 && UnitCell.isHexagonalSG(n, null);
        boolean isHex = toHex && UnitCell.isHexagonalSG(-1, params);
        boolean toRhom = n != 0 && sg.axisChoice == 'r';
        boolean bl = isRhom = toRhom && UnitCell.isRhombohedral(params);
        if (toHex && isHex || toRhom && isRhom) {
            allowSame = true;
        }
        if (n > (allowSame ? 2 : 0)) {
            boolean absame = UnitCell.approx0(a - b);
            boolean bcsame = UnitCell.approx0(b - c);
            boolean acsame = UnitCell.approx0(c - a);
            boolean albesame = UnitCell.approx0(alpha - beta);
            boolean begasame = UnitCell.approx0(beta - gamma);
            boolean algasame = UnitCell.approx0(gamma - alpha);
            if (!allowSame) {
                float d;
                if (a > b) {
                    d = a;
                    a = b;
                    b = d;
                }
                if (bcsame = UnitCell.approx0(b - c)) {
                    c = b * 1.5f;
                }
                if (absame = UnitCell.approx0(a - b)) {
                    b = a * 1.2f;
                }
                if (acsame = UnitCell.approx0(c - a)) {
                    c = a * 1.1f;
                }
                if (UnitCell.approx0(alpha - 90.0f)) {
                    alpha = 80.0f;
                }
                if (UnitCell.approx0(beta - 90.0f)) {
                    beta = 100.0f;
                }
                if (UnitCell.approx0(gamma - 90.0f)) {
                    gamma = 110.0f;
                }
                if (alpha > beta) {
                    d = alpha;
                    alpha = beta;
                    beta = d;
                }
                albesame = UnitCell.approx0(alpha - beta);
                begasame = UnitCell.approx0(beta - gamma);
                algasame = UnitCell.approx0(gamma - alpha);
                if (albesame) {
                    beta = alpha * 1.2f;
                }
                if (begasame) {
                    gamma = beta * 1.3f;
                }
                if (algasame) {
                    gamma = alpha * 1.4f;
                }
            }
            if (toHex) {
                if (!(!toRhom ? isHex : isRhom)) {
                    if (sg.axisChoice == 'r') {
                        c = b = a;
                        if (!allowSame && alpha > 85.0f && alpha < 95.0f) {
                            alpha = 80.0f;
                        }
                        gamma = beta = alpha;
                    } else {
                        b = a;
                        beta = 90.0f;
                        alpha = 90.0f;
                        gamma = 120.0f;
                    }
                }
            } else if (n >= 195) {
                c = b = a;
                gamma = 90.0f;
                beta = 90.0f;
                alpha = 90.0f;
            } else if (n >= 75) {
                b = a;
                if (acsame && !allowSame) {
                    c = a * 1.5f;
                }
                gamma = 90.0f;
                beta = 90.0f;
                alpha = 90.0f;
            } else if (n >= 16) {
                gamma = 90.0f;
                beta = 90.0f;
                alpha = 90.0f;
            } else if (n >= 3) {
                switch (sg.uniqueAxis) {
                    case 'a': {
                        gamma = 90.0f;
                        beta = 90.0f;
                        break;
                    }
                    default: {
                        gamma = 90.0f;
                        alpha = 90.0f;
                        break;
                    }
                    case 'c': {
                        beta = 90.0f;
                        alpha = 90.0f;
                    }
                }
            }
        }
        boolean isNew = a != params[0] || b != params[1] || c != params[2] || alpha != params[3] || beta != params[4] || gamma != params[5];
        newParams[0] = a;
        newParams[1] = b;
        newParams[2] = c;
        newParams[3] = alpha;
        newParams[4] = beta;
        newParams[5] = gamma;
        return isNew;
    }

    public static boolean isHexagonalSG(int n, float[] params) {
        return n < 1 ? UnitCell.isHexagonal(params) : n >= 143 && n <= 194;
    }

    public static boolean isMonoclinicSG(int n) {
        return n >= 3 && n <= 15;
    }

    public static boolean isTetragonalSG(int n) {
        return n >= 75 && n <= 142;
    }

    public static boolean isPolarSG(int n) {
        return n == 1 || n >= 3 && n <= 5 || n >= 6 && n <= 9 || n >= 25 && n <= 46 || n >= 75 && n <= 80 || n >= 99 && n <= 110 || n >= 143 && n <= 146 || n >= 156 && n <= 161 || n >= 168 && n <= 173 || n >= 183 && n <= 186;
    }

    private static void removeDuplicates(Lst<P3> list, int i0, int n0, int n) {
        if (n < 0) {
            n = list.size();
        }
        for (int i = i0; i < n; ++i) {
            P3 p = (P3)list.get(i);
            for (int j = Math.max(i + 1, n0); j < n; ++j) {
                if (!(((P3)list.get(j)).distanceSquared(p) < 1.96E-6f)) continue;
                list.removeItemAt(j);
                --n;
                --j;
            }
        }
    }
}

