/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sf.sdedit.ui.components.GrabbableViewport;
import net.sf.sdedit.util.Browser;

public class AdvancedHelpPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
TreeCellRenderer {
    private static final long serialVersionUID = 421111139685691723L;
    private JScrollPane navigatorScrollPane;
    private JScrollPane contentScrollPane;
    private JEditorPane editorPane;
    private JTree navigator;
    private DefaultTreeModel navigatorModel;
    private DefaultMutableTreeNode navigatorRoot;
    private static Pattern pattern = Pattern.compile(".*<a name=\"(.+?)\">(.*?)<\\/a.*");
    private Map<String, DefaultMutableTreeNode> anchorMap;
    private String url;
    private static Font[] fonts;
    private static Cursor HAND;
    private static Cursor DEFAULT;

    public AdvancedHelpPanel(URL url, HyperlinkListener listener) {
        this.init();
        this.url = url.toString();
        this.anchorMap = new HashMap<String, DefaultMutableTreeNode>();
        try {
            this.readAnchors(url);
            this.editorPane.setPage(url);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.navigatorModel.nodeStructureChanged(this.navigatorRoot);
        this.expandNavigator();
        this.navigator.addMouseListener(this);
        this.navigator.addMouseMotionListener(this);
        this.editorPane.addHyperlinkListener(new Browser());
        this.editorPane.addHyperlinkListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAnchors(URL url) throws IOException {
        InputStream stream = url.openStream();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            String line = br.readLine();
            while (line != null) {
                this.searchAnchors(line);
                line = br.readLine();
            }
        }
        finally {
            stream.close();
        }
    }

    private void searchAnchors(String string) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            String id = matcher.group(1);
            String content = matcher.group(2);
            this.addAnchor(id, content);
        }
    }

    private DefaultMutableTreeNode addAnchor(String id, String content) {
        DefaultMutableTreeNode parent;
        int dot = id.lastIndexOf(46);
        if (dot == -1) {
            parent = this.navigatorRoot;
        } else {
            String parentId = id.substring(0, dot);
            parent = this.anchorMap.get(parentId);
            if (parent == null) {
                parent = this.addAnchor(parentId, "");
            }
        }
        UserObject obj = new UserObject(id, content);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(obj);
        parent.add(node);
        this.anchorMap.put(id, node);
        return node;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.navigatorScrollPane = new JScrollPane();
        this.contentScrollPane = new JScrollPane();
        this.editorPane = new JEditorPane(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                super.paintComponent(g);
            }
        };
        this.editorPane.setContentType("text/html; charset=ISO-8859-1");
        this.editorPane.setEditable(false);
        GrabbableViewport viewPort = new GrabbableViewport();
        ((JViewport)viewPort).setView(this.editorPane);
        this.contentScrollPane.setViewport(viewPort);
        Border emptyBorder1 = BorderFactory.createEmptyBorder(5, 5, 0, 10);
        this.add((Component)this.navigatorScrollPane, "West");
        Border border = BorderFactory.createEtchedBorder(0);
        this.navigatorScrollPane.setBorder(border);
        this.add((Component)this.contentScrollPane, "Center");
        this.navigatorRoot = new DefaultMutableTreeNode();
        this.navigatorModel = new DefaultTreeModel(this.navigatorRoot);
        this.navigator = new JTree(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintComponent(g);
            }
        };
        this.navigator.setBorder(emptyBorder1);
        this.navigator.setCellRenderer(this);
        this.navigator.setModel(this.navigatorModel);
        this.navigator.setRootVisible(false);
        this.navigatorScrollPane.setViewportView(this.navigator);
    }

    private void expandNavigator() {
        int numberOfRows = 0;
        while (this.navigator.getRowCount() != numberOfRows) {
            numberOfRows = this.navigator.getRowCount();
            for (int i = 0; i < numberOfRows; ++i) {
                this.navigator.expandRow(i);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath path = this.navigator.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            UserObject obj = (UserObject)node.getUserObject();
            String id = obj.id;
            try {
                this.editorPane.setPage(this.url + "#" + id);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private static int countDots(String string) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object o = ((DefaultMutableTreeNode)value).getUserObject();
        JLabel label = new JLabel();
        if (!(o instanceof UserObject)) {
            return label;
        }
        UserObject obj = (UserObject)o;
        int f = Math.min(AdvancedHelpPanel.countDots(obj.id), fonts.length - 1);
        label.setFont(fonts[f]);
        label.setText("<html><u>" + obj.content + "</u>");
        return label;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int y;
        int x = e.getX();
        TreePath path = this.navigator.getPathForLocation(x, y = e.getY());
        if (path != null) {
            this.navigator.setCursor(HAND);
        } else {
            this.navigator.setCursor(DEFAULT);
        }
    }

    static {
        HAND = Cursor.getPredefinedCursor(12);
        DEFAULT = Cursor.getPredefinedCursor(0);
        fonts = new Font[3];
        String fontName = "Dialog";
        AdvancedHelpPanel.fonts[0] = new Font(fontName, 1, 13);
        AdvancedHelpPanel.fonts[1] = new Font(fontName, 0, 13);
        AdvancedHelpPanel.fonts[2] = new Font(fontName, 0, 12);
    }

    private static class UserObject {
        private String id;
        private String content;

        UserObject(String id, String content) {
            this.id = id;
            this.content = content;
        }

        public String toString() {
            return this.content;
        }
    }
}

