/****************************************************************************
** Shared Class code from reading file 'KDbQuerySchemaParameter.shared.h'
**
** Created
**      by: The Shared Data Compiler version 0.3
**
** WARNING! All changes made in this file will be lost!
*****************************************************************************/

/* This file is part of the KDE project
   Copyright (C) 2006-2010 Jarosław Staniek <staniek@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KDB_QUERYSCHEMAPARAMETER_H
#define KDB_QUERYSCHEMAPARAMETER_H

#include "KDbField.h"
#include <QSharedData>

//! @short A single parameter of a query schema
/*! @note objects of this class are implicitly shared, what means they have value semantics
          by offering copy-on-write behaviour to maximize resource usage and minimize copying.
          Only a pointer to the data is passed around. See <a href="https://doc.qt.io/qt-5/qshareddatapointer.html#details">Qt documentation</a>.
 */
//! @note This class has been generated using the following SDC class options: operator==, implicit
class KDB_EXPORT KDbQuerySchemaParameter
{
public:

    //! @internal data class used to implement implicitly shared class KDbQuerySchemaParameter.
    //! Provides thread-safe reference counting.
    class Data : public QSharedData
    {
    public:
        Data()
        : type(KDbField::InvalidType)
        {
        }

        Data(const Data &other)
         : QSharedData(other)
         , type(other.type)
         , message(other.message)
        {
        }

        virtual ~Data() {}

        //! Clones the object with all attributes; the copy isn't shared with the original.
        virtual Data* clone() const { return new Data(*this); }

        bool operator==(const Data &other) const {
            return type == other.type
                   && message == other.message;
        }

        KDbField::Type type; //!< @see KDbQuerySchemaParameter::type(), KDbQuerySchemaParameter::setType()
        QString message; //!< @see KDbQuerySchemaParameter::message(), KDbQuerySchemaParameter::setMessage()
    };

    KDbQuerySchemaParameter()
     : d(new Data)
    {
    }

    KDbQuerySchemaParameter(const KDbQuerySchemaParameter &other)
     : d(other.d)
    {
    }

    virtual ~KDbQuerySchemaParameter();

    /*!
    @return datatype of the parameter.
    */
    KDbField::Type type() const {
        return d->type;
    }

    /*!
    Sets a datatype of the parameter.
    */
    void setType(const KDbField::Type & type) {
        d->type = type;
    }

    /*!
    @return user-visible message that will be displayed when asking for value of the parameter.
    */
    QString message() const {
        return d->message;
    }

    /*!
    Sets user-visible message that will be displayed when asking for value of the parameter.
    */
    void setMessage(const QString & message) {
        d->message = message;
    }

    //! @return true if this object is equal to @a other; otherwise returns false.
    bool operator==(const KDbQuerySchemaParameter &other) const {
        return *d == *other.d;
    }

    //! @return true if this object is not equal to @a other; otherwise returns false.
    bool operator!=(const KDbQuerySchemaParameter &other) const {
        return !operator==(other);
    }



protected:
    QSharedDataPointer<Data> d;
};

//! @short An iterator for a list of values of query schema parameters
//! Allows to iterate over parameters and returns QVariant value or well-formatted string.
//! The iterator is initially set to the last item because of the parser requirements
class KDB_EXPORT KDbQuerySchemaParameterValueListIterator
{
public:
    explicit KDbQuerySchemaParameterValueListIterator(const QList<QVariant>& params);
    ~KDbQuerySchemaParameterValueListIterator();

    //! @return previous value
    QVariant previousValue() const;

private:
    Q_DISABLE_COPY(KDbQuerySchemaParameterValueListIterator)
    class Private;
    Private * const d;
};

//! Sends information about query schema parameter @a parameter to debug output @a dbg.
KDB_EXPORT QDebug operator<<(QDebug dbg, const KDbQuerySchemaParameter& parameter);

//! Sends information about query schema parameter list @a list to debug output @a dbg.
KDB_EXPORT QDebug operator<<(QDebug dbg, const QList<KDbQuerySchemaParameter>& list);

#endif
