/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.Collection;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CompilerTarget;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodHandle;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.ParameterDefinitionCollection;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.ClassType;
import com.strobel.decompiler.languages.java.ast.Comment;
import com.strobel.decompiler.languages.java.ast.CommentType;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.InlinedBytecodeExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.ThrowStatement;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.transforms.AbstractHelperClassTransform;
import java.util.Collections;
import java.util.List;

public class InvokeDynamicRewriter
extends AbstractHelperClassTransform {
    private static final String T_DESC_THROWABLE = "java/lang/Throwable";
    private static final String T_DESC_THROWABLE_WRAPPER = "java/lang/reflect/UndeclaredThrowableException";
    private static final String T_DESC_METHOD_HANDLE = "java/lang/invoke/MethodHandle";
    private static final String T_DESC_METHOD_HANDLES = "java/lang/invoke/MethodHandles";
    private static final String T_DESC_LOOKUP = "java/lang/invoke/MethodHandles$Lookup";
    private static final String T_DESC_CALL_SITE = "java/lang/invoke/CallSite";
    private static final String T_SIGNATURE_LOOKUP = "()Ljava/lang/invoke/MethodHandles$Lookup;";
    private static final String M_DESC_INVOKE_EXACT = "([Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String M_DESC_DYNAMIC_INVOKER = "()Ljava/lang/invoke/MethodHandle;";

    public InvokeDynamicRewriter(DecompilerContext context) {
        super(context);
    }

    @Override
    public Void visitInvocationExpression(InvocationExpression node, Void data) {
        super.visitInvocationExpression(node, data);
        Expression target = node.getTarget();
        if (target instanceof InlinedBytecodeExpression) {
            InlinedBytecodeExpression bytecode = (InlinedBytecodeExpression)target;
            TypeDeclaration currentType = this.currentType;
            TypeDefinition currentTypeDefinition = currentType != null ? currentType.getUserData(Keys.TYPE_DEFINITION) : null;
            DynamicCallSite callSite = node.getUserData(Keys.DYNAMIC_CALL_SITE);
            if (currentTypeDefinition == null || callSite == null || bytecode.getCode() != AstCode.InvokeDynamic || this.resolver == null) {
                return null;
            }
            IndyHelperBuilder hb = new IndyHelperBuilder(currentType, currentTypeDefinition, callSite);
            if (hb.build()) {
                MethodReference method;
                MethodDefinition methodDefinition;
                AstNodeCollection<Expression> originalArguments = node.getArguments();
                InvocationExpression replacement = this.makeType(hb.definition).invoke((MethodReference)hb.definition.mdInvoke, new Expression[0]);
                AstNodeCollection<Expression> newArguments = replacement.getArguments();
                for (Expression argument : originalArguments) {
                    argument.remove();
                    newArguments.add(argument);
                }
                node.replaceWith(replacement);
                replacement.getParent().insertChildBefore(replacement, new Comment(" invokedynamic(!) ", CommentType.MultiLine), Roles.COMMENT);
                currentType.getMembers().insertAfter(currentType.getMembers().lastOrNullObject(), hb.declaration);
                AstNode commentAnchor = hb.declaration.getFirstChild();
                List<Object> bootstrapArguments = callSite.getBootstrapArguments();
                if (bootstrapArguments.size() >= 3 && bootstrapArguments.get(1) instanceof MethodHandle && (methodDefinition = (method = ((MethodHandle)bootstrapArguments.get(1)).getMethod()).resolve()) != null) {
                    this.context.getForcedVisibleMembers().add(methodDefinition);
                }
                hb.declaration.insertChildBefore(commentAnchor, new Comment(" This helper class was generated by Procyon to approximate the behavior of an"), Roles.COMMENT);
                hb.declaration.insertChildBefore(commentAnchor, new Comment(" 'invokedynamic' instruction that it doesn't know how to interpret."), Roles.COMMENT);
            }
        }
        return null;
    }

    protected final class IndyHelperBuilder {
        static final String T_DESC_METHOD_HANDLE = "java/lang/invoke/MethodHandle";
        static final String F_DESC_ENSURE_HANDLE = "Ljava/lang/invoke/MethodHandle;";
        static final String M_DESC_ENSURE_HANDLE = "()Ljava/lang/invoke/MethodHandle;";
        final TypeDeclaration parentDeclaration;
        final TypeReference parentType;
        final DynamicCallSite callSite;
        final TypeReference callSiteType;
        final TypeReference methodHandleType;
        final TypeReference methodHandlesType;
        final TypeReference lookupType;
        final MethodReference handleMethod;
        final MethodReference ensureHandleMethod;
        final HelperTypeDefinition definition;
        final Variable lookupVariable;
        final int uniqueTypeId;
        TypeDeclaration declaration;
        MethodDeclaration handleDeclaration;
        MethodDeclaration invokeDeclaration;
        MethodDeclaration ensureHandleDeclaration;
        InvocationExpression bootstrapCall;

        IndyHelperBuilder(TypeDeclaration parentDeclaration, TypeReference parentType, DynamicCallSite callSite) {
            this.parentDeclaration = VerifyArgument.notNull(parentDeclaration, "parentDeclaration");
            this.parentType = VerifyArgument.notNull(parentType, "parentType");
            this.callSite = VerifyArgument.notNull(callSite, "callSite");
            this.uniqueTypeId = AbstractHelperClassTransform.nextUniqueId();
            TypeReference helperType = InvokeDynamicRewriter.this.parser.parseTypeDescriptor("ProcyonInvokeDynamicHelper_" + this.uniqueTypeId);
            this.callSiteType = InvokeDynamicRewriter.this.parser.parseTypeDescriptor(InvokeDynamicRewriter.T_DESC_CALL_SITE);
            this.methodHandleType = InvokeDynamicRewriter.this.parser.parseTypeDescriptor("java/lang/invoke/MethodHandle");
            this.methodHandlesType = InvokeDynamicRewriter.this.parser.parseTypeDescriptor(InvokeDynamicRewriter.T_DESC_METHOD_HANDLES);
            this.definition = new HelperTypeDefinition(helperType, parentType);
            this.handleMethod = InvokeDynamicRewriter.this.parser.parseMethod(this.definition, "handle", "()Ljava/lang/invoke/MethodHandle;");
            this.ensureHandleMethod = InvokeDynamicRewriter.this.parser.parseMethod(this.definition, "ensureHandle", "()Ljava/lang/invoke/MethodHandle;");
            this.lookupType = InvokeDynamicRewriter.this.parser.parseTypeDescriptor(InvokeDynamicRewriter.T_DESC_LOOKUP);
            Variable vLookup = new Variable();
            vLookup.setGenerated(true);
            vLookup.setName("lookup");
            vLookup.setType(this.lookupType);
            this.lookupVariable = vLookup;
        }

        boolean build() {
            TypeDeclaration declaration;
            this.bootstrapCall = InvokeDynamicRewriter.this.makeBootstrapCall(this.callSite, this.lookupVariable);
            this.declaration = declaration = new TypeDeclaration();
            AstNodeCollection<JavaModifierToken> modifiers = this.declaration.getModifiers();
            for (Flags.Flag modifier : Flags.asFlagSet(26L)) {
                modifiers.add(new JavaModifierToken(TextLocation.EMPTY, modifier));
            }
            declaration.setClassType(ClassType.CLASS);
            declaration.setName(this.definition.getSimpleName());
            declaration.putUserData(Keys.TYPE_REFERENCE, this.definition.selfReference);
            declaration.putUserData(Keys.TYPE_DEFINITION, this.definition);
            AstNodeCollection<EntityDeclaration> members = declaration.getMembers();
            members.add(this.buildLookupField());
            members.add(this.buildHandleField());
            members.add(this.buildFenceField());
            members.add(this.buildHandleMethod());
            members.add(this.buildEnsureHandleMethod());
            members.add(this.buildInvokeMethod());
            return true;
        }

        FieldDeclaration buildHandleField() {
            return InvokeDynamicRewriter.this.declareField(this.definition.fdHandle, Expression.NULL, 0);
        }

        FieldDeclaration buildFenceField() {
            return InvokeDynamicRewriter.this.declareField(this.definition.fdFence, Expression.NULL, 64);
        }

        FieldDeclaration buildLookupField() {
            MethodReference lookup = InvokeDynamicRewriter.this.parser.parseMethod(this.methodHandlesType, "lookup", InvokeDynamicRewriter.T_SIGNATURE_LOOKUP);
            return InvokeDynamicRewriter.this.declareField(this.definition.fdLookup, InvokeDynamicRewriter.this.makeType(this.methodHandlesType).invoke(lookup, new Expression[0]), 16);
        }

        VariableDeclarationStatement makeHandleVariableDeclaration() {
            Variable v = new Variable();
            VariableDeclarationStatement vd = new VariableDeclarationStatement(InvokeDynamicRewriter.this.makeType(this.methodHandleType), "handle", InvokeDynamicRewriter.this.makeReference(this.definition.fdHandle));
            v.setGenerated(false);
            v.setName("handle");
            v.setType(this.methodHandleType);
            vd.putUserData(Keys.VARIABLE, v);
            return vd;
        }

        MethodDeclaration buildHandleMethod() {
            MethodDeclaration declaration = InvokeDynamicRewriter.this.newMethod(this.definition.mdHandle);
            VariableDeclarationStatement vd = this.makeHandleVariableDeclaration();
            vd.setModifiers(Collections.singletonList(Flags.Flag.FINAL));
            declaration.setBody(new BlockStatement(vd, new IfElseStatement(-34, new BinaryOperatorExpression(InvokeDynamicRewriter.this.varReference(vd), BinaryOperatorType.INEQUALITY, new NullReferenceExpression()), (Statement)new ReturnStatement(InvokeDynamicRewriter.this.varReference(vd))), new ReturnStatement(InvokeDynamicRewriter.this.makeReference(this.ensureHandleMethod).invoke(new Expression[0]))));
            this.handleDeclaration = declaration;
            return declaration;
        }

        MethodDeclaration buildInvokeMethod() {
            MethodDeclaration declaration = InvokeDynamicRewriter.this.newMethod(this.definition.mdInvoke);
            TryCatchStatement tryCatch = new TryCatchStatement(-34);
            CatchClause cc = new CatchClause();
            AstType throwableType = InvokeDynamicRewriter.this.makeType(InvokeDynamicRewriter.T_DESC_THROWABLE);
            Variable t = new Variable();
            t.setType(throwableType.toTypeReference());
            t.setName("t");
            t.setGenerated(true);
            cc.putUserData(Keys.VARIABLE, t);
            cc.setVariableName("t");
            cc.getExceptionTypes().add(throwableType);
            cc.setBody(new BlockStatement(new ThrowStatement(InvokeDynamicRewriter.this.makeType(InvokeDynamicRewriter.T_DESC_THROWABLE_WRAPPER).makeNew(InvokeDynamicRewriter.this.varReference(t)))));
            MethodReference invokeExact = InvokeDynamicRewriter.this.parser.parseMethod(InvokeDynamicRewriter.this.parser.parseTypeDescriptor("java/lang/invoke/MethodHandle"), "invokeExact", InvokeDynamicRewriter.M_DESC_INVOKE_EXACT);
            InvocationExpression invoke = InvokeDynamicRewriter.this.makeReference(this.handleMethod).invoke(new Expression[0]).invoke(invokeExact, new Expression[0]);
            AstNodeCollection<Expression> arguments = invoke.getArguments();
            for (ParameterDeclaration p : declaration.getParameters()) {
                arguments.add(InvokeDynamicRewriter.this.varReference(p));
            }
            tryCatch.setTryBlock(new BlockStatement(new ReturnStatement(invoke)));
            tryCatch.getCatchClauses().add(cc);
            declaration.setBody(new BlockStatement(tryCatch));
            this.invokeDeclaration = declaration;
            return declaration;
        }

        MethodDeclaration buildEnsureHandleMethod() {
            MethodDeclaration declaration = InvokeDynamicRewriter.this.newMethod(this.definition.mdEnsureHandle);
            VariableDeclarationStatement vd = this.makeHandleVariableDeclaration();
            MethodReference dynamicInvoker = InvokeDynamicRewriter.this.parser.parseMethod(this.callSiteType, "dynamicInvoker", "()Ljava/lang/invoke/MethodHandle;");
            VariableDeclarationStatement vdLookup = new VariableDeclarationStatement(InvokeDynamicRewriter.this.makeType(this.lookupType), "lookup", InvokeDynamicRewriter.this.makeReference(this.definition.fdLookup));
            TryCatchStatement tryCatch = new TryCatchStatement(-34);
            CatchClause cc = new CatchClause();
            AstType throwableType = InvokeDynamicRewriter.this.makeType(InvokeDynamicRewriter.T_DESC_THROWABLE);
            Variable t = new Variable();
            t.setType(throwableType.toTypeReference());
            t.setName("t");
            t.setGenerated(true);
            cc.putUserData(Keys.VARIABLE, t);
            cc.setVariableName("t");
            cc.getExceptionTypes().add(throwableType);
            cc.setBody(new BlockStatement(new ThrowStatement(InvokeDynamicRewriter.this.makeType(InvokeDynamicRewriter.T_DESC_THROWABLE_WRAPPER).makeNew(InvokeDynamicRewriter.this.varReference(t)))));
            tryCatch.setTryBlock(new BlockStatement(new ExpressionStatement(new AssignmentExpression(InvokeDynamicRewriter.this.varReference(vd), this.bootstrapCall.cast(InvokeDynamicRewriter.this.makeType(this.callSiteType)).invoke(dynamicInvoker, new Expression[0])))));
            tryCatch.getCatchClauses().add(cc);
            vdLookup.putUserData(Keys.VARIABLE, this.lookupVariable);
            declaration.setBody(new BlockStatement(new ExpressionStatement(new AssignmentExpression(InvokeDynamicRewriter.this.makeReference(this.definition.fdFence), new PrimitiveExpression(-34, 0))), vd, new IfElseStatement(-34, new BinaryOperatorExpression(InvokeDynamicRewriter.this.varReference(vd), BinaryOperatorType.EQUALITY, new NullReferenceExpression(-34)), (Statement)new BlockStatement(vdLookup, tryCatch, new ExpressionStatement(new AssignmentExpression(InvokeDynamicRewriter.this.makeReference(this.definition.fdFence), new PrimitiveExpression(-34, 1))), new ExpressionStatement(new AssignmentExpression(InvokeDynamicRewriter.this.makeReference(this.definition.fdHandle), InvokeDynamicRewriter.this.varReference(vd))), new ExpressionStatement(new AssignmentExpression(InvokeDynamicRewriter.this.makeReference(this.definition.fdFence), new PrimitiveExpression(-34, 0))))), new ReturnStatement(InvokeDynamicRewriter.this.varReference(vd))));
            this.ensureHandleDeclaration = declaration;
            return declaration;
        }

        private final class HelperTypeDefinition
        extends TypeDefinition {
            final TypeReference selfReference;
            final FieldDefinition fdLookup;
            final FieldDefinition fdHandle;
            final FieldDefinition fdFence;
            final MethodDefinition mdHandle;
            final MethodDefinition mdEnsureHandle;
            final MethodDefinition mdInvoke;

            HelperTypeDefinition(TypeReference selfReference, TypeReference parentType) {
                super(AbstractHelperClassTransform.resolver(parentType));
                this.selfReference = selfReference;
                this.setPackageName(selfReference.getPackageName());
                this.setSimpleName(selfReference.getSimpleName());
                this.setBaseType(BuiltinTypes.Object);
                this.setFlags(18L);
                this.setDeclaringType(parentType);
                TypeDefinition resolvedParent = parentType.resolve();
                if (resolvedParent != null) {
                    this.setResolver(resolvedParent.getResolver());
                    this.setCompilerVersion(resolvedParent.getCompilerMajorVersion(), resolvedParent.getCompilerMinorVersion());
                } else {
                    this.setResolver(InvokeDynamicRewriter.this.resolver());
                    this.setCompilerVersion(CompilerTarget.JDK1_7.majorVersion, CompilerTarget.JDK1_7.minorVersion);
                }
                final HelperTypeDefinition self = this;
                this.fdHandle = new FieldDefinition(IndyHelperBuilder.this.methodHandleType){
                    {
                        super(fieldType);
                        this.setName("handle");
                        this.setDeclaringType(self);
                        this.setFlags(10L);
                    }
                };
                this.fdFence = new FieldDefinition(BuiltinTypes.Integer){
                    {
                        super(fieldType);
                        this.setName("fence");
                        this.setDeclaringType(self);
                        this.setFlags(10L);
                    }
                };
                this.fdLookup = new FieldDefinition(InvokeDynamicRewriter.this.resolver.lookupType(InvokeDynamicRewriter.T_DESC_LOOKUP)){
                    {
                        super(fieldType);
                        this.setName("LOOKUP");
                        this.setDeclaringType(self);
                        this.setFlags(26L);
                    }
                };
                this.mdHandle = new MethodDefinition(){
                    {
                        this.setName("handle");
                        this.setDeclaringType(self);
                        this.setFlags(10L);
                        this.setReturnType(IndyHelperBuilder.this.methodHandleType);
                    }
                };
                this.mdEnsureHandle = new MethodDefinition(){
                    {
                        this.setName("ensureHandle");
                        this.setDeclaringType(self);
                        this.setFlags(10L);
                        this.setReturnType(IndyHelperBuilder.this.methodHandleType);
                    }
                };
                this.mdInvoke = new MethodDefinition(){
                    {
                        IMethodSignature methodType = IndyHelperBuilder.this.callSite.getMethodType();
                        this.setName("invoke");
                        this.setDeclaringType(self);
                        this.setFlags(10L);
                        this.setReturnType(methodType.getReturnType());
                        ParameterDefinitionCollection ps = this.getParametersInternal();
                        List<ParameterDefinition> tps = methodType.getParameters();
                        int n = tps.size();
                        for (int i = 0; i < n; ++i) {
                            ParameterDefinition template = tps.get(i);
                            ParameterDefinition pd = new ParameterDefinition(template.getSlot(), "p" + i, template.getParameterType());
                            ps.add(pd);
                        }
                    }
                };
                Collection<FieldDefinition> fields = this.getDeclaredFieldsInternal();
                fields.add(this.fdFence);
                fields.add(this.fdHandle);
                fields.add(this.fdLookup);
            }
        }
    }
}

