/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.InterpolatorState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Alpha;
import javax.media.j3d.ColorInterpolator;
import javax.media.j3d.Material;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;

public class ColorInterpolatorState
extends InterpolatorState {
    private int target;

    public ColorInterpolatorState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.target = controller.getSymbolTable().addReference((SceneGraphObject)((ColorInterpolator)this.node).getTarget());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.target);
        Color3f color3f = new Color3f();
        ((ColorInterpolator)this.node).getStartColor(color3f);
        this.control.writeColor3f(dataOutput, color3f);
        ((ColorInterpolator)this.node).getEndColor(color3f);
        this.control.writeColor3f(dataOutput, color3f);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.target = dataInput.readInt();
        ((ColorInterpolator)this.node).setStartColor(this.control.readColor3f(dataInput));
        ((ColorInterpolator)this.node).setEndColor(this.control.readColor3f(dataInput));
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.target);
    }

    public void buildGraph() {
        ((ColorInterpolator)this.node).setTarget((Material)this.control.getSymbolTable().getJ3dNode(this.target));
        super.buildGraph();
    }

    public SceneGraphObject createNode(Class clazz) {
        return this.createNode(clazz, new Class[]{Alpha.class, Material.class}, new Object[]{null, null});
    }

    protected SceneGraphObject createNode() {
        return new ColorInterpolator(null, null);
    }
}

