/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.triggercondition.resolvers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.alerting.triggercondition.resolvers.TriggerExpression;
import org.opensearch.alerting.triggercondition.resolvers.TriggerExpressionResolver;
import org.opensearch.alerting.triggercondition.tokens.ExpressionToken;
import org.opensearch.alerting.triggercondition.tokens.TriggerExpressionConstant;
import org.opensearch.alerting.triggercondition.tokens.TriggerExpressionOperator;
import org.opensearch.alerting.triggercondition.tokens.TriggerExpressionToken;
import org.opensearch.commons.alerting.model.DocLevelQuery;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u0010H\u0016J0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0013\u001a\u00020\b2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e0\u0010H\u0002J\b\u0010\u0014\u001a\u00020\bH\u0016R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpressionRPNResolver;", "Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpressionResolver;", "polishNotation", "Ljava/util/ArrayList;", "Lorg/opensearch/alerting/triggercondition/tokens/ExpressionToken;", "Lkotlin/collections/ArrayList;", "(Ljava/util/ArrayList;)V", "eqString", "", "getEqString", "()Ljava/lang/String;", "eqString$delegate", "Lkotlin/Lazy;", "evaluate", "", "queryToDocIds", "", "Lorg/opensearch/commons/alerting/model/DocLevelQuery;", "resolveQueryExpression", "queryExpString", "toString", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTriggerExpressionRPNResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TriggerExpressionRPNResolver.kt\norg/opensearch/alerting/triggercondition/resolvers/TriggerExpressionRPNResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class TriggerExpressionRPNResolver
implements TriggerExpressionResolver {
    @NotNull
    private final ArrayList<ExpressionToken> polishNotation;
    @NotNull
    private final Lazy eqString$delegate;

    public TriggerExpressionRPNResolver(@NotNull ArrayList<ExpressionToken> polishNotation) {
        Intrinsics.checkNotNullParameter(polishNotation, (String)"polishNotation");
        this.polishNotation = polishNotation;
        this.eqString$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TriggerExpressionRPNResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder = new StringBuilder();
                for (ExpressionToken expToken : TriggerExpressionRPNResolver.access$getPolishNotation$p(this.this$0)) {
                    ExpressionToken expressionToken = expToken;
                    if (expressionToken instanceof TriggerExpressionToken) {
                        stringBuilder.append(((TriggerExpressionToken)expToken).getValue());
                    } else if (expressionToken instanceof TriggerExpressionOperator) {
                        stringBuilder.append(((TriggerExpressionOperator)expToken).getValue());
                    } else if (expressionToken instanceof TriggerExpressionConstant) {
                        stringBuilder.append(((TriggerExpressionConstant)expToken).getType().getIdent());
                    } else {
                        throw new Exception();
                    }
                    stringBuilder.append(" ");
                }
                return stringBuilder.toString();
            }
        }));
    }

    private final String getEqString() {
        Lazy lazy = this.eqString$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public String toString() {
        String string = this.getEqString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"eqString");
        return string;
    }

    @Override
    @NotNull
    public Set<String> evaluate(@NotNull Map<DocLevelQuery, ? extends Set<String>> queryToDocIds) {
        Intrinsics.checkNotNullParameter(queryToDocIds, (String)"queryToDocIds");
        Stack<Set<String>> tokenStack = new Stack<Set<String>>();
        Set allDocIds = new LinkedHashSet();
        for (Set<String> set : queryToDocIds.values()) {
            allDocIds.addAll((Collection)set);
        }
        for (ExpressionToken expressionToken : this.polishNotation) {
            TriggerExpression triggerExpression;
            ExpressionToken expressionToken2 = expressionToken;
            if (expressionToken2 instanceof TriggerExpressionToken) {
                tokenStack.push(this.resolveQueryExpression(((TriggerExpressionToken)expressionToken).getValue(), queryToDocIds));
                continue;
            }
            if (!(expressionToken2 instanceof TriggerExpressionOperator)) continue;
            Set right = (Set)tokenStack.pop();
            Intrinsics.checkNotNullExpressionValue((Object)expressionToken, (String)"expToken");
            switch (WhenMappings.$EnumSwitchMapping$0[((TriggerExpressionOperator)expressionToken).ordinal()]) {
                case 1: {
                    Object e = tokenStack.pop();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"tokenStack.pop()");
                    Set set = (Set)e;
                    Intrinsics.checkNotNullExpressionValue((Object)right, (String)"right");
                    triggerExpression = new TriggerExpression.And(set, right);
                    break;
                }
                case 2: {
                    Object e = tokenStack.pop();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"tokenStack.pop()");
                    Set set = (Set)e;
                    Intrinsics.checkNotNullExpressionValue((Object)right, (String)"right");
                    triggerExpression = new TriggerExpression.Or(set, right);
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNullExpressionValue((Object)right, (String)"right");
                    triggerExpression = new TriggerExpression.Not(allDocIds, right);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No matching operator.");
                }
            }
            TriggerExpression expr = triggerExpression;
            tokenStack.push(expr.resolve());
        }
        Object e = tokenStack.pop();
        Intrinsics.checkNotNullExpressionValue(e, (String)"tokenStack.pop()");
        return (Set)e;
    }

    private final Set<String> resolveQueryExpression(String queryExpString, Map<DocLevelQuery, ? extends Set<String>> queryToDocIds) {
        if (!StringsKt.startsWith$default((String)queryExpString, (String)TriggerExpressionConstant.ConstantType.QUERY.getIdent(), (boolean)false, (int)2, null)) {
            return SetsKt.emptySet();
        }
        String token = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)queryExpString, (String)TriggerExpressionConstant.ConstantType.BRACKET_LEFT.getIdent(), null, (int)2, null), (String)TriggerExpressionConstant.ConstantType.BRACKET_RIGHT.getIdent(), null, (int)2, null);
        if (((CharSequence)token).length() == 0) {
            return SetsKt.emptySet();
        }
        String[] stringArray = new String[]{TriggerExpressionConstant.ConstantType.EQUALS.getIdent()};
        List tokens = StringsKt.split$default((CharSequence)token, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (tokens.isEmpty() || tokens.size() != 2) {
            return SetsKt.emptySet();
        }
        String identifier = (String)tokens.get(0);
        String value = (String)tokens.get(1);
        Set documents = new LinkedHashSet();
        String string = identifier;
        if (Intrinsics.areEqual((Object)string, (Object)TriggerExpressionConstant.ConstantType.NAME.getIdent())) {
            Optional<Object> optional = queryToDocIds.keySet().stream().filter(arg_0 -> TriggerExpressionRPNResolver.resolveQueryExpression$lambda$0((Function1)new Function1<DocLevelQuery, Boolean>(value){
                final /* synthetic */ String $value;
                {
                    this.$value = $value;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(DocLevelQuery it) {
                    return Intrinsics.areEqual((Object)it.getName(), (Object)this.$value);
                }
            }, arg_0)).findFirst();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"value = tokens[1]\n      \u2026me == value }.findFirst()");
            Optional<Object> key2 = optional;
            if (key2.isPresent()) {
                Set<String> set = queryToDocIds.get(key2.get());
                if (set != null) {
                    Set<String> doc = set;
                    boolean bl = false;
                    documents.addAll((Collection)doc);
                }
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)TriggerExpressionConstant.ConstantType.ID.getIdent())) {
            Optional<Object> optional = queryToDocIds.keySet().stream().filter(arg_0 -> TriggerExpressionRPNResolver.resolveQueryExpression$lambda$2((Function1)new Function1<DocLevelQuery, Boolean>(value){
                final /* synthetic */ String $value;
                {
                    this.$value = $value;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(DocLevelQuery it) {
                    return Intrinsics.areEqual((Object)it.getId(), (Object)this.$value);
                }
            }, arg_0)).findFirst();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"value = tokens[1]\n      \u2026id == value }.findFirst()");
            Optional<Object> key3 = optional;
            if (key3.isPresent()) {
                Set<String> set = queryToDocIds.get(key3.get());
                if (set != null) {
                    Set<String> doc = set;
                    boolean bl = false;
                    documents.addAll((Collection)doc);
                }
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)TriggerExpressionConstant.ConstantType.TAG.getIdent())) {
            queryToDocIds.keySet().stream().forEach(arg_0 -> TriggerExpressionRPNResolver.resolveQueryExpression$lambda$4((Function1)new Function1<DocLevelQuery, Unit>(value, queryToDocIds, (Set<String>)documents){
                final /* synthetic */ String $value;
                final /* synthetic */ Map<DocLevelQuery, Set<String>> $queryToDocIds;
                final /* synthetic */ Set<String> $documents;
                {
                    this.$value = $value;
                    this.$queryToDocIds = $queryToDocIds;
                    this.$documents = $documents;
                    super(1);
                }

                public final void invoke(DocLevelQuery it) {
                    block1: {
                        if (!it.getTags().contains(this.$value)) break block1;
                        Set<String> set = this.$queryToDocIds.get(it);
                        if (set != null) {
                            Set<String> set2 = set;
                            Set<String> set3 = this.$documents;
                            Set<String> it1 = set2;
                            boolean bl = false;
                            set3.addAll((Collection<String>)it1);
                        }
                    }
                }
            }, arg_0));
        }
        return documents;
    }

    private static final boolean resolveQueryExpression$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean resolveQueryExpression$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void resolveQueryExpression$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ArrayList access$getPolishNotation$p(TriggerExpressionRPNResolver $this) {
        return $this.polishNotation;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TriggerExpressionOperator.values().length];
            try {
                nArray[TriggerExpressionOperator.AND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TriggerExpressionOperator.OR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TriggerExpressionOperator.NOT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

